<?php
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

require_once 'koneksi.php';

// Cek login
checkLogin();

date_default_timezone_set('Asia/Jakarta');

$user_id = $_SESSION['user_id'];
$role = $_SESSION['role'];
$nik_karyawan = $_SESSION['nik_karyawan'];

// Pastikan hanya trainer yang bisa mengakses halaman ini
if (!isset($role) || $role !== 'trainer') {
    header("Location: dashboard.php?error=" . urlencode("Anda tidak memiliki izin untuk mengakses halaman ini."));
    exit();
}

// Ambil informasi user trainer
$stmt = $koneksi->prepare("SELECT nama_lengkap, jabatan, divisi, foto_profil FROM trainers WHERE id = ?");
if ($stmt === false) {
    error_log("Prepare failed for trainer profile: " . $koneksi->error);
    $user = []; // Initialize user as empty array to prevent further errors
} else {
    $stmt->bind_param("i", $user_id);
    $stmt->execute();
    $result = $stmt->get_result();
    $user = $result->fetch_assoc();
    $stmt->close();
}

$nama_user = $user['nama_lengkap'] ?? 'Unknown';

$current_page = basename($_SERVER['PHP_SELF']);

$training_id = $_GET['training_id'] ?? null;
$training_title = "Tidak Ditemukan";
$post_test_submissions = [];

if ($training_id) {
    // Ambil judul training
    $stmt = $koneksi->prepare("SELECT judul FROM trainings WHERE id = ?");
    if ($stmt === false) {
        error_log("Prepare failed for training title: " . $koneksi->error);
    } else {
        $stmt->bind_param("i", $training_id);
        $stmt->execute();
        $result = $stmt->get_result();
        if ($row = $result->fetch_assoc()) {
            $training_title = $row['judul'];
        }
        $stmt->close();
    }

    // Ambil semua submission untuk training ini, termasuk divisi
    // PERUBAHAN: Ubah ORDER BY untuk mengurutkan berdasarkan divisi secara alfabetis
    $stmt = $koneksi->prepare("
        SELECT
            pts.id AS submission_id,
            pts.user_id,
            pts.user_role,
            pts.score,
            pts.submission_time,
            p.nama_lengkap AS peserta_nama,
            p.divisi AS peserta_divisi,
            i.nama_lengkap AS iss_nama,
            i.divisi AS iss_divisi
        FROM post_test_submissions pts
        LEFT JOIN peserta p ON pts.user_id = p.id AND pts.user_role = 'peserta'
        LEFT JOIN iss i ON pts.user_id = i.id AND pts.user_role = 'iss'
        WHERE pts.training_id = ?
        ORDER BY 
            CASE 
                WHEN pts.user_role = 'peserta' THEN p.divisi 
                ELSE i.divisi 
            END ASC,
            CASE 
                WHEN pts.user_role = 'peserta' THEN p.nama_lengkap 
                ELSE i.nama_lengkap 
            END ASC
    ");
    if ($stmt === false) {
        error_log("Prepare failed for post test submissions: " . $koneksi->error);
    } else {
        $stmt->bind_param("i", $training_id);
        $stmt->execute();
        $result = $stmt->get_result();
        while ($row = $result->fetch_assoc()) {
            $post_test_submissions[] = $row;
        }
        $stmt->close();
    }
}

?>
<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Hasil Post Test Peserta - E-Learning</title>
    <link rel="icon" type="image/png" href="image/icon.png">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.10.0/font/bootstrap-icons.css">
    <style>
        :root {
            --soft-ui-primary: #cb0c9f; /* Soft UI primary color */
            --soft-ui-secondary: #67748e; /* Soft UI secondary color */
            --soft-ui-info: #17c1e8; /* Soft UI info color */
            --soft-ui-success: #82d616; /* Soft UI success color */
            --soft-ui-warning: #fb8c00; /* Soft UI warning color */
            --soft-ui-danger: #ea0606; /* Soft UI danger color */
            --soft-ui-light: #e9ecef; /* Soft UI light color */
            --soft-ui-dark: #344767; /* Soft UI dark color */
            --soft-ui-white: #ffffff;
            --soft-ui-gray-100: #f8f9fa;
            --soft-ui-gray-200: #e9ecef;
            --soft-ui-gray-300: #dee2e6;
            --soft-ui-gray-400: #ced4da;
            --soft-ui-gray-500: #adb5bd;
            --soft-ui-gray-600: #6c757d;
            --soft-ui-gray-700: #495057;
            --soft-ui-gray-800: #343a40;
            --soft-ui-gray-900: #212529;
        }

        html, body {
            height: 100%;
            margin: 0;
            font-family: 'Open Sans', sans-serif; /* Soft UI font */
            background-color: var(--soft-ui-gray-100); /* Light background */
        }
        
        body {
            overflow-x: hidden;
            display: flex;
            flex-direction: column;
        }
        
        .navbar-top {
            position: fixed;
            top: 0;
            width: 100%;
            z-index: 1100;
            background: var(--soft-ui-white);
            border-bottom: 1px solid var(--soft-ui-gray-200);
            box-shadow: 0 2px 12px rgba(0, 0, 0, 0.05);
            padding: 0.75rem 1.5rem;
        }
        
        .navbar-top .container-fluid {
            display: flex;
            align-items: center;
            justify-content: space-between;
            flex-wrap: nowrap;
            position: relative;
        }
        
        /* Logo styling */
        .navbar-logo {
            height: 40px;
            width: auto;
            margin-right: 15px;
        }
        
        /* Center title styling */
        .navbar-title {
            position: absolute;
            left: 50%;
            transform: translateX(-50%);
            font-size: 1.3rem;
            color: var(--soft-ui-dark);
            font-weight: 700;
            text-align: center;
            white-space: nowrap;
            pointer-events: none; /* Prevent interference with dropdown */
        }

        /* Mobile title styling - 2 lines */
        .navbar-title-mobile {
            display: none;
            font-size: 0.85rem;
            color: var(--soft-ui-dark);
            font-weight: 700;
            text-align: center;
            line-height: 1.2;
            flex: 1;
            margin: 0 10px;
        }

        .navbar-title-mobile .line1 {
            display: block;
        }

        .navbar-title-mobile .line2 {
            display: block;
            font-size: 0.8rem;
        }
        
        .navbar-brand {
            font-size: 1.2rem;
            color: var(--soft-ui-dark);
            font-weight: 700;
            display: flex;
            align-items: center;
            z-index: 1;
        }

        .navbar-nav {
            position: relative;
            z-index: 1200; /* Higher z-index for dropdown */
        }

        .navbar-nav .nav-item .nav-link {
            color: var(--soft-ui-secondary);
            font-weight: 600;
            padding: 0.5rem 1rem;
            transition: all 0.2s ease-in-out;
        }

        .navbar-nav .nav-item .nav-link:hover {
            color: var(--soft-ui-primary);
        }

        .navbar-nav .nav-item .nav-link.active {
            color: var(--soft-ui-primary);
        }

        /* Fix dropdown menu positioning and z-index */
        .navbar-nav .dropdown-menu {
            position: absolute;
            top: 100%;
            right: 0;
            left: auto;
            z-index: 1300; /* Very high z-index */
            background-color: var(--soft-ui-white);
            border: 1px solid var(--soft-ui-gray-200);
            border-radius: 0.5rem;
            box-shadow: 0 4px 12px rgba(0, 0, 0, 0.15);
            min-width: 160px;
            margin-top: 0.125rem;
        }

        .navbar-nav .dropdown-item {
            color: var(--soft-ui-secondary);
            padding: 0.5rem 1rem;
            font-weight: 500;
            transition: all 0.2s ease-in-out;
        }

        .navbar-nav .dropdown-item:hover {
            background-color: var(--soft-ui-gray-200);
            color: var(--soft-ui-dark);
        }

        .navbar-nav .dropdown-item.active {
            background-color: var(--soft-ui-primary);
            color: var(--soft-ui-white);
        }
        
        .sidebar {
            min-height: 100vh;
            width: 250px;
            position: fixed;
            top: 0;
            left: 0;
            z-index: 1000;
            background: var(--soft-ui-white);
            color: var(--soft-ui-dark);
            padding-top: 70px; /* Space for top navbar */
            transition: all 0.3s ease-in-out;
            border-right: 1px solid var(--soft-ui-gray-200);
            box-shadow: 4px 0 15px rgba(0, 0, 0, 0.05);
            border-radius: 0 1rem 1rem 0; /* Rounded right corners */
        }
        
        .content {
            margin-left: 250px;
            margin-top: 0;
            padding: 20px;
            padding-top: 90px; /* Adjust for fixed top navbar */
            transition: all 0.3s ease-in-out;
            flex-grow: 1;
        }
        
        .hamburger-mobile {
            display: none;
            background: none;
            border: none;
            color: var(--soft-ui-dark);
            font-size: 1.5rem;
            cursor: pointer;
            margin-right: 15px;
            transition: all 0.3s ease;
            z-index: 1;
        }
        
        .hamburger-mobile:focus {
            outline: none;
        }
        
        .sidebar-overlay {
            display: none;
            position: fixed;
            top: 0;
            left: 0;
            right: 0;
            bottom: 0;
            background-color: rgba(0, 0, 0, 0.4);
            z-index: 999;
        }
        
        /* Profile Section Styles (adapted for Soft UI) */
        .profile-section {
            text-align: center;
            padding: 15px 20px;
            border-bottom: 1px solid var(--soft-ui-gray-200);
            background: var(--soft-ui-white);
            border-radius: 0.75rem;
            box-shadow: 0 4px 15px rgba(0, 0, 0, 0.05);
        }
        
        .profile-photo {
            width: 80px;
            height: 80px;
            border-radius: 50%;
            object-fit: cover;
            border: 2px solid var(--soft-ui-gray-300);
            margin: 0 auto 10px;
            display: block;
            box-shadow: 0 4px 10px rgba(0, 0, 0, 0.08);
        }
        
        .profile-photo-placeholder {
            width: 80px;
            height: 80px;
            border-radius: 50%;
            background: var(--soft-ui-gray-400);
            display: flex;
            align-items: center;
            justify-content: center;
            margin: 0 auto 10px;
            border: 2px solid var(--soft-ui-gray-300);
            box-shadow: 0 4px 10px rgba(0, 0, 0, 0.08);
        }
        
        .profile-photo-placeholder i {
            font-size: 2rem;
            color: var(--soft-ui-white);
        }
        
        .profile-name {
            font-size: 1.1rem;
            font-weight: 600;
            color: var(--soft-ui-dark);
            margin-bottom: 5px;
            word-wrap: break-word;
        }
        
        .profile-info {
            font-size: 0.9rem;
            font-weight: 400;
            color: var(--soft-ui-secondary);
            margin-bottom: 3px;
        }
        
        /* Sidebar Menu Styles */
        .sidebar .nav-link {
            color: var(--soft-ui-secondary);
            padding: 0.75rem 1rem;
            border-radius: 0.5rem;
            margin: 0.25rem 0.75rem;
            transition: all 0.2s ease-in-out;
            font-weight: 600;
            display: flex;
            align-items: center;
        }
        
        .sidebar .nav-link:hover {
            background-color: var(--soft-ui-gray-200);
            color: var(--soft-ui-dark);
        }
        
        .sidebar .nav-link.active {
            background-color: var(--soft-ui-primary);
            color: var(--soft-ui-white) !important;
            box-shadow: 0 4px 12px rgba(0, 0, 0, 0.1);
        }

        .sidebar .nav-link.active i {
            color: var(--soft-ui-white);
        }
        
        .sidebar .nav-link i {
            font-size: 1.2rem;
            margin-right: 10px;
            color: var(--soft-ui-secondary);
            transition: all 0.2s ease-in-out;
        }

        .sidebar .nav-item.dropdown .dropdown-menu {
            background-color: var(--soft-ui-white);
            border: none;
            box-shadow: 0 4px 12px rgba(0, 0, 0, 0.08);
            border-radius: 0.5rem;
            padding: 0.5rem 0;
            margin-top: 0.25rem;
        }

        .sidebar .nav-item.dropdown .dropdown-item {
            color: var(--soft-ui-secondary);
            padding: 0.5rem 1.5rem;
            font-weight: 500;
            transition: all 0.2s ease-in-out;
        }

        .sidebar .nav-item.dropdown .dropdown-item:hover {
            background-color: var(--soft-ui-gray-200);
            color: var(--soft-ui-dark);
        }

        .sidebar .nav-item.dropdown .dropdown-item.active {
            background-color: var(--soft-ui-primary);
            color: var(--soft-ui-white);
        }

        .sidebar .nav-item:not(:last-child) {
            border-bottom: none; /* Remove default border */
        }
        
        /* Card Styles - Updated to Soft UI */
        .card {
            transition: transform 0.3s ease, box-shadow 0.3s ease;
            border: 1px solid var(--soft-ui-gray-200);
            border-radius: 0.75rem;
            box-shadow: 0 4px 12px rgba(0, 0, 0, 0.05);
            overflow: hidden;
            background: var(--soft-ui-white);
            backdrop-filter: blur(10px);
        }
        
        .card:hover {
            transform: translateY(-3px);
            box-shadow: 0 6px 16px rgba(0, 0, 0, 0.08);
        }
        
        .card-header {
            padding: 25px 30px;
            color: var(--soft-ui-white);
            text-align: center;
            font-weight: 700;
            font-size: 1.4rem;
            background: linear-gradient(195deg, var(--soft-ui-primary), #a80a85);
            position: relative;
            border-radius: 0.75rem 0.75rem 0 0;
        }

        .card-header::before {
            content: '';
            position: absolute;
            top: 0;
            left: 0;
            right: 0;
            bottom: 0;
            background: linear-gradient(45deg, rgba(255, 255, 255, 0.1) 0%, transparent 50%);
            pointer-events: none;
        }

        .card-header i {
            margin-right: 10px;
            font-size: 1.3rem;
        }
        
        .card-body {
            padding: 30px;
            background: var(--soft-ui-white);
        }
        
        /* Button Styles - Updated to Soft UI */
        .btn-primary {
            background: linear-gradient(195deg, var(--soft-ui-primary), #a80a85);
            border: none;
            border-radius: 0.75rem;
            padding: 0.75rem 2rem;
            font-weight: 600;
            font-size: 1rem;
            box-shadow: 0 4px 12px rgba(203, 12, 159, 0.3);
            transition: all 0.3s ease;
            color: var(--soft-ui-white);
            text-transform: uppercase;
            letter-spacing: 0.5px;
        }
        
        .btn-primary:hover {
            background: linear-gradient(195deg, #a80a85, var(--soft-ui-primary));
            transform: translateY(-2px);
            box-shadow: 0 6px 16px rgba(203, 12, 159, 0.4);
            color: var(--soft-ui-white);
        }

        .btn-info {
            background: linear-gradient(195deg, var(--soft-ui-info), #0ea5e9);
            border: none;
            border-radius: 0.5rem;
            color: var(--soft-ui-white);
            font-weight: 600;
            transition: all 0.3s ease;
            box-shadow: 0 2px 8px rgba(23, 193, 232, 0.3);
        }

        .btn-info:hover {
            background: linear-gradient(195deg, #0ea5e9, var(--soft-ui-info));
            transform: translateY(-1px);
            box-shadow: 0 4px 12px rgba(23, 193, 232, 0.4);
            color: var(--soft-ui-white);
        }

        /* Button Export Excel - New Style */
        .btn-success {
            background: linear-gradient(195deg, var(--soft-ui-success), #20c997);
            border: none;
            border-radius: 0.75rem;
            padding: 0.75rem 2rem;
            font-weight: 600;
            font-size: 1rem;
            box-shadow: 0 4px 12px rgba(130, 214, 22, 0.3);
            transition: all 0.3s ease;
            color: var(--soft-ui-white);
            text-transform: uppercase;
            letter-spacing: 0.5px;
        }
        
        .btn-success:hover {
            background: linear-gradient(195deg, #20c997, var(--soft-ui-success));
            transform: translateY(-2px);
            box-shadow: 0 6px 16px rgba(130, 214, 22, 0.4);
            color: var(--soft-ui-white);
        }
        
        /* Alert Styles - Updated to Soft UI */
        .alert {
            border-radius: 0.75rem;
            padding: 1.5rem;
            border: none;
            box-shadow: 0 4px 12px rgba(0, 0, 0, 0.05);
            font-weight: 500;
        }

        .alert-danger {
            background: linear-gradient(195deg, rgba(234, 6, 6, 0.1), rgba(220, 53, 69, 0.1));
            color: var(--soft-ui-danger);
            border-left: 4px solid var(--soft-ui-danger);
        }

        .alert-warning {
            background: linear-gradient(195deg, rgba(251, 140, 0, 0.1), rgba(255, 193, 7, 0.1));
            color: var(--soft-ui-warning);
            border-left: 4px solid var(--soft-ui-warning);
        }
        
        .page-title {
            font-size: 2rem;
            font-weight: 700;
            color: var(--soft-ui-dark);
            margin-bottom: 30px;
            text-align: left;
            background: linear-gradient(195deg, var(--soft-ui-primary), #a80a85);
            -webkit-background-clip: text;
            -webkit-text-fill-color: transparent;
            background-clip: text;
        }
        
        footer {
            background: var(--soft-ui-white);
            color: var(--soft-ui-secondary);
            border-top: 1px solid var(--soft-ui-gray-200);
            padding: 1rem 0;
            text-align: center;
            flex-shrink: 0;
            margin-top: 2rem;
        }
        
        .animate-fade-in {
            animation: fadeIn 0.5s ease-in-out;
        }
        
        @keyframes fadeIn {
            from { opacity: 0; transform: translateY(10px); }
            to { opacity: 1; transform: translateY(0); }
        }
        
        /* Table Styles - Updated to Soft UI */
        .table {
            border-radius: 0.75rem;
            overflow: hidden;
            box-shadow: 0 4px 12px rgba(0, 0, 0, 0.05);
        }

        .table th, .table td {
            vertical-align: middle;
            font-size: 0.95rem;
            padding: 15px 20px;
            border: none;
        }
        
        .table th {
            background: linear-gradient(195deg, var(--soft-ui-primary), #a80a85);
            color: var(--soft-ui-white);
            font-weight: 700;
            text-transform: uppercase;
            letter-spacing: 0.5px;
            font-size: 0.85rem;
        }

        .table tbody tr {
            background: var(--soft-ui-white);
            transition: all 0.2s ease-in-out;
        }
        
        .table-hover tbody tr:hover {
            background: linear-gradient(195deg, rgba(203, 12, 159, 0.05), rgba(168, 10, 133, 0.05));
            transform: scale(1.01);
            box-shadow: 0 2px 8px rgba(0, 0, 0, 0.08);
        }

        .table tbody tr:nth-child(even) {
            background: var(--soft-ui-gray-100);
        }

        .table tbody tr:nth-child(even):hover {
            background: linear-gradient(195deg, rgba(203, 12, 159, 0.08), rgba(168, 10, 133, 0.08));
        }
        
        .btn-action {
            padding: 0.4rem 0.8rem;
            font-size: 0.85rem;
            border-radius: 0.5rem;
            margin-right: 5px;
            font-weight: 600;
            text-transform: uppercase;
            letter-spacing: 0.3px;
        }
        
        /* Badge styles for user types - Updated to Soft UI */
        .badge-peserta {
            background: linear-gradient(135deg, var(--soft-ui-success) 0%, #20c997 100%);
            color: var(--soft-ui-white);
            font-size: 0.8rem;
            padding: 0.4rem 0.8rem;
            border-radius: 0.75rem;
            font-weight: 600;
            text-transform: uppercase;
            letter-spacing: 0.3px;
            box-shadow: 0 2px 8px rgba(130, 214, 22, 0.3);
        }
        
        .badge-iss {
            background: linear-gradient(135deg, var(--soft-ui-primary) 0%, #e83e8c 100%);
            color: var(--soft-ui-white);
            font-size: 0.8rem;
            padding: 0.4rem 0.8rem;
            border-radius: 0.75rem;
            font-weight: 600;
            text-transform: uppercase;
            letter-spacing: 0.3px;
            box-shadow: 0 2px 8px rgba(203, 12, 159, 0.3);
        }

        /* Action buttons container */
        .action-buttons {
            display: flex;
            gap: 15px;
            margin-bottom: 20px;
            flex-wrap: wrap;
        }

        /* Responsive adjustments */
        @media (max-width: 768px) {
            .sidebar {
                margin-left: -250px;
                border-radius: 0;
                padding-top: 90px; /* Increased for mobile navbar height */
            }
            .sidebar-active {
                margin-left: 0;
            }
            .content {
                margin-left: 0;
                padding-top: 100px; /* Increased for mobile navbar height */
            }
            
            /* Hide desktop title and logo on mobile */
            .navbar-title {
                display: none;
            }
            .navbar-logo {
                display: none;
            }
            
            /* Show mobile title */
            .navbar-title-mobile {
                display: block;
            }
            
            .hamburger-mobile {
                display: block;
            }
            .navbar-search {
                display: none; /* Hide search on small screens */
            }
            .navbar-nav {
                position: static;
            }
            .navbar-nav .dropdown-menu {
                position: absolute;
                right: 0;
                left: auto;
                z-index: 1300;
            }
            
            /* Adjust navbar height for mobile */
            .navbar-top {
                padding: 0.5rem 1rem;
                min-height: 70px;
            }

            .profile-photo, .profile-photo-placeholder {
                width: 60px;
                height: 60px;
            }
            .profile-photo-placeholder i {
                font-size: 1.5rem;
            }
            .profile-name {
                font-size: 1rem;
            }
            .profile-info {
                font-size: 0.8rem;
            }

            .page-title {
                font-size: 1.5rem;
            }

            .table th, .table td {
                padding: 10px 12px;
                font-size: 0.85rem;
            }

            .btn-action {
                padding: 0.3rem 0.6rem;
                font-size: 0.75rem;
            }

            .action-buttons {
                flex-direction: column;
                gap: 10px;
            }

            .btn-success, .btn-primary {
                width: 100%;
                text-align: center;
            }
        }

        @media (max-width: 576px) {
            .navbar-top {
                padding: 0.5rem 1rem;
                min-height: 70px;
            }
            .navbar-title-mobile {
                font-size: 0.8rem;
            }
            .navbar-title-mobile .line2 {
                font-size: 0.75rem;
            }
            
            .profile-photo, .profile-photo-placeholder {
                width: 50px;
                height: 50px;
            }
            .profile-photo-placeholder i {
                font-size: 1.2rem;
            }
            .profile-name {
                font-size: 0.9rem;
            }
            .profile-info {
                font-size: 0.7rem;
            }

            .page-title {
                font-size: 1.3rem;
            }

            .table th, .table td {
                padding: 8px 10px;
                font-size: 0.8rem;
            }

            .badge-peserta, .badge-iss {
                font-size: 0.7rem;
                padding: 0.3rem 0.6rem;
            }
        }
    </style>
</head>
<body>
    <!-- Top Navbar -->
    <nav class="navbar navbar-expand-lg navbar-top">
        <div class="container-fluid">
            <button class="hamburger-mobile d-md-none" type="button" id="sidebarToggle">
                <i class="bi bi-list"></i>
            </button>
            <a class="navbar-brand d-none d-md-flex" href="#">
                <img src="image/logopim.png" alt="Logo PIM" class="navbar-logo">
            </a>
            <div class="navbar-title d-none d-md-block">
                E-Learning System Pondok Indah Mall
            </div>
            <div class="navbar-title-mobile d-md-none">
                <span class="line1">E-Learning System</span>
                <span class="line2">Pondok Indah Mall</span>
            </div>
            <ul class="navbar-nav ms-auto mb-2 mb-lg-0">
                <li class="nav-item dropdown">
                    <a class="nav-link dropdown-toggle text-dark" href="#" id="navbarDropdown" role="button" data-bs-toggle="dropdown" aria-expanded="false">
                        <i class="bi bi-person-circle"></i>
                    </a>
                    <ul class="dropdown-menu dropdown-menu-end">
                        <li><a class="dropdown-item <?php echo ($current_page == 'profile.php') ? 'active' : ''; ?>" href="profile.php">Profile</a></li>
                        <li><a class="dropdown-item <?php echo ($current_page == 'change_password.php') ? 'active' : ''; ?>" href="change_password.php">Change Password</a></li>
                        <li><hr class="dropdown-divider"></li>
                        <li><a class="dropdown-item" href="logout.php">Logout</a></li>
                    </ul>
                </li>
            </ul>
        </div>
    </nav>

    <!-- Sidebar overlay (for mobile) -->
    <div class="sidebar-overlay" id="sidebarOverlay"></div>

    <!-- Sidebar -->
    <div class="sidebar border-end" id="sidebar">
        <!-- Profile Section moved here, directly after sidebar padding-top -->
        <div class="profile-section">
            <?php if (!empty($user['foto_profil'])): ?>
                <img src="Uploads/profiles/<?php echo htmlspecialchars($user['foto_profil']); ?>" alt="Foto Profil" class="profile-photo">
            <?php else: ?>
                <div class="profile-photo-placeholder">
                    <i class="bi bi-person-circle"></i>
                </div>
            <?php endif; ?>
            <div class="profile-name"><?php echo htmlspecialchars($user['nama_lengkap']); ?></div>
            <div class="profile-info"><?php echo htmlspecialchars($user['jabatan'] ?? 'Tidak ada jabatan'); ?></div>
            <div class="profile-info"><?php echo htmlspecialchars($user['divisi'] ?? 'Tidak ada divisi'); ?></div>
        </div>
        <div class="p-3">
            <h5 class="mb-4 text-dark">Menu</h5>
            <ul class="nav flex-column">
                <li class="nav-item">
                    <a class="nav-link <?php echo ($current_page == 'dashboard.php') ? 'active' : ''; ?>" href="dashboard.php">
                        <i class="bi bi-house-door-fill"></i> Dashboard
                    </a>
                </li>
                <li class="nav-item">
                    <a class="nav-link <?php echo ($current_page == 'materi.php') ? 'active' : ''; ?>" href="materi.php">
                        <i class="bi bi-book"></i> Materi
                    </a>
                </li>
            <?php if ($role == 'trainer'): ?>
                <li class="nav-item dropdown">
                    <a class="nav-link dropdown-toggle <?php echo ($current_page == 'add_posttest.php' || $current_page == 'list_posttest.php' || $current_page == 'view_posttest_scores.php') ? 'active' : ''; ?>" href="#" id="postTestDropdown" role="button" data-bs-toggle="dropdown" aria-expanded="false">
                        <i class="bi bi-clipboard-check"></i> Post Test
                    </a>
                    <ul class="dropdown-menu" aria-labelledby="postTestDropdown">
                        <li><a class="dropdown-item <?php echo ($current_page == 'add_posttest.php') ? 'active' : ''; ?>" href="add_posttest.php">Tambah Post Test</a></li>
                        <li><a class="dropdown-item <?php echo ($current_page == 'list_posttest.php' || $current_page == 'view_posttest_scores.php') ? 'active' : ''; ?>" href="list_posttest.php">List Post Test</a></li>
                    </ul>
                </li>
            <?php endif; ?>
                <li class="nav-item dropdown">
                    <a class="nav-link dropdown-toggle <?php echo ($current_page == 'add_training.php' || $current_page == 'list_training.php') ? 'active' : ''; ?>" href="#" id="trainingDropdown" role="button" data-bs-toggle="dropdown" aria-expanded="false">
                        <i class="bi bi-journal-text"></i> Training
                    </a>
                    <ul class="dropdown-menu" aria-labelledby="trainingDropdown">
                        <?php if($role == 'trainer'): ?>
                        <li><a class="dropdown-item <?php echo ($current_page == 'add_training.php') ? 'active' : ''; ?>" href="add_training.php">Tambah Kegiatan Training</a></li>
                        <?php endif; ?>
                        <li><a class="dropdown-item <?php echo ($current_page == 'list_training.php') ? 'active' : ''; ?>" href="list_training.php">List Training</a></li>
                    </ul>
                </li>
            <?php if ($role == 'trainer'): ?>
                <li class="nav-item">
                    <a class="nav-link <?php echo ($current_page == 'report.php') ? 'active' : ''; ?>" href="report.php">
                        <i class="bi bi-file-earmark-text"></i> Report
                    </a>
                </li>
                <li class="nav-item">
                    <a class="nav-link <?php echo ($current_page == 'data_evaluasi.php') ? 'active' : ''; ?>" href="data_evaluasi.php">
                        <i class="bi bi-clipboard-data"></i> Data Evaluasi
                    </a>
                </li>
            <?php endif; ?>
            </ul>
        </div>
    </div>

    <!-- Content -->
    <div class="content">
        <div class="container mt-4">
            <h2 class="page-title animate-fade-in">
                <i class="bi bi-clipboard-data me-3"></i>
                Hasil Post Test Peserta: <?php echo htmlspecialchars($training_title); ?>
            </h2>

            <!-- Tambahkan button export di sini -->
            <div class="mb-3 animate-fade-in">
                <a href="export_posttest_excel.php?training_id=<?php echo htmlspecialchars($training_id); ?>" class="btn btn-success" target="_blank">
                    <i class="bi bi-file-earmark-excel me-2"></i> Export to Excel
                </a>
            </div>

            <?php if (!$training_id): ?>
                <div class="alert alert-danger text-center animate-fade-in">
                    <i class="bi bi-exclamation-triangle me-2"></i>
                    ID Training tidak ditemukan. Silakan kembali ke <a href="list_posttest.php" class="text-decoration-none fw-bold">List Post Test</a>.
                </div>
            <?php elseif (empty($post_test_submissions)): ?>
                <div class="alert alert-warning text-center animate-fade-in">
                    <i class="bi bi-info-circle me-2"></i>
                    Belum ada peserta yang mengerjakan post test untuk training ini.
                </div>
            <?php else: ?>

                <div class="card animate-fade-in">
                    <div class="card-header">
                        <i class="bi bi-table"></i>
                        Daftar Nilai Post Test (Diurutkan berdasarkan Divisi)
                    </div>
                    <div class="card-body">
                        <div class="table-responsive">
                            <table class="table table-hover">
                                <thead>
                                    <tr>
                                        <th><i class="bi bi-hash me-1"></i>No.</th>
                                        <th><i class="bi bi-person me-1"></i>Nama Peserta</th>
                                        <th><i class="bi bi-people me-1"></i>Tipe Karyawan</th>
                                        <th><i class="bi bi-building me-1"></i>Divisi</th>
                                        <th><i class="bi bi-award me-1"></i>Score</th>
                                        <th><i class="bi bi-clock me-1"></i>Waktu Submit</th>
                                        <th><i class="bi bi-gear me-1"></i>Aksi</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php $no = 1; foreach ($post_test_submissions as $submission): ?>
                                        <tr>
                                            <td><strong><?php echo $no++; ?></strong></td>
                                            <td>
                                                <strong><?php echo htmlspecialchars($submission['user_role'] == 'peserta' ? $submission['peserta_nama'] : $submission['iss_nama']); ?></strong>
                                            </td>
                                            <td>
                                                <?php if($submission['user_role'] == 'iss'): ?>
                                                    <span class="badge badge-iss">
                                                        <i class="bi bi-person me-1"></i> ISS
                                                    </span>
                                                <?php else: ?>
                                                    <span class="badge badge-peserta">
                                                        <i class="bi bi-person me-1"></i> Peserta
                                                    </span>
                                                <?php endif; ?>
                                            </td>
                                            <td><?php echo htmlspecialchars($submission['user_role'] == 'peserta' ? ($submission['peserta_divisi'] ?? '-') : ($submission['iss_divisi'] ?? '-')); ?></td>
                                            <td>
                                                <span class="fw-bold text-primary"><?php echo htmlspecialchars($submission['score']); ?></span>
                                            </td>
                                            <td>
                                                <small class="text-muted"><?php echo htmlspecialchars($submission['submission_time']); ?></small>
                                            </td>
                                            <td>
                                                <a href="post_test_result.php?submission_id=<?php echo htmlspecialchars($submission['submission_id']); ?>" class="btn btn-sm btn-info btn-action" title="Lihat Detail">
                                                    <i class="bi bi-eye me-1"></i> Detail
                                                </a>
                                            </td>
                                        </tr>
                                    <?php endforeach; ?>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
                
                <div class="mt-4 text-center">
                    <a href="list_posttest.php" class="btn btn-primary">
                        <i class="bi bi-arrow-left me-2"></i> Kembali ke List Post Test
                    </a>
                </div>
            <?php endif; ?>
        </div>
    </div>

    <footer class="text-center">
        <div class="container">
            <p class="mb-0">© <?php echo date('Y'); ?> E-Learning System by PIM</p>
        </div>
    </footer>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
    <script>
        // Toggle sidebar for mobile
        document.addEventListener('DOMContentLoaded', function() {
            const sidebarToggle = document.getElementById('sidebarToggle');
            const sidebar = document.getElementById('sidebar');
            const sidebarOverlay = document.getElementById('sidebarOverlay');
            const trainingDropdownToggle = document.getElementById('trainingDropdown');
            const postTestDropdownToggle = document.getElementById('postTestDropdown');
            
            let isDropdownClick = false;

            function toggleSidebar() {
                sidebar.classList.toggle('sidebar-active');
                sidebarOverlay.style.display = sidebar.classList.contains('sidebar-active') ? 'block' : 'none';
                
                if (sidebar.classList.contains('sidebar-active')) {
                    document.body.style.overflow = 'hidden';
                } else {
                    document.body.style.overflow = '';
                }
            }

            sidebarToggle.addEventListener('click', function(e) {
                e.stopPropagation();
                toggleSidebar();
            });

            sidebarOverlay.addEventListener('click', function() {
                if (!isDropdownClick) {
                    toggleSidebar();
                }
                isDropdownClick = false;
            });

            if (trainingDropdownToggle) {
                trainingDropdownToggle.addEventListener('click', function(e) {
                    if (window.innerWidth <= 768) {
                        isDropdownClick = true;
                    }
                });
            }

            if (postTestDropdownToggle) {
                postTestDropdownToggle.addEventListener('click', function(e) {
                    if (window.innerWidth <= 768) {
                        isDropdownClick = true;
                    }
                });
            }
            
            document.addEventListener('click', function(e) {
                if (window.innerWidth <= 768) {
                    let clickedInsideAnyDropdown = false;
                    if (trainingDropdownToggle && trainingDropdownToggle.contains(e.target)) {
                        clickedInsideAnyDropdown = true;
                    }
                    if (postTestDropdownToggle && postTestDropdownToggle.contains(e.target)) {
                        clickedInsideAnyDropdown = true;
                    }
                    if (!clickedInsideAnyDropdown) {
                        isDropdownClick = false;
                    }
                }
            });

            const regularNavLinks = document.querySelectorAll('.sidebar .nav-link:not(.dropdown-toggle)');
            regularNavLinks.forEach(link => {
                link.addEventListener('click', function() {
                    if (window.innerWidth <= 768 && sidebar.classList.contains('sidebar-active')) {
                        toggleSidebar();
                    }
                });
            });

            const dropdownItems = document.querySelectorAll('.sidebar .dropdown-menu .dropdown-item');
            dropdownItems.forEach(item => {
                item.addEventListener('click', function() {
                    if (window.innerWidth <= 768 && sidebar.classList.contains('sidebar-active')) {
                        toggleSidebar();
                    }
                });
            });

            window.addEventListener('resize', function() {
                if (window.innerWidth > 768) {
                    sidebar.classList.remove('sidebar-active');
                    sidebarOverlay.style.display = 'none';
                    document.body.style.overflow = '';
                    isDropdownClick = false;
                }
            });
        });
    </script>
</body>
</html>
