<?php
require_once 'koneksi.php';

// Cek login
checkLogin();

$user_id = $_SESSION['user_id'];
$role = $_SESSION['role'];
$nik_karyawan = $_SESSION['nik_karyawan'];

// Ambil informasi user menggunakan prepared statement
if ($role == 'trainer') {
    $stmt = $koneksi->prepare("SELECT nama_lengkap, foto_profil, jabatan, divisi FROM trainers WHERE id = ?");
} elseif ($role == 'iss') {
    $stmt = $koneksi->prepare("SELECT nama_lengkap, foto_profil, jabatan, divisi FROM iss WHERE id = ?");
} else {
    $stmt = $koneksi->prepare("SELECT nama_lengkap, foto_profil, jabatan, divisi FROM peserta WHERE id = ?");
}
$stmt->bind_param("i", $user_id);
$stmt->execute();
$result = $stmt->get_result();
$user = $result->fetch_assoc();
$nama_lengkap = $user['nama_lengkap'] ?? 'Unknown';
$stmt->close();

// Ambil data training berdasarkan ID
if (!isset($_GET['id']) || !is_numeric($_GET['id'])) {
    header("Location: list_training.php?error=ID training tidak valid");
    exit();
}

$training_id = (int)$_GET['id'];
$stmt = $koneksi->prepare("SELECT judul, file_name, file_type FROM trainings WHERE id = ?");
$stmt->bind_param("i", $training_id);
$stmt->execute();
$result = $stmt->get_result();

if ($result->num_rows == 0) {
    header("Location: list_training.php?error=Training tidak ditemukan");
    exit();
}

$training = $result->fetch_assoc();
$file_path = 'Uploads/trainings/' . $training['file_name'];
$file_type = strtolower($training['file_type']);
$stmt->close();

// Cek apakah file ada di server
$absolute_file_path = $_SERVER['DOCUMENT_ROOT'] . '/' . $file_path;
if (!file_exists($file_path)) {
    header("Location: list_training.php?error=File tidak ditemukan di server");
    exit();
}

// Fungsi untuk menentukan cara menampilkan file
function canDisplayInline($file_type) {
    $inline_types = ['pdf', 'jpg', 'jpeg', 'png', 'gif', 'txt'];
    return in_array(strtolower($file_type), $inline_types);
}

function isGoogleDocsSupported($file_type) {
    $supported_types = ['pdf', 'doc', 'docx', 'xls', 'xlsx', 'ppt', 'pptx'];
    return in_array(strtolower($file_type), $supported_types);
}

// Set current page untuk highlight menu
$current_page = basename($_SERVER['PHP_SELF']);
?>
<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Lihat File Training - E-Learning</title>
    <link rel="icon" type="image/png" href="image/icon.png">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.10.0/font/bootstrap-icons.css">
    <style>
        :root {
            --soft-ui-primary-start: #00C4CC;
            --soft-ui-primary-end: #CB0C9F;
            --soft-ui-secondary: #67748E;
            --soft-ui-info: #17C1E8;
            --soft-ui-success: #82D616;
            --soft-ui-warning: #FB8C00;
            --soft-ui-danger: #EA0606;
            --soft-ui-light: #E9ECEF;
            --soft-ui-dark: #344767;
            --soft-ui-white: #FFFFFF;
            --soft-ui-gray-100: #F8F9FA;
            --soft-ui-gray-200: #E9ECEF;
            --soft-ui-gray-300: #DEE2E6;
            --soft-ui-gray-400: #CED4DA;
            --soft-ui-gray-500: #ADB5BD;
            --soft-ui-gray-600: #6C757D;
            --soft-ui-gray-700: #495057;
            --soft-ui-gray-800: #343A40;
            --soft-ui-gray-900: #212529;
        }

        html, body {
            height: 100%;
            margin: 0;
            font-family: 'Open Sans', sans-serif;
            background-color: var(--soft-ui-gray-100);
        }
        
        body {
            overflow-x: hidden;
            display: flex;
            flex-direction: column;
        }
        
        .navbar-top {
            position: fixed;
            top: 0;
            width: 100%;
            z-index: 1100;
            background: var(--soft-ui-white);
            border-bottom: 1px solid var(--soft-ui-gray-200);
            box-shadow: 0 2px 12px rgba(0, 0, 0, 0.05);
            padding: 0.75rem 1.5rem;
        }
        
        .navbar-top .container-fluid {
            display: flex;
            align-items: center;
            justify-content: space-between;
            flex-wrap: nowrap;
            position: relative;
        }
        
        .navbar-logo {
            height: 40px;
            width: auto;
            margin-right: 15px;
        }
        
        .navbar-title {
            position: absolute;
            left: 50%;
            transform: translateX(-50%);
            font-size: 1.3rem;
            color: var(--soft-ui-dark);
            font-weight: 700;
            text-align: center;
            white-space: nowrap;
            pointer-events: none;
        }

        .navbar-title-mobile {
            display: none;
            font-size: 0.85rem;
            color: var(--soft-ui-dark);
            font-weight: 700;
            text-align: center;
            line-height: 1.2;
            flex: 1;
            margin: 0 10px;
        }

        .navbar-title-mobile .line1 {
            display: block;
        }

        .navbar-title-mobile .line2 {
            display: block;
            font-size: 0.8rem;
        }
        
        .navbar-brand {
            font-size: 1.2rem;
            color: var(--soft-ui-dark);
            font-weight: 700;
            display: flex;
            align-items: center;
            z-index: 1;
        }

        .navbar-nav .nav-item .nav-link {
            color: var(--soft-ui-secondary);
            font-weight: 600;
            padding: 0.5rem 1rem;
            transition: all 0.2s ease-in-out;
        }

        .navbar-nav .nav-item .nav-link:hover {
            color: var(--soft-ui-primary-end);
        }

        .navbar-nav .nav-item .nav-link.active {
            color: var(--soft-ui-primary-end);
        }

        .navbar-nav .dropdown-menu {
            position: absolute;
            top: 100%;
            right: 0;
            left: auto;
            z-index: 1300;
            background-color: var(--soft-ui-white);
            border: 1px solid var(--soft-ui-gray-200);
            border-radius: 0.5rem;
            box-shadow: 0 4px 12px rgba(0, 0, 0, 0.15);
            min-width: 160px;
            margin-top: 0.125rem;
        }

        .navbar-nav .dropdown-item {
            color: var(--soft-ui-secondary);
            padding: 0.5rem 1rem;
            font-weight: 500;
            transition: all 0.2s ease-in-out;
        }

        .navbar-nav .dropdown-item:hover {
            background-color: var(--soft-ui-gray-200);
            color: var(--soft-ui-dark);
        }

        .navbar-nav .dropdown-item.active {
            background-color: var(--soft-ui-primary-end);
            color: var(--soft-ui-white);
        }
        
        .sidebar {
            min-height: 100vh;
            width: 250px;
            position: fixed;
            top: 0;
            left: 0;
            z-index: 1000;
            background: var(--soft-ui-white);
            color: var(--soft-ui-dark);
            padding-top: 70px;
            transition: all 0.3s ease-in-out;
            border-right: 1px solid var(--soft-ui-gray-200);
            box-shadow: 4px 0 15px rgba(0, 0, 0, 0.05);
            border-radius: 0 1rem 1rem 0;
        }

        .content {
            margin-left: 250px;
            margin-top: 0;
            padding: 20px;
            padding-top: 90px;
            transition: all 0.3s ease-in-out;
            flex-grow: 1;
        }
        
        .hamburger-mobile {
            display: none;
            background: none;
            border: none;
            color: var(--soft-ui-dark);
            font-size: 1.5rem;
            cursor: pointer;
            margin-right: 15px;
            transition: all 0.3s ease;
            z-index: 1;
        }
        
        .hamburger-mobile:focus {
            outline: none;
        }
        
        .sidebar-overlay {
            display: none;
            position: fixed;
            top: 0;
            left: 0;
            right: 0;
            bottom: 0;
            background-color: rgba(0, 0, 0, 0.4);
            z-index: 999;
        }
        
        .profile-section {
            text-align: center;
            padding: 15px 20px;
            border-bottom: 1px solid var(--soft-ui-gray-200);
            background: var(--soft-ui-white);
            border-radius: 0.75rem;
            box-shadow: 0 4px 15px rgba(0, 0, 0, 0.05);
        }
        
        .profile-photo {
            width: 80px;
            height: 80px;
            border-radius: 50%;
            object-fit: cover;
            border: 2px solid var(--soft-ui-gray-300);
            margin: 0 auto 10px;
            display: block;
            box-shadow: 0 4px 10px rgba(0, 0, 0, 0.08);
        }
        
        .profile-photo-placeholder {
            width: 80px;
            height: 80px;
            border-radius: 50%;
            background: var(--soft-ui-gray-400);
            display: flex;
            align-items: center;
            justify-content: center;
            margin: 0 auto 10px;
            border: 2px solid var(--soft-ui-gray-300);
            box-shadow: 0 4px 10px rgba(0, 0, 0, 0.08);
        }
        
        .profile-photo-placeholder i {
            font-size: 2rem;
            color: var(--soft-ui-white);
        }
        
        .profile-name {
            font-size: 1.1rem;
            font-weight: 600;
            color: var(--soft-ui-dark);
            margin-bottom: 5px;
            word-wrap: break-word;
        }
        
        .profile-info {
            font-size: 0.9rem;
            font-weight: 400;
            color: var(--soft-ui-secondary);
            margin-bottom: 3px;
        }
        
        .sidebar .nav-link {
            color: var(--soft-ui-secondary);
            padding: 0.75rem 1rem;
            border-radius: 0.5rem;
            margin: 0.25rem 0.75rem;
            transition: all 0.2s ease-in-out;
            font-weight: 600;
            display: flex;
            align-items: center;
        }
        
        .sidebar .nav-link:hover {
            background: linear-gradient(90deg, rgba(0, 196, 204, 0.1), rgba(203, 12, 159, 0.1));
            color: var(--soft-ui-dark);
        }
        
        .sidebar .nav-link.active {
            background: linear-gradient(195deg, var(--soft-ui-primary-start), var(--soft-ui-primary-end));
            color: var(--soft-ui-white) !important;
            box-shadow: 0 4px 12px rgba(0, 0, 0, 0.1);
        }

        .sidebar .nav-link.active i {
            color: var(--soft-ui-white);
        }
        
        .sidebar .nav-link i {
            font-size: 1.2rem;
            margin-right: 10px;
            color: var(--soft-ui-secondary);
            transition: all 0.2s ease-in-out;
        }

        .sidebar .nav-item.dropdown .dropdown-menu {
            background-color: var(--soft-ui-white);
            border: none;
            box-shadow: 0 4px 12px rgba(0, 0, 0, 0.08);
            border-radius: 0.5rem;
            padding: 0.5rem 0;
            margin-top: 0.25rem;
        }

        .sidebar .nav-item.dropdown .dropdown-item {
            color: var(--soft-ui-secondary);
            padding: 0.5rem 1.5rem;
            font-weight: 500;
            transition: all 0.2s ease-in-out;
        }

        .sidebar .nav-item.dropdown .dropdown-item:hover {
            background: linear-gradient(90deg, rgba(0, 196, 204, 0.1), rgba(203, 12, 159, 0.1));
            color: var(--soft-ui-dark);
        }

        .sidebar .nav-item.dropdown .dropdown-item.active {
            background: linear-gradient(195deg, var(--soft-ui-primary-start), var(--soft-ui-primary-end));
            color: var(--soft-ui-white);
        }

        .sidebar .nav-item:not(:last-child) {
            border-bottom: none;
        }
        
        .viewer-card {
            background-color: var(--soft-ui-white);
            border-radius: 0.75rem;
            box-shadow: 0 4px 12px rgba(0, 0, 0, 0.05);
            transition: all 0.2s ease-in-out;
            position: relative;
            border: 1px solid var(--soft-ui-gray-200);
        }

        .viewer-card:hover {
            transform: translateY(-3px);
            box-shadow: 0 6px 16px rgba(0, 0, 0, 0.08);
        }
        
        .viewer-header {
            padding: 20px;
            color: var(--soft-ui-white);
            text-align: center;
            font-weight: 600;
            font-size: 1.25rem;
            background: linear-gradient(195deg, var(--soft-ui-primary-start), var(--soft-ui-primary-end));
            border-top-left-radius: 0.75rem;
            border-top-right-radius: 0.75rem;
        }
        
        .viewer-body {
            padding: 20px;
        }
        
        .file-viewer {
            width: 100%;
            border: none;
            border-radius: 8px;
            box-shadow: 0 4px 8px rgba(0, 0, 0, 0.05);
            background: var(--soft-ui-white);
        }
        
        /* Fullscreen button style */
        .btn-fullscreen {
            background: linear-gradient(195deg, var(--soft-ui-info), var(--soft-ui-primary-start));
            border: none;
            border-radius: 0.5rem;
            padding: 0.75rem 1.5rem;
            font-weight: 600;
            color: var(--soft-ui-white);
            transition: all 0.3s ease;
            box-shadow: 0 4px 12px rgba(23, 193, 232, 0.3);
        }
        
        .btn-fullscreen:hover {
            background: linear-gradient(195deg, var(--soft-ui-primary-start), var(--soft-ui-info));
            transform: translateY(-2px);
            box-shadow: 0 6px 16px rgba(0, 196, 204, 0.4);
            color: var(--soft-ui-white);
        }
        
        .btn-primary {
            background: linear-gradient(195deg, var(--soft-ui-primary-start), var(--soft-ui-primary-end));
            border: none;
            border-radius: 0.5rem;
            padding: 0.75rem 1.5rem;
            font-weight: 600;
            transition: all 0.3s ease;
            box-shadow: 0 4px 12px rgba(0, 196, 204, 0.3);
        }
        
        .btn-primary:hover {
            background: linear-gradient(195deg, var(--soft-ui-primary-end), var(--soft-ui-primary-start));
            transform: translateY(-2px);
            box-shadow: 0 6px 16px rgba(203, 12, 159, 0.4);
        }
        
        .btn-secondary {
            background-color: var(--soft-ui-gray-600);
            border: none;
            border-radius: 0.5rem;
            padding: 0.75rem 1.5rem;
            font-weight: 600;
            transition: all 0.3s ease;
        }
        
        .btn-secondary:hover {
            background-color: var(--soft-ui-gray-700);
            transform: translateY(-2px);
        }
        
        footer {
            background: var(--soft-ui-white);
            color: var(--soft-ui-secondary);
            border-top: 1px solid var(--soft-ui-gray-200);
            padding: 1rem 0;
            text-align: center;
            flex-shrink: 0;
            margin-top: 2rem;
        }
        
        .animate-fade-in {
            animation: fadeIn 0.5s ease-in-out;
        }
        
        @keyframes fadeIn {
            from { opacity: 0; transform: translateY(10px); }
            to { opacity: 1; transform: translateY(0); }
        }
        
        .alert {
            border-radius: 8px;
            padding: 1rem;
            border: none;
            box-shadow: 0 4px 12px rgba(0, 0, 0, 0.05);
        }
        
        .no-preview {
            text-align: center;
            padding: 50px;
            background: var(--soft-ui-gray-100);
            border-radius: 8px;
            color: var(--soft-ui-secondary);
            border: 1px solid var(--soft-ui-gray-200);
        }
        
        .no-preview i {
            font-size: 3rem;
            margin-bottom: 15px;
            color: var(--soft-ui-gray-400);
        }

        /* Fullscreen overlay styles */
        .fullscreen-overlay {
            position: fixed;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            background-color: rgba(0, 0, 0, 0.95);
            z-index: 9999;
            display: none;
            flex-direction: column;
            align-items: center;
            justify-content: center;
        }

        .fullscreen-header {
            width: 100%;
            padding: 15px 20px;
            background: linear-gradient(195deg, var(--soft-ui-primary-start), var(--soft-ui-primary-end));
            color: var(--soft-ui-white);
            display: flex;
            justify-content: space-between;
            align-items: center;
            z-index: 10000;
        }

        .fullscreen-title {
            font-size: 1.2rem;
            font-weight: 600;
        }

        .fullscreen-close {
            background: none;
            border: none;
            color: var(--soft-ui-white);
            font-size: 1.5rem;
            cursor: pointer;
            padding: 5px;
            border-radius: 5px;
            transition: all 0.2s ease;
        }

        .fullscreen-close:hover {
            background-color: rgba(255, 255, 255, 0.2);
        }

        .fullscreen-content {
            width: 100%;
            height: calc(100% - 60px);
            display: flex;
            align-items: center;
            justify-content: center;
            overflow: auto;
            position: relative;
        }

        .fullscreen-pdf {
            width: 100%;
            height: 100%;
            border: none;
        }

        .fullscreen-image {
            max-width: 100%;
            max-height: 100%;
            object-fit: contain;
        }

        .fullscreen-text {
            width: 80%;
            max-width: 1200px;
            height: 90%;
            background: var(--soft-ui-white);
            padding: 30px;
            border-radius: 8px;
            overflow: auto;
        }

        .fullscreen-text pre {
            white-space: pre-wrap;
            font-family: 'Courier New', monospace;
            color: var(--soft-ui-dark);
        }

        @media (max-width: 768px) {
            .sidebar {
                margin-left: -250px;
                border-radius: 0;
                padding-top: 90px;
            }
            .sidebar-active {
                margin-left: 0;
            }
            .content {
                margin-left: 0;
                padding-top: 100px;
            }
            
            .navbar-title {
                display: none;
            }
            .navbar-logo {
                display: none;
            }
            
            .navbar-title-mobile {
                display: block;
            }
            
            .hamburger-mobile {
                display: block;
            }
            .navbar-search {
                display: none;
            }
            .navbar-nav {
                position: static;
            }
            .navbar-nav .dropdown-menu {
                position: absolute;
                right: 0;
                left: auto;
                z-index: 1300;
            }

            .navbar-top {
                padding: 0.5rem 1rem;
                min-height: 70px;
            }

            .profile-photo, .profile-photo-placeholder {
                width: 60px;
                height: 60px;
            }
            .profile-photo-placeholder i {
                font-size: 1.5rem;
            }
            .profile-name {
                font-size: 1rem;
            }
            .profile-info {
                font-size: 0.8rem;
            }

            .file-viewer {
                height: 400px !important;
            }
            .viewer-header {
                font-size: 1rem;
            }
            .btn-primary, .btn-secondary, .btn-fullscreen {
                padding: 0.5rem 1rem;
                font-size: 0.9rem;
            }
            
            .fullscreen-text {
                width: 95%;
                padding: 15px;
            }
            
            .fullscreen-title {
                font-size: 1rem;
            }
        }

        @media (max-width: 576px) {
            .navbar-top {
                padding: 0.5rem 1rem;
                min-height: 70px;
            }
            .navbar-title-mobile {
                font-size: 0.8rem;
            }
            .navbar-title-mobile .line2 {
                font-size: 0.75rem;
            }

            .profile-photo, .profile-photo-placeholder {
                width: 50px;
                height: 50px;
            }
            .profile-photo-placeholder i {
                font-size: 1.2rem;
            }
            .profile-name {
                font-size: 0.9rem;
            }
            .profile-info {
                font-size: 0.7rem;
            }
        }
    </style>
</head>
<body>
    <nav class="navbar navbar-expand-lg navbar-top">
        <div class="container-fluid">
            <button class="hamburger-mobile d-md-none" type="button" id="sidebarToggle">
                <i class="bi bi-list"></i>
            </button>
            <a class="navbar-brand d-none d-md-flex" href="#">
                <img src="image/logopim.png" alt="Logo PIM" class="navbar-logo">
            </a>
            <div class="navbar-title d-none d-md-block">
                E-Learning System Pondok Indah Mall
            </div>
            <div class="navbar-title-mobile d-md-none">
                <span class="line1">E-Learning System</span>
                <span class="line2">Pondok Indah Mall</span>
            </div>
            <?php if ($role != 'iss'): ?>
            <ul class="navbar-nav ms-auto mb-2 mb-lg-0">
                <li class="nav-item dropdown">
                    <a class="nav-link dropdown-toggle text-dark" href="#" id="navbarDropdown" role="button" data-bs-toggle="dropdown" aria-expanded="false">
                        <i class="bi bi-person-circle"></i>
                    </a>
                    <ul class="dropdown-menu dropdown-menu-end">
                        <li><a class="dropdown-item <?php echo ($current_page == 'profile.php') ? 'active' : ''; ?>" href="profile.php">Profile</a></li>
                        <li><hr class="dropdown-divider"></li>
                        <li><a class="dropdown-item" href="logout.php">Logout</a></li>
                    </ul>
                </li>
            </ul>
            <?php endif; ?>
        </div>
    </nav>

    <div class="sidebar-overlay" id="sidebarOverlay"></div>

    <div class="sidebar border-end" id="sidebar">
        <div class="profile-section">
            <?php if (!empty($user['foto_profil'])): ?>
                <img src="Uploads/profiles/<?php echo htmlspecialchars($user['foto_profil']); ?>" alt="Foto Profil" class="profile-photo">
            <?php else: ?>
                <div class="profile-photo-placeholder">
                    <i class="bi bi-person-circle"></i>
                </div>
            <?php endif; ?>
            <div class="profile-name"><?php echo htmlspecialchars($user['nama_lengkap']); ?></div>
            <div class="profile-info"><?php echo htmlspecialchars($user['jabatan'] ?? 'Tidak ada jabatan'); ?></div>
            <div class="profile-info"><?php echo htmlspecialchars($user['divisi'] ?? 'Tidak ada divisi'); ?></div>
        </div>
        <div class="p-3">
            <h5 class="mb-4 text-dark">Menu</h5>
            <ul class="nav flex-column">
                <li class="nav-item">
                    <a class="nav-link <?php echo ($current_page == 'dashboard.php') ? 'active' : ''; ?>" href="dashboard.php">
                        <i class="bi bi-house-door-fill"></i> Dashboard
                    </a>
                </li>
                <li class="nav-item">
                    <a class="nav-link <?php echo ($current_page == 'materi.php') ? 'active' : ''; ?>" href="materi.php">
                        <i class="bi bi-book"></i> Materi
                    </a>
                </li>
                <?php if ($role == 'trainer'): ?>
                    <li class="nav-item dropdown">
                        <a class="nav-link dropdown-toggle <?php echo ($current_page == 'add_posttest.php' || $current_page == 'list_posttest.php') ? 'active' : ''; ?>" href="#" id="postTestDropdown" role="button" data-bs-toggle="dropdown" aria-expanded="false">
                            <i class="bi bi-clipboard-check"></i> Post Test
                        </a>
                        <ul class="dropdown-menu" aria-labelledby="postTestDropdown">
                            <li><a class="dropdown-item <?php echo ($current_page == 'add_posttest.php') ? 'active' : ''; ?>" href="add_posttest.php">Tambah Post Test</a></li>
                            <li><a class="dropdown-item <?php echo ($current_page == 'list_posttest.php') ? 'active' : ''; ?>" href="list_posttest.php">List Post Test</a></li>
                        </ul>
                    </li>
                <?php elseif ($role == 'peserta' || $role == 'iss'): ?>
                    <li class="nav-item">
                        <a class="nav-link <?php echo ($current_page == 'list_posttest.php') ? 'active' : ''; ?>" href="list_posttest.php">
                            <i class="bi bi-clipboard-check"></i> Post Test
                        </a>
                    </li>
                <?php endif; ?>
                <li class="nav-item dropdown">
                    <a class="nav-link dropdown-toggle <?php echo ($current_page == 'add_training.php' || $current_page == 'list_training.php') ? 'active' : ''; ?>" href="#" id="trainingDropdown" role="button" data-bs-toggle="dropdown" aria-expanded="false">
                        <i class="bi bi-journal-text"></i> Training
                    </a>
                    <ul class="dropdown-menu" aria-labelledby="trainingDropdown">
                        <?php if($role == 'trainer'): ?>
                        <li><a class="dropdown-item <?php echo ($current_page == 'add_training.php') ? 'active' : ''; ?>" href="add_training.php">Tambah Kegiatan Training</a></li>
                        <?php endif; ?>
                        <li><a class="dropdown-item <?php echo ($current_page == 'list_training.php') ? 'active' : ''; ?>" href="list_training.php">List Training</a></li>
                    </ul>
                </li>
                <?php if ($role == 'trainer'): ?>
                <li class="nav-item">
                    <a class="nav-link <?php echo ($current_page == 'report.php') ? 'active' : ''; ?>" href="report.php">
                        <i class="bi bi-file-earmark-text"></i> Report
                    </a>
                </li>
                <li class="nav-item">
                    <a class="nav-link <?php echo ($current_page == 'data_evaluasi.php') ? 'active' : ''; ?>" href="data_evaluasi.php">
                        <i class="bi bi-clipboard-data"></i> Data Evaluasi
                    </a>
                </li>
                <?php endif; ?>
            </ul>
        </div>
    </div>

    <!-- Fullscreen Overlay -->
    <div class="fullscreen-overlay" id="fullscreenOverlay">
        <div class="fullscreen-header">
            <div class="fullscreen-title"><?php echo htmlspecialchars($training['judul']); ?></div>
            <button class="fullscreen-close" id="closeFullscreen">
                <i class="bi bi-x-lg"></i>
            </button>
        </div>
        <div class="fullscreen-content" id="fullscreenContent">
            <!-- Content will be dynamically inserted here -->
        </div>
    </div>

    <div class="content">
        <div class="container mt-4">
            <div class="row">
                <div class="col-md-12">
                    <div class="card viewer-card animate-fade-in">
                        <div class="viewer-header">
                            <?php echo htmlspecialchars($training['judul']); ?>
                        </div>
                        <div class="viewer-body">
                            <!-- File Viewer -->
                            <?php if ($file_type == 'pdf'): ?>
                                <!-- PDF Viewer -->
                                <iframe id="fileViewer" src="<?php echo $file_path; ?>" class="file-viewer" style="height: 600px;"></iframe>
                            <?php elseif (in_array($file_type, ['jpg', 'jpeg', 'png', 'gif'])): ?>
                                <!-- Image Viewer -->
                                <div class="text-center">
                                    <img id="fileViewer" src="<?php echo $file_path; ?>" class="img-fluid" style="max-height: 600px; border-radius: 8px;" alt="Training Image">
                                </div>
                            <?php elseif ($file_type == 'txt'): ?>
                                <!-- Text File Viewer -->
                                <div id="fileViewer" style="background: var(--soft-ui-gray-100); padding: 20px; border-radius: 8px; max-height: 600px; overflow-y: auto; border: 1px solid var(--soft-ui-gray-200);">
                                    <pre style="white-space: pre-wrap; font-family: 'Courier New', monospace; color: var(--soft-ui-dark);"><?php echo htmlspecialchars(file_get_contents($file_path)); ?></pre>
                                </div>
                            <?php elseif (isGoogleDocsSupported($file_type)): ?>
                                <!-- Try Google Docs Viewer for supported formats -->
                                <div id="google-viewer-container">
                                    <?php
                                    $base_url = (isset($_SERVER['HTTPS']) && $_SERVER['HTTPS'] === 'on' ? "https" : "http") . "://$_SERVER[HTTP_HOST]";
                                    $file_url = $base_url . '/' . $file_path;
                                    $google_docs_url = 'https://docs.google.com/viewer?url=' . urlencode($file_url) . '&embedded=true';
                                    ?>
                                    <iframe id="fileViewer" src="<?php echo $google_docs_url; ?>" class="file-viewer" style="height: 600px;"></iframe>
                                    <div id="fallback-message" class="no-preview" style="display: none;">
                                        <i class="bi bi-file-earmark-x"></i>
                                        <h5>Preview Tidak Tersedia</h5>
                                        <p>File tidak dapat ditampilkan dalam browser. Silakan unduh file untuk melihat isinya.</p>
                                        <p><strong>Tipe file:</strong> <?php echo strtoupper($file_type); ?></p>
                                    </div>
                                </div>
                            <?php else: ?>
                                <!-- No Preview Available -->
                                <div class="no-preview">
                                    <i class="bi bi-file-earmark"></i>
                                    <h5>Preview Tidak Tersedia</h5>
                                    <p>File dengan tipe <strong><?php echo strtoupper($file_type); ?></strong> tidak dapat ditampilkan dalam browser.</p>
                                    <p>Silakan unduh file untuk melihat isinya.</p>
                                </div>
                            <?php endif; ?>

                            <div class="d-flex gap-2 justify-content-end mt-4">
                                <?php if (canDisplayInline($file_type) || isGoogleDocsSupported($file_type)): ?>
                                <button id="toggleFullscreen" class="btn btn-fullscreen">
                                    <i class="bi bi-arrows-fullscreen me-2"></i> Layar Penuh
                                </button>
                                <?php endif; ?>
                                <a href="<?php echo $file_path; ?>" class="btn btn-primary" download>
                                    <i class="bi bi-download me-2"></i> Unduh
                                </a>
                                <a href="list_training.php" class="btn btn-secondary">
                                    <i class="bi bi-arrow-left me-2"></i> Kembali
                                </a>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <footer class="text-center">
        <div class="container">
            <p class="mb-0">© <?php echo date('Y'); ?> E-Learning System by PIM</p>
        </div>
    </footer>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
    <script>
        document.addEventListener('DOMContentLoaded', function() {
            const sidebarToggle = document.getElementById('sidebarToggle');
            const sidebar = document.getElementById('sidebar');
            const sidebarOverlay = document.getElementById('sidebarOverlay');
            const trainingDropdownToggle = document.getElementById('trainingDropdown');
            const postTestDropdownToggle = document.getElementById('postTestDropdown');
            
            let isDropdownClick = false;

            function toggleSidebar() {
                sidebar.classList.toggle('sidebar-active');
                sidebarOverlay.style.display = sidebar.classList.contains('sidebar-active') ? 'block' : 'none';
                
                if (sidebar.classList.contains('sidebar-active')) {
                    document.body.style.overflow = 'hidden';
                } else {
                    document.body.style.overflow = '';
                }
            }

            sidebarToggle.addEventListener('click', function(e) {
                e.stopPropagation();
                toggleSidebar();
            });

            sidebarOverlay.addEventListener('click', function() {
                if (!isDropdownClick) {
                    toggleSidebar();
                }
                isDropdownClick = false;
            });

            if (trainingDropdownToggle) {
                trainingDropdownToggle.addEventListener('click', function(e) {
                    if (window.innerWidth <= 768) {
                        isDropdownClick = true;
                    }
                });
            }

            if (postTestDropdownToggle) {
                postTestDropdownToggle.addEventListener('click', function(e) {
                    if (window.innerWidth <= 768) {
                        isDropdownClick = true;
                    }
                });
            }
            
            document.addEventListener('click', function(e) {
                if (window.innerWidth <= 768) {
                    let clickedInsideAnyDropdown = false;
                    if (trainingDropdownToggle && trainingDropdownToggle.contains(e.target)) {
                        clickedInsideAnyDropdown = true;
                    }
                    if (postTestDropdownToggle && postTestDropdownToggle.contains(e.target)) {
                        clickedInsideAnyDropdown = true;
                    }
                    if (!clickedInsideAnyDropdown) {
                        isDropdownClick = false;
                    }
                }
            });

            const regularNavLinks = document.querySelectorAll('.sidebar .nav-link:not(.dropdown-toggle)');
            regularNavLinks.forEach(link => {
                link.addEventListener('click', function() {
                    if (window.innerWidth <= 768 && sidebar.classList.contains('sidebar-active')) {
                        toggleSidebar();
                    }
                });
            });

            const dropdownItems = document.querySelectorAll('.sidebar .dropdown-menu .dropdown-item');
            dropdownItems.forEach(item => {
                item.addEventListener('click', function() {
                    if (window.innerWidth <= 768 && sidebar.classList.contains('sidebar-active')) {
                        toggleSidebar();
                    }
                });
            });

            window.addEventListener('resize', function() {
                if (window.innerWidth > 768) {
                    sidebar.classList.remove('sidebar-active');
                    sidebarOverlay.style.display = 'none';
                    document.body.style.overflow = '';
                    isDropdownClick = false;
                }
            });

            // Fullscreen functionality
            const toggleFullscreenBtn = document.getElementById('toggleFullscreen');
            const fullscreenOverlay = document.getElementById('fullscreenOverlay');
            const fullscreenContent = document.getElementById('fullscreenContent');
            const closeFullscreenBtn = document.getElementById('closeFullscreen');
            const fileViewer = document.getElementById('fileViewer');

            if (toggleFullscreenBtn) {
                toggleFullscreenBtn.addEventListener('click', function() {
                    console.log('Fullscreen button clicked'); // Debug log
                    openFullscreen();
                });
            }

            if (closeFullscreenBtn) {
                closeFullscreenBtn.addEventListener('click', function() {
                    closeFullscreen();
                });
            }

            // Close fullscreen when clicking overlay background
            fullscreenOverlay.addEventListener('click', function(e) {
                if (e.target === fullscreenOverlay) {
                    closeFullscreen();
                }
            });

            // Close fullscreen when pressing Escape key
            document.addEventListener('keydown', function(e) {
                if (e.key === 'Escape' && fullscreenOverlay.style.display === 'flex') {
                    closeFullscreen();
                }
            });

            function openFullscreen() {
                console.log('Opening fullscreen'); // Debug log
                
                if (!fileViewer) {
                    console.log('File viewer not found');
                    return;
                }
                
                const fileType = '<?php echo $file_type; ?>';
                const filePath = '<?php echo $file_path; ?>';
                
                console.log('File type:', fileType); // Debug log
                console.log('File path:', filePath); // Debug log
                
                // Clear previous content
                fullscreenContent.innerHTML = '';
                
                // Add appropriate content based on file type
                if (fileType === 'pdf') {
                    fullscreenContent.innerHTML = `<iframe class="fullscreen-pdf" src="${filePath}"></iframe>`;
                } else if (['jpg', 'jpeg', 'png', 'gif'].includes(fileType)) {
                    fullscreenContent.innerHTML = `<img class="fullscreen-image" src="${filePath}" alt="Training Image">`;
                } else if (fileType === 'txt') {
                    // Get text content from the existing viewer
                    const textElement = fileViewer.querySelector('pre');
                    const textContent = textElement ? textElement.textContent : 'Tidak dapat memuat konten teks';
                    fullscreenContent.innerHTML = `<div class="fullscreen-text"><pre style="white-space: pre-wrap; font-family: 'Courier New', monospace; color: var(--soft-ui-dark);">${textContent}</pre></div>`;
                } else {
                    // For Google Docs supported files or other iframe content
                    const iframeSrc = fileViewer.src;
                    if (iframeSrc && iframeSrc !== window.location.href) {
                        fullscreenContent.innerHTML = `<iframe class="fullscreen-pdf" src="${iframeSrc}"></iframe>`;
                    } else {
                        fullscreenContent.innerHTML = `<div class="fullscreen-text"><p>Tidak dapat menampilkan file dalam mode fullscreen</p></div>`;
                    }
                }
                
                // Show fullscreen overlay
                fullscreenOverlay.style.display = 'flex';
                document.body.style.overflow = 'hidden';
                
                console.log('Fullscreen opened'); // Debug log
            }

            function closeFullscreen() {
                console.log('Closing fullscreen'); // Debug log
                fullscreenOverlay.style.display = 'none';
                document.body.style.overflow = '';
            }
        });
    </script>
</body>
</html>
