<?php
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

require_once 'koneksi.php';

// Cek login
checkLogin();

date_default_timezone_set('Asia/Jakarta');

$user_id = $_SESSION['user_id'];
$role = $_SESSION['role'];
$nik_karyawan = $_SESSION['nik_karyawan'];

// Ambil informasi user berdasarkan peran
$user = []; // Initialize $user to an empty array
$stmt = null; // Initialize $stmt

if ($role == 'trainer') {
    $stmt = $koneksi->prepare("SELECT nama_lengkap, jabatan, divisi, foto_profil FROM trainers WHERE id = ?");
} elseif ($role == 'iss') {
    // Updated query to only select available columns for 'iss' table
    $stmt = $koneksi->prepare("SELECT nama_lengkap, jabatan, divisi FROM iss WHERE id = ?");
} else { // Peserta
    $stmt = $koneksi->prepare("SELECT nama_lengkap, jabatan, divisi, foto_profil FROM peserta WHERE id = ?");
}

// Check if the prepare statement was successful
if ($stmt === false) {
    // Log the error for debugging purposes
    error_log("Prepare failed for user info query for role '{$role}': " . $koneksi->error);
    // Optionally, you can redirect or display a user-friendly message here
    // For now, we just ensure $user is an empty array to prevent further errors
} else {
    $stmt->bind_param("i", $user_id);
    $stmt->execute();
    $result = $stmt->get_result();
    $user = $result->fetch_assoc();
    $stmt->close();
}

$nama_user = $user['nama_lengkap'] ?? 'Unknown';

$current_page = basename($_SERVER['PHP_SELF']);

$training_id = $_GET['training_id'] ?? null;
$training_title = "Tidak Ditemukan";
$post_test_questions = [];

if ($training_id) {
    // Ambil judul training
    $stmt = $koneksi->prepare("SELECT judul FROM trainings WHERE id = ?");
    if ($stmt === false) {
        error_log("Prepare failed for training title query: " . $koneksi->error);
    } else {
        $stmt->bind_param("i", $training_id);
        $stmt->execute();
        $result = $stmt->get_result();
        if ($row = $result->fetch_assoc()) {
            $training_title = $row['judul'];
        }
        $stmt->close();
    }

    // Ambil soal-soal post test untuk training ini
    $stmt = $koneksi->prepare("SELECT id, question_text, option_a, option_b, option_c, option_d FROM post_test_questions WHERE training_id = ? ORDER BY id ASC");
    if ($stmt === false) {
        error_log("Prepare failed for post test questions query: " . $koneksi->error);
    } else {
        $stmt->bind_param("i", $training_id);
        $stmt->execute();
        $result = $stmt->get_result();
        while ($row = $result->fetch_assoc()) {
            $post_test_questions[] = $row;
        }
        $stmt->close();
    }
}

?>
<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Kerjakan Post Test - E-Learning</title>
    <link rel="icon" type="image/png" href="image/icon.png">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.10.0/font/bootstrap-icons.css">
    <style>
        :root {
            --soft-ui-primary: #cb0c9f;
            --soft-ui-secondary: #67748e;
            --soft-ui-info: #17c1e8;
            --soft-ui-success: #82d616;
            --soft-ui-warning: #fb8c00;
            --soft-ui-danger: #ea0606;
            --soft-ui-light: #e9ecef;
            --soft-ui-dark: #344767;
            --soft-ui-white: #ffffff;
            --soft-ui-gray-100: #f8f9fa;
            --soft-ui-gray-200: #e9ecef;
            --soft-ui-gray-300: #dee2e6;
            --soft-ui-gray-400: #ced4da;
            --soft-ui-gray-500: #adb5bd;
            --soft-ui-gray-600: #6c757d;
            --soft-ui-gray-700: #495057;
            --soft-ui-gray-800: #343a40;
            --soft-ui-gray-900: #212529;
        }

        html, body {
            height: 100%;
            margin: 0;
            font-family: 'Open Sans', sans-serif;
            background-color: var(--soft-ui-gray-100);
        }
        
        body {
            overflow-x: hidden;
            display: flex;
            flex-direction: column;
        }
        
        .navbar-top {
            position: fixed;
            top: 0;
            width: 100%;
            z-index: 1100;
            background: var(--soft-ui-white);
            border-bottom: 1px solid var(--soft-ui-gray-200);
            box-shadow: 0 2px 12px rgba(0, 0, 0, 0.05);
            padding: 0.75rem 1.5rem;
        }
        
        .navbar-top .container-fluid {
            display: flex;
            align-items: center;
            justify-content: space-between;
            flex-wrap: nowrap;
            position: relative;
        }
        
        .navbar-logo {
            height: 40px;
            width: auto;
            margin-right: 15px;
        }
        
        .navbar-title {
            position: absolute;
            left: 50%;
            transform: translateX(-50%);
            font-size: 1.3rem;
            color: var(--soft-ui-dark);
            font-weight: 700;
            text-align: center;
            white-space: nowrap;
            pointer-events: none;
        }

        .navbar-title-mobile {
            display: none;
            font-size: 0.85rem;
            color: var(--soft-ui-dark);
            font-weight: 700;
            text-align: center;
            line-height: 1.2;
            flex: 1;
            margin: 0 10px;
        }

        .navbar-title-mobile .line1 {
            display: block;
        }

        .navbar-title-mobile .line2 {
            display: block;
            font-size: 0.8rem;
        }
        
        .navbar-brand {
            font-size: 1.2rem;
            color: var(--soft-ui-dark);
            font-weight: 700;
            display: flex;
            align-items: center;
            z-index: 1;
        }

        .navbar-nav {
            position: relative;
            z-index: 1200;
        }

        .navbar-nav .nav-item .nav-link {
            color: var(--soft-ui-secondary);
            font-weight: 600;
            padding: 0.5rem 1rem;
            transition: all 0.2s ease-in-out;
        }

        .navbar-nav .nav-item .nav-link:hover {
            color: var(--soft-ui-primary);
        }

        .navbar-nav .nav-item .nav-link.active {
            color: var(--soft-ui-primary);
        }

        .navbar-nav .dropdown-menu {
            position: absolute;
            top: 100%;
            right: 0;
            left: auto;
            z-index: 1300;
            background-color: var(--soft-ui-white);
            border: 1px solid var(--soft-ui-gray-200);
            border-radius: 0.5rem;
            box-shadow: 0 4px 12px rgba(0, 0, 0, 0.15);
            min-width: 160px;
            margin-top: 0.125rem;
        }

        .navbar-nav .dropdown-item {
            color: var(--soft-ui-secondary);
            padding: 0.5rem 1rem;
            font-weight: 500;
            transition: all 0.2s ease-in-out;
        }

        .navbar-nav .dropdown-item:hover {
            background-color: var(--soft-ui-gray-200);
            color: var(--soft-ui-dark);
        }

        .navbar-nav .dropdown-item.active {
            background-color: var(--soft-ui-primary);
            color: var(--soft-ui-white);
        }
        
        .sidebar {
            min-height: 100vh;
            width: 250px;
            position: fixed;
            top: 0;
            left: 0;
            z-index: 1000;
            background: var(--soft-ui-white);
            color: var(--soft-ui-dark);
            padding-top: 70px;
            transition: all 0.3s ease-in-out;
            border-right: 1px solid var(--soft-ui-gray-200);
            box-shadow: 4px 0 15px rgba(0, 0, 0, 0.05);
            border-radius: 0 1rem 1rem 0;
        }
        
        .content {
            margin-left: 250px;
            margin-top: 0;
            padding: 20px;
            padding-top: 90px;
            transition: all 0.3s ease-in-out;
            flex-grow: 1;
        }
        
        .hamburger-mobile {
            display: none;
            background: none;
            border: none;
            color: var(--soft-ui-dark);
            font-size: 1.5rem;
            cursor: pointer;
            margin-right: 15px;
            transition: all 0.3s ease;
            z-index: 1;
        }
        
        .hamburger-mobile:focus {
            outline: none;
        }
        
        .sidebar-overlay {
            display: none;
            position: fixed;
            top: 0;
            left: 0;
            right: 0;
            bottom: 0;
            background-color: rgba(0, 0, 0, 0.4);
            z-index: 999;
        }
        
        .profile-section {
            text-align: center;
            padding: 15px 20px;
            border-bottom: 1px solid var(--soft-ui-gray-200);
            background: var(--soft-ui-white);
            border-radius: 0.75rem;
            box-shadow: 0 4px 15px rgba(0, 0, 0, 0.05);
        }
        
        .profile-photo {
            width: 80px;
            height: 80px;
            border-radius: 50%;
            object-fit: cover;
            border: 2px solid var(--soft-ui-gray-300);
            margin: 0 auto 10px;
            display: block;
            box-shadow: 0 4px 10px rgba(0, 0, 0, 0.08);
        }
        
        .profile-photo-placeholder {
            width: 80px;
            height: 80px;
            border-radius: 50%;
            background: var(--soft-ui-gray-400);
            display: flex;
            align-items: center;
            justify-content: center;
            margin: 0 auto 10px;
            border: 2px solid var(--soft-ui-gray-300);
            box-shadow: 0 4px 10px rgba(0, 0, 0, 0.08);
        }
        
        .profile-photo-placeholder i {
            font-size: 2rem;
            color: var(--soft-ui-white);
        }
        
        .profile-name {
            font-size: 1.1rem;
            font-weight: 600;
            color: var(--soft-ui-dark);
            margin-bottom: 5px;
            word-wrap: break-word;
        }
        
        .profile-info {
            font-size: 0.9rem;
            font-weight: 400;
            color: var(--soft-ui-secondary);
            margin-bottom: 3px;
        }
        
        .sidebar .nav-link {
            color: var(--soft-ui-secondary);
            padding: 0.75rem 1rem;
            border-radius: 0.5rem;
            margin: 0.25rem 0.75rem;
            transition: all 0.2s ease-in-out;
            font-weight: 600;
            display: flex;
            align-items: center;
        }
        
        .sidebar .nav-link:hover {
            background-color: var(--soft-ui-gray-200);
            color: var(--soft-ui-dark);
        }
        
        .sidebar .nav-link.active {
            background-color: var(--soft-ui-primary);
            color: var(--soft-ui-white) !important;
            box-shadow: 0 4px 12px rgba(0, 0, 0, 0.1);
        }

        .sidebar .nav-link.active i {
            color: var(--soft-ui-white);
        }
        
        .sidebar .nav-link i {
            font-size: 1.2rem;
            margin-right: 10px;
            color: var(--soft-ui-secondary);
            transition: all 0.2s ease-in-out;
        }

        .sidebar .nav-item.dropdown .dropdown-menu {
            background-color: var(--soft-ui-white);
            border: none;
            box-shadow: 0 4px 12px rgba(0, 0, 0, 0.08);
            border-radius: 0.5rem;
            padding: 0.5rem 0;
            margin-top: 0.25rem;
        }

        .sidebar .nav-item.dropdown .dropdown-item {
            color: var(--soft-ui-secondary);
            padding: 0.5rem 1.5rem;
            font-weight: 500;
            transition: all 0.2s ease-in-out;
        }

        .sidebar .nav-item.dropdown .dropdown-item:hover {
            background-color: var(--soft-ui-gray-200);
            color: var(--soft-ui-dark);
        }

        .sidebar .nav-item.dropdown .dropdown-item.active {
            background-color: var(--soft-ui-primary);
            color: var(--soft-ui-white);
        }
        
        .card {
            background-color: var(--soft-ui-white);
            border-radius: 0.75rem;
            box-shadow: 0 4px 12px rgba(0, 0, 0, 0.05);
            transition: all 0.2s ease-in-out;
            border: none;
        }

        .card:hover {
            transform: translateY(-3px);
            box-shadow: 0 6px 16px rgba(0, 0, 0, 0.08);
        }
        
        .card-header {
            padding: 1.5rem;
            color: var(--soft-ui-white);
            text-align: center;
            font-weight: 700;
            font-size: 1.25rem;
            background: linear-gradient(195deg, var(--soft-ui-primary), #a80a85);
            border-bottom: none;
            border-radius: 0.75rem 0.75rem 0 0;
        }
        
        .card-body {
            padding: 1.5rem;
            background: var(--soft-ui-white);
        }
        
        .question-card {
            margin-bottom: 1.5rem;
            background-color: var(--soft-ui-white);
            border-radius: 0.75rem;
            box-shadow: 0 4px 12px rgba(0, 0, 0, 0.05);
            transition: all 0.2s ease-in-out;
            border: none;
            overflow: hidden;
        }

        .question-card:hover {
            transform: translateY(-2px);
            box-shadow: 0 6px 16px rgba(0, 0, 0, 0.08);
        }
        
        .question-card .card-header {
            background: linear-gradient(195deg, var(--soft-ui-primary), #a80a85);
            color: var(--soft-ui-white);
            font-weight: 700;
            font-size: 1.1rem;
            padding: 1rem 1.5rem;
            border-radius: 0;
        }
        
        .question-card .card-body {
            padding: 1.5rem;
            background: var(--soft-ui-white);
        }
        
        .question-card .form-check {
            margin-bottom: 1rem;
            padding: 0.75rem;
            border-radius: 0.5rem;
            transition: all 0.2s ease-in-out;
            border: 1px solid var(--soft-ui-gray-200);
        }

        .question-card .form-check:hover {
            background-color: var(--soft-ui-gray-100);
            border-color: var(--soft-ui-primary);
        }
        
        .question-card .form-check-input {
            margin-top: 0.3em;
            border-color: var(--soft-ui-gray-400);
        }

        .question-card .form-check-input:checked {
            background-color: var(--soft-ui-primary);
            border-color: var(--soft-ui-primary);
        }

        .question-card .form-check-input:focus {
            border-color: var(--soft-ui-primary);
            box-shadow: 0 0 0 0.2rem rgba(203, 12, 159, 0.25);
        }
        
        .question-card .form-check-label {
            font-size: 1rem;
            color: var(--soft-ui-dark);
            font-weight: 500;
            cursor: pointer;
            margin-left: 0.5rem;
        }

        .question-card .card-text {
            font-size: 1.1rem;
            color: var(--soft-ui-dark);
            font-weight: 600;
            margin-bottom: 1.5rem;
            line-height: 1.6;
        }
        
        .btn-primary {
            background: linear-gradient(195deg, var(--soft-ui-primary), #a80a85);
            border: none;
            border-radius: 0.5rem;
            padding: 0.75rem 1.5rem;
            font-weight: 600;
            font-size: 0.875rem;
            color: var(--soft-ui-white);
            transition: all 0.3s ease;
            box-shadow: 0 4px 12px rgba(0, 0, 0, 0.1);
            text-transform: uppercase;
            letter-spacing: 0.5px;
        }
        
        .btn-primary:hover {
            background: linear-gradient(195deg, #a80a85, var(--soft-ui-primary));
            transform: translateY(-2px);
            box-shadow: 0 6px 16px rgba(0, 0, 0, 0.15);
            color: var(--soft-ui-white);
        }

        .btn-submit-test {
            background: linear-gradient(195deg, var(--soft-ui-success), #6bb518);
            border: none;
            border-radius: 0.5rem;
            padding: 1rem 2rem;
            font-weight: 700;
            font-size: 1rem;
            color: var(--soft-ui-white);
            transition: all 0.3s ease;
            box-shadow: 0 4px 12px rgba(0, 0, 0, 0.1);
            text-transform: uppercase;
            letter-spacing: 0.5px;
        }

        .btn-submit-test:hover {
            background: linear-gradient(195deg, #6bb518, var(--soft-ui-success));
            transform: translateY(-2px);
            box-shadow: 0 6px 16px rgba(0, 0, 0, 0.15);
            color: var(--soft-ui-white);
        }
        
        .alert {
            border-radius: 0.75rem;
            padding: 1rem 1.5rem;
            border: none;
            font-weight: 500;
        }

        .alert-warning {
            background: linear-gradient(195deg, rgba(251, 140, 0, 0.1), rgba(251, 140, 0, 0.05));
            color: var(--soft-ui-warning);
            border-left: 4px solid var(--soft-ui-warning);
        }
        
        .page-title {
            font-size: 2.5rem;
            font-weight: 700;
            color: var(--soft-ui-dark);
            margin-bottom: 2rem;
            text-align: center;
            line-height: 1.2;
        }
        
        footer {
            background: var(--soft-ui-white);
            color: var(--soft-ui-secondary);
            border-top: 1px solid var(--soft-ui-gray-200);
            padding: 1rem 0;
            text-align: center;
            flex-shrink: 0;
            margin-top: 2rem;
        }
        
        .animate-fade-in {
            animation: fadeIn 0.5s ease-in-out;
        }
        
        @keyframes fadeIn {
            from { opacity: 0; transform: translateY(10px); }
            to { opacity: 1; transform: translateY(0); }
        }

        @media (max-width: 768px) {
            .sidebar {
                margin-left: -250px;
                border-radius: 0;
                padding-top: 90px;
            }
            .sidebar-active {
                margin-left: 0;
            }
            .content {
                margin-left: 0;
                padding-top: 100px;
            }
            
            .navbar-title {
                display: none;
            }
            .navbar-logo {
                display: none;
            }
            
            .navbar-title-mobile {
                display: block;
            }
            
            .hamburger-mobile {
                display: block;
            }
            .navbar-nav {
                position: static;
            }
            .navbar-nav .dropdown-menu {
                position: absolute;
                right: 0;
                left: auto;
                z-index: 1300;
            }
            
            .page-title {
                font-size: 1.8rem;
                text-align: center;
            }
            
            .question-card .card-body {
                padding: 1rem;
            }

            .question-card .form-check {
                padding: 0.5rem;
                margin-bottom: 0.75rem;
            }

            .question-card .form-check-label {
                font-size: 0.9rem;
            }
            
            .navbar-top {
                padding: 0.5rem 1rem;
                min-height: 70px;
            }

            .profile-photo, .profile-photo-placeholder {
                width: 60px;
                height: 60px;
            }
            .profile-photo-placeholder i {
                font-size: 1.5rem;
            }
            .profile-name {
                font-size: 1rem;
            }
            .profile-info {
                font-size: 0.8rem;
            }
        }

        @media (max-width: 576px) {
            .navbar-top {
                padding: 0.5rem 1rem;
                min-height: 70px;
            }
            .navbar-title-mobile {
                font-size: 0.8rem;
            }
            .navbar-title-mobile .line2 {
                font-size: 0.75rem;
            }
            .page-title {
                font-size: 1.5rem;
            }

            .question-card .card-text {
                font-size: 1rem;
            }

            .question-card .form-check-label {
                font-size: 0.85rem;
            }

            .profile-photo, .profile-photo-placeholder {
                width: 50px;
                height: 50px;
            }
            .profile-photo-placeholder i {
                font-size: 1.2rem;
            }
            .profile-name {
                font-size: 0.9rem;
            }
            .profile-info {
                font-size: 0.7rem;
            }
        }
    </style>
</head>
<body>
    <!-- Top Navbar -->
    <nav class="navbar navbar-expand-lg navbar-top">
        <div class="container-fluid">
            <button class="hamburger-mobile d-md-none" type="button" id="sidebarToggle">
                <i class="bi bi-list"></i>
            </button>
            <a class="navbar-brand d-none d-md-flex" href="#">
                <img src="image/logopim.png" alt="Logo PIM" class="navbar-logo">
            </a>
            <div class="navbar-title d-none d-md-block">
                E-Learning System Pondok Indah Mall
            </div>
            <div class="navbar-title-mobile d-md-none">
                <span class="line1">E-Learning System</span>
                <span class="line2">Pondok Indah Mall</span>
            </div>
            <?php if ($role != 'iss'): ?>
            <ul class="navbar-nav ms-auto mb-2 mb-lg-0">
                <li class="nav-item dropdown">
                    <a class="nav-link dropdown-toggle text-dark" href="#" id="navbarDropdown" role="button" data-bs-toggle="dropdown" aria-expanded="false">
                        <i class="bi bi-person-circle"></i>
                    </a>
                    <ul class="dropdown-menu dropdown-menu-end">
                        <li><a class="dropdown-item <?php echo ($current_page == 'profile.php') ? 'active' : ''; ?>" href="profile.php">Profile</a></li>
                        <li><hr class="dropdown-divider"></li>
                        <li><a class="dropdown-item" href="logout.php">Logout</a></li>
                    </ul>
                </li>
            </ul>
            <?php endif; ?>
        </div>
    </nav>

    <!-- Sidebar overlay (for mobile) -->
    <div class="sidebar-overlay" id="sidebarOverlay"></div>

    <!-- Sidebar -->
    <div class="sidebar border-end" id="sidebar">
        <div class="profile-section">
            <?php if (!empty($user['foto_profil'])): ?>
                <img src="Uploads/profiles/<?php echo htmlspecialchars($user['foto_profil']); ?>" alt="Foto Profil" class="profile-photo">
            <?php else: ?>
                <div class="profile-photo-placeholder">
                    <i class="bi bi-person-circle"></i>
                </div>
            <?php endif; ?>
            <div class="profile-name"><?php echo htmlspecialchars($user['nama_lengkap'] ?? 'N/A'); ?></div>
            <div class="profile-info"><?php echo htmlspecialchars($user['jabatan'] ?? 'N/A'); ?></div>
            <div class="profile-info"><?php echo htmlspecialchars($user['divisi'] ?? 'N/A'); ?></div>
        </div>
        <div class="p-3">
            <h5 class="mb-4 text-dark">Menu</h5>
            <ul class="nav flex-column">
                <li class="nav-item">
                    <a class="nav-link <?php echo ($current_page == 'dashboard.php') ? 'active' : ''; ?>" href="dashboard.php">
                        <i class="bi bi-house-door-fill"></i> Dashboard
                    </a>
                </li>
                <li class="nav-item">
                    <a class="nav-link <?php echo ($current_page == 'materi.php') ? 'active' : ''; ?>" href="materi.php">
                        <i class="bi bi-book"></i> Materi
                    </a>
                </li>
                <?php if ($role == 'trainer'): ?>
                    <li class="nav-item dropdown">
                        <a class="nav-link dropdown-toggle <?php echo ($current_page == 'add_posttest.php' || $current_page == 'list_posttest.php' || $current_page == 'view_posttest_scores.php') ? 'active' : ''; ?>" href="#" id="postTestDropdown" role="button" data-bs-toggle="dropdown" aria-expanded="false">
                            <i class="bi bi-clipboard-check"></i> Post Test
                        </a>
                        <ul class="dropdown-menu" aria-labelledby="postTestDropdown">
                            <li><a class="dropdown-item <?php echo ($current_page == 'add_posttest.php') ? 'active' : ''; ?>" href="add_posttest.php">Tambah Post Test</a></li>
                            <li><a class="dropdown-item <?php echo ($current_page == 'list_posttest.php' || $current_page == 'view_posttest_scores.php') ? 'active' : ''; ?>" href="list_posttest.php">List Post Test</a></li>
                        </ul>
                    </li>
                <?php elseif ($role == 'peserta' || $role == 'iss'): ?>
                    <li class="nav-item">
                        <a class="nav-link <?php echo ($current_page == 'list_posttest.php' || $current_page == 'take_posttest.php' || $current_page == 'post_test_result.php') ? 'active' : ''; ?>" href="list_posttest.php">
                            <i class="bi bi-clipboard-check"></i> Post Test
                        </a>
                    </li>
                <?php endif; ?>
                <li class="nav-item dropdown">
                    <a class="nav-link dropdown-toggle <?php echo ($current_page == 'add_training.php' || $current_page == 'list_training.php') ? 'active' : ''; ?>" href="#" id="trainingDropdown" role="button" data-bs-toggle="dropdown" aria-expanded="false">
                        <i class="bi bi-journal-text"></i> Training
                    </a>
                    <ul class="dropdown-menu" aria-labelledby="trainingDropdown">
                        <?php if($role == 'trainer'): ?>
                        <li><a class="dropdown-item <?php echo ($current_page == 'add_training.php') ? 'active' : ''; ?>" href="add_training.php">Tambah Kegiatan Training</a></li>
                        <?php endif; ?>
                        <li><a class="dropdown-item <?php echo ($current_page == 'list_training.php') ? 'active' : ''; ?>" href="list_training.php">List Training</a></li>
                    </ul>
                </li>
                <?php if ($role == 'trainer'): ?>
                    <li class="nav-item">
                        <a class="nav-link <?php echo ($current_page == 'report.php') ? 'active' : ''; ?>" href="report.php">
                            <i class="bi bi-file-earmark-text"></i> Report
                        </a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link <?php echo ($current_page == 'data_evaluasi.php') ? 'active' : ''; ?>" href="data_evaluasi.php">
                            <i class="bi bi-clipboard-data"></i> Data Evaluasi
                        </a>
                    </li>
                <?php endif; ?>
            </ul>
        </div>
    </div>

    <!-- Content -->
    <div class="content">
        <div class="container-fluid">
            <h2 class="page-title animate-fade-in">Kerjakan Post Test: <?php echo htmlspecialchars($training_title); ?></h2>

            <?php if (empty($post_test_questions)): ?>
                <div class="alert alert-warning text-center animate-fade-in">
                    <i class="bi bi-info-circle me-2"></i>
                    Tidak ada soal post test yang tersedia untuk training ini.
                </div>
            <?php else: ?>
                <form method="POST" action="submit_posttest.php">
                    <input type="hidden" name="training_id" value="<?php echo htmlspecialchars($training_id); ?>">
                    <?php $q_num = 1; foreach ($post_test_questions as $question): ?>
                        <div class="question-card animate-fade-in">
                            <div class="card-header">
                                <i class="bi bi-question-circle me-2"></i>Soal #<?php echo $q_num++; ?>
                            </div>
                            <div class="card-body">
                                <p class="card-text"><?php echo htmlspecialchars($question['question_text']); ?></p>
                                <div class="form-check">
                                    <input class="form-check-input" type="radio" name="answers[<?php echo htmlspecialchars($question['id']); ?>]" id="option_a_<?php echo htmlspecialchars($question['id']); ?>" value="A" required>
                                    <label class="form-check-label" for="option_a_<?php echo htmlspecialchars($question['id']); ?>">
                                        A. <?php echo htmlspecialchars($question['option_a']); ?>
                                    </label>
                                </div>
                                <div class="form-check">
                                    <input class="form-check-input" type="radio" name="answers[<?php echo htmlspecialchars($question['id']); ?>]" id="option_b_<?php echo htmlspecialchars($question['id']); ?>" value="B">
                                    <label class="form-check-label" for="option_b_<?php echo htmlspecialchars($question['id']); ?>">
                                        B. <?php echo htmlspecialchars($question['option_b']); ?>
                                    </label>
                                </div>
                                <div class="form-check">
                                    <input class="form-check-input" type="radio" name="answers[<?php echo htmlspecialchars($question['id']); ?>]" id="option_c_<?php echo htmlspecialchars($question['id']); ?>" value="C">
                                    <label class="form-check-label" for="option_c_<?php echo htmlspecialchars($question['id']); ?>">
                                        C. <?php echo htmlspecialchars($question['option_c']); ?>
                                    </label>
                                </div>
                                <div class="form-check">
                                    <input class="form-check-input" type="radio" name="answers[<?php echo htmlspecialchars($question['id']); ?>]" id="option_d_<?php echo htmlspecialchars($question['id']); ?>" value="D">
                                    <label class="form-check-label" for="option_d_<?php echo htmlspecialchars($question['id']); ?>">
                                        D. <?php echo htmlspecialchars($question['option_d']); ?>
                                    </label>
                                </div>
                            </div>
                        </div>
                    <?php endforeach; ?>
                    <div class="text-center">
                        <button type="submit" class="btn btn-submit-test mt-4 animate-fade-in">
                            <i class="bi bi-check-circle me-2"></i> Selesai & Kirim Jawaban
                        </button>
                    </div>
                </form>
            <?php endif; ?>
        </div>
    </div>

    <footer class="text-center">
        <div class="container">
            <p class="mb-0">© <?php echo date('Y'); ?> E-Learning System by PIM</p>
        </div>
    </footer>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
    <script>
        document.addEventListener('DOMContentLoaded', function() {
            const sidebarToggle = document.getElementById('sidebarToggle');
            const sidebar = document.getElementById('sidebar');
            const sidebarOverlay = document.getElementById('sidebarOverlay');
            const trainingDropdownToggle = document.getElementById('trainingDropdown');
            const postTestDropdownToggle = document.getElementById('postTestDropdown');
            
            let isDropdownClick = false;

            function toggleSidebar() {
                sidebar.classList.toggle('sidebar-active');
                sidebarOverlay.style.display = sidebar.classList.contains('sidebar-active') ? 'block' : 'none';
                
                if (sidebar.classList.contains('sidebar-active')) {
                    document.body.style.overflow = 'hidden';
                } else {
                    document.body.style.overflow = '';
                }
            }

            sidebarToggle.addEventListener('click', function(e) {
                e.stopPropagation();
                toggleSidebar();
            });

            sidebarOverlay.addEventListener('click', function() {
                if (!isDropdownClick) {
                    toggleSidebar();
                }
                isDropdownClick = false;
            });

            if (trainingDropdownToggle) {
                trainingDropdownToggle.addEventListener('click', function(e) {
                    if (window.innerWidth <= 768) {
                        isDropdownClick = true;
                    }
                });
            }

            if (postTestDropdownToggle) {
                postTestDropdownToggle.addEventListener('click', function(e) {
                    if (window.innerWidth <= 768) {
                        isDropdownClick = true;
                    }
                });
            }
            
            document.addEventListener('click', function(e) {
                if (window.innerWidth <= 768) {
                    let clickedInsideAnyDropdown = false;
                    if (trainingDropdownToggle && trainingDropdownToggle.contains(e.target)) {
                        clickedInsideAnyDropdown = true;
                    }
                    if (postTestDropdownToggle && postTestDropdownToggle.contains(e.target)) {
                        clickedInsideAnyDropdown = true;
                    }
                    if (!clickedInsideAnyDropdown) {
                        isDropdownClick = false;
                    }
                }
            });

            const regularNavLinks = document.querySelectorAll('.sidebar .nav-link:not(.dropdown-toggle)');
            regularNavLinks.forEach(link => {
                link.addEventListener('click', function() {
                    if (window.innerWidth <= 768 && sidebar.classList.contains('sidebar-active')) {
                        toggleSidebar();
                    }
                });
            });

            const dropdownItems = document.querySelectorAll('.sidebar .dropdown-menu .dropdown-item');
            dropdownItems.forEach(item => {
                item.addEventListener('click', function() {
                    if (window.innerWidth <= 768 && sidebar.classList.contains('sidebar-active')) {
                        toggleSidebar();
                    }
                });
            });

            window.addEventListener('resize', function() {
                if (window.innerWidth > 768) {
                    sidebar.classList.remove('sidebar-active');
                    sidebarOverlay.style.display = 'none';
                    document.body.style.overflow = '';
                    isDropdownClick = false;
                }
            });
        });
    </script>
</body>
</html>