<?php
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

require_once 'koneksi.php';

// Cek login
checkLogin();

date_default_timezone_set('Asia/Jakarta');

$user_id = $_SESSION['user_id'];
$role = $_SESSION['role'];
$nik_karyawan = $_SESSION['nik_karyawan'];

// Pastikan user adalah trainer
if (!isset($role) || $role !== 'trainer') {
    header("Location: login.php?error=Anda tidak memiliki izin untuk mengakses halaman ini");
    exit();
}

// Ambil informasi user menggunakan prepared statement
$stmt = $koneksi->prepare("SELECT nama_lengkap, jabatan, divisi, foto_profil FROM trainers WHERE id = ?");
$stmt->bind_param("i", $user_id);
$stmt->execute();
$result = $stmt->get_result();
$user = $result->fetch_assoc();
$stmt->close();

// Ambil input pencarian
$search_term = isset($_GET['search']) ? trim($_GET['search']) : '';
$error = isset($_GET['error']) ? $_GET['error'] : '';
$training_data = [];
$search_performed = false;

if (!empty($search_term)) {
    $search_performed = true;
    
    // ✅ UPDATED: Query untuk mencari training berdasarkan nama peserta (peserta + ISS)
    $sql = "
        SELECT 
            t.judul AS nama_training,
            YEAR(t.training_date) AS tahun,
            tr.nama_lengkap AS nama_trainer,
            TIMESTAMPDIFF(HOUR, t.start_time, t.end_time) AS jumlah_jam,
            CASE 
                WHEN tp.user_type = 'peserta' THEN p.nama_lengkap
                WHEN tp.user_type = 'iss' THEN i.nama_lengkap
            END as nama_peserta,
            tp.user_type as tipe_user
        FROM 
            training_participants tp
            LEFT JOIN peserta p ON tp.user_id = p.id AND tp.user_type = 'peserta'
            LEFT JOIN iss i ON tp.user_id = i.id AND tp.user_type = 'iss'
            INNER JOIN trainings t ON tp.training_id = t.id
            INNER JOIN trainers tr ON t.nama_trainer = tr.nama_lengkap
        WHERE 
            (p.nama_lengkap LIKE ? OR i.nama_lengkap LIKE ?)
        ORDER BY 
            t.training_date DESC
    ";
    
    $stmt = $koneksi->prepare($sql);
    if ($stmt === false) {
        $error = "Error preparing statement: " . $koneksi->error;
    } else {
        $search_param = "%" . $search_term . "%";
        $stmt->bind_param("ss", $search_param, $search_param);
        $stmt->execute();
        $result = $stmt->get_result();
        while ($row = $result->fetch_assoc()) {
            $training_data[] = $row;
        }
        $stmt->close();
    }
}

$current_page = basename($_SERVER['PHP_SELF']);
?>
<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Report Training - E-Learning</title>
    <link rel="icon" type="image/png" href="image/icon.png">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.10.0/font/bootstrap-icons.css">
    <style>
        :root {
            --soft-ui-primary-start: #00C4CC; /* Teal */
            --soft-ui-primary-end: #CB0C9F; /* Purple */
            --soft-ui-secondary: #67748E; /* Secondary color */
            --soft-ui-info: #17C1E8; /* Info color */
            --soft-ui-success: #82D616; /* Success color */
            --soft-ui-warning: #FB8C00; /* Warning color */
            --soft-ui-danger: #EA0606; /* Danger color */
            --soft-ui-light: #E9ECEF; /* Light color */
            --soft-ui-dark: #344767; /* Dark color */
            --soft-ui-white: #FFFFFF;
            --soft-ui-gray-100: #F8F9FA;
            --soft-ui-gray-200: #E9ECEF;
            --soft-ui-gray-300: #DEE2E6;
            --soft-ui-gray-400: #CED4DA;
            --soft-ui-gray-500: #ADB5BD;
            --soft-ui-gray-600: #6C757D;
            --soft-ui-gray-700: #495057;
            --soft-ui-gray-800: #343A40;
            --soft-ui-gray-900: #212529;
        }

        html, body {
            height: 100%;
            margin: 0;
            font-family: 'Open Sans', sans-serif;
            background-color: var(--soft-ui-gray-100);
        }
        
        body {
            overflow-x: hidden;
            display: flex;
            flex-direction: column;
        }
        
        .navbar-top {
            position: fixed;
            top: 0;
            width: 100%;
            z-index: 1100;
            background: var(--soft-ui-white);
            border-bottom: 1px solid var(--soft-ui-gray-200);
            box-shadow: 0 2px 12px rgba(0, 0, 0, 0.05);
            padding: 0.75rem 1.5rem;
        }
        
        .navbar-top .container-fluid {
            display: flex;
            align-items: center;
            justify-content: space-between;
            flex-wrap: nowrap;
            position: relative;
        }
        
        .navbar-logo {
            height: 40px;
            width: auto;
            margin-right: 15px;
        }
        
        .navbar-title {
            position: absolute;
            left: 50%;
            transform: translateX(-50%);
            font-size: 1.3rem;
            color: var(--soft-ui-dark);
            font-weight: 700;
            text-align: center;
            white-space: nowrap;
            pointer-events: none;
        }

        .navbar-title-mobile {
            display: none;
            font-size: 0.85rem;
            color: var(--soft-ui-dark);
            font-weight: 700;
            text-align: center;
            line-height: 1.2;
            flex: 1;
            margin: 0 10px;
        }

        .navbar-title-mobile .line1 {
            display: block;
        }

        .navbar-title-mobile .line2 {
            display: block;
            font-size: 0.8rem;
        }
        
        .navbar-brand {
            font-size: 1.2rem;
            color: var(--soft-ui-dark);
            font-weight: 700;
            display: flex;
            align-items: center;
            z-index: 1;
        }

        .navbar-nav {
            position: relative;
            z-index: 1200;
        }

        .navbar-nav .nav-item .nav-link {
            color: var(--soft-ui-secondary);
            font-weight: 600;
            padding: 0.5rem 1rem;
            transition: all 0.2s ease-in-out;
        }

        .navbar-nav .nav-item .nav-link:hover {
            color: var(--soft-ui-primary-end);
        }

        .navbar-nav .nav-item .nav-link.active {
            color: var(--soft-ui-primary-end);
        }

        .navbar-nav .dropdown-menu {
            position: absolute;
            top: 100%;
            right: 0;
            left: auto;
            z-index: 1300;
            background-color: var(--soft-ui-white);
            border: 1px solid var(--soft-ui-gray-200);
            border-radius: 0.5rem;
            box-shadow: 0 4px 12px rgba(0, 0, 0, 0.15);
            min-width: 160px;
            margin-top: 0.125rem;
        }

        .navbar-nav .dropdown-item {
            color: var(--soft-ui-secondary);
            padding: 0.5rem 1rem;
            font-weight: 500;
            transition: all 0.2s ease-in-out;
        }

        .navbar-nav .dropdown-item:hover {
            background-color: var(--soft-ui-gray-200);
            color: var(--soft-ui-dark);
        }

        .navbar-nav .dropdown-item.active {
            background-color: var(--soft-ui-primary-end);
            color: var(--soft-ui-white);
        }
        
        .sidebar {
            min-height: 100vh;
            width: 250px;
            position: fixed;
            top: 0;
            left: 0;
            z-index: 1000;
            background: var(--soft-ui-white);
            color: var(--soft-ui-dark);
            padding-top: 70px;
            transition: all 0.3s ease-in-out;
            border-right: 1px solid var(--soft-ui-gray-200);
            box-shadow: 4px 0 15px rgba(0, 0, 0, 0.05);
            border-radius: 0 1rem 1rem 0;
        }
        
        .content {
            margin-left: 250px;
            margin-top: 0;
            padding: 20px;
            padding-top: 90px;
            transition: all 0.3s ease-in-out;
            flex-grow: 1;
        }
        
        .hamburger-mobile {
            display: none;
            background: none;
            border: none;
            color: var(--soft-ui-dark);
            font-size: 1.5rem;
            cursor: pointer;
            margin-right: 15px;
            transition: all 0.3s ease;
            z-index: 1;
        }
        
        .hamburger-mobile:focus {
            outline: none;
        }
        
        .sidebar-overlay {
            display: none;
            position: fixed;
            top: 0;
            left: 0;
            right: 0;
            bottom: 0;
            background-color: rgba(0, 0, 0, 0.4);
            z-index: 999;
        }
        
        .profile-section {
            text-align: center;
            padding: 15px 20px;
            border-bottom: 1px solid var(--soft-ui-gray-200);
            background: var(--soft-ui-white);
            border-radius: 0.75rem;
            box-shadow: 0 4px 15px rgba(0, 0, 0, 0.05);
        }
        
        .profile-photo {
            width: 80px;
            height: 80px;
            border-radius: 50%;
            object-fit: cover;
            border: 2px solid var(--soft-ui-gray-300);
            margin: 0 auto 10px;
            display: block;
            box-shadow: 0 4px 10px rgba(0, 0, 0, 0.08);
        }
        
        .profile-photo-placeholder {
            width: 80px;
            height: 80px;
            border-radius: 50%;
            background: var(--soft-ui-gray-400);
            display: flex;
            align-items: center;
            justify-content: center;
            margin: 0 auto 10px;
            border: 2px solid var(--soft-ui-gray-300);
            box-shadow: 0 4px 10px rgba(0, 0, 0, 0.08);
        }
        
        .profile-photo-placeholder i {
            font-size: 2rem;
            color: var(--soft-ui-white);
        }
        
        .profile-name {
            font-size: 1.1rem;
            font-weight: 600;
            color: var(--soft-ui-dark);
            margin-bottom: 5px;
            word-wrap: break-word;
        }
        
        .profile-info {
            font-size: 0.9rem;
            font-weight: 400;
            color: var(--soft-ui-secondary);
            margin-bottom: 3px;
        }
        
        .sidebar .nav-link {
            color: var(--soft-ui-secondary);
            padding: 0.75rem 1rem;
            border-radius: 0.5rem;
            margin: 0.25rem 0.75rem;
            transition: all 0.2s ease-in-out;
            font-weight: 600;
            display: flex;
            align-items: center;
        }
        
        .sidebar .nav-link:hover {
            background: linear-gradient(90deg, rgba(0, 196, 204, 0.1), rgba(203, 12, 159, 0.1));
            color: var(--soft-ui-dark);
        }
        
        .sidebar .nav-link.active {
            background: linear-gradient(195deg, var(--soft-ui-primary-start), var(--soft-ui-primary-end));
            color: var(--soft-ui-white) !important;
            box-shadow: 0 4px 12px rgba(0, 0, 0, 0.1);
        }

        .sidebar .nav-link.active i {
            color: var(--soft-ui-white);
        }
        
        .sidebar .nav-link i {
            font-size: 1.2rem;
            margin-right: 10px;
            color: var(--soft-ui-secondary);
            transition: all 0.2s ease-in-out;
        }

        .sidebar .nav-item.dropdown .dropdown-menu {
            background-color: var(--soft-ui-white);
            border: none;
            box-shadow: 0 4px 12px rgba(0, 0, 0, 0.08);
            border-radius: 0.5rem;
            padding: 0.5rem 0;
            margin-top: 0.25rem;
        }

        .sidebar .nav-item.dropdown .dropdown-item {
            color: var(--soft-ui-secondary);
            padding: 0.5rem 1.5rem;
            font-weight: 500;
            transition: all 0.2s ease-in-out;
        }

        .sidebar .nav-item.dropdown .dropdown-item:hover {
            background: linear-gradient(90deg, rgba(0, 196, 204, 0.1), rgba(203, 12, 159, 0.1));
            color: var(--soft-ui-dark);
        }

        .sidebar .nav-item.dropdown .dropdown-item.active {
            background: linear-gradient(195deg, var(--soft-ui-primary-start), var(--soft-ui-primary-end));
            color: var(--soft-ui-white);
        }
        
        .card {
            background-color: var(--soft-ui-white);
            border-radius: 0.75rem;
            box-shadow: 0 4px 12px rgba(0, 0, 0, 0.05);
            transition: all 0.2s ease-in-out;
            border: none;
        }

        .card:hover {
            transform: translateY(-3px);
            box-shadow: 0 6px 16px rgba(0, 0, 0, 0.08);
        }
        
        .card-header {
            padding: 1.5rem;
            color: var(--soft-ui-white);
            text-align: center;
            font-weight: 700;
            font-size: 1.25rem;
            background: linear-gradient(195deg, var(--soft-ui-primary-start), var(--soft-ui-primary-end));
            border-bottom: none;
            border-radius: 0.75rem 0.75rem 0 0;
        }
        
        .card-body {
            padding: 1.5rem;
            background: var(--soft-ui-white);
        }
        
        .table-responsive {
            margin-top: 20px;
            border-radius: 0.5rem;
            overflow: hidden;
        }
        
        .table {
            border-collapse: separate;
            border-spacing: 0;
            border-radius: 0.5rem;
            overflow: hidden;
            background: var(--soft-ui-white);
            margin-bottom: 0;
        }
        
        .table th, .table td {
            vertical-align: middle;
            text-align: center;
            padding: 1rem;
            border: none;
        }
        
        .table thead th {
            background: linear-gradient(195deg, var(--soft-ui-primary-start), var(--soft-ui-primary-end));
            color: var(--soft-ui-white);
            font-weight: 700;
            text-transform: uppercase;
            font-size: 0.875rem;
            letter-spacing: 0.5px;
        }
        
        .table tbody tr {
            transition: background 0.3s ease;
            background: var(--soft-ui-white);
        }
        
        .table tbody tr:nth-of-type(odd) {
            background: var(--soft-ui-gray-100);
        }
        
        .table tbody tr:hover {
            background: rgba(0, 196, 204, 0.1);
            transform: scale(1.01);
        }
        
        .table td:first-child {
            text-align: left !important;
            font-weight: 600;
            color: var(--soft-ui-dark);
        }
        
        .badge-peserta {
            background: linear-gradient(195deg, var(--soft-ui-success), #6bb518);
            color: var(--soft-ui-white);
            font-size: 0.75rem;
            padding: 0.5rem 1rem;
            border-radius: 1rem;
            font-weight: 600;
            display: inline-flex;
            align-items: center;
            gap: 0.25rem;
        }
        
        .badge-iss {
            background: linear-gradient(195deg, var(--soft-ui-info), #1398c4);
            color: var(--soft-ui-white);
            font-size: 0.75rem;
            padding: 0.5rem 1rem;
            border-radius: 1rem;
            font-weight: 600;
            display: inline-flex;
            align-items: center;
            gap: 0.25rem;
        }
        
        .btn-primary {
            background: linear-gradient(195deg, var(--soft-ui-primary-start), var(--soft-ui-primary-end));
            border: none;
            border-radius: 0.5rem;
            padding: 0.75rem 1.5rem;
            font-weight: 600;
            font-size: 0.875rem;
            color: var(--soft-ui-white);
            transition: all 0.3s ease;
            box-shadow: 0 4px 12px rgba(0, 196, 204, 0.3);
            text-transform: uppercase;
            letter-spacing: 0.5px;
        }
        
        .btn-primary:hover {
            background: linear-gradient(195deg, #009ea6, #a80a85);
            transform: translateY(-2px);
            box-shadow: 0 6px 16px rgba(0, 196, 204, 0.4);
            color: var(--soft-ui-white);
        }
        
        .form-control {
            border: 1px solid var(--soft-ui-gray-300);
            border-radius: 0.5rem;
            padding: 0.75rem 1rem;
            font-size: 0.875rem;
            transition: all 0.2s ease-in-out;
            background-color: var(--soft-ui-white);
        }

        .form-control:focus {
            border-color: var(--soft-ui-primary-start);
            box-shadow: 0 0 0 0.2rem rgba(0, 196, 204, 0.25);
            background-color: var(--soft-ui-white);
        }
        
        .alert {
            border-radius: 0.75rem;
            padding: 1rem 1.5rem;
            border: none;
            font-weight: 500;
        }

        .alert-danger {
            background: linear-gradient(195deg, rgba(234, 6, 6, 0.1), rgba(234, 6, 6, 0.05));
            color: var(--soft-ui-danger);
            border-left: 4px solid var(--soft-ui-danger);
        }

        .alert-warning {
            background: linear-gradient(195deg, rgba(251, 140, 0, 0.1), rgba(251, 140, 0, 0.05));
            color: var(--soft-ui-warning);
            border-left: 4px solid var(--soft-ui-warning);
        }

        .alert-info {
            background: linear-gradient(195deg, rgba(0, 196, 204, 0.1), rgba(203, 12, 159, 0.1));
            color: var(--soft-ui-primary-start);
            border-left: 4px solid var(--soft-ui-primary-start);
        }

        .alert-success {
            background: linear-gradient(195deg, rgba(130, 214, 22, 0.1), rgba(130, 214, 22, 0.05));
            color: var(--soft-ui-success);
            border-left: 4px solid var(--soft-ui-success);
        }
        
        .page-title {
            font-size: 2.5rem;
            font-weight: 700;
            color: var(--soft-ui-dark);
            margin-bottom: 0.5rem;
            text-align: left;
        }
        
        .page-subtitle {
            font-size: 1.25rem;
            font-weight: 400;
            color: var(--soft-ui-secondary);
            margin-bottom: 2rem;
            text-align: left;
        }
        
        .search-form {
            margin-bottom: 1.5rem;
        }
        
        .search-form .input-group {
            display: flex;
            align-items: stretch;
            gap: 0.75rem;
        }
        
        .search-form .form-control {
            flex: 1;
        }
        
        footer {
            background: var(--soft-ui-white);
            color: var(--soft-ui-secondary);
            border-top: 1px solid var(--soft-ui-gray-200);
            padding: 1rem 0;
            text-align: center;
            flex-shrink: 0;
            margin-top: 2rem;
        }
        
        .animate-fade-in {
            animation: fadeIn 0.5s ease-in-out;
        }
        
        @keyframes fadeIn {
            from { opacity: 0; transform: translateY(10px); }
            to { opacity: 1; transform: translateY(0); }
        }

        @media (max-width: 768px) {
            .sidebar {
                margin-left: -250px;
                border-radius: 0;
                padding-top: 90px;
            }
            .sidebar-active {
                margin-left: 0;
            }
            .content {
                margin-left: 0;
                padding-top: 100px;
            }
            
            .navbar-title {
                display: none;
            }
            .navbar-logo {
                display: none;
            }
            
            .navbar-title-mobile {
                display: block;
            }
            
            .hamburger-mobile {
                display: block;
            }
            .navbar-nav {
                position: static;
            }
            .navbar-nav .dropdown-menu {
                position: absolute;
                right: 0;
                left: auto;
                z-index: 1300;
            }
            
            .page-title {
                font-size: 1.8rem;
                text-align: center;
            }
            
            .page-subtitle {
                font-size: 1rem;
                text-align: center;
            }
            
            .search-form .input-group {
                flex-direction: column;
                gap: 0.5rem;
            }
            
            .table th, .table td {
                font-size: 0.8rem;
                padding: 0.75rem 0.5rem;
            }
            
            .navbar-top {
                padding: 0.5rem 1rem;
                min-height: 70px;
            }
        }

        @media (max-width: 576px) {
            .navbar-top {
                padding: 0.5rem 1rem;
                min-height: 70px;
            }
            .navbar-title-mobile {
                font-size: 0.8rem;
            }
            .navbar-title-mobile .line2 {
                font-size: 0.75rem;
            }
            .page-title {
                font-size: 1.5rem;
            }
            .page-subtitle {
                font-size: 0.9rem;
            }
            .table th, .table td {
                font-size: 0.75rem;
                padding: 0.5rem 0.25rem;
            }
        }
    </style>
</head>
<body>
    <!-- Top Navbar -->
    <nav class="navbar navbar-expand-lg navbar-top">
        <div class="container-fluid">
            <button class="hamburger-mobile d-md-none" type="button" id="sidebarToggle">
                <i class="bi bi-list"></i>
            </button>
            <a class="navbar-brand d-none d-md-flex" href="#">
                <img src="image/logopim.png" alt="Logo PIM" class="navbar-logo">
            </a>
            <div class="navbar-title d-none d-md-block">
                E-Learning System Pondok Indah Mall
            </div>
            <div class="navbar-title-mobile d-md-none">
                <span class="line1">E-Learning System</span>
                <span class="line2">Pondok Indah Mall</span>
            </div>
            <ul class="navbar-nav ms-auto mb-2 mb-lg-0">
                <li class="nav-item dropdown">
                    <a class="nav-link dropdown-toggle text-dark" href="#" id="navbarDropdown" role="button" data-bs-toggle="dropdown" aria-expanded="false">
                        <i class="bi bi-person-circle"></i>
                    </a>
                    <ul class="dropdown-menu dropdown-menu-end">
                        <li><a class="dropdown-item <?php echo ($current_page == 'profile.php') ? 'active' : ''; ?>" href="profile.php">Profile</a></li>
                        <li><hr class="dropdown-divider"></li>
                        <li><a class="dropdown-item" href="logout.php">Logout</a></li>
                    </ul>
                </li>
            </ul>
        </div>
    </nav>

    <!-- Sidebar overlay (for mobile) -->
    <div class="sidebar-overlay" id="sidebarOverlay"></div>

    <!-- Sidebar -->
    <div class="sidebar border-end" id="sidebar">
        <div class="profile-section">
            <?php if (!empty($user['foto_profil'])): ?>
                <img src="Uploads/profiles/<?php echo htmlspecialchars($user['foto_profil']); ?>" alt="Foto Profil" class="profile-photo">
            <?php else: ?>
                <div class="profile-photo-placeholder">
                    <i class="bi bi-person-circle"></i>
                </div>
            <?php endif; ?>
            <div class="profile-name"><?php echo htmlspecialchars($user['nama_lengkap'] ?? 'Trainer Tidak Dikenal'); ?></div>
            <div class="profile-info"><?php echo htmlspecialchars($user['jabatan'] ?? 'Tidak ada jabatan'); ?></div>
            <div class="profile-info"><?php echo htmlspecialchars($user['divisi'] ?? 'Tidak ada divisi'); ?></div>
        </div>
        <div class="p-3">
            <h5 class="mb-4 text-dark">Menu</h5>
            <ul class="nav flex-column">
                <li class="nav-item">
                    <a class="nav-link <?php echo ($current_page == 'dashboard.php') ? 'active' : ''; ?>" href="dashboard.php">
                        <i class="bi bi-house-door-fill"></i> Dashboard
                    </a>
                </li>
                <li class="nav-item">
                    <a class="nav-link <?php echo ($current_page == 'materi.php') ? 'active' : ''; ?>" href="materi.php">
                        <i class="bi bi-book"></i> Materi
                    </a>
                </li>
                <?php if ($role == 'trainer'): ?>
                    <li class="nav-item dropdown">
                        <a class="nav-link dropdown-toggle <?php echo ($current_page == 'add_posttest.php' || $current_page == 'list_posttest.php' || $current_page == 'view_posttest_scores.php') ? 'active' : ''; ?>" href="#" id="postTestDropdown" role="button" data-bs-toggle="dropdown" aria-expanded="false">
                            <i class="bi bi-clipboard-check"></i> Post Test
                        </a>
                        <ul class="dropdown-menu" aria-labelledby="postTestDropdown">
                            <li><a class="dropdown-item <?php echo ($current_page == 'add_posttest.php') ? 'active' : ''; ?>" href="add_posttest.php">Tambah Post Test</a></li>
                            <li><a class="dropdown-item <?php echo ($current_page == 'list_posttest.php' || $current_page == 'view_posttest_scores.php') ? 'active' : ''; ?>" href="list_posttest.php">List Post Test</a></li>
                        </ul>
                    </li>
                <?php elseif ($role == 'peserta' || $role == 'iss'): ?>
                    <li class="nav-item">
                        <a class="nav-link <?php echo ($current_page == 'list_posttest.php' || $current_page == 'take_posttest.php' || $current_page == 'post_test_result.php') ? 'active' : ''; ?>" href="list_posttest.php">
                            <i class="bi bi-clipboard-check"></i> Post Test
                        </a>
                    </li>
                <?php endif; ?>
                <li class="nav-item dropdown">
                    <a class="nav-link dropdown-toggle <?php echo ($current_page == 'add_training.php' || $current_page == 'list_training.php') ? 'active' : ''; ?>" href="#" id="trainingDropdown" role="button" data-bs-toggle="dropdown" aria-expanded="false">
                        <i class="bi bi-journal-text"></i> Training
                    </a>
                    <ul class="dropdown-menu" aria-labelledby="trainingDropdown">
                        <?php if($role == 'trainer'): ?>
                        <li><a class="dropdown-item <?php echo ($current_page == 'add_training.php') ? 'active' : ''; ?>" href="add_training.php">Tambah Kegiatan Training</a></li>
                        <?php endif; ?>
                        <li><a class="dropdown-item <?php echo ($current_page == 'list_training.php') ? 'active' : ''; ?>" href="list_training.php">List Training</a></li>
                    </ul>
                </li>
                <?php if ($role == 'trainer'): ?>
                    <li class="nav-item">
                        <a class="nav-link <?php echo ($current_page == 'report.php') ? 'active' : ''; ?>" href="report.php">
                            <i class="bi bi-file-earmark-text"></i> Report
                        </a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link <?php echo ($current_page == 'data_evaluasi.php') ? 'active' : ''; ?>" href="data_evaluasi.php">
                            <i class="bi bi-clipboard-data"></i> Data Evaluasi
                        </a>
                    </li>
                <?php endif; ?>
            </ul>
        </div>
    </div>

    <!-- Content -->
    <div class="content">
        <div class="container-fluid">
            <h2 class="page-title animate-fade-in">Report Training Karyawan</h2>
            <p class="page-subtitle animate-fade-in">Pondok Indah Mall</p>
            <div class="row">
                <div class="col-md-12">
                    <div class="card animate-fade-in">
                        <div class="card-header">
                            <i class="bi bi-file-earmark-text me-2"></i>
                            Data Report Training
                        </div>
                        <div class="card-body">
                            <!-- Search Form -->
                            <form method="GET" action="" class="search-form">
                                <div class="input-group">
                                    <input type="text" class="form-control" name="search" placeholder="Cari nama peserta atau ISS..." value="<?php echo htmlspecialchars($search_term); ?>">
                                    <button type="submit" class="btn btn-primary">
                                        <i class="bi bi-search me-2"></i> Cari
                                    </button>
                                </div>
                            </form>
                            
                            <?php if (!empty($error)): ?>
                                <div class="alert alert-danger mt-3">
                                    <i class="bi bi-exclamation-triangle me-2"></i><?php echo htmlspecialchars($error); ?>
                                </div>
                            <?php endif; ?>
                            
                            <?php if ($search_performed): ?>
                                <?php if (empty($training_data)): ?>
                                    <div class="alert alert-warning mt-3">
                                        <i class="bi bi-info-circle me-2"></i>
                                        Tidak ditemukan data training untuk peserta dengan nama "<?php echo htmlspecialchars($search_term); ?>".
                                    </div>
                                <?php else: ?>
                                    <div class="alert alert-info mt-3">
                                        <i class="bi bi-check-circle me-2"></i>
                                        Menampilkan <?php echo count($training_data); ?> hasil pencarian untuk "<?php echo htmlspecialchars($search_term); ?>".
                                    </div>
                                    <div class="table-responsive">
                                        <table class="table table-bordered table-striped">
                                            <thead>
                                                <tr>
                                                    <th>Nama Training</th>
                                                    <th>Tahun</th>
                                                    <th>Nama Trainer</th>
                                                    <th>Jumlah Jam Training</th>
                                                    <th>Tipe User</th>
                                                </tr>
                                            </thead>
                                            <tbody>
                                                <?php foreach ($training_data as $data): ?>
                                                    <tr>
                                                        <td><?php echo htmlspecialchars($data['nama_training']); ?></td>
                                                        <td><?php echo htmlspecialchars($data['tahun']); ?></td>
                                                        <td><?php echo htmlspecialchars($data['nama_trainer']); ?></td>
                                                        <td><?php echo htmlspecialchars($data['jumlah_jam']); ?> jam</td>
                                                        <td>
                                                            <?php if($data['tipe_user'] == 'iss'): ?>
                                                                <span class="badge badge-iss">
                                                                    <i class="bi bi-person"></i> ISS
                                                                </span>
                                                            <?php else: ?>
                                                                <span class="badge badge-peserta">
                                                                    <i class="bi bi-person"></i> Peserta
                                                                </span>
                                                            <?php endif; ?>
                                                        </td>
                                                    </tr>
                                                <?php endforeach; ?>
                                            </tbody>
                                        </table>
                                    </div>
                                <?php endif; ?>
                            <?php elseif (!empty($search_term)): ?>
                                <div class="alert alert-info mt-3">
                                    <i class="bi bi-info-circle me-2"></i>
                                    Pencarian untuk "<?php echo htmlspecialchars($search_term); ?>" telah dilakukan.
                                </div>
                            <?php endif; ?>
                            
                            <div class="d-flex justify-content-end mt-3">
                                <a href="dashboard.php" class="btn btn-primary">
                                    <i class="bi bi-arrow-left me-2"></i> Kembali
                                </a>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Footer -->
    <footer class="text-center">
        <div class="container">
            <p class="mb-0">© <?php echo date('Y'); ?> E-Learning System by PIM</p>
        </div>
    </footer>

    <!-- Scripts -->
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
    <script>
        document.addEventListener('DOMContentLoaded', function() {
            const sidebarToggle = document.getElementById('sidebarToggle');
            const sidebar = document.getElementById('sidebar');
            const sidebarOverlay = document.getElementById('sidebarOverlay');
            const trainingDropdownToggle = document.getElementById('trainingDropdown');
            const postTestDropdownToggle = document.getElementById('postTestDropdown');
            
            let isDropdownClick = false;

            function toggleSidebar() {
                sidebar.classList.toggle('sidebar-active');
                sidebarOverlay.style.display = sidebar.classList.contains('sidebar-active') ? 'block' : 'none';
                
                if (sidebar.classList.contains('sidebar-active')) {
                    document.body.style.overflow = 'hidden';
                } else {
                    document.body.style.overflow = '';
                }
            }

            sidebarToggle.addEventListener('click', function(e) {
                e.stopPropagation();
                toggleSidebar();
            });

            sidebarOverlay.addEventListener('click', function() {
                if (!isDropdownClick) {
                    toggleSidebar();
                }
                isDropdownClick = false;
            });

            if (trainingDropdownToggle) {
                trainingDropdownToggle.addEventListener('click', function(e) {
                    if (window.innerWidth <= 768) {
                        isDropdownClick = true;
                    }
                });
            }

            if (postTestDropdownToggle) {
                postTestDropdownToggle.addEventListener('click', function(e) {
                    if (window.innerWidth <= 768) {
                        isDropdownClick = true;
                    }
                });
            }
            
            document.addEventListener('click', function(e) {
                if (window.innerWidth <= 768) {
                    let clickedInsideAnyDropdown = false;
                    if (trainingDropdownToggle && trainingDropdownToggle.contains(e.target)) {
                        clickedInsideAnyDropdown = true;
                    }
                    if (postTestDropdownToggle && postTestDropdownToggle.contains(e.target)) {
                        clickedInsideAnyDropdown = true;
                    }
                    if (!clickedInsideAnyDropdown) {
                        isDropdownClick = false;
                    }
                }
            });

            const regularNavLinks = document.querySelectorAll('.sidebar .nav-link:not(.dropdown-toggle)');
            regularNavLinks.forEach(link => {
                link.addEventListener('click', function() {
                    if (window.innerWidth <= 768 && sidebar.classList.contains('sidebar-active')) {
                        toggleSidebar();
                    }
                });
            });

            const dropdownItems = document.querySelectorAll('.sidebar .dropdown-menu .dropdown-item');
            dropdownItems.forEach(item => {
                item.addEventListener('click', function() {
                    if (window.innerWidth <= 768 && sidebar.classList.contains('sidebar-active')) {
                        toggleSidebar();
                    }
                });
            });

            window.addEventListener('resize', function() {
                if (window.innerWidth > 768) {
                    sidebar.classList.remove('sidebar-active');
                    sidebarOverlay.style.display = 'none';
                    document.body.style.overflow = '';
                    isDropdownClick = false;
                }
            });
        });
    </script>
</body>
</html>