<?php
require_once 'koneksi.php';

session_start();

// Cek jika user sudah login
if (isset($_SESSION['user_id'])) {
    header("Location: dashboard.php");
    exit();
}

$error = "";
$success = "";

// Proses form registrasi ISS
if ($_SERVER["REQUEST_METHOD"] == "POST") {
    $nik_karyawan = clean($_POST['nik_karyawan']);
    $divisi = clean($_POST['divisi']);
    $jabatan = clean($_POST['jabatan']);
    $nama_lengkap = clean($_POST['nama_lengkap']);
    
    // Validasi input
    if (empty($nik_karyawan) || empty($divisi) || empty($jabatan) || empty($nama_lengkap)) {
        $error = "Semua field harus diisi.";
    } elseif (!preg_match('/^[a-zA-Z0-9]+$/', $nik_karyawan)) {
        $error = "NIK Karyawan hanya boleh berisi huruf dan angka.";
    } else {
        // Cek apakah NIK Karyawan sudah terdaftar
        $stmt = $koneksi->prepare("SELECT id FROM iss WHERE nik_karyawan = ?");
        $stmt->bind_param("s", $nik_karyawan);
        $stmt->execute();
        $stmt->store_result();

        if ($stmt->num_rows > 0) {
            // NIK Karyawan sudah terdaftar, ambil ID-nya
            $stmt->bind_result($iss_id);
            $stmt->fetch();
            
            // Update data ISS
            $stmt = $koneksi->prepare("UPDATE iss SET divisi = ?, jabatan = ?, nama_lengkap = ? WHERE id = ?");
            $stmt->bind_param("sssi", $divisi, $jabatan, $nama_lengkap, $iss_id);
            
            if ($stmt->execute()) {
                $success = "Data berhasil diperbarui! Anda akan diarahkan ke halaman login.";
                // Redirect ke login setelah 2 detik
                echo "<script>
                    setTimeout(function() {
                        window.location.href = 'login.php';
                    }, 2000);
                </script>";
            } else {
                $error = "Gagal memperbarui data: " . $stmt->error;
            }
        } else {
            // Tambahkan NIK Karyawan baru
            $stmt = $koneksi->prepare("INSERT INTO iss (nik_karyawan, divisi, jabatan, nama_lengkap, created_at) VALUES (?, ?, ?, ?, NOW())");
            $stmt->bind_param("ssss", $nik_karyawan, $divisi, $jabatan, $nama_lengkap);
            
            if ($stmt->execute()) {
                $success = "Registrasi berhasil! Anda akan diarahkan ke halaman login.";
                // Redirect ke login setelah 2 detik
                echo "<script>
                    setTimeout(function() {
                        window.location.href = 'login.php';
                    }, 2000);
                </script>";
            } else {
                $error = "Gagal menyimpan data: " . $stmt->error;
            }
        }
        $stmt->close();
    }
}
?>
<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Registrasi ISS - PIM Training</title>
    <link rel="icon" type="image/png" href="image/icon.png">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <style>
        html, body {
            height: 100%;
            margin: 0;
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
        }
        
        body {
            background-image: url('image/bg.jpg'); /* Updated background image */
            background-size: cover;
            background-position: center center;
            background-repeat: no-repeat;
            display: flex;
            flex-direction: column;
            align-items: center;
            justify-content: center;
            min-height: 100vh;
            color: #fff;
        }
        
        .wrapper {
            width: 100%;
            display: flex;
            flex-direction: column;
            align-items: center;
            justify-content: center;
            min-height: 100vh;
        }
        
        .register-container {
            max-width: 450px;
            width: 100%;
            padding: 0 15px;
        }
        
        .register-card {
            background: rgba(255, 255, 255, 0.5); /* Semi-transparent white */
            border-radius: 15px;
            box-shadow: 0 8px 24px rgba(0, 0, 0, 0.2); /* Stronger shadow */
            overflow: hidden;
            transition: transform 0.3s ease;
            backdrop-filter: blur(5px); /* Add blur for transparency effect */
            color: #333; /* Default text color inside card */
        }
        
        .register-card:hover {
            transform: translateY(-5px);
        }
        
        .register-body {
            padding: 2rem;
        }
        
        .form-label {
            font-weight: 500;
            color: #555; /* Darker grey for readability on light card */
        }
        
        .input-group-text {
            background: #e9ecef; /* Lighter background */
            border: 1px solid #ced4da; /* Subtle border */
            color: #555;
            border-right: none; /* Remove right border to blend with input */
            border-radius: 8px 0 0 8px; /* Match input border-radius */
        }
        
        .form-control, .form-select {
            border: 1px solid #ced4da; /* Subtle border */
            border-radius: 8px;
            padding: 0.75rem;
            transition: border-color 0.3s ease, box-shadow 0.3s ease;
            background-color: rgba(255, 255, 255, 0.5); /* Slightly transparent input */
            color: #333; /* Ensure input text is dark */
        }
        
        .form-control:focus, .form-select:focus {
            border-color: #86b9c6; /* A light blue/teal for focus */
            box-shadow: 0 0 0 0.2rem rgba(134, 185, 198, 0.25);
        }
        
        .btn-primary {
            background: linear-gradient(to right, #ff9a9e 0%, #fad0c4 99%, #fad0c4 100%); /* Gradient from target design */
            border: none;
            color: #fff; /* White text */
            padding: 0.75rem;
            font-weight: 500;
            border-radius: 8px;
            transition: transform 0.3s ease, box-shadow 0.3s ease;
        }
        
        .btn-primary:hover {
            background: linear-gradient(to right, #ff9a9e 0%, #fad0c4 99%, #fad0c4 100%); /* Keep same gradient on hover */
            opacity: 0.9; /* Slight opacity change on hover */
            transform: scale(1.02); /* Slightly smaller scale on hover */
            box-shadow: 0 4px 12px rgba(0, 0, 0, 0.2);
        }
        
        .alert {
            border-radius: 8px;
            padding: 1rem;
            font-size: 0.9rem;
            display: flex;
            align-items: center;
            gap: 0.5rem;
        }
        
        .auth-footer {
            text-align: center;
            padding: 0.3rem 1rem 1rem 1rem; /* Mengurangi padding atas menjadi 0.5rem */
            background: transparent; /* Make it transparent */
            border-top: none; /* Remove border */
            color: #555; /* Darker text for readability */
        }
        
        .auth-footer a {
            color: #0a939e; /* Keep the existing theme color for the link */
            text-decoration: none;
            font-weight: 500;
        }
        
        .auth-footer a:hover {
            text-decoration: underline;
        }
        
        .animate-fade-in {
            animation: fadeIn 0.5s ease-in-out;
        }
        
        @keyframes fadeIn {
            from { opacity: 0; transform: translateY(20px); }
            to { opacity: 1; transform: translateY(0); }
        }
        
        footer {
            flex-shrink: 0;
            text-align: center;
            padding: 1rem 0;
            background: transparent;
            color: #ffffff;
            border-top: none;
            position: absolute;
            bottom: 0;
            width: 100%;
        }

        @media (max-width: 576px) {
            .register-container {
                padding: 0 10px;
            }
            .register-card {
                border-radius: 10px;
            }
            .register-body {
                padding: 1.5rem;
            }
            .btn-primary {
                padding: 0.65rem;
            }
        }
    </style>
</head>
<body>
    <div class="wrapper">
        <div class="register-container">
            <div class="register-card animate-fade-in">
                <div class="register-body">
                    <h2 class="text-center mb-2" style="color: #555; font-weight: 600;">Registrasi Peserta ISS</h2>
                    <p class="text-center mb-4" style="color: #555;">Daftar akun ISS baru Anda</p>
                    
                    <?php if(!empty($error)): ?>
                        <div class="alert alert-danger">
                            <i class="fas fa-exclamation-triangle"></i>
                            <?php echo htmlspecialchars($error); ?>
                        </div>
                    <?php endif; ?>
                    
                    <?php if(!empty($success)): ?>
                        <div class="alert alert-success">
                            <i class="fas fa-check-circle"></i>
                            <?php echo htmlspecialchars($success); ?>
                        </div>
                    <?php endif; ?>
                    
                    <form method="POST" action="">
                        <div class="mb-3">
                            <label for="nik_karyawan" class="form-label">NIK Karyawan</label>
                            <div class="input-group">
                                <span class="input-group-text"><i class="fas fa-id-badge"></i></span>
                                <input type="text" class="form-control" id="nik_karyawan" name="nik_karyawan" placeholder="Masukkan NIK Karyawan" required pattern="[a-zA-Z0-9]+" title="NIK Karyawan hanya boleh berisi huruf dan angka" value="<?php echo isset($_POST['nik_karyawan']) ? htmlspecialchars($_POST['nik_karyawan']) : ''; ?>">
                            </div>
                        </div>
                        <div class="mb-3">
                            <label for="divisi" class="form-label">Divisi</label>
                            <div class="input-group">
                                <span class="input-group-text"><i class="fas fa-building"></i></span>
                                <select class="form-select" id="divisi" name="divisi" required>
                                    <option value="">-- Pilih Divisi --</option>
                                    <option value="Cleaner" <?php echo (isset($_POST['divisi']) && $_POST['divisi'] == 'Cleaner') ? 'selected' : ''; ?>>Cleaner - ISS</option>
                                    <option value="Security" <?php echo (isset($_POST['divisi']) && $_POST['divisi'] == 'Security') ? 'selected' : ''; ?>>Security - ISS</option>
                                    <option value="Lifeguard" <?php echo (isset($_POST['divisi']) && $_POST['divisi'] == 'Lifeguard') ? 'selected' : ''; ?>>Lifeguard - ISS</option>
                                    <option value="Receptionist" <?php echo (isset($_POST['divisi']) && $_POST['divisi'] == 'Receptionist') ? 'selected' : ''; ?>>Receptionist - ISS</option>
                                    <option value="Office Boy/Girl" <?php echo (isset($_POST['divisi']) && $_POST['divisi'] == 'Office Boy/Girl') ? 'selected' : ''; ?>>Office Boy/Girl - ISS</option>
                                </select>
                            </div>
                        </div>
                        <div class="mb-3">
                            <label for="jabatan" class="form-label">Jabatan</label>
                            <div class="input-group">
                                <span class="input-group-text"><i class="fas fa-user-tag"></i></span>
                                <select class="form-select" id="jabatan" name="jabatan" required>
                                    <option value="">-- Pilih Jabatan --</option>
                                    <option value="Site Head" <?php echo (isset($_POST['jabatan']) && $_POST['jabatan'] == 'Site Head') ? 'selected' : ''; ?>>Site Head</option>
                                    <option value="Service Supervisor" <?php echo (isset($_POST['jabatan']) && $_POST['jabatan'] == 'Service Supervisor') ? 'selected' : ''; ?>>Service Supervisor</option>
                                    <option value="Teams Leader" <?php echo (isset($_POST['jabatan']) && $_POST['jabatan'] == 'Teams Leader') ? 'selected' : ''; ?>>Teams Leader</option>
                                    <option value="Pelaksana" <?php echo (isset($_POST['jabatan']) && $_POST['jabatan'] == 'Pelaksana') ? 'selected' : ''; ?>>Pelaksana</option>
                                </select>
                            </div>
                        </div>
                        <div class="mb-4">
                            <label for="nama_lengkap" class="form-label">Nama Lengkap</label>
                            <div class="input-group">
                                <span class="input-group-text"><i class="fas fa-user"></i></span>
                                <input type="text" class="form-control" id="nama_lengkap" name="nama_lengkap" placeholder="Masukkan Nama Lengkap" required value="<?php echo isset($_POST['nama_lengkap']) ? htmlspecialchars($_POST['nama_lengkap']) : ''; ?>">
                            </div>
                        </div>
                        <div class="d-grid mb-4">
                            <button type="submit" class="btn btn-primary">
                                DAFTAR
                            </button>
                        </div>
                    </form>
                </div>
                <div class="auth-footer">
                    <p>Sudah punya akun? <a href="login.php">Login di sini</a></p>
                </div>
            </div>
        </div>
    </div>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>
