<?php
require_once 'koneksi.php';

// Cek jika user sudah login
if (isset($_SESSION['user_id'])) {
    redirect("dashboard.php");
}

$error = "";
$success = "";

// Proses registrasi
if ($_SERVER["REQUEST_METHOD"] == "POST") {
    $nik_karyawan = clean($_POST['nik_karyawan']);
    $divisi = html_entity_decode(clean($_POST['divisi'])); // Decode HTML entities
    $jabatan = clean($_POST['jabatan']);
    $password = $_POST['password'];
    $confirm_password = $_POST['confirm_password'];
    $nama_lengkap = clean($_POST['nama_lengkap']);
    $email = clean($_POST['email']);
    $no_telp = clean($_POST['no_telp']);
    $role = clean($_POST['role']);
    
    // Validasi input
    if (empty($nik_karyawan) || empty($divisi) || empty($jabatan) || empty($password) || empty($nama_lengkap) || empty($email)) {
        $error = "Semua field wajib diisi kecuali No. Telepon";
    } elseif ($password !== $confirm_password) {
        $error = "Password tidak cocok";
    } elseif (strlen($password) < 6) {
        $error = "Password minimal 6 karakter";
    } elseif (!is_numeric($nik_karyawan)) {
        $error = "NIK Karyawan harus berupa angka";
    } else {
        $table = ($role == 'trainer') ? 'trainers' : 'peserta';
        
        // Validasi jabatan
        $valid_jabatan = ['Pelaksana', 'Leader', 'Staff', 'Asst. Supervisor', 'Supervisor', 'Asst. Manager', 'Manager', 'Deputy GM'];
        if (!in_array($jabatan, $valid_jabatan)) {
            $error = "Jabatan tidak valid";
        } else {
            // Cek NIK Karyawan sudah ada atau belum
            $stmt = $koneksi->prepare("SELECT id FROM $table WHERE nik_karyawan = ?");
            $stmt->bind_param("s", $nik_karyawan);
            $stmt->execute();
            $result = $stmt->get_result();
            
            if ($result->num_rows > 0) {
                $error = "NIK Karyawan sudah digunakan";
            } else {
                // Cek email sudah ada atau belum
                $stmt = $koneksi->prepare("SELECT id FROM $table WHERE email = ?");
                $stmt->bind_param("s", $email);
                $stmt->execute();
                $result = $stmt->get_result();
                
                if ($result->num_rows > 0) {
                    $error = "Email sudah digunakan";
                } else {
                    // Validasi divisi
                    $valid_divisions = [
                        'HR & GA', 'HSE & CCTV', 'Finance', 'Marketing', 'Promosi', 'Customer Service', 
                        'Legal', 'Engineering', 'Engineering - BM', 'Engineering - ME', 
                        'Engineering - Fit Out', 'Engineering - Landscape', 'Engineering - Waterpark', 
                        'Security', 'Parkir', 'IT'
                    ];
                    
                    // Decode HTML entities in valid_divisions for comparison
                    $decoded_divisions = array_map('html_entity_decode', $valid_divisions);
                    
                    if (!in_array($divisi, $decoded_divisions)) {
                        $error = "Divisi tidak valid";
                    } else {
                        // Hash password
                        $hashed_password = password_hash($password, PASSWORD_DEFAULT);
                        
                        // Insert data menggunakan prepared statement
                        $stmt = $koneksi->prepare("INSERT INTO $table (nik_karyawan, divisi, jabatan, password, nama_lengkap, email, no_telp) VALUES (?, ?, ?, ?, ?, ?, ?)");
                        $stmt->bind_param("sssssss", $nik_karyawan, $divisi, $jabatan, $hashed_password, $nama_lengkap, $email, $no_telp);
                        
                        if ($stmt->execute()) {
                            $success = "Registrasi berhasil! Silahkan login.";
                        } else {
                            $error = "Error: " . $stmt->error;
                        }
                    }
                }
            }
            $stmt->close();
        }
    }
}
?>
<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Registrasi E-Learning</title>
    <link rel="icon" type="image/png" href="image/icon.png">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css">
</head>
<body class="bg-light">
    <div class="container">
        <div class="row justify-content-center mt-5">
            <div class="col-md-6">
                <div class="card shadow">
                    <div class="card-header bg-primary text-white">
                        <h4 class="text-center mb-0">Registrasi E-Learning</h4>
                    </div>
                    <div class="card-body">
                        <?php if(!empty($error)): ?>
                            <div class="alert alert-danger"><?php echo htmlspecialchars($error); ?></div>
                        <?php endif; ?>
                        
                        <?php if(!empty($success)): ?>
                            <div class="alert alert-success"><?php echo htmlspecialchars($success); ?></div>
                        <?php endif; ?>
                        
                        <form method="POST" action="">
                            <div class="mb-3">
                                <label for="role" class="form-label">Daftar Sebagai</label>
                                <select class="form-select" name="role" id="role" required>
                                    <option value="peserta">Peserta</option>
                                    <option value="trainer">Trainer</option>
                                </select>
                            </div>
                            <div class="mb-3">
                                <label for="nik_karyawan" class="form-label">NIK Karyawan</label>
                                <input type="text" class="form-control" id="nik_karyawan" name="nik_karyawan" required pattern="[0-9]+" title="NIK Karyawan harus berupa angka">
                            </div>
                            <div class="mb-3">
                                <label for="divisi" class="form-label">Divisi</label>
                                <select class="form-select" name="divisi" id="divisi" required>
                                    <option value="" disabled selected>Pilih Divisi</option>
                                    <option value="HR & GA">HR & GA</option>
                                    <option value="HSE & CCTV">HSE & CCTV</option>
                                    <option value="Finance">Finance</option>
                                    <option value="Marketing">Marketing</option>
                                    <option value="Promosi">Promosi</option>
                                    <option value="Customer Service">Customer Service</option>
                                    <option value="Legal">Legal</option>
                                    <option value="Engineering">Engineering</option>
                                    <option value="Engineering - BM">Engineering - BM</option>
                                    <option value="Engineering - ME">Engineering - ME</option>
                                    <option value="Engineering - Fit Out">Engineering - Fit Out</option>
                                    <option value="Engineering - Landscape">Engineering - Landscape</option>
                                    <option value="Engineering - Waterpark">Engineering - Waterpark</option>
                                    <option value="Security">Security</option>
                                    <option value="Parkir">Parkir</option>
                                    <option value="IT">IT</option>
                                </select>
                            </div>
                            <div class="mb-3">
                                <label for="jabatan" class="form-label">Jabatan</label>
                                <select class="form-select" name="jabatan" id="jabatan" required>
                                    <option value="" disabled selected>Pilih Jabatan</option>
                                    <option value="Pelaksana">Pelaksana</option>
                                    <option value="Leader">Leader</option>
                                    <option value="Staff">Staff</option>
                                    <option value="Asst. Supervisor">Asst. Supervisor</option>
                                    <option value="Supervisor">Supervisor</option>
                                    <option value="Asst. Manager">Asst. Manager</option>
                                    <option value="Manager">Manager</option>
                                    <option value="Deputy GM">Deputy GM</option>
                                </select>
                            </div>
                            <div class="mb-3">
                                <label for="nama_lengkap" class="form-label">Nama Lengkap</label>
                                <input type="text" class="form-control" id="nama_lengkap" name="nama_lengkap" required>
                            </div>
                            <div class="mb-3">
                                <label for="email" class="form-label">Email</label>
                                <input type="email" class="form-control" id="email" name="email" required>
                            </div>
                            <div class="mb-3">
                                <label for="no_telp" class="form-label">No. Telepon</label>
                                <input type="text" class="form-control" id="no_telp" name="no_telp">
                            </div>
                            <div class="mb-3">
                                <label for="password" class="form-label">Password</label>
                                <input type="password" class="form-control" id="password" name="password" required>
                            </div>
                            <div class="mb-3">
                                <label for="confirm_password" class="form-label">Konfirmasi Password</label>
                                <input type="password" class="form-control" id="confirm_password" name="confirm_password" required>
                            </div>
                            <div class="d-grid">
                                <button type="submit" class="btn btn-primary">Daftar</button>
                            </div>
                        </form>
                        <div class="text-center mt-3">
                            <p>Sudah punya akun? <a href="login.php">Login disini</a></p>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>