<?php
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

require_once 'koneksi.php';

// Cek login
checkLogin();

date_default_timezone_set('Asia/Jakarta');

$user_id = $_SESSION['user_id'];
$role = $_SESSION['role'];
$nik_karyawan = $_SESSION['nik_karyawan'];

// Ambil informasi user berdasarkan peran
$user = []; // Initialize $user to an empty array
$stmt = null; // Initialize $stmt

if ($role == 'trainer') {
    $stmt = $koneksi->prepare("SELECT nama_lengkap, jabatan, divisi, foto_profil FROM trainers WHERE id = ?");
} elseif ($role == 'iss') {
    // Updated query to only select available columns for 'iss' table
    $stmt = $koneksi->prepare("SELECT nama_lengkap, jabatan, divisi FROM iss WHERE id = ?");
} else { // Peserta
    $stmt = $koneksi->prepare("SELECT nama_lengkap, jabatan, divisi, foto_profil FROM peserta WHERE id = ?");
}

// Check if the prepare statement was successful
if ($stmt === false) {
    // Log the error for debugging purposes
    error_log("Prepare failed for user info query for role '{$role}': " . $koneksi->error);
    // For now, we just ensure $user is an empty array to prevent further errors
} else {
    $stmt->bind_param("i", $user_id);
    $stmt->execute();
    $result = $stmt->get_result();
    $user = $result->fetch_assoc();
    $stmt->close();
}

$nama_user = $user['nama_lengkap'] ?? 'Unknown';

$current_page = basename($_SERVER['PHP_SELF']);

$submission_id = $_GET['submission_id'] ?? null;
$submission_data = null;
$answers_detail = [];
$training_title = "Tidak Ditemukan";
$total_questions = 0;
$correct_answers_count = 0; // Ini akan dihitung dari post_test_answers
$final_score_100 = 0; // Ini akan diambil dari post_test_submissions.score

if ($submission_id) {
    // Get submission details including the 1-100 score
    // Pastikan submission_id milik user yang sedang login dan sesuai role
    $stmt = $koneksi->prepare("SELECT ps.score, ps.training_id, t.judul AS training_judul FROM post_test_submissions ps JOIN trainings t ON ps.training_id = t.id WHERE ps.id = ? AND ps.user_id = ? AND ps.user_role = ?");
    if ($stmt === false) {
        error_log("Prepare failed for submission data query: " . $koneksi->error);
    } else {
        $stmt->bind_param("iis", $submission_id, $user_id, $role);
        $stmt->execute();
        $result = $stmt->get_result();
        if ($row = $result->fetch_assoc()) {
            $submission_data = $row;
            $training_title = $row['training_judul'];
            $final_score_100 = $row['score']; // Ambil skor 1-100 yang sudah disimpan
        }
        $stmt->close();
    }

    if ($submission_data) {
        // Get answers details for this submission and count correct answers
        $stmt = $koneksi->prepare("
            SELECT
                pa.selected_option,
                pa.is_correct,
                ptq.question_text,
                ptq.option_a, ptq.option_b, ptq.option_c, ptq.option_d,
                ptq.correct_answer
            FROM post_test_answers pa
            JOIN post_test_questions ptq ON pa.question_id = ptq.id
            WHERE pa.submission_id = ?
            ORDER BY ptq.id ASC
        ");
        if ($stmt === false) {
            error_log("Prepare failed for answers detail query: " . $koneksi->error);
        } else {
            $stmt->bind_param("i", $submission_id);
            $stmt->execute();
            $result = $stmt->get_result();
            while ($row = $result->fetch_assoc()) {
                $answers_detail[] = $row;
                $total_questions++; // Hitung total soal yang dijawab
                if ($row['is_correct']) {
                    $correct_answers_count++; // Hitung jumlah jawaban benar
                }
            }
            $stmt->close();
        }
    }
}

?>
<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Hasil Post Test - E-Learning</title>
    <link rel="icon" type="image/png" href="image/icon.png">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.10.0/font/bootstrap-icons.css">
    <style>
        :root {
            --soft-ui-primary: #cb0c9f;
            --soft-ui-secondary: #67748e;
            --soft-ui-info: #17c1e8;
            --soft-ui-success: #82d616;
            --soft-ui-warning: #fb8c00;
            --soft-ui-danger: #ea0606;
            --soft-ui-light: #e9ecef;
            --soft-ui-dark: #344767;
            --soft-ui-white: #ffffff;
            --soft-ui-gray-100: #f8f9fa;
            --soft-ui-gray-200: #e9ecef;
            --soft-ui-gray-300: #dee2e6;
            --soft-ui-gray-400: #ced4da;
            --soft-ui-gray-500: #adb5bd;
            --soft-ui-gray-600: #6c757d;
            --soft-ui-gray-700: #495057;
            --soft-ui-gray-800: #343a40;
            --soft-ui-gray-900: #212529;
        }

        html, body {
            height: 100%;
            margin: 0;
            font-family: 'Open Sans', sans-serif;
            background-color: var(--soft-ui-gray-100);
        }
        
        body {
            overflow-x: hidden;
            display: flex;
            flex-direction: column;
        }
        
        .navbar-top {
            position: fixed;
            top: 0;
            width: 100%;
            z-index: 1100;
            background: var(--soft-ui-white);
            border-bottom: 1px solid var(--soft-ui-gray-200);
            box-shadow: 0 2px 12px rgba(0, 0, 0, 0.05);
            padding: 0.75rem 1.5rem;
        }
        
        .navbar-top .container-fluid {
            display: flex;
            align-items: center;
            justify-content: space-between;
            flex-wrap: nowrap;
            position: relative;
        }
        
        .navbar-logo {
            height: 40px;
            width: auto;
            margin-right: 15px;
        }
        
        .navbar-title {
            position: absolute;
            left: 50%;
            transform: translateX(-50%);
            font-size: 1.3rem;
            color: var(--soft-ui-dark);
            font-weight: 700;
            text-align: center;
            white-space: nowrap;
            pointer-events: none;
        }

        .navbar-title-mobile {
            display: none;
            font-size: 0.85rem;
            color: var(--soft-ui-dark);
            font-weight: 700;
            text-align: center;
            line-height: 1.2;
            flex: 1;
            margin: 0 10px;
        }

        .navbar-title-mobile .line1 {
            display: block;
        }

        .navbar-title-mobile .line2 {
            display: block;
            font-size: 0.8rem;
        }
        
        .navbar-brand {
            font-size: 1.2rem;
            color: var(--soft-ui-dark);
            font-weight: 700;
            display: flex;
            align-items: center;
            z-index: 1;
        }

        .navbar-nav {
            position: relative;
            z-index: 1200;
        }

        .navbar-nav .nav-item .nav-link {
            color: var(--soft-ui-secondary);
            font-weight: 600;
            padding: 0.5rem 1rem;
            transition: all 0.2s ease-in-out;
        }

        .navbar-nav .nav-item .nav-link:hover {
            color: var(--soft-ui-primary);
        }

        .navbar-nav .nav-item .nav-link.active {
            color: var(--soft-ui-primary);
        }

        .navbar-nav .dropdown-menu {
            position: absolute;
            top: 100%;
            right: 0;
            left: auto;
            z-index: 1300;
            background-color: var(--soft-ui-white);
            border: 1px solid var(--soft-ui-gray-200);
            border-radius: 0.5rem;
            box-shadow: 0 4px 12px rgba(0, 0, 0, 0.15);
            min-width: 160px;
            margin-top: 0.125rem;
        }

        .navbar-nav .dropdown-item {
            color: var(--soft-ui-secondary);
            padding: 0.5rem 1rem;
            font-weight: 500;
            transition: all 0.2s ease-in-out;
        }

        .navbar-nav .dropdown-item:hover {
            background-color: var(--soft-ui-gray-200);
            color: var(--soft-ui-dark);
        }

        .navbar-nav .dropdown-item.active {
            background-color: var(--soft-ui-primary);
            color: var(--soft-ui-white);
        }
        
        .sidebar {
            min-height: 100vh;
            width: 250px;
            position: fixed;
            top: 0;
            left: 0;
            z-index: 1000;
            background: var(--soft-ui-white);
            color: var(--soft-ui-dark);
            padding-top: 70px;
            transition: all 0.3s ease-in-out;
            border-right: 1px solid var(--soft-ui-gray-200);
            box-shadow: 4px 0 15px rgba(0, 0, 0, 0.05);
            border-radius: 0 1rem 1rem 0;
        }
        
        .content {
            margin-left: 250px;
            margin-top: 0;
            padding: 20px;
            padding-top: 90px;
            transition: all 0.3s ease-in-out;
            flex-grow: 1;
        }
        
        .hamburger-mobile {
            display: none;
            background: none;
            border: none;
            color: var(--soft-ui-dark);
            font-size: 1.5rem;
            cursor: pointer;
            margin-right: 15px;
            transition: all 0.3s ease;
            z-index: 1;
        }
        
        .hamburger-mobile:focus {
            outline: none;
        }
        
        .sidebar-overlay {
            display: none;
            position: fixed;
            top: 0;
            left: 0;
            right: 0;
            bottom: 0;
            background-color: rgba(0, 0, 0, 0.4);
            z-index: 999;
        }
        
        .profile-section {
            text-align: center;
            padding: 15px 20px;
            border-bottom: 1px solid var(--soft-ui-gray-200);
            background: var(--soft-ui-white);
            border-radius: 0.75rem;
            box-shadow: 0 4px 15px rgba(0, 0, 0, 0.05);
        }
        
        .profile-photo {
            width: 80px;
            height: 80px;
            border-radius: 50%;
            object-fit: cover;
            border: 2px solid var(--soft-ui-gray-300);
            margin: 0 auto 10px;
            display: block;
            box-shadow: 0 4px 10px rgba(0, 0, 0, 0.08);
        }
        
        .profile-photo-placeholder {
            width: 80px;
            height: 80px;
            border-radius: 50%;
            background: var(--soft-ui-gray-400);
            display: flex;
            align-items: center;
            justify-content: center;
            margin: 0 auto 10px;
            border: 2px solid var(--soft-ui-gray-300);
            box-shadow: 0 4px 10px rgba(0, 0, 0, 0.08);
        }
        
        .profile-photo-placeholder i {
            font-size: 2rem;
            color: var(--soft-ui-white);
        }
        
        .profile-name {
            font-size: 1.1rem;
            font-weight: 600;
            color: var(--soft-ui-dark);
            margin-bottom: 5px;
            word-wrap: break-word;
        }
        
        .profile-info {
            font-size: 0.9rem;
            font-weight: 400;
            color: var(--soft-ui-secondary);
            margin-bottom: 3px;
        }
        
        .sidebar .nav-link {
            color: var(--soft-ui-secondary);
            padding: 0.75rem 1rem;
            border-radius: 0.5rem;
            margin: 0.25rem 0.75rem;
            transition: all 0.2s ease-in-out;
            font-weight: 600;
            display: flex;
            align-items: center;
        }
        
        .sidebar .nav-link:hover {
            background-color: var(--soft-ui-gray-200);
            color: var(--soft-ui-dark);
        }
        
        .sidebar .nav-link.active {
            background-color: var(--soft-ui-primary);
            color: var(--soft-ui-white) !important;
            box-shadow: 0 4px 12px rgba(0, 0, 0, 0.1);
        }

        .sidebar .nav-link.active i {
            color: var(--soft-ui-white);
        }
        
        .sidebar .nav-link i {
            font-size: 1.2rem;
            margin-right: 10px;
            color: var(--soft-ui-secondary);
            transition: all 0.2s ease-in-out;
        }

        .sidebar .nav-item.dropdown .dropdown-menu {
            background-color: var(--soft-ui-white);
            border: none;
            box-shadow: 0 4px 12px rgba(0, 0, 0, 0.08);
            border-radius: 0.5rem;
            padding: 0.5rem 0;
            margin-top: 0.25rem;
        }

        .sidebar .nav-item.dropdown .dropdown-item {
            color: var(--soft-ui-secondary);
            padding: 0.5rem 1.5rem;
            font-weight: 500;
            transition: all 0.2s ease-in-out;
        }

        .sidebar .nav-item.dropdown .dropdown-item:hover {
            background-color: var(--soft-ui-gray-200);
            color: var(--soft-ui-dark);
        }

        .sidebar .nav-item.dropdown .dropdown-item.active {
            background-color: var(--soft-ui-primary);
            color: var(--soft-ui-white);
        }
        
        .card {
            background-color: var(--soft-ui-white);
            border-radius: 0.75rem;
            box-shadow: 0 4px 12px rgba(0, 0, 0, 0.05);
            transition: all 0.2s ease-in-out;
            border: none;
        }

        .card:hover {
            transform: translateY(-3px);
            box-shadow: 0 6px 16px rgba(0, 0, 0, 0.08);
        }
        
        .card-header {
            padding: 1.5rem;
            color: var(--soft-ui-white);
            text-align: center;
            font-weight: 700;
            font-size: 1.25rem;
            background: linear-gradient(195deg, var(--soft-ui-primary), #a80a85);
            border-bottom: none;
            border-radius: 0.75rem 0.75rem 0 0;
        }
        
        .card-body {
            padding: 1.5rem;
            background: var(--soft-ui-white);
        }
        
        .btn-primary {
            background: linear-gradient(195deg, var(--soft-ui-primary), #a80a85);
            border: none;
            border-radius: 0.5rem;
            padding: 0.75rem 1.5rem;
            font-weight: 600;
            font-size: 0.875rem;
            color: var(--soft-ui-white);
            transition: all 0.3s ease;
            box-shadow: 0 4px 12px rgba(0, 0, 0, 0.1);
            text-transform: uppercase;
            letter-spacing: 0.5px;
        }
        
        .btn-primary:hover {
            background: linear-gradient(195deg, #a80a85, var(--soft-ui-primary));
            transform: translateY(-2px);
            box-shadow: 0 6px 16px rgba(0, 0, 0, 0.15);
            color: var(--soft-ui-white);
        }
        
        .alert {
            border-radius: 0.75rem;
            padding: 1rem 1.5rem;
            border: none;
            font-weight: 500;
        }

        .alert-danger {
            background: linear-gradient(195deg, rgba(234, 6, 6, 0.1), rgba(234, 6, 6, 0.05));
            color: var(--soft-ui-danger);
            border-left: 4px solid var(--soft-ui-danger);
        }
        
        .page-title {
            font-size: 2.5rem;
            font-weight: 700;
            color: var(--soft-ui-dark);
            margin-bottom: 2rem;
            text-align: center;
            line-height: 1.2;
        }
        
        footer {
            background: var(--soft-ui-white);
            color: var(--soft-ui-secondary);
            border-top: 1px solid var(--soft-ui-gray-200);
            padding: 1rem 0;
            text-align: center;
            flex-shrink: 0;
            margin-top: 2rem;
        }
        
        .animate-fade-in {
            animation: fadeIn 0.5s ease-in-out;
        }
        
        @keyframes fadeIn {
            from { opacity: 0; transform: translateY(10px); }
            to { opacity: 1; transform: translateY(0); }
        }
        
        .result-summary {
            text-align: center;
            margin-bottom: 2.5rem;
            padding: 2.5rem;
            background: linear-gradient(195deg, rgba(203, 12, 159, 0.05), rgba(168, 10, 133, 0.05));
            border-radius: 1rem;
            box-shadow: 0 8px 20px rgba(0, 0, 0, 0.08);
            border: 1px solid var(--soft-ui-gray-200);
            backdrop-filter: blur(10px);
        }
        
        .result-summary h3 {
            color: var(--soft-ui-primary);
            font-weight: 700;
            margin-bottom: 1.5rem;
            font-size: 2rem;
        }
        
        .result-summary p {
            font-size: 1.1rem;
            color: var(--soft-ui-dark);
            margin-bottom: 1rem;
            font-weight: 500;
        }
        
        .result-summary .score {
            font-size: 4rem;
            font-weight: 900;
            background: linear-gradient(195deg, var(--soft-ui-success), #6bb518);
            -webkit-background-clip: text;
            -webkit-text-fill-color: transparent;
            background-clip: text;
            margin: 1.5rem 0;
            display: block;
            text-shadow: 0 4px 8px rgba(0, 0, 0, 0.1);
        }

        .result-summary .h4 {
            color: var(--soft-ui-primary);
            font-weight: 700;
        }

        .result-summary .h5 {
            color: var(--soft-ui-dark);
            font-weight: 600;
        }
        
        .question-review-card {
            margin-bottom: 1.5rem;
            background-color: var(--soft-ui-white);
            border-radius: 0.75rem;
            box-shadow: 0 4px 12px rgba(0, 0, 0, 0.05);
            transition: all 0.2s ease-in-out;
            border: none;
            overflow: hidden;
        }

        .question-review-card:hover {
            transform: translateY(-2px);
            box-shadow: 0 6px 16px rgba(0, 0, 0, 0.08);
        }
        
        .question-review-card .card-header {
            background: linear-gradient(195deg, var(--soft-ui-secondary), #5a6c7d);
            color: var(--soft-ui-white);
            font-weight: 700;
            font-size: 1.1rem;
            padding: 1rem 1.5rem;
            border-radius: 0;
            display: flex;
            align-items: center;
            justify-content: space-between;
        }
        
        .question-review-card .card-body {
            padding: 1.5rem;
            background: var(--soft-ui-white);
        }
        
        .question-review-card .question-text {
            font-weight: 700;
            margin-bottom: 1.5rem;
            color: var(--soft-ui-dark);
            font-size: 1.1rem;
            line-height: 1.6;
        }
        
        .question-review-card .option-item {
            padding: 0.75rem 1rem;
            border-bottom: 1px solid var(--soft-ui-gray-200);
            border-radius: 0.5rem;
            margin-bottom: 0.5rem;
            transition: all 0.2s ease-in-out;
            background: var(--soft-ui-gray-100);
        }
        
        .question-review-card .option-item:last-child {
            border-bottom: none;
            margin-bottom: 0;
        }
        
        .question-review-card .option-label {
            font-size: 1rem;
            color: var(--soft-ui-dark);
            font-weight: 500;
        }
        
        .question-review-card .selected-answer {
            font-weight: 700;
            background: linear-gradient(195deg, rgba(23, 193, 232, 0.1), rgba(41, 182, 246, 0.1));
            border-left: 4px solid var(--soft-ui-info);
        }
        
        .question-review-card .correct-answer {
            font-weight: 700;
            background: linear-gradient(195deg, rgba(130, 214, 22, 0.1), rgba(102, 187, 106, 0.1));
            border-left: 4px solid var(--soft-ui-success);
            color: var(--soft-ui-success);
        }
        
        .question-review-card .wrong-answer {
            font-weight: 700;
            background: linear-gradient(195deg, rgba(234, 6, 6, 0.1), rgba(244, 67, 54, 0.1));
            border-left: 4px solid var(--soft-ui-danger);
            color: var(--soft-ui-danger);
        }
        
        .feedback-icon {
            margin-left: 10px;
            font-size: 1.2rem;
        }
        
        .feedback-icon.correct {
            color: var(--soft-ui-success);
        }
        
        .feedback-icon.wrong {
            color: var(--soft-ui-danger);
        }

        .badge {
            border-radius: 0.5rem !important;
            padding: 0.5rem 1rem !important;
            font-weight: 600 !important;
            font-size: 0.75rem !important;
        }

        .bg-success {
            background: linear-gradient(195deg, var(--soft-ui-success), #6bb518) !important;
            color: var(--soft-ui-white) !important;
        }

        .review-section-title {
            font-size: 1.8rem;
            font-weight: 700;
            color: var(--soft-ui-dark);
            margin-bottom: 1.5rem;
            text-align: center;
            border-bottom: 2px solid var(--soft-ui-primary);
            padding-bottom: 0.5rem;
        }

        @media (max-width: 768px) {
            .sidebar {
                margin-left: -250px;
                border-radius: 0;
                padding-top: 90px;
            }
            .sidebar-active {
                margin-left: 0;
            }
            .content {
                margin-left: 0;
                padding-top: 100px;
            }
            
            .navbar-title {
                display: none;
            }
            .navbar-logo {
                display: none;
            }
            
            .navbar-title-mobile {
                display: block;
            }
            
            .hamburger-mobile {
                display: block;
            }
            .navbar-nav {
                position: static;
            }
            .navbar-nav .dropdown-menu {
                position: absolute;
                right: 0;
                left: auto;
                z-index: 1300;
            }
            
            .page-title {
                font-size: 1.8rem;
                text-align: center;
            }

            .result-summary {
                padding: 1.5rem;
                margin-bottom: 2rem;
            }

            .result-summary h3 {
                font-size: 1.5rem;
            }

            .result-summary .score {
                font-size: 3rem;
            }

            .question-review-card .card-body {
                padding: 1rem;
            }

            .question-review-card .option-item {
                padding: 0.5rem 0.75rem;
            }
            
            .navbar-top {
                padding: 0.5rem 1rem;
                min-height: 70px;
            }

            .profile-photo, .profile-photo-placeholder {
                width: 60px;
                height: 60px;
            }
            .profile-photo-placeholder i {
                font-size: 1.5rem;
            }
            .profile-name {
                font-size: 1rem;
            }
            .profile-info {
                font-size: 0.8rem;
            }
        }

        @media (max-width: 576px) {
            .navbar-top {
                padding: 0.5rem 1rem;
                min-height: 70px;
            }
            .navbar-title-mobile {
                font-size: 0.8rem;
            }
            .navbar-title-mobile .line2 {
                font-size: 0.75rem;
            }
            .page-title {
                font-size: 1.5rem;
            }

            .result-summary {
                padding: 1rem;
            }

            .result-summary h3 {
                font-size: 1.3rem;
            }

            .result-summary .score {
                font-size: 2.5rem;
            }

            .question-review-card .question-text {
                font-size: 1rem;
            }

            .profile-photo, .profile-photo-placeholder {
                width: 50px;
                height: 50px;
            }
            .profile-photo-placeholder i {
                font-size: 1.2rem;
            }
            .profile-name {
                font-size: 0.9rem;
            }
            .profile-info {
                font-size: 0.7rem;
            }
        }
    </style>
</head>
<body>
    <!-- Top Navbar -->
    <nav class="navbar navbar-expand-lg navbar-top">
        <div class="container-fluid">
            <button class="hamburger-mobile d-md-none" type="button" id="sidebarToggle">
                <i class="bi bi-list"></i>
            </button>
            <a class="navbar-brand d-none d-md-flex" href="#">
                <img src="image/logopim.png" alt="Logo PIM" class="navbar-logo">
            </a>
            <div class="navbar-title d-none d-md-block">
                E-Learning System Pondok Indah Mall
            </div>
            <div class="navbar-title-mobile d-md-none">
                <span class="line1">E-Learning System</span>
                <span class="line2">Pondok Indah Mall</span>
            </div>
            <?php if ($role != 'iss'): ?>
            <ul class="navbar-nav ms-auto mb-2 mb-lg-0">
                <li class="nav-item dropdown">
                    <a class="nav-link dropdown-toggle text-dark" href="#" id="navbarDropdown" role="button" data-bs-toggle="dropdown" aria-expanded="false">
                        <i class="bi bi-person-circle"></i>
                    </a>
                    <ul class="dropdown-menu dropdown-menu-end">
                        <li><a class="dropdown-item <?php echo ($current_page == 'profile.php') ? 'active' : ''; ?>" href="profile.php">Profile</a></li>
                        <li><hr class="dropdown-divider"></li>
                        <li><a class="dropdown-item" href="logout.php">Logout</a></li>
                    </ul>
                </li>
            </ul>
            <?php endif; ?>
        </div>
    </nav>

    <!-- Sidebar overlay (for mobile) -->
    <div class="sidebar-overlay" id="sidebarOverlay"></div>

    <!-- Sidebar -->
    <div class="sidebar border-end" id="sidebar">
        <div class="profile-section">
            <?php if (!empty($user['foto_profil'])): ?>
                <img src="Uploads/profiles/<?php echo htmlspecialchars($user['foto_profil']); ?>" alt="Foto Profil" class="profile-photo">
            <?php else: ?>
                <div class="profile-photo-placeholder">
                    <i class="bi bi-person-circle"></i>
                </div>
            <?php endif; ?>
            <div class="profile-name"><?php echo htmlspecialchars($user['nama_lengkap'] ?? 'N/A'); ?></div>
            <div class="profile-info"><?php echo htmlspecialchars($user['jabatan'] ?? 'N/A'); ?></div>
            <div class="profile-info"><?php echo htmlspecialchars($user['divisi'] ?? 'N/A'); ?></div>
        </div>
        <div class="p-3">
            <h5 class="mb-4 text-dark">Menu</h5>
            <ul class="nav flex-column">
                <li class="nav-item">
                    <a class="nav-link <?php echo ($current_page == 'dashboard.php') ? 'active' : ''; ?>" href="dashboard.php">
                        <i class="bi bi-house-door-fill"></i> Dashboard
                    </a>
                </li>
                <li class="nav-item">
                    <a class="nav-link <?php echo ($current_page == 'materi.php') ? 'active' : ''; ?>" href="materi.php">
                        <i class="bi bi-book"></i> Materi
                    </a>
                </li>
                <?php if ($role == 'trainer'): ?>
                    <li class="nav-item dropdown">
                        <a class="nav-link dropdown-toggle <?php echo ($current_page == 'add_posttest.php' || $current_page == 'list_posttest.php' || $current_page == 'view_posttest_scores.php') ? 'active' : ''; ?>" href="#" id="postTestDropdown" role="button" data-bs-toggle="dropdown" aria-expanded="false">
                            <i class="bi bi-clipboard-check"></i> Post Test
                        </a>
                        <ul class="dropdown-menu" aria-labelledby="postTestDropdown">
                            <li><a class="dropdown-item <?php echo ($current_page == 'add_posttest.php') ? 'active' : ''; ?>" href="add_posttest.php">Tambah Post Test</a></li>
                            <li><a class="dropdown-item <?php echo ($current_page == 'list_posttest.php' || $current_page == 'view_posttest_scores.php') ? 'active' : ''; ?>" href="list_posttest.php">List Post Test</a></li>
                        </ul>
                    </li>
                <?php elseif ($role == 'peserta' || $role == 'iss'): ?>
                    <li class="nav-item">
                        <a class="nav-link <?php echo ($current_page == 'list_posttest.php' || $current_page == 'take_posttest.php' || $current_page == 'post_test_result.php') ? 'active' : ''; ?>" href="list_posttest.php">
                            <i class="bi bi-clipboard-check"></i> Post Test
                        </a>
                    </li>
                <?php endif; ?>
                <li class="nav-item dropdown">
                    <a class="nav-link dropdown-toggle <?php echo ($current_page == 'add_training.php' || $current_page == 'list_training.php') ? 'active' : ''; ?>" href="#" id="trainingDropdown" role="button" data-bs-toggle="dropdown" aria-expanded="false">
                        <i class="bi bi-journal-text"></i> Training
                    </a>
                    <ul class="dropdown-menu" aria-labelledby="trainingDropdown">
                        <?php if($role == 'trainer'): ?>
                        <li><a class="dropdown-item <?php echo ($current_page == 'add_training.php') ? 'active' : ''; ?>" href="add_training.php">Tambah Kegiatan Training</a></li>
                        <?php endif; ?>
                        <li><a class="dropdown-item <?php echo ($current_page == 'list_training.php') ? 'active' : ''; ?>" href="list_training.php">List Training</a></li>
                    </ul>
                </li>
                <?php if ($role == 'trainer'): ?>
                    <li class="nav-item">
                        <a class="nav-link <?php echo ($current_page == 'report.php') ? 'active' : ''; ?>" href="report.php">
                            <i class="bi bi-file-earmark-text"></i> Report
                        </a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link <?php echo ($current_page == 'data_evaluasi.php') ? 'active' : ''; ?>" href="data_evaluasi.php">
                            <i class="bi bi-clipboard-data"></i> Data Evaluasi
                        </a>
                    </li>
                <?php endif; ?>
            </ul>
        </div>
    </div>

    <!-- Content -->
    <div class="content">
        <div class="container-fluid">
            <?php if (!$submission_data): ?>
                <div class="alert alert-danger text-center animate-fade-in">
                    <i class="bi bi-exclamation-triangle me-2"></i>
                    Data hasil post test tidak ditemukan atau Anda tidak memiliki izin untuk melihatnya.
                </div>
            <?php else: ?>
                <div class="result-summary animate-fade-in">
                    <h3><i class="bi bi-trophy me-2"></i>Ringkasan Hasil Post Test</h3>
                    <p>Anda telah menyelesaikan Post Test untuk training:</p>
                    <p class="h4 text-primary"><strong><?php echo htmlspecialchars($training_title); ?></strong></p>
                    <div class="row mt-4">
                        <div class="col-md-4">
                            <p><i class="bi bi-list-ol me-2"></i>Jumlah Soal: <strong><?php echo $total_questions; ?></strong></p>
                        </div>
                        <div class="col-md-4">
                            <p><i class="bi bi-check-circle me-2"></i>Jawaban Benar: <strong><?php echo $correct_answers_count; ?></strong></p>
                        </div>
                        <div class="col-md-4">
                            <?php if ($total_questions > 0): ?>
                                <p><i class="bi bi-percent me-2"></i>Persentase: <strong><?php echo round(($correct_answers_count / $total_questions) * 100, 2); ?>%</strong></p>
                            <?php endif; ?>
                        </div>
                    </div>
                    <span class="score"><?php echo $final_score_100; ?></span>
                    <p class="h5 mt-3"><i class="bi bi-award me-2"></i>Nilai Anda (dari 100)</p>
                    <a href="list_posttest.php" class="btn btn-primary mt-4">
                        <i class="bi bi-arrow-left me-2"></i>Kembali ke Daftar Post Test
                    </a>
                </div>

                <h3 class="review-section-title animate-fade-in">
                    <i class="bi bi-eye me-2"></i>Tinjauan Jawaban Anda
                </h3>
                <?php $q_num = 1; foreach ($answers_detail as $answer): ?>
                    <div class="question-review-card animate-fade-in">
                        <div class="card-header">
                            <span><i class="bi bi-question-circle me-2"></i>Soal #<?php echo $q_num++; ?></span>
                            <?php if ($answer['is_correct']): ?>
                                <i class="bi bi-check-circle-fill feedback-icon correct" title="Jawaban Benar"></i>
                            <?php else: ?>
                                <i class="bi bi-x-circle-fill feedback-icon wrong" title="Jawaban Salah"></i>
                            <?php endif; ?>
                        </div>
                        <div class="card-body">
                            <p class="question-text"><?php echo htmlspecialchars($answer['question_text']); ?></p>
                            <ul class="list-unstyled">
                                <?php
                                $options = ['A' => $answer['option_a'], 'B' => $answer['option_b'], 'C' => $answer['option_c'], 'D' => $answer['option_d']];
                                foreach ($options as $opt_key => $opt_value):
                                    $class = '';
                                    $icon = '';
                                    if ($opt_key == $answer['selected_option']) {
                                        $class = $answer['is_correct'] ? 'correct-answer' : 'wrong-answer';
                                        $icon = $answer['is_correct'] ? '<i class="bi bi-check-circle-fill feedback-icon correct"></i>' : '<i class="bi bi-x-circle-fill feedback-icon wrong"></i>';
                                    }
                                    // Highlight correct answer if user was wrong, but not if they already got it right
                                    if ($opt_key == $answer['correct_answer'] && !$answer['is_correct']) {
                                        $class .= ' correct-answer'; 
                                    }
                                ?>
                                    <li class="option-item <?php echo $class; ?>">
                                        <span class="option-label"><?php echo htmlspecialchars($opt_key); ?>. <?php echo htmlspecialchars($opt_value); ?></span>
                                        <?php echo $icon; ?>
                                        <?php if ($opt_key == $answer['correct_answer'] && $opt_key != $answer['selected_option']): ?>
                                            <span class="badge bg-success ms-2">
                                                <i class="bi bi-check me-1"></i>Jawaban Benar
                                            </span>
                                        <?php endif; ?>
                                    </li>
                                <?php endforeach; ?>
                            </ul>
                            <div class="mt-4 p-3 rounded" style="background: var(--soft-ui-gray-100);">
                                <div class="row">
                                    <div class="col-md-6">
                                        <p class="mb-2">
                                            <i class="bi bi-person-check me-2"></i>Jawaban Anda: 
                                            <strong class="<?php echo $answer['is_correct'] ? 'text-success' : 'text-danger'; ?>">
                                                <?php echo htmlspecialchars($answer['selected_option']); ?>
                                            </strong>
                                        </p>
                                    </div>
                                    <div class="col-md-6">
                                        <p class="mb-2">
                                            <i class="bi bi-check-circle me-2"></i>Jawaban Benar: 
                                            <strong class="text-success"><?php echo htmlspecialchars($answer['correct_answer']); ?></strong>
                                        </p>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                <?php endforeach; ?>
            <?php endif; ?>
        </div>
    </div>

    <footer class="text-center">
        <div class="container">
            <p class="mb-0"><i class="bi bi-c-circle me-2"></i><?php echo date('Y'); ?> E-Learning System by PIM</p>
        </div>
    </footer>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
    <script>
        document.addEventListener('DOMContentLoaded', function() {
            const sidebarToggle = document.getElementById('sidebarToggle');
            const sidebar = document.getElementById('sidebar');
            const sidebarOverlay = document.getElementById('sidebarOverlay');
            const trainingDropdownToggle = document.getElementById('trainingDropdown');
            const postTestDropdownToggle = document.getElementById('postTestDropdown');
            
            let isDropdownClick = false;

            function toggleSidebar() {
                sidebar.classList.toggle('sidebar-active');
                sidebarOverlay.style.display = sidebar.classList.contains('sidebar-active') ? 'block' : 'none';
                
                if (sidebar.classList.contains('sidebar-active')) {
                    document.body.style.overflow = 'hidden';
                } else {
                    document.body.style.overflow = '';
                }
            }

            sidebarToggle.addEventListener('click', function(e) {
                e.stopPropagation();
                toggleSidebar();
            });

            sidebarOverlay.addEventListener('click', function() {
                if (!isDropdownClick) {
                    toggleSidebar();
                }
                isDropdownClick = false;
            });

            if (trainingDropdownToggle) {
                trainingDropdownToggle.addEventListener('click', function(e) {
                    if (window.innerWidth <= 768) {
                        isDropdownClick = true;
                    }
                });
            }

            if (postTestDropdownToggle) {
                postTestDropdownToggle.addEventListener('click', function(e) {
                    if (window.innerWidth <= 768) {
                        isDropdownClick = true;
                    }
                });
            }
            
            document.addEventListener('click', function(e) {
                if (window.innerWidth <= 768) {
                    let clickedInsideAnyDropdown = false;
                    if (trainingDropdownToggle && trainingDropdownToggle.contains(e.target)) {
                        clickedInsideAnyDropdown = true;
                    }
                    if (postTestDropdownToggle && postTestDropdownToggle.contains(e.target)) {
                        clickedInsideAnyDropdown = true;
                    }
                    if (!clickedInsideAnyDropdown) {
                        isDropdownClick = false;
                    }
                }
            });

            const regularNavLinks = document.querySelectorAll('.sidebar .nav-link:not(.dropdown-toggle)');
            regularNavLinks.forEach(link => {
                link.addEventListener('click', function() {
                    if (window.innerWidth <= 768 && sidebar.classList.contains('sidebar-active')) {
                        toggleSidebar();
                    }
                });
            });

            const dropdownItems = document.querySelectorAll('.sidebar .dropdown-menu .dropdown-item');
            dropdownItems.forEach(item => {
                item.addEventListener('click', function() {
                    if (window.innerWidth <= 768 && sidebar.classList.contains('sidebar-active')) {
                        toggleSidebar();
                    }
                });
            });

            window.addEventListener('resize', function() {
                if (window.innerWidth > 768) {
                    sidebar.classList.remove('sidebar-active');
                    sidebarOverlay.style.display = 'none';
                    document.body.style.overflow = '';
                    isDropdownClick = false;
                }
            });
        });
    </script>
</body>
</html>