<?php
require_once 'koneksi.php';

// Cek login
checkLogin();

date_default_timezone_set('Asia/Jakarta');

$user_id = $_SESSION['user_id'];
$role = $_SESSION['role'];
$nik_karyawan = $_SESSION['nik_karyawan'];

// Pastikan user adalah trainer
if ($role !== 'trainer') {
    header("Location: list_training.php?error=Anda tidak memiliki izin untuk mengakses halaman ini");
    exit();
}

// Ambil informasi trainer berdasarkan nik_karyawan
$stmt = $koneksi->prepare("SELECT nama_lengkap, foto_profil, jabatan, divisi FROM trainers WHERE nik_karyawan = ?");
$stmt->bind_param("s", $nik_karyawan);
$stmt->execute();
$result = $stmt->get_result();
$trainer = $result->fetch_assoc();
$stmt->close();

if (!$trainer) {
    header("Location: list_training.php?error=Data trainer tidak ditemukan");
    exit();
}
$nama_user = $trainer['nama_lengkap'];
$foto_profil = $trainer['foto_profil'];
$jabatan = $trainer['jabatan'] ?? 'Tidak ada jabatan';
$divisi = $trainer['divisi'] ?? 'Tidak ada divisi';

// Cek apakah training_id disediakan
if (!isset($_GET['training_id']) || !is_numeric($_GET['training_id'])) {
    header("Location: list_training.php?error=Training ID tidak valid");
    exit();
}

$training_id = (int)$_GET['training_id'];

// Verifikasi bahwa trainer memiliki akses ke training ini
$stmt = $koneksi->prepare("SELECT judul, nama_trainer, training_date, start_time, end_time FROM trainings WHERE id = ?");
$stmt->bind_param("i", $training_id);
$stmt->execute();
$result = $stmt->get_result();
if ($result->num_rows == 0) {
    header("Location: list_training.php?error=Training tidak ditemukan");
    exit();
}
$training = $result->fetch_assoc();
if ($training['nama_trainer'] !== $nama_user) {
    header("Location: list_training.php?error=Anda tidak memiliki izin untuk melihat peserta training ini");
    exit();
}
$training_title = $training['judul'];

// Format tanggal, hari, dan jam
setlocale(LC_TIME, 'id_ID');
$training_date = $training['training_date'] && $training['training_date'] != '0000-00-00' 
    ? new DateTime($training['training_date'])
    : null;
$formatted_date = $training_date ? $training_date->format('d F Y') : 'Tanggal tidak valid';
$day_name = $training_date ? ['Minggu', 'Senin', 'Selasa', 'Rabu', 'Kamis', 'Jumat', 'Sabtu'][$training_date->format('w')] : '-';
$start_time = date('H:i', strtotime($training['start_time']));
$end_time = date('H:i', strtotime($training['end_time']));
$stmt->close();

// ✅ UPDATED: Ambil daftar peserta (peserta + ISS) menggunakan prepared statement
$stmt = $koneksi->prepare("
    SELECT 
        tp.id,
        tp.training_id,
        tp.user_id,
        tp.user_type,
        tp.join_time,
        CASE 
            WHEN tp.user_type = 'peserta' THEN p.nama_lengkap
            WHEN tp.user_type = 'iss' THEN i.nama_lengkap
        END as nama_lengkap,
        CASE 
            WHEN tp.user_type = 'peserta' THEN p.nik_karyawan
            WHEN tp.user_type = 'iss' THEN i.nik_karyawan
        END as nik_karyawan,
        CASE 
            WHEN tp.user_type = 'peserta' THEN p.divisi
            WHEN tp.user_type = 'iss' THEN i.divisi
        END as divisi,
        CASE 
            WHEN tp.user_type = 'peserta' THEN p.jabatan
            WHEN tp.user_type = 'iss' THEN i.jabatan
        END as jabatan,
        tp.user_type as tipe_user
    FROM training_participants tp
    LEFT JOIN peserta p ON tp.user_id = p.id AND tp.user_type = 'peserta'
    LEFT JOIN iss i ON tp.user_id = i.id AND tp.user_type = 'iss'
    WHERE tp.training_id = ?
    ORDER BY tp.join_time ASC, nama_lengkap ASC
");
$stmt->bind_param("i", $training_id);
$stmt->execute();
$participants_result = $stmt->get_result();
$stmt->close();

// Proses export to PDF
if (isset($_GET['export']) && $_GET['export'] == 'pdf') {
    require_once 'tcpdf/tcpdf.php';
    
    // Buat instance TCPDF
    $pdf = new TCPDF(PDF_PAGE_ORIENTATION, PDF_UNIT, PDF_PAGE_FORMAT, true, 'UTF-8', false);
    
    // Set metadata
    $pdf->SetCreator(PDF_CREATOR);
    $pdf->SetAuthor($nama_user);
    $pdf->SetTitle('Daftar Peserta Training - ' . $training_title);
    $pdf->SetSubject('Daftar Peserta');
    
    // Set header dan footer
    $pdf->SetHeaderData('', 0, 'E-Learning System Pondok Indah Mall', 'Daftar Peserta Training', ['0', '0', '0'], ['255', '255', '255']);
    $pdf->setHeaderFont(['helvetica', '', 12]);
    $pdf->setFooterFont(['helvetica', '', 10]);
    
    // Set margin
    $pdf->SetMargins(15, 20, 15);
    $pdf->SetHeaderMargin(5);
    $pdf->SetFooterMargin(10);
    
    // Set font
    $pdf->SetFont('helvetica', '', 12);
    
    // Tambah halaman
    $pdf->AddPage();
    
    // Konten PDF
    $html = '
    <h2 style="text-align: center;">' . htmlspecialchars($training_title) . '</h2>
    <p style="text-align: center; margin-bottom: 5pt;">' . htmlspecialchars($day_name . ', ' . $formatted_date) . '<br>Pukul ' . htmlspecialchars($start_time . ' - ' . $end_time) . '</p>';
    
    if ($participants_result->num_rows > 0) {
        $html .= '
        <table border="1" cellpadding="4" style="margin: auto;">
            <thead>
                <tr style="background-color: #f0f0f0;">
                    <th width="5%"><b>No</b></th>
                    <th width="20%"><b>Nama Peserta</b></th>
                    <th width="15%"><b>NIK Karyawan</b></th>
                    <th width="18%"><b>Divisi</b></th>
                    <th width="15%"><b>Jabatan</b></th>
                    <th width="12%"><b>Tipe Karyawan</b></th>
                    <th width="15%"><b>Waktu Bergabung</b></th>
                </tr>
            </thead>
            <tbody>';
        
        $no = 1;
        $participants_result->data_seek(0);
        while ($row = $participants_result->fetch_assoc()) {
            $join_time = $row['join_time'] ? date('d-m-Y H:i', strtotime($row['join_time'])) : '-';
            $tipe_badge = $row['tipe_user'] == 'iss' ? 'ISS' : 'Peserta';
            $html .= '
            <tr>
                <td width="5%">' . $no++ . '</td>
                <td width="20%">' . htmlspecialchars($row['nama_lengkap']) . '</td>
                <td width="15%">' . htmlspecialchars($row['nik_karyawan']) . '</td>
                <td width="18%">' . htmlspecialchars($row['divisi']) . '</td>
                <td width="15%">' . htmlspecialchars($row['jabatan'] ?? '-') . '</td>
                <td width="12%">' . htmlspecialchars($tipe_badge) . '</td>
                <td width="15%">' . htmlspecialchars($join_time) . '</td>
            </tr>';
        }
        
        $html .= '
            </tbody>
        </table>';
    } else {
        $html .= '<p>Tidak ada peserta yang bergabung dengan training ini.</p>';
    }
    
    // Add this right before the existing footer content
    $html .= '<br><br><p style="text-align: center; font-style: italic; color: #666; font-size: 10pt;">This document is generated and authorized by system*</p>';

    // Tulis konten ke PDF
    $pdf->writeHTML($html, true, false, true, false, '');
    
    // Output PDF
    $pdf_filename = 'Peserta_' . preg_replace('/[^a-zA-Z0-9_-]/', '_', $training_title) . '_' . ($training_date ? $training_date->format('Y-m-d') : 'unknown') . '.pdf';
    $pdf->Output($pdf_filename, 'D');
    exit();
}

$error = isset($_GET['error']) ? $_GET['error'] : '';
// Set current page untuk highlight menu
$current_page = basename($_SERVER['PHP_SELF']);
?>
<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Daftar Peserta Training - E-Learning</title>
    <link rel="icon" type="image/png" href="image/icon.png">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.10.0/font/bootstrap-icons.css">
    <style>
        :root {
            --soft-ui-primary-start: #00C4CC; /* Teal */
            --soft-ui-primary-end: #CB0C9F; /* Purple */
            --soft-ui-secondary: #67748E; /* Secondary color */
            --soft-ui-info: #17C1E8; /* Info color */
            --soft-ui-success: #82D616; /* Success color */
            --soft-ui-warning: #FB8C00; /* Warning color */
            --soft-ui-danger: #EA0606; /* Danger color */
            --soft-ui-light: #E9ECEF; /* Light color */
            --soft-ui-dark: #344767; /* Dark color */
            --soft-ui-white: #FFFFFF;
            --soft-ui-gray-100: #F8F9FA;
            --soft-ui-gray-200: #E9ECEF;
            --soft-ui-gray-300: #DEE2E6;
            --soft-ui-gray-400: #CED4DA;
            --soft-ui-gray-500: #ADB5BD;
            --soft-ui-gray-600: #6C757D;
            --soft-ui-gray-700: #495057;
            --soft-ui-gray-800: #343A40;
            --soft-ui-gray-900: #212529;
        }

        html, body {
            height: 100%;
            margin: 0;
            font-family: 'Open Sans', sans-serif;
            background-color: var(--soft-ui-gray-100);
        }
        
        body {
            overflow-x: hidden;
            display: flex;
            flex-direction: column;
        }
        
        .navbar-top {
            position: fixed;
            top: 0;
            width: 100%;
            z-index: 1100;
            background: var(--soft-ui-white);
            border-bottom: 1px solid var(--soft-ui-gray-200);
            box-shadow: 0 2px 12px rgba(0, 0, 0, 0.05);
            padding: 0.75rem 1.5rem;
        }
        
        .navbar-top .container-fluid {
            display: flex;
            align-items: center;
            justify-content: space-between;
            flex-wrap: nowrap;
            position: relative;
        }
        
        .navbar-logo {
            height: 40px;
            width: auto;
            margin-right: 15px;
        }
        
        .navbar-title {
            position: absolute;
            left: 50%;
            transform: translateX(-50%);
            font-size: 1.3rem;
            color: var(--soft-ui-dark);
            font-weight: 700;
            text-align: center;
            white-space: nowrap;
            pointer-events: none;
        }

        .navbar-title-mobile {
            display: none;
            font-size: 0.85rem;
            color: var(--soft-ui-dark);
            font-weight: 700;
            text-align: center;
            line-height: 1.2;
            flex: 1;
            margin: 0 10px;
        }

        .navbar-title-mobile .line1 {
            display: block;
        }

        .navbar-title-mobile .line2 {
            display: block;
            font-size: 0.8rem;
        }
        
        .navbar-brand {
            font-size: 1.2rem;
            color: var(--soft-ui-dark);
            font-weight: 700;
            display: flex;
            align-items: center;
            z-index: 1;
        }

        .navbar-nav .nav-item .nav-link {
            color: var(--soft-ui-secondary);
            font-weight: 600;
            padding: 0.5rem 1rem;
            transition: all 0.2s ease-in-out;
        }

        .navbar-nav .nav-item .nav-link:hover {
            color: var(--soft-ui-primary-end);
        }

        .navbar-nav .nav-item .nav-link.active {
            color: var(--soft-ui-primary-end);
        }

        .navbar-nav .dropdown-menu {
            position: absolute;
            top: 100%;
            right: 0;
            left: auto;
            z-index: 1300;
            background-color: var(--soft-ui-white);
            border: 1px solid var(--soft-ui-gray-200);
            border-radius: 0.5rem;
            box-shadow: 0 4px 12px rgba(0, 0, 0, 0.15);
            min-width: 160px;
            margin-top: 0.125rem;
        }

        .navbar-nav .dropdown-item {
            color: var(--soft-ui-secondary);
            padding: 0.5rem 1rem;
            font-weight: 500;
            transition: all 0.2s ease-in-out;
        }

        .navbar-nav .dropdown-item:hover {
            background-color: var(--soft-ui-gray-200);
            color: var(--soft-ui-dark);
        }

        .navbar-nav .dropdown-item.active {
            background-color: var(--soft-ui-primary-end);
            color: var(--soft-ui-white);
        }
        
        .sidebar {
            min-height: 100vh;
            width: 250px;
            position: fixed;
            top: 0;
            left: 0;
            z-index: 1000;
            background: var(--soft-ui-white);
            color: var(--soft-ui-dark);
            padding-top: 70px;
            transition: all 0.3s ease-in-out;
            border-right: 1px solid var(--soft-ui-gray-200);
            box-shadow: 4px 0 15px rgba(0, 0, 0, 0.05);
            border-radius: 0 1rem 1rem 0;
        }

        .content {
            margin-left: 250px;
            margin-top: 0;
            padding: 20px;
            padding-top: 90px;
            transition: all 0.3s ease-in-out;
            flex-grow: 1;
        }
        
        .hamburger-mobile {
            display: none;
            background: none;
            border: none;
            color: var(--soft-ui-dark);
            font-size: 1.5rem;
            cursor: pointer;
            margin-right: 15px;
            transition: all 0.3s ease;
            z-index: 1;
        }
        
        .hamburger-mobile:focus {
            outline: none;
        }
        
        .sidebar-overlay {
            display: none;
            position: fixed;
            top: 0;
            left: 0;
            right: 0;
            bottom: 0;
            background-color: rgba(0, 0, 0, 0.4);
            z-index: 999;
        }
        
        .profile-section {
            text-align: center;
            padding: 15px 20px;
            border-bottom: 1px solid var(--soft-ui-gray-200);
            background: var(--soft-ui-white);
            border-radius: 0.75rem;
            box-shadow: 0 4px 15px rgba(0, 0, 0, 0.05);
        }
        
        .profile-photo {
            width: 80px;
            height: 80px;
            border-radius: 50%;
            object-fit: cover;
            border: 2px solid var(--soft-ui-gray-300);
            margin: 0 auto 10px;
            display: block;
            box-shadow: 0 4px 10px rgba(0, 0, 0, 0.08);
        }
        
        .profile-photo-placeholder {
            width: 80px;
            height: 80px;
            border-radius: 50%;
            background: var(--soft-ui-gray-400);
            display: flex;
            align-items: center;
            justify-content: center;
            margin: 0 auto 10px;
            border: 2px solid var(--soft-ui-gray-300);
            box-shadow: 0 4px 10px rgba(0, 0, 0, 0.08);
        }
        
        .profile-photo-placeholder i {
            font-size: 2rem;
            color: var(--soft-ui-white);
        }
        
        .profile-name {
            font-size: 1.1rem;
            font-weight: 600;
            color: var(--soft-ui-dark);
            margin-bottom: 5px;
            word-wrap: break-word;
        }
        
        .profile-info {
            font-size: 0.9rem;
            font-weight: 400;
            color: var(--soft-ui-secondary);
            margin-bottom: 3px;
        }
        
        .table-card {
            background-color: var(--soft-ui-white);
            border-radius: 0.75rem;
            box-shadow: 0 4px 12px rgba(0, 0, 0, 0.05);
            transition: all 0.2s ease-in-out;
            position: relative;
            margin-bottom: 1rem;
        }

        .table-card:hover {
            transform: translateY(-3px);
            box-shadow: 0 6px 16px rgba(0, 0, 0, 0.08);
        }

        .table-header {
            background: var(--soft-ui-white);
            color: var(--soft-ui-dark);
            font-size: 1.25rem;
            font-weight: 700;
            text-align: left;
            padding: 1.5rem;
            border-bottom: 1px solid var(--soft-ui-gray-200);
            border-top-left-radius: 0.75rem;
            border-top-right-radius: 0.75rem;
        }
        
        .table-body {
            padding: 20px;
        }
        
        .table {
            border-collapse: separate;
            border-spacing: 0;
            border-radius: 8px;
            overflow: hidden;
        }
        
        .table th, .table td {
            padding: 12px 15px;
            vertical-align: middle;
            border: none;
        }
        
        .table thead th {
            background: linear-gradient(135deg, var(--soft-ui-gray-200), var(--soft-ui-gray-300));
            color: var(--soft-ui-dark);
            font-weight: 600;
            text-transform: uppercase;
            font-size: 0.9rem;
        }
        
        .table tbody tr {
            transition: background 0.3s ease;
        }
        
        .table-striped tbody tr:nth-of-type(odd) {
            background: rgba(0, 0, 0, 0.02);
        }
        
        .table-hover tbody tr:hover {
            background: linear-gradient(195deg, rgba(0, 196, 204, 0.05), rgba(203, 12, 159, 0.05));
        }
        
        .btn-primary {
            background: linear-gradient(195deg, var(--soft-ui-primary-start), var(--soft-ui-primary-end));
            border: none;
            border-radius: 0.75rem;
            padding: 1rem 2.5rem;
            font-size: 1.1rem;
            font-weight: 700;
            color: var(--soft-ui-white);
            text-decoration: none;
            display: inline-flex;
            align-items: center;
            transition: all 0.3s ease;
            box-shadow: 0 8px 25px rgba(0, 196, 204, 0.3);
            text-transform: uppercase;
            letter-spacing: 1px;
            position: relative;
            overflow: hidden;
        }

        .btn-primary::before {
            content: '';
            position: absolute;
            top: 0;
            left: -100%;
            width: 100%;
            height: 100%;
            background: linear-gradient(90deg, transparent, rgba(255, 255, 255, 0.2), transparent);
            transition: left 0.5s;
        }

        .btn-primary:hover::before {
            left: 100%;
        }
        
        .btn-primary:hover {
            background: linear-gradient(195deg, var(--soft-ui-primary-end), var(--soft-ui-primary-start));
            transform: translateY(-5px);
            box-shadow: 0 12px 35px rgba(203, 12, 159, 0.4);
            color: var(--soft-ui-white);
        }
        
        .btn-primary i {
            margin-right: 12px;
            font-size: 1.3rem;
        }
        
        .btn-danger {
            background: linear-gradient(195deg, var(--soft-ui-danger), #dc3545);
            border: none;
            border-radius: 0.75rem;
            padding: 1rem 2.5rem;
            font-size: 1.1rem;
            font-weight: 700;
            color: var(--soft-ui-white);
            text-decoration: none;
            display: inline-flex;
            align-items: center;
            transition: all 0.3s ease;
            box-shadow: 0 8px 25px rgba(0, 196, 204, 0.3);
            text-transform: uppercase;
            letter-spacing: 1px;
            position: relative;
            overflow: hidden;
        }

        .btn-danger::before {
            content: '';
            position: absolute;
            top: 0;
            left: -100%;
            width: 100%;
            height: 100%;
            background: linear-gradient(90deg, transparent, rgba(255, 255, 255, 0.2), transparent);
            transition: left 0.5s;
        }

        .btn-danger:hover::before {
            left: 100%;
        }
        
        .btn-danger:hover {
            background: linear-gradient(195deg, #c82333, var(--soft-ui-danger));
            transform: translateY(-5px);
            box-shadow: 0 12px 35px rgba(203, 12, 159, 0.4);
            color: var(--soft-ui-white);
        }
        
        .btn-danger i {
            margin-right: 12px;
            font-size: 1.3rem;
        }
        
        .alert {
            border-radius: 8px;
            padding: 1rem;
        }
        
        .page-title {
            font-size: 2.8rem;
            font-weight: 700;
            color: var(--soft-ui-dark);
            margin-bottom: 20px;
            background: linear-gradient(195deg, var(--soft-ui-primary-start), var(--soft-ui-primary-end));
            -webkit-background-clip: text;
            -webkit-text-fill-color: transparent;
            background-clip: text;
            line-height: 1.2;
        }
        
        .training-info {
            font-size: 1.2rem;
            color: var(--soft-ui-secondary);
            margin-bottom: 30px;
            font-weight: 500;
            line-height: 1.6;
            text-align: center;
            background: linear-gradient(195deg, var(--soft-ui-primary-start), var(--soft-ui-primary-end));
            -webkit-background-clip: text;
            -webkit-text-fill-color: transparent;
            background-clip: text;
        }
        
        footer {
            background: var(--soft-ui-white);
            color: var(--soft-ui-secondary);
            border-top: 1px solid var(--soft-ui-gray-200);
            padding: 1rem 0;
            text-align: center;
            flex-shrink: 0;
            margin-top: 2rem;
        }
        
        .animate-fade-in {
            animation: fadeIn 0.5s ease-in-out;
        }
        
        @keyframes fadeIn {
            from { opacity: 0; transform: translateY(10px); }
            to { opacity: 1; transform: translateY(0); }
        }

        /* Badge styles for user types */
        .badge-peserta {
            background: linear-gradient(135deg, var(--soft-ui-success), #20c997);
            color: var(--soft-ui-white);
            font-size: 0.75rem;
            padding: 0.25rem 0.5rem;
            border-radius: 12px;
        }
        
        .badge-iss {
            background: linear-gradient(135deg, #6f42c1, var(--soft-ui-primary-end));
            color: var(--soft-ui-white);
            font-size: 0.75rem;
            padding: 0.25rem 0.5rem;
            border-radius: 12px;
        }
        
        @media (max-width: 768px) {
            .sidebar {
                margin-left: -250px;
                border-radius: 0;
                padding-top: 90px;
            }
            .sidebar-active {
                margin-left: 0;
            }
            .content {
                margin-left: 0;
                padding-top: 100px;
            }
            
            .navbar-title {
                display: none;
            }
            .navbar-logo {
                display: none;
            }
            
            .navbar-title-mobile {
                display: block;
            }
            
            .hamburger-mobile {
                display: block;
            }
            .navbar-search {
                display: none;
            }
            .navbar-nav {
                position: static;
            }
            .navbar-nav .dropdown-menu {
                position: absolute;
                right: 0;
                left: auto;
                z-index: 1300;
            }
            .table-card {
                margin-bottom: 1rem;
            }
            .chart-container {
                height: 250px;
            }

            .page-title {
                font-size: 2rem;
            }
            .training-info {
                font-size: 1rem;
            }
            .btn-primary, .btn-danger {
                padding: 0.8rem 2rem;
                font-size: 1rem;
            }

            .profile-photo, .profile-photo-placeholder {
                width: 60px;
                height: 60px;
            }
            .profile-photo-placeholder i {
                font-size: 1.5rem;
            }
            .profile-name {
                font-size: 1rem;
            }
            .profile-info {
                font-size: 0.8rem;
            }
        }

        @media (max-width: 576px) {
            .navbar-top {
                padding: 0.5rem 1rem;
                min-height: 70px;
            }
            .navbar-title-mobile {
                font-size: 0.8rem;
            }
            .navbar-title-mobile .line2 {
                font-size: 0.75rem;
            }
            .page-title {
                font-size: 1.7rem;
            }
            .training-info {
                font-size: 0.9rem;
            }
            .btn-primary, .btn-danger {
                padding: 0.7rem 1.5rem;
                font-size: 0.9rem;
            }

            .profile-photo, .profile-photo-placeholder {
                width: 50px;
                height: 50px;
            }
            .profile-photo-placeholder i {
                font-size: 1.2rem;
            }
            .profile-name {
                font-size: 0.9rem;
            }
            .profile-info {
                font-size: 0.7rem;
            }
        }
        
        .dropdown-menu, .dropdown-menu-end {
            position: absolute;
            z-index: 1000;
            background: var(--soft-ui-white);
            border: 1px solid var(--soft-ui-gray-200);
            border-radius: 0.5rem;
            box-shadow: 0 4px 12px rgba(0, 0, 0, 0.15);
            transform: translateY(10px);
            opacity: 0;
            transition: opacity 0.3s ease, transform 0.3s ease;
        }
        
        .dropdown-menu.show, .dropdown-menu-end.show {
            transform: translateY(0);
            opacity: 1;
        }
        
        .dropdown-item {
            color: var(--soft-ui-secondary);
            padding: 0.5rem 1rem;
            font-weight: 500;
            transition: all 0.2s ease-in-out;
        }
        
        .dropdown-item:hover {
            background-color: var(--soft-ui-gray-200);
            color: var(--soft-ui-dark);
        }
        
        .dropdown-item.active {
            background-color: var(--soft-ui-primary-end);
            color: var(--soft-ui-white);
        }

        .sidebar .nav-link {
            color: var(--soft-ui-secondary);
            padding: 0.75rem 1rem;
            border-radius: 0.5rem;
            margin: 0.25rem 0.75rem;
            transition: all 0.2s ease-in-out;
            font-weight: 600;
            display: flex;
            align-items: center;
        }
        
        .sidebar .nav-link:hover {
            background: linear-gradient(90deg, rgba(0, 196, 204, 0.1), rgba(203, 12, 159, 0.1));
            color: var(--soft-ui-dark);
        }
        
        .sidebar .nav-link.active {
            background: linear-gradient(195deg, var(--soft-ui-primary-start), var(--soft-ui-primary-end));
            color: var(--soft-ui-white) !important;
            box-shadow: 0 4px 12px rgba(0, 0, 0, 0.1);
        }

        .sidebar .nav-link.active i {
            color: var(--soft-ui-white);
        }
        
        .sidebar .nav-link i {
            font-size: 1.2rem;
            margin-right: 10px;
            color: var(--soft-ui-secondary);
            transition: all 0.2s ease-in-out;
        }

        .sidebar .nav-item.dropdown .dropdown-menu {
            background-color: var(--soft-ui-white);
            border: none;
            box-shadow: 0 4px 12px rgba(0, 0, 0, 0.08);
            border-radius: 0.5rem;
            padding: 0.5rem 0;
            margin-top: 0.25rem;
        }

        .sidebar .nav-item.dropdown .dropdown-item {
            color: var(--soft-ui-secondary);
            padding: 0.5rem 1.5rem;
            font-weight: 500;
            transition: all 0.2s ease-in-out;
        }

        .sidebar .nav-item.dropdown .dropdown-item:hover {
            background: linear-gradient(90deg, rgba(0, 196, 204, 0.1), rgba(203, 12, 159, 0.1));
            color: var(--soft-ui-dark);
        }

        .sidebar .nav-item.dropdown .dropdown-item.active {
            background: linear-gradient(195deg, var(--soft-ui-primary-start), var(--soft-ui-primary-end));
            color: var(--soft-ui-white);
        }

        .sidebar .nav-item:not(:last-child) {
            border-bottom: none;
        }
    </style>
</head>
<body>
    <nav class="navbar navbar-expand-lg navbar-top">
        <div class="container-fluid">
            <button class="hamburger-mobile d-md-none" type="button" id="sidebarToggle">
                <i class="bi bi-list"></i>
            </button>
            <a class="navbar-brand d-none d-md-flex" href="#">
                <img src="image/logopim.png" alt="Logo PIM" class="navbar-logo">
            </a>
            <div class="navbar-title d-none d-md-block">
                E-Learning System Pondok Indah Mall
            </div>
            <div class="navbar-title-mobile d-md-none">
                <span class="line1">E-Learning System</span>
                <span class="line2">Pondok Indah Mall</span>
            </div>
            <ul class="navbar-nav ms-auto mb-2 mb-lg-0">
                <li class="nav-item dropdown">
                    <a class="nav-link dropdown-toggle text-dark" href="#" id="navbarDropdown" role="button" data-bs-toggle="dropdown" aria-expanded="false">
                        <i class="bi bi-person-circle"></i>
                    </a>
                    <ul class="dropdown-menu dropdown-menu-end">
                        <li><a class="dropdown-item <?php echo ($current_page == 'profile.php') ? 'active' : ''; ?>" href="profile.php">Profile</a></li>
                        <li><a class="dropdown-item <?php echo ($current_page == 'change_password.php') ? 'active' : ''; ?>" href="change_password.php">Change Password</a></li>
                        <li><hr class="dropdown-divider"></li>
                        <li><a class="dropdown-item" href="logout.php">Logout</a></li>
                    </ul>
                </li>
            </ul>
        </div>
    </nav>

    <div class="sidebar-overlay" id="sidebarOverlay"></div>

    <div class="sidebar border-end" id="sidebar">
        <div class="profile-section">
            <?php if (!empty($foto_profil)): ?>
                <img src="Uploads/profiles/<?php echo htmlspecialchars($foto_profil); ?>" alt="Foto Profil" class="profile-photo">
            <?php else: ?>
                <div class="profile-photo-placeholder">
                    <i class="bi bi-person-circle"></i>
                </div>
            <?php endif; ?>
            <div class="profile-name"><?php echo htmlspecialchars($nama_user); ?></div>
            <div class="profile-info"><?php echo htmlspecialchars($jabatan); ?></div>
            <div class="profile-info"><?php echo htmlspecialchars($divisi); ?></div>
        </div>
        <div class="p-3">
            <h5 class="mb-4 text-dark">Menu</h5>
            <ul class="nav flex-column">
                <li class="nav-item">
                    <a class="nav-link <?php echo ($current_page == 'dashboard.php') ? 'active' : ''; ?>" href="dashboard.php">
                        <i class="bi bi-house-door-fill"></i> Dashboard
                    </a>
                </li>
                <li class="nav-item">
                    <a class="nav-link <?php echo ($current_page == 'materi.php') ? 'active' : ''; ?>" href="materi.php">
                        <i class="bi bi-book"></i> Materi
                    </a>
                </li>
                <!-- Post Test Menu -->
                <?php if ($role == 'trainer'): ?>
                    <li class="nav-item dropdown">
                        <a class="nav-link dropdown-toggle <?php echo ($current_page == 'add_posttest.php' || $current_page == 'list_posttest.php' || $current_page == 'view_posttest_scores.php') ? 'active' : ''; ?>" href="#" id="postTestDropdown" role="button" data-bs-toggle="dropdown" aria-expanded="false">
                            <i class="bi bi-clipboard-check"></i> Post Test
                        </a>
                        <ul class="dropdown-menu" aria-labelledby="postTestDropdown">
                            <li><a class="dropdown-item <?php echo ($current_page == 'add_posttest.php') ? 'active' : ''; ?>" href="add_posttest.php">Tambah Post Test</a></li>
                            <li><a class="dropdown-item <?php echo ($current_page == 'list_posttest.php' || $current_page == 'view_posttest_scores.php') ? 'active' : ''; ?>" href="list_posttest.php">List Post Test</a></li>
                        </ul>
                    </li>
                <?php elseif ($role == 'peserta' || $role == 'iss'): ?>
                    <li class="nav-item">
                        <a class="nav-link <?php echo ($current_page == 'list_posttest.php' || $current_page == 'take_posttest.php' || $current_page == 'post_test_result.php') ? 'active' : ''; ?>" href="list_posttest.php">
                            <i class="bi bi-clipboard-check"></i> Post Test
                        </a>
                    </li>
                <?php endif; ?>
                <!-- End Post Test Menu -->
                <li class="nav-item dropdown">
                    <a class="nav-link dropdown-toggle <?php echo ($current_page == 'add_training.php' || $current_page == 'list_training.php') ? 'active' : ''; ?>" 
                       href="#" id="trainingDropdown" role="button" data-bs-toggle="dropdown" aria-expanded="false">
                        <i class="bi bi-journal-text"></i> Training
                    </a>
                    <ul class="dropdown-menu" aria-labelledby="trainingDropdown">
                        <li><a class="dropdown-item <?php echo ($current_page == 'add_training.php') ? 'active' : ''; ?>" href="add_training.php">Tambah Kegiatan Training</a></li>
                        <li><a class="dropdown-item <?php echo ($current_page == 'list_training.php') ? 'active' : ''; ?>" href="list_training.php">List Training</a></li>
                    </ul>
                </li>
                
                <!-- Tambahkan menu Report dan Data Evaluasi untuk Trainer -->
                <?php if ($_SESSION['role'] == 'trainer'): ?>
                    <li class="nav-item">
                        <a class="nav-link <?php echo ($current_page == 'report.php') ? 'active' : ''; ?>" href="report.php">
                            <i class="bi bi-file-earmark-text"></i> Report
                        </a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link <?php echo ($current_page == 'data_evaluasi.php') ? 'active' : ''; ?>" href="data_evaluasi.php">
                            <i class="bi bi-clipboard-data"></i> Data Evaluasi
                        </a>
                    </li>
                <?php endif; ?>
            </ul>
        </div>
    </div>

    <div class="content">
        <div class="container-fluid">
            <h2 class="page-title animate-fade-in">Daftar Peserta Training</h2>
            <div class="row">
                <div class="col-md-12">
                    <div class="card table-card animate-fade-in">
                        <div class="table-header">
                            <?php echo htmlspecialchars($training_title); ?>
                        </div>
                        <div class="table-body">
                            <p class="training-info"><?php echo htmlspecialchars($day_name . ', ' . $formatted_date); ?></p>
                            <p class="training-info mb-4">Pukul <?php echo htmlspecialchars($start_time . ' - ' . $end_time); ?></p>
                            
                            <?php if(!empty($error)): ?>
                                <div class="alert alert-danger"><?php echo htmlspecialchars($error); ?></div>
                            <?php endif; ?>
                            
                            <?php if($participants_result->num_rows > 0): ?>
                            <div class="table-responsive">
                                <table class="table table-striped table-hover">
                                    <thead>
                                        <tr>
                                            <th>No</th>
                                            <th>Nama Peserta</th>
                                            <th>NIK Karyawan</th>
                                            <th>Divisi</th>
                                            <th>Jabatan</th>
                                            <th>Tipe Karyawan</th>
                                            <th>Waktu Bergabung</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <?php 
                                        $no = 1;
                                        $participants_result->data_seek(0);
                                        while($row = $participants_result->fetch_assoc()): 
                                        ?>
                                        <tr>
                                            <td><?php echo $no++; ?></td>
                                            <td><?php echo htmlspecialchars($row['nama_lengkap']); ?></td>
                                            <td><?php echo htmlspecialchars($row['nik_karyawan']); ?></td>
                                            <td><?php echo htmlspecialchars($row['divisi']); ?></td>
                                            <td><?php echo htmlspecialchars($row['jabatan'] ?? '-'); ?></td>
                                            <td>
                                                <?php if($row['tipe_user'] == 'iss'): ?>
                                                    <span class="badge badge-iss">
                                                        <i class="bi bi-person"></i> ISS
                                                    </span>
                                                <?php else: ?>
                                                    <span class="badge badge-peserta">
                                                        <i class="bi bi-person"></i> Peserta
                                                    </span>
                                                <?php endif; ?>
                                            </td>
                                            <td><?php echo $row['join_time'] ? date('d-m-Y H:i', strtotime($row['join_time'])) : '-'; ?></td>
                                        </tr>
                                        <?php endwhile; ?>
                                    </tbody>
                                </table>
                            </div>
                            <?php else: ?>
                            <div class="alert alert-info">
                                Belum ada peserta yang bergabung dengan training ini.
                            </div>
                            <?php endif; ?>
                            <div class="d-flex gap-2 justify-content-end">
                                <a href="list_training.php" class="btn btn-primary">
                                    <i class="bi bi-arrow-left me-2"></i> Kembali
                                </a>
                                <a href="?training_id=<?php echo $training_id; ?>&export=pdf" class="btn btn-danger">
                                    <i class="bi bi-file-earmark-pdf me-2"></i> Export PDF
                                </a>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <footer class="text-center">
        <div class="container">
            <p class="mb-0">© <?php echo date('Y'); ?> E-Learning System by PIM</p>
        </div>
    </footer>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
    <script>
        document.addEventListener('DOMContentLoaded', function() {
            const sidebarToggle = document.getElementById('sidebarToggle');
            const sidebar = document.getElementById('sidebar');
            const sidebarOverlay = document.getElementById('sidebarOverlay');
            const trainingDropdownToggle = document.getElementById('trainingDropdown');
            const postTestDropdownToggle = document.getElementById('postTestDropdown');
            
            let isDropdownClick = false;

            function toggleSidebar() {
                sidebar.classList.toggle('sidebar-active');
                sidebarOverlay.style.display = sidebar.classList.contains('sidebar-active') ? 'block' : 'none';
                
                if (sidebar.classList.contains('sidebar-active')) {
                    document.body.style.overflow = 'hidden';
                } else {
                    document.body.style.overflow = '';
                }
            }

            sidebarToggle.addEventListener('click', function(e) {
                e.stopPropagation();
                toggleSidebar();
            });

            sidebarOverlay.addEventListener('click', function() {
                if (!isDropdownClick) {
                    toggleSidebar();
                }
                isDropdownClick = false;
            });

            if (trainingDropdownToggle) {
                trainingDropdownToggle.addEventListener('click', function(e) {
                    if (window.innerWidth <= 768) {
                        isDropdownClick = true;
                    }
                });
            }

            if (postTestDropdownToggle) {
                postTestDropdownToggle.addEventListener('click', function(e) {
                    if (window.innerWidth <= 768) {
                        isDropdownClick = true;
                    }
                });
            }
            
            document.addEventListener('click', function(e) {
                if (window.innerWidth <= 768) {
                    let clickedInsideAnyDropdown = false;
                    if (trainingDropdownToggle && trainingDropdownToggle.contains(e.target)) {
                        clickedInsideAnyDropdown = true;
                    }
                    if (postTestDropdownToggle && postTestDropdownToggle.contains(e.target)) {
                        clickedInsideAnyDropdown = true;
                    }
                    if (!clickedInsideAnyDropdown) {
                        isDropdownClick = false;
                    }
                }
            });

            const regularNavLinks = document.querySelectorAll('.sidebar .nav-link:not(.dropdown-toggle)');
            regularNavLinks.forEach(link => {
                link.addEventListener('click', function() {
                    if (window.innerWidth <= 768 && sidebar.classList.contains('sidebar-active')) {
                        toggleSidebar();
                    }
                });
            });

            const dropdownItems = document.querySelectorAll('.sidebar .dropdown-menu .dropdown-item');
            dropdownItems.forEach(item => {
                item.addEventListener('click', function() {
                    if (window.innerWidth <= 768 && sidebar.classList.contains('sidebar-active')) {
                        toggleSidebar();
                    }
                });
            });

            window.addEventListener('resize', function() {
                if (window.innerWidth > 768) {
                    sidebar.classList.remove('sidebar-active');
                    sidebarOverlay.style.display = 'none';
                    document.body.style.overflow = '';
                    isDropdownClick = false;
                }
            });
        });
    </script>
</body>
</html>