<?php
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

require_once 'koneksi.php';

// Cek login
checkLogin();

date_default_timezone_set('Asia/Jakarta');

$user_id = $_SESSION['user_id'];
$role = $_SESSION['role'];
$nik_karyawan = $_SESSION['nik_karyawan'];

// Ambil informasi user berdasarkan peran
if ($role == 'trainer') {
    $stmt = $koneksi->prepare("SELECT nama_lengkap, jabatan, divisi, foto_profil FROM trainers WHERE id = ?");
    if ($stmt === false) {
        die('Prepare failed for trainer: ' . $koneksi->error);
    }
} elseif ($role == 'iss') {
    $stmt = $koneksi->prepare("SELECT nama_lengkap, jabatan, divisi FROM iss WHERE id = ?");
    if ($stmt === false) {
        die('Prepare failed for ISS: ' . $koneksi->error);
    }
} else { // Peserta
    $stmt = $koneksi->prepare("SELECT nama_lengkap, jabatan, divisi, foto_profil FROM peserta WHERE id = ?");
    if ($stmt === false) {
        die('Prepare failed for peserta: ' . $koneksi->error);
    }
}
$stmt->bind_param("i", $user_id);
$stmt->execute();
$result = $stmt->get_result();
$user = $result->fetch_assoc();
$stmt->close();

// Menyesuaikan penanganan foto_profil untuk ISS
$foto_profil_path = '';
if ($role == 'iss') {
    // ISS tidak memiliki foto_profil, jadi kita set kosong atau placeholder default
    $foto_profil_path = '';
} else {
    $foto_profil_path = $user['foto_profil'] ?? '';
}

$nama_user = $user['nama_lengkap'] ?? 'Unknown';

$current_page = basename($_SERVER['PHP_SELF']);

$trainings_list = []; // Digunakan untuk daftar training yang bisa diambil post testnya
$selected_training_id = $_GET['training_id'] ?? '';
$search_query = $_GET['search'] ?? '';

// Ambil daftar training untuk filter/pilihan post test
// Menambahkan kolom training_date dan mengurutkan berdasarkan training_date DESC
$query_trainings = "SELECT id, judul, training_date FROM trainings";
$params_trainings = [];
$types_trainings = "";
$where_clauses_trainings = [];

if (!empty($search_query)) {
    $where_clauses_trainings[] = "judul LIKE ?";
    $params_trainings[] = "%" . $search_query . "%";
    $types_trainings .= "s";
}

if (!empty($where_clauses_trainings)) {
    $query_trainings .= " WHERE " . implode(" AND ", $where_clauses_trainings);
}
$query_trainings .= " ORDER BY training_date DESC"; // Urutkan dari yang terbaru

$stmt = $koneksi->prepare($query_trainings);
if ($stmt === false) {
    die('Prepare failed for trainings list: ' . $koneksi->error);
}

if (!empty($params_trainings)) {
    $stmt->bind_param($types_trainings, ...$params_trainings);
}

$stmt->execute();
$result = $stmt->get_result();
while ($row = $result->fetch_assoc()) {
    $trainings_list[] = $row;
}
$stmt->close();
?>
<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>List Soal Post Test - E-Learning</title>
    <link rel="icon" type="image/png" href="image/icon.png">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.10.0/font/bootstrap-icons.css">
    <style>
        :root {
            --soft-ui-primary-start: #00C4CC; /* Teal */
            --soft-ui-primary-end: #CB0C9F; /* Purple */
            --soft-ui-secondary: #67748E; /* Kept as secondary color */
            --soft-ui-info: #17C1E8; /* Kept as info color */
            --soft-ui-success: #82D616; /* Kept as success color */
            --soft-ui-warning: #FB8C00; /* Kept as warning color */
            --soft-ui-danger: #EA0606; /* Kept as danger color */
            --soft-ui-light: #E9ECEF; /* Kept as light color */
            --soft-ui-dark: #344767; /* Kept as dark color */
            --soft-ui-white: #FFFFFF;
            --soft-ui-gray-100: #F8F9FA;
            --soft-ui-gray-200: #E9ECEF;
            --soft-ui-gray-300: #DEE2E6;
            --soft-ui-gray-400: #CED4DA;
            --soft-ui-gray-500: #ADB5BD;
            --soft-ui-gray-600: #6C757D;
            --soft-ui-gray-700: #495057;
            --soft-ui-gray-800: #343A40;
            --soft-ui-gray-900: #212529;
        }

        html, body {
            height: 100%;
            margin: 0;
            font-family: 'Open Sans', sans-serif;
            background-color: var(--soft-ui-gray-100);
        }
        
        body {
            overflow-x: hidden;
            display: flex;
            flex-direction: column;
        }
        
        .navbar-top {
            position: fixed;
            top: 0;
            width: 100%;
            z-index: 1100;
            background: var(--soft-ui-white);
            border-bottom: 1px solid var(--soft-ui-gray-200);
            box-shadow: 0 2px 12px rgba(0, 0, 0, 0.05);
            padding: 0.75rem 1.5rem;
        }
        
        .navbar-top .container-fluid {
            display: flex;
            align-items: center;
            justify-content: space-between;
            flex-wrap: nowrap;
            position: relative;
        }
        
        .navbar-logo {
            height: 40px;
            width: auto;
            margin-right: 15px;
        }
        
        .navbar-title {
            position: absolute;
            left: 50%;
            transform: translateX(-50%);
            font-size: 1.3rem;
            color: var(--soft-ui-dark);
            font-weight: 700;
            text-align: center;
            white-space: nowrap;
            pointer-events: none;
        }

        .navbar-title-mobile {
            display: none;
            font-size: 0.85rem;
            color: var(--soft-ui-dark);
            font-weight: 700;
            text-align: center;
            line-height: 1.2;
            flex: 1;
            margin: 0 10px;
        }

        .navbar-title-mobile .line1 {
            display: block;
        }

        .navbar-title-mobile .line2 {
            display: block;
            font-size: 0.8rem;
        }
        
        .navbar-brand {
            font-size: 1.2rem;
            color: var(--soft-ui-dark);
            font-weight: 700;
            display: flex;
            align-items: center;
            z-index: 1;
        }

        .navbar-nav {
            position: relative;
            z-index: 1200;
        }

        .navbar-nav .nav-item .nav-link {
            color: var(--soft-ui-secondary);
            font-weight: 600;
            padding: 0.5rem 1rem;
            transition: all 0.2s ease-in-out;
        }

        .navbar-nav .nav-item .nav-link:hover {
            color: var(--soft-ui-primary-end);
        }

        .navbar-nav .nav-item .nav-link.active {
            color: var(--soft-ui-primary-end);
        }

        .navbar-nav .dropdown-menu {
            position: absolute;
            top: 100%;
            right: 0;
            left: auto;
            z-index: 1300;
            background-color: var(--soft-ui-white);
            border: 1px solid var(--soft-ui-gray-200);
            border-radius: 0.5rem;
            box-shadow: 0 4px 12px rgba(0, 0, 0, 0.15);
            min-width: 160px;
            margin-top: 0.125rem;
        }

        .navbar-nav .dropdown-item {
            color: var(--soft-ui-secondary);
            padding: 0.5rem 1rem;
            font-weight: 500;
            transition: all 0.2s ease-in-out;
        }

        .navbar-nav .dropdown-item:hover {
            background-color: var(--soft-ui-gray-200);
            color: var(--soft-ui-dark);
        }

        .navbar-nav .dropdown-item.active {
            background-color: var(--soft-ui-primary-end);
            color: var(--soft-ui-white);
        }
        
        .sidebar {
            min-height: 100vh;
            width: 250px;
            position: fixed;
            top: 0;
            left: 0;
            z-index: 1000;
            background: var(--soft-ui-white);
            color: var(--soft-ui-dark);
            padding-top: 70px;
            transition: all 0.3s ease-in-out;
            border-right: 1px solid var(--soft-ui-gray-200);
            box-shadow: 4px 0 15px rgba(0, 0, 0, 0.05);
            border-radius: 0 1rem 1rem 0;
        }

        .content {
            margin-left: 250px;
            margin-top: 0;
            padding: 20px;
            padding-top: 90px;
            transition: all 0.3s ease-in-out;
            flex-grow: 1;
        }
        
        .hamburger-mobile {
            display: none;
            background: none;
            border: none;
            color: var(--soft-ui-dark);
            font-size: 1.5rem;
            cursor: pointer;
            margin-right: 15px;
            transition: all 0.3s ease;
            z-index: 1;
        }
        
        .hamburger-mobile:focus {
            outline: none;
        }
        
        .sidebar-overlay {
            display: none;
            position: fixed;
            top: 0;
            left: 0;
            right: 0;
            bottom: 0;
            background-color: rgba(0, 0, 0, 0.4);
            z-index: 999;
        }
        
        .profile-section {
            text-align: center;
            padding: 15px 20px;
            border-bottom: 1px solid var(--soft-ui-gray-200);
            background: var(--soft-ui-white);
            border-radius: 0.75rem;
            box-shadow: 0 4px 15px rgba(0, 0, 0, 0.05);
        }
        
        .profile-photo {
            width: 80px;
            height: 80px;
            border-radius: 50%;
            object-fit: cover;
            border: 2px solid var(--soft-ui-gray-300);
            margin: 0 auto 10px;
            display: block;
            box-shadow: 0 4px 10px rgba(0, 0, 0, 0.08);
        }
        
        .profile-photo-placeholder {
            width: 80px;
            height: 80px;
            border-radius: 50%;
            background: var(--soft-ui-gray-400);
            display: flex;
            align-items: center;
            justify-content: center;
            margin: 0 auto 10px;
            border: 2px solid var(--soft-ui-gray-300);
            box-shadow: 0 4px 10px rgba(0, 0, 0, 0.08);
        }
        
        .profile-photo-placeholder i {
            font-size: 2rem;
            color: var(--soft-ui-white);
        }
        
        .profile-name {
            font-size: 1.1rem;
            font-weight: 600;
            color: var(--soft-ui-dark);
            margin-bottom: 5px;
            word-wrap: break-word;
        }
        
        .profile-info {
            font-size: 0.9rem;
            font-weight: 400;
            color: var(--soft-ui-secondary);
            margin-bottom: 3px;
        }
        
        .sidebar .nav-link {
            color: var(--soft-ui-secondary);
            padding: 0.75rem 1rem;
            border-radius: 0.5rem;
            margin: 0.25rem 0.75rem;
            transition: all 0.2s ease-in-out;
            font-weight: 600;
            display: flex;
            align-items: center;
        }
        
        .sidebar .nav-link:hover {
            background: linear-gradient(90deg, rgba(0, 196, 204, 0.1), rgba(203, 12, 159, 0.1));
            color: var(--soft-ui-dark);
        }
        
        .sidebar .nav-link.active {
            background: linear-gradient(195deg, var(--soft-ui-primary-start), var(--soft-ui-primary-end));
            color: var(--soft-ui-white) !important;
            box-shadow: 0 4px 12px rgba(0, 0, 0, 0.1);
        }

        .sidebar .nav-link.active i {
            color: var(--soft-ui-white);
        }
        
        .sidebar .nav-link i {
            font-size: 1.2rem;
            margin-right: 10px;
            color: var(--soft-ui-secondary);
            transition: all 0.2s ease-in-out;
        }

        .sidebar .nav-item.dropdown .dropdown-menu {
            background-color: var(--soft-ui-white);
            border: none;
            box-shadow: 0 4px 12px rgba(0, 0, 0, 0.08);
            border-radius: 0.5rem;
            padding: 0.5rem 0;
            margin-top: 0.25rem;
        }

        .sidebar .nav-item.dropdown .dropdown-item {
            color: var(--soft-ui-secondary);
            padding: 0.5rem 1.5rem;
            font-weight: 500;
            transition: all 0.2s ease-in-out;
        }

        .sidebar .nav-item.dropdown .dropdown-item:hover {
            background: linear-gradient(90deg, rgba(0, 196, 204, 0.1), rgba(203, 12, 159, 0.1));
            color: var(--soft-ui-dark);
        }

        .sidebar .nav-item.dropdown .dropdown-item.active {
            background: linear-gradient(195deg, var(--soft-ui-primary-start), var(--soft-ui-primary-end));
            color: var(--soft-ui-white);
        }

        .sidebar .nav-item:not(:last-child) {
            border-bottom: none;
        }

        .page-title {
            font-size: 2rem;
            font-weight: 700;
            color: var(--soft-ui-dark);
            margin-bottom: 30px;
            text-align: center;
            background: linear-gradient(195deg, var(--soft-ui-primary-start), var(--soft-ui-primary-end));
            -webkit-background-clip: text;
            -webkit-text-fill-color: transparent;
            background-clip: text;
        }

        .search-form {
            margin-bottom: 30px;
        }

        .search-form .form-control {
            border-radius: 0.5rem;
            border: 1px solid var(--soft-ui-gray-300);
            padding: 0.75rem 1rem;
            font-size: 1rem;
            transition: all 0.2s ease-in-out;
        }

        .search-form .form-control:focus {
            border-color: var(--soft-ui-primary-start);
            box-shadow: 0 0 0 0.2rem rgba(0, 196, 204, 0.25);
        }

        .search-form .btn {
            border-radius: 0.5rem;
            padding: 0.75rem 1.5rem;
            font-weight: 600;
            transition: all 0.2s ease-in-out;
        }

        .search-form .btn-primary {
            background: linear-gradient(195deg, var(--soft-ui-primary-start), var(--soft-ui-primary-end));
            border: none;
            color: var(--soft-ui-white);
        }

        .search-form .btn-primary:hover {
            background: linear-gradient(195deg, var(--soft-ui-primary-end), var(--soft-ui-primary-start));
            transform: translateY(-2px);
            box-shadow: 0 4px 12px rgba(203, 12, 159, 0.3);
        }

        .card {
            background-color: var(--soft-ui-white);
            border-radius: 0.75rem;
            box-shadow: 0 4px 12px rgba(0, 0, 0, 0.05);
            transition: all 0.2s ease-in-out;
            border: none;
        }

        .card:hover {
            transform: translateY(-5px);
            box-shadow: 0 8px 20px rgba(0, 0, 0, 0.1);
        }

        .training-card {
            height: 100%;
            display: flex;
            flex-direction: column;
        }

        .training-card .card-header {
            background: linear-gradient(195deg, var(--soft-ui-primary-start), var(--soft-ui-primary-end));
            color: var(--soft-ui-white);
            font-weight: 700;
            font-size: 1.1rem;
            text-align: center;
            padding: 1rem;
            border-top-left-radius: 0.75rem;
            border-top-right-radius: 0.75rem;
        }

        .training-card .card-body {
            padding: 1.5rem;
            flex-grow: 1;
            display: flex;
            flex-direction: column;
        }

        .training-card .card-title {
            font-size: 1.25rem;
            font-weight: 700;
            color: var(--soft-ui-dark);
            margin-bottom: 1rem;
        }

        .training-card .card-text {
            color: var(--soft-ui-secondary);
            margin-bottom: 1rem;
            flex-grow: 1;
        }

        .btn {
            border-radius: 0.5rem;
            padding: 0.75rem 1.5rem;
            font-weight: 600;
            transition: all 0.2s ease-in-out;
            border: none;
        }

        .btn-primary {
            background: linear-gradient(195deg, var(--soft-ui-primary-start), var(--soft-ui-primary-end));
            color: var(--soft-ui-white);
        }

        .btn-primary:hover {
            background: linear-gradient(195deg, var(--soft-ui-primary-end), var(--soft-ui-primary-start));
            transform: translateY(-2px);
            box-shadow: 0 4px 12px rgba(203, 12, 159, 0.3);
            color: var(--soft-ui-white);
        }

        .btn-start-test {
            background: linear-gradient(195deg, var(--soft-ui-primary-start), var(--soft-ui-primary-end));
            color: var(--soft-ui-white);
        }

        .btn-start-test:hover {
            background: linear-gradient(195deg, var(--soft-ui-primary-end), var(--soft-ui-primary-start));
            transform: translateY(-2px);
            box-shadow: 0 4px 12px rgba(130, 214, 22, 0.3);
            color: var(--soft-ui-white);
        }

        .btn-view-scores {
            background: linear-gradient(195deg, var(--soft-ui-primary-start), var(--soft-ui-primary-end));
            color: var(--soft-ui-white);
        }

        .btn-view-scores:hover {
            background: linear-gradient(195deg, var(--soft-ui-primary-end), var(--soft-ui-primary-start));
            transform: translateY(-2px);
            box-shadow: 0 4px 12px rgba(23, 193, 232, 0.3);
            color: var(--soft-ui-white);
        }

        .alert {
            border-radius: 0.75rem;
            border: none;
            padding: 1rem 1.5rem;
            font-weight: 500;
        }

        .alert-info {
            background: rgba(0, 196, 204, 0.1);
            color: var(--soft-ui-primary-start);
        }

        .alert-warning {
            background: rgba(203, 12, 159, 0.1);
            color: var(--soft-ui-primary-end);
        }
        
        footer {
            background: var(--soft-ui-white);
            color: var(--soft-ui-secondary);
            border-top: 1px solid var(--soft-ui-gray-200);
            padding: 1rem 0;
            text-align: center;
            flex-shrink: 0;
            margin-top: 2rem;
        }
        
        .animate-fade-in {
            animation: fadeIn 0.5s ease-in-out;
        }
        
        @keyframes fadeIn {
            from { opacity: 0; transform: translateY(10px); }
            to { opacity: 1; transform: translateY(0); }
        }

        @media (max-width: 768px) {
            .sidebar {
                margin-left: -250px;
                border-radius: 0;
                padding-top: 90px;
            }
            .sidebar-active {
                margin-left: 0;
            }
            .content {
                margin-left: 0;
                padding-top: 100px;
            }
            
            .navbar-title {
                display: none;
            }
            .navbar-logo {
                display: none;
            }
            
            .navbar-title-mobile {
                display: block;
            }
            
            .hamburger-mobile {
                display: block;
            }
            .navbar-search {
                display: none;
            }
            .navbar-nav {
                position: static;
            }
            .navbar-nav .dropdown-menu {
                position: absolute;
                right: 0;
                left: auto;
                z-index: 1300;
            }
            .page-title {
                font-size: 1.5rem;
                margin-bottom: 20px;
            }
            
            .training-card .card-body {
                padding: 1rem;
            }

            .training-card .card-title {
                font-size: 1.1rem;
            }
        }

        @media (max-width: 576px) {
            .navbar-top {
                padding: 0.5rem 1rem;
                min-height: 70px;
            }
            .navbar-title-mobile {
                font-size: 0.8rem;
            }
            .navbar-title-mobile .line2 {
                font-size: 0.75rem;
            }
            .page-title {
                font-size: 1.25rem;
            }

            .training-card .card-body {
                padding: 0.75rem;
            }
        }
    </style>
</head>
<body>
    <nav class="navbar navbar-expand-lg navbar-top">
        <div class="container-fluid">
            <button class="hamburger-mobile d-md-none" type="button" id="sidebarToggle">
                <i class="bi bi-list"></i>
            </button>
            <a class="navbar-brand d-none d-md-flex" href="#">
                <img src="image/logopim.png" alt="Logo PIM" class="navbar-logo">
            </a>
            <div class="navbar-title d-none d-md-block">
                E-Learning System Pondok Indah Mall
            </div>
            <div class="navbar-title-mobile d-md-none">
                <span class="line1">E-Learning System</span>
                <span class="line2">Pondok Indah Mall</span>
            </div>
            <?php if ($role != 'iss'): ?>
            <ul class="navbar-nav ms-auto mb-2 mb-lg-0">
                <li class="nav-item dropdown">
                    <a class="nav-link dropdown-toggle text-dark" href="#" id="navbarDropdown" role="button" data-bs-toggle="dropdown" aria-expanded="false">
                        <i class="bi bi-person-circle"></i>
                    </a>
                    <ul class="dropdown-menu dropdown-menu-end">
                        <li><a class="dropdown-item <?php echo ($current_page == 'profile.php') ? 'active' : ''; ?>" href="profile.php">Profile</a></li>
                        <li><hr class="dropdown-divider"></li>
                        <li><a class="dropdown-item" href="logout.php">Logout</a></li>
                    </ul>
                </li>
            </ul>
            <?php endif; ?>
        </div>
    </nav>

    <div class="sidebar-overlay" id="sidebarOverlay"></div>

    <div class="sidebar border-end" id="sidebar">
        <div class="profile-section">
            <?php if (!empty($foto_profil_path)): ?>
                <img src="Uploads/profiles/<?php echo htmlspecialchars($foto_profil_path); ?>" alt="Foto Profil" class="profile-photo">
            <?php else: ?>
                <div class="profile-photo-placeholder">
                    <i class="bi bi-person-circle"></i>
                </div>
            <?php endif; ?>
            <div class="profile-name"><?php echo htmlspecialchars($user['nama_lengkap']); ?></div>
            <div class="profile-info"><?php echo htmlspecialchars($user['jabatan'] ?? 'Tidak ada jabatan'); ?></div>
            <div class="profile-info"><?php echo htmlspecialchars($user['divisi'] ?? 'Tidak ada divisi'); ?></div>
        </div>
        <div class="p-3">
            <h5 class="mb-4 text-dark">Menu</h5>
            <ul class="nav flex-column">
                <li class="nav-item">
                    <a class="nav-link <?php echo ($current_page == 'dashboard.php') ? 'active' : ''; ?>" href="dashboard.php">
                        <i class="bi bi-house-door-fill"></i> Dashboard
                    </a>
                </li>
                <li class="nav-item">
                    <a class="nav-link <?php echo ($current_page == 'materi.php') ? 'active' : ''; ?>" href="materi.php">
                        <i class="bi bi-book"></i> Materi
                    </a>
                </li>
            <?php if ($role == 'trainer'): ?>
                <li class="nav-item dropdown">
                    <a class="nav-link dropdown-toggle <?php echo ($current_page == 'add_posttest.php' || $current_page == 'list_posttest.php') ? 'active' : ''; ?>" href="#" id="postTestDropdown" role="button" data-bs-toggle="dropdown" aria-expanded="false">
                        <i class="bi bi-clipboard-check"></i> Post Test
                    </a>
                    <ul class="dropdown-menu" aria-labelledby="postTestDropdown">
                        <li><a class="dropdown-item <?php echo ($current_page == 'add_posttest.php') ? 'active' : ''; ?>" href="add_posttest.php">Tambah Post Test</a></li>
                        <li><a class="dropdown-item <?php echo ($current_page == 'list_posttest.php') ? 'active' : ''; ?>" href="list_posttest.php">List Post Test</a></li>
                    </ul>
                </li>
            <?php else: // For Peserta and ISS roles ?>
                <li class="nav-item">
                    <a class="nav-link <?php echo ($current_page == 'list_posttest.php') ? 'active' : ''; ?>" href="list_posttest.php">
                        <i class="bi bi-clipboard-check"></i> Post Test
                    </a>
                </li>
            <?php endif; ?>
                <li class="nav-item dropdown">
                    <a class="nav-link dropdown-toggle <?php echo ($current_page == 'add_training.php' || $current_page == 'list_training.php') ? 'active' : ''; ?>" href="#" id="trainingDropdown" role="button" data-bs-toggle="dropdown" aria-expanded="false">
                        <i class="bi bi-journal-text"></i> Training
                    </a>
                    <ul class="dropdown-menu" aria-labelledby="trainingDropdown">
                        <?php if($role == 'trainer'): ?>
                        <li><a class="dropdown-item <?php echo ($current_page == 'add_training.php') ? 'active' : ''; ?>" href="add_training.php">Tambah Kegiatan Training</a></li>
                        <?php endif; ?>
                        <li><a class="dropdown-item <?php echo ($current_page == 'list_training.php') ? 'active' : ''; ?>" href="list_training.php">List Training</a></li>
                    </ul>
                </li>
            <?php if ($role == 'trainer'): ?>
                <li class="nav-item">
                    <a class="nav-link <?php echo ($current_page == 'report.php') ? 'active' : ''; ?>" href="report.php">
                        <i class="bi bi-file-earmark-text"></i> Report
                    </a>
                </li>
                <li class="nav-item">
                    <a class="nav-link <?php echo ($current_page == 'data_evaluasi.php') ? 'active' : ''; ?>" href="data_evaluasi.php">
                        <i class="bi bi-clipboard-data"></i> Data Evaluasi
                    </a>
                </li>
            <?php endif; ?>
            </ul>
        </div>
    </div>

    <div class="content">
        <div class="container-fluid">
            <h2 class="page-title animate-fade-in">List Post Test</h2>

            <!-- Search Form -->
            <div class="row mb-4">
                <div class="col-12">
                    <form method="GET" action="" class="search-form animate-fade-in">
                        <div class="row g-3 align-items-end">
                            <div class="col-md-9">
                                <label for="search_query" class="form-label">
                                    <i class="bi bi-search me-2"></i>Cari Training:
                                </label>
                                <input type="text" class="form-control" id="search_query" name="search" placeholder="Cari berdasarkan judul training" value="<?php echo htmlspecialchars($search_query); ?>">
                            </div>
                            <div class="col-md-3">
                                <button type="submit" class="btn btn-primary w-100">
                                    <i class="bi bi-search me-2"></i> Cari
                                </button>
                            </div>
                        </div>
                    </form>
                </div>
            </div>

            <!-- Info Alert -->
            <div class="row">
                <div class="col-12">
                    <div class="alert alert-info animate-fade-in" role="alert">
                        <i class="bi bi-info-circle me-2"></i>
                        <?php if ($role == 'trainer'): ?>
                            Pilih training di bawah ini untuk melihat hasil nilai Post Test peserta.
                        <?php else: ?>
                            Pilih training di bawah ini untuk memulai pengerjaan soal Post Test.
                        <?php endif; ?>
                    </div>
                </div>
            </div>

            <!-- Training Cards -->
            <div class="row row-cols-1 row-cols-md-2 row-cols-lg-3 g-4">
                <?php if (empty($trainings_list)): ?>
                    <div class="col-12">
                        <div class="alert alert-warning text-center animate-fade-in">
                            <i class="bi bi-exclamation-triangle me-2"></i>
                            <?php if (!empty($search_query)): ?>
                                Tidak ada training yang cocok dengan pencarian "<?php echo htmlspecialchars($search_query); ?>".
                            <?php else: ?>
                                Belum ada training yang tersedia untuk Post Test.
                            <?php endif; ?>
                        </div>
                    </div>
                <?php else: ?>
                    <?php foreach ($trainings_list as $training): ?>
                        <div class="col animate-fade-in">
                            <div class="card training-card">
                                <div class="card-header">
                                    <i class="bi bi-clipboard-check me-2"></i>
                                    Training Post Test
                                </div>
                                <div class="card-body">
                                    <h5 class="card-title"><?php echo htmlspecialchars($training['judul']); ?></h5>
                                    <p class="card-text">
                                        <i class="bi bi-calendar-event me-2"></i>
                                        <strong>Tanggal Kegiatan:</strong><br>
                                        <?php
                                            if (isset($training['training_date'])) {
                                                $training_date = new DateTime($training['training_date']);
                                                echo $training_date->format('d M Y');
                                            } else {
                                                echo 'Tanggal tidak tersedia';
                                            }
                                        ?>
                                    </p>
                                    <p class="card-text">
                                        <?php if ($role == 'trainer'): ?>
                                            <i class="bi bi-bar-chart me-2"></i>
                                            Klik tombol di bawah untuk melihat hasil nilai post test untuk training ini.
                                        <?php else: ?>
                                            <i class="bi bi-play-circle me-2"></i>
                                            Klik tombol di bawah untuk memulai post test untuk training ini.
                                        <?php endif; ?>
                                    </p>
                                    <?php if ($role == 'trainer'): ?>
                                        <a href="view_posttest_scores.php?training_id=<?php echo htmlspecialchars($training['id']); ?>" class="btn btn-view-scores w-100 mt-auto">
                                            <i class="bi bi-bar-chart-line me-2"></i> Hasil Nilai Peserta
                                        </a>
                                    <?php else: ?>
                                        <a href="take_posttest.php?training_id=<?php echo htmlspecialchars($training['id']); ?>" class="btn btn-start-test w-100 mt-auto">
                                            <i class="bi bi-play-circle me-2"></i> Mulai Post Test
                                        </a>
                                    <?php endif; ?>
                                </div>
                            </div>
                        </div>
                    <?php endforeach; ?>
                <?php endif; ?>
            </div>
        </div>
    </div>

    <footer class="text-center">
        <div class="container">
            <p class="mb-0">© <?php echo date('Y'); ?> E-Learning System by PIM</p>
        </div>
    </footer>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
    <script>
        document.addEventListener('DOMContentLoaded', function() {
            const sidebarToggle = document.getElementById('sidebarToggle');
            const sidebar = document.getElementById('sidebar');
            const sidebarOverlay = document.getElementById('sidebarOverlay');
            const trainingDropdownToggle = document.getElementById('trainingDropdown');
            const postTestDropdownToggle = document.getElementById('postTestDropdown');
            
            let isDropdownClick = false;

            function toggleSidebar() {
                sidebar.classList.toggle('sidebar-active');
                sidebarOverlay.style.display = sidebar.classList.contains('sidebar-active') ? 'block' : 'none';
                
                if (sidebar.classList.contains('sidebar-active')) {
                    document.body.style.overflow = 'hidden';
                } else {
                    document.body.style.overflow = '';
                }
            }

            sidebarToggle.addEventListener('click', function(e) {
                e.stopPropagation();
                toggleSidebar();
            });

            sidebarOverlay.addEventListener('click', function() {
                if (!isDropdownClick) {
                    toggleSidebar();
                }
                isDropdownClick = false;
            });

            if (trainingDropdownToggle) {
                trainingDropdownToggle.addEventListener('click', function(e) {
                    if (window.innerWidth <= 768) {
                        isDropdownClick = true;
                    }
                });
            }

            if (postTestDropdownToggle) {
                postTestDropdownToggle.addEventListener('click', function(e) {
                    if (window.innerWidth <= 768) {
                        isDropdownClick = true;
                    }
                });
            }
            
            document.addEventListener('click', function(e) {
                if (window.innerWidth <= 768) {
                    let clickedInsideAnyDropdown = false;
                    if (trainingDropdownToggle && trainingDropdownToggle.contains(e.target)) {
                        clickedInsideAnyDropdown = true;
                    }
                    if (postTestDropdownToggle && postTestDropdownToggle.contains(e.target)) {
                        clickedInsideAnyDropdown = true;
                    }
                    if (!clickedInsideAnyDropdown) {
                        isDropdownClick = false;
                    }
                }
            });

            const regularNavLinks = document.querySelectorAll('.sidebar .nav-link:not(.dropdown-toggle)');
            regularNavLinks.forEach(link => {
                link.addEventListener('click', function() {
                    if (window.innerWidth <= 768 && sidebar.classList.contains('sidebar-active')) {
                        toggleSidebar();
                    }
                });
            });

            const dropdownItems = document.querySelectorAll('.sidebar .dropdown-menu .dropdown-item');
            dropdownItems.forEach(item => {
                item.addEventListener('click', function() {
                    if (window.innerWidth <= 768 && sidebar.classList.contains('sidebar-active')) {
                        toggleSidebar();
                    }
                });
            });

            window.addEventListener('resize', function() {
                if (window.innerWidth > 768) {
                    sidebar.classList.remove('sidebar-active');
                    sidebarOverlay.style.display = 'none';
                    document.body.style.overflow = '';
                    isDropdownClick = false;
                }
            });
        });
    </script>
</body>
</html>