<?php
// Mulai session di setiap file yang membutuhkan
// Ini harus berada di bagian paling atas file, sebelum output apapun
session_start();

// Konfigurasi database
$host = 'localhost';
$username = 'k7015501_pimtraining';
$password = 'iherocomeback';
$database = 'k7015501_pimtraining';

// Membuat koneksi
$koneksi = mysqli_connect($host, $username, $password, $database);

// Cek koneksi
if (!$koneksi) {
    die("Koneksi gagal: " . mysqli_connect_error());
}

// PENTING: Set zona waktu untuk koneksi database ke Asia/Jakarta (UTC+7)
// Ini memastikan bahwa fungsi waktu MySQL seperti NOW() menyimpan waktu yang benar
// dan waktu yang diambil dari database juga diinterpretasikan dengan benar.
$koneksi->query("SET time_zone = '+07:00'");

// Fungsi untuk membersihkan input
function clean($data) {
    global $koneksi;
    $data = mysqli_real_escape_string($koneksi, $data);
    $data = trim($data);
    $data = stripslashes($data);
    $data = htmlspecialchars($data);
    return $data;
}

// Fungsi untuk redirecting
function redirect($url) {
    header("Location: $url");
    exit();
}

// Fungsi untuk memeriksa apakah user sudah login
function checkLogin() {
    // session_start() sudah dipanggil di awal file, jadi tidak perlu di sini
    if (!isset($_SESSION['user_id']) || !isset($_SESSION['role'])) {
        header("Location: login.php");
        exit();
    }
    
    // Validasi role - ISS sekarang memiliki akses yang sama seperti peserta
    $allowed_roles = ['trainer', 'peserta', 'iss'];
    if (!in_array($_SESSION['role'], $allowed_roles)) {
        header("Location: login.php?error=Invalid role");
        exit();
    }
}

// Fungsi untuk memeriksa apakah user adalah trainer
function checkTrainer() {
    if (!isset($_SESSION['role']) || $_SESSION['role'] !== 'trainer') {
        redirect("dashboard.php");
    }
}

// Fungsi untuk mengambil data user ISS
function getISSData($user_id) {
    global $koneksi;
    
    $stmt = $koneksi->prepare("SELECT * FROM iss WHERE id = ?");
    $stmt->bind_param("i", $user_id);
    $stmt->execute();
    $result = $stmt->get_result();
    $user = $result->fetch_assoc();
    $stmt->close();
    
    return $user;
}

// Fungsi untuk mengambil data user guest (tetap dipertahankan jika masih digunakan)
function getGuestData($user_id) {
    global $koneksi;
    
    $stmt = $koneksi->prepare("SELECT * FROM guests WHERE id = ?");
    $stmt->bind_param("i", $user_id);
    $stmt->execute();
    $result = $stmt->get_result();
    $user = $result->fetch_assoc();
    $stmt->close();
    
    return $user;
}

// Fungsi untuk memeriksa tipe file yang diizinkan
function isAllowedFileType($extension) {
    $allowed = array('ppt', 'pptx', 'pdf', 'doc', 'docx');
    return in_array(strtolower($extension), $allowed);
}
?>
