<?php
require_once 'koneksi.php';

header('Content-Type: application/json');

if (isset($_GET['query'])) {
    $query = '%' . $koneksi->real_escape_string($_GET['query']) . '%';
    $stmt = $koneksi->prepare("SELECT id, nama_lengkap, nik_karyawan FROM peserta WHERE nama_lengkap LIKE ? ORDER BY nama_lengkap LIMIT 10");
    $stmt->bind_param("s", $query);
    $stmt->execute();
    $result = $stmt->get_result();
    $peserta = $result->fetch_all(MYSQLI_ASSOC);
    $stmt->close();

    echo json_encode($peserta);
} else {
    echo json_encode([]);
}
?>