<?php
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

require_once 'koneksi.php';

// Cek login
checkLogin();

$user_id = $_SESSION['user_id'];
$role = $_SESSION['role'];

// Pastikan hanya trainer yang bisa mengakses
if (!isset($role) || $role !== 'trainer') {
    header("Location: dashboard.php?error=" . urlencode("Anda tidak memiliki izin untuk mengakses halaman ini."));
    exit();
}

$training_id = $_GET['training_id'] ?? null;

if (!$training_id) {
    header("Location: list_posttest.php?error=" . urlencode("ID Training tidak ditemukan."));
    exit();
}

// Ambil judul training
$training_title = "Tidak Ditemukan";
$stmt = $koneksi->prepare("SELECT judul FROM trainings WHERE id = ?");
if ($stmt !== false) {
    $stmt->bind_param("i", $training_id);
    $stmt->execute();
    $result = $stmt->get_result();
    if ($row = $result->fetch_assoc()) {
        $training_title = $row['judul'];
    }
    $stmt->close();
}

// Ambil semua submission untuk training ini - SAMA PERSIS dengan query di view_posttest_scores.php
$post_test_submissions = [];
$stmt = $koneksi->prepare("
    SELECT
        pts.id AS submission_id,
        pts.user_id,
        pts.user_role,
        pts.score,
        pts.submission_time,
        p.nama_lengkap AS peserta_nama,
        p.divisi AS peserta_divisi,
        i.nama_lengkap AS iss_nama,
        i.divisi AS iss_divisi
    FROM post_test_submissions pts
    LEFT JOIN peserta p ON pts.user_id = p.id AND pts.user_role = 'peserta'
    LEFT JOIN iss i ON pts.user_id = i.id AND pts.user_role = 'iss'
    WHERE pts.training_id = ?
    ORDER BY 
        CASE 
            WHEN pts.user_role = 'peserta' THEN p.divisi 
            ELSE i.divisi 
        END ASC,
        CASE 
            WHEN pts.user_role = 'peserta' THEN p.nama_lengkap 
            ELSE i.nama_lengkap 
        END ASC
");

if ($stmt !== false) {
    $stmt->bind_param("i", $training_id);
    $stmt->execute();
    $result = $stmt->get_result();
    while ($row = $result->fetch_assoc()) {
        $post_test_submissions[] = $row;
    }
    $stmt->close();
}

// Set headers untuk download Excel
$filename = "Hasil_Post_Test_" . preg_replace('/[^A-Za-z0-9_\-]/', '_', $training_title) . "_" . date('Y-m-d_H-i-s') . ".xls";

header("Content-Type: application/vnd.ms-excel");
header("Content-Disposition: attachment; filename=\"$filename\"");
header("Pragma: no-cache");
header("Expires: 0");

// Mulai output Excel
echo "\xEF\xBB\xBF"; // UTF-8 BOM untuk support karakter Indonesia
?>
<!DOCTYPE html>
<html>
<head>
    <meta charset="UTF-8">
    <style>
        table {
            border-collapse: collapse;
            width: 100%;
        }
        th, td {
            border: 1px solid #000;
            padding: 8px;
            text-align: left;
        }
        th {
            background-color: #cb0c9f;
            color: white;
            font-weight: bold;
            text-align: center;
        }
        .center {
            text-align: center;
        }
        .header-title {
            font-size: 16px;
            font-weight: bold;
            margin-bottom: 10px;
            text-align: center;
        }
        .training-info {
            margin-bottom: 20px;
            text-align: center;
        }
    </style>
</head>
<body>
    <div class="header-title">HASIL POST TEST PESERTA</div>
    <div class="training-info">
        <strong>Training: <?php echo htmlspecialchars($training_title); ?></strong><br>
        <strong>Tanggal Export: <?php echo date('d/m/Y H:i:s'); ?></strong><br>
        <strong>Data diurutkan berdasarkan: Divisi (A-Z)</strong>
    </div>

    <?php if (empty($post_test_submissions)): ?>
        <p><strong>Tidak ada data untuk diekspor.</strong></p>
    <?php else: ?>
        <table>
            <thead>
                <tr>
                    <th>No.</th>
                    <th>Nama Peserta</th>
                    <th>Tipe Karyawan</th>
                    <th>Divisi</th>
                    <th>Score</th>
                    <th>Waktu Submit</th>
                </tr>
            </thead>
            <tbody>
                <?php 
                $no = 1; 
                foreach ($post_test_submissions as $submission): 
                    // Logika sama persis dengan yang di view_posttest_scores.php
                    $nama = $submission['user_role'] == 'peserta' ? $submission['peserta_nama'] : $submission['iss_nama'];
                    $divisi = $submission['user_role'] == 'peserta' ? ($submission['peserta_divisi'] ?? '-') : ($submission['iss_divisi'] ?? '-');
                    $tipe = $submission['user_role'] == 'iss' ? 'ISS' : 'Peserta';
                ?>
                    <tr>
                        <td class="center"><?php echo $no++; ?></td>
                        <td><?php echo htmlspecialchars($nama); ?></td>
                        <td class="center"><?php echo $tipe; ?></td>
                        <td><?php echo htmlspecialchars($divisi); ?></td>
                        <td class="center"><?php echo htmlspecialchars($submission['score']); ?></td>
                        <td class="center"><?php echo htmlspecialchars($submission['submission_time']); ?></td>
                    </tr>
                <?php endforeach; ?>
            </tbody>
        </table>
    <?php endif; ?>

    <br><br>
    <div style="font-size: 12px; color: #666;">
        <p>Diekspor dari E-Learning System Pondok Indah Mall pada <?php echo date('d/m/Y H:i:s'); ?></p>
        <p>Data diurutkan berdasarkan Divisi secara alfabetis (A-Z), kemudian Nama Peserta (A-Z)</p>
    </div>
</body>
</html>
