<?php
require_once 'koneksi.php';

// Cek login
checkLogin();

// Pastikan user adalah trainer atau admin
if (!isset($_SESSION['role']) || ($_SESSION['role'] !== 'trainer' && $_SESSION['role'] !== 'admin')) {
    http_response_code(403);
    die('Akses ditolak');
}

// Ambil ID evaluasi dari parameter GET
$evaluation_id = isset($_GET['id']) ? (int)$_GET['id'] : 0;

if ($evaluation_id <= 0) {
    die('ID evaluasi tidak valid');
}

// Query untuk mengambil detail evaluasi
$stmt = $koneksi->prepare("
    SELECT 
        id,
        training_name,
        instructor,
        location,
        participant_name,
        position,
        work_unit,
        training_date,
        fasilitator_persiapan,
        fasilitator_materi,
        waktu_training,
        training_interaktif,
        fasilitas_tempat,
        peralatan_training,
        ilmu_baru,
        memahami_tujuan,
        sesuai_harapan,
        bermanfaat,
        kualitas_kerja,
        relevan_pekerjaan,
        saran_masukan,
        created_at
    FROM 
        evaluasi_training
    WHERE 
        id = ?
");

$stmt->bind_param("i", $evaluation_id);
$stmt->execute();
$result = $stmt->get_result();

if ($result->num_rows === 0) {
    die('Data evaluasi tidak ditemukan');
}

$evaluation = $result->fetch_assoc();
$stmt->close();

// Function untuk mengkonversi angka ke teks rating
function getRatingText($rating) {
    switch($rating) {
        case 1: return 'Sangat Tidak Setuju';
        case 2: return 'Tidak Setuju';
        case 3: return 'Setuju';
        case 4: return 'Sangat Setuju';
        default: return 'Tidak Valid';
    }
}

// Function untuk menampilkan bintang rating
function getStarRating($rating) {
    $stars = '';
    for ($i = 1; $i <= 4; $i++) {
        if ($i <= $rating) {
            $stars .= '<i class="bi bi-star-fill text-warning"></i>';
        } else {
            $stars .= '<i class="bi bi-star text-muted"></i>';
        }
    }
    return $stars;
}

// Hitung rata-rata penilaian
$ratings = [
    $evaluation['fasilitator_persiapan'],
    $evaluation['fasilitator_materi'],
    $evaluation['waktu_training'],
    $evaluation['training_interaktif'],
    $evaluation['fasilitas_tempat'],
    $evaluation['peralatan_training'],
    $evaluation['ilmu_baru'],
    $evaluation['memahami_tujuan'],
    $evaluation['sesuai_harapan'],
    $evaluation['bermanfaat'],
    $evaluation['kualitas_kerja'],
    $evaluation['relevan_pekerjaan']
];
$average = array_sum($ratings) / count($ratings);
$average_rounded = round($average, 1);

// Format tanggal
$training_date = date('d-m-Y', strtotime($evaluation['training_date']));
$created_date = date('d-m-Y H:i', strtotime($evaluation['created_at']));
?>

<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Evaluasi Training - <?php echo htmlspecialchars($evaluation['training_name']); ?></title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.7.2/font/bootstrap-icons.css" rel="stylesheet">
    
    <style>
        /* CSS yang sama persis dengan get_evaluation_detail.php */
        .detail-section {
            margin-bottom: 25px;
            padding: 15px;
            border: 1px solid #e9ecef;
            border-radius: 8px;
            background-color: #f8f9fa;
        }

        .detail-section h6 {
            color: #2c3e50;
            font-weight: 600;
            margin-bottom: 15px;
            border-bottom: 2px solid #3498db;
            padding-bottom: 5px;
        }

        .rating-item {
            display: flex;
            justify-content: space-between;
            align-items: center;
            padding: 8px 0;
            border-bottom: 1px solid #e9ecef;
        }

        .rating-item:last-child {
            border-bottom: none;
        }

        .rating-value {
            display: flex;
            align-items: center;
            gap: 10px;
        }

        .overall-rating {
            text-align: center;
            padding: 20px;
            background: linear-gradient(135deg, #3498db 0%, #2980b9 100%);
            color: white;
            border-radius: 10px;
            margin-bottom: 20px;
        }

        .overall-rating h4 {
            margin: 0;
            font-size: 2rem;
        }

        .info-grid {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(250px, 1fr));
            gap: 15px;
            margin-bottom: 20px;
        }

        .info-item {
            padding: 10px;
            background-color: white;
            border-radius: 6px;
            border-left: 4px solid #3498db;
        }

        .info-label {
            font-weight: 600;
            color: #2c3e50;
            font-size: 0.9rem;
        }

        .info-value {
            color: #34495e;
            margin-top: 2px;
        }

        /* Style untuk print dan preview */
        body {
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
            background-color: #f8f9fa;
            padding: 20px;
        }

        .preview-container {
            max-width: 900px;
            margin: 0 auto;
            background: white;
            padding: 30px;
            border-radius: 10px;
            box-shadow: 0 0 20px rgba(0,0,0,0.1);
        }

        /* Toolbar untuk aksi */
        .preview-toolbar {
            position: fixed;
            top: 20px;
            right: 20px;
            z-index: 1000;
            display: flex;
            gap: 10px;
        }

        .btn-action {
            display: inline-flex;
            align-items: center;
            gap: 8px;
            padding: 10px 16px;
            border: none;
            border-radius: 6px;
            text-decoration: none;
            font-size: 14px;
            font-weight: 500;
            transition: all 0.3s ease;
            box-shadow: 0 2px 4px rgba(0,0,0,0.1);
        }

        .btn-pdf {
            background: linear-gradient(135deg, #e74c3c 0%, #c0392b 100%);
            color: white;
        }

        .btn-pdf:hover {
            background: linear-gradient(135deg, #c0392b 0%, #a93226 100%);
            color: white;
            transform: translateY(-1px);
            box-shadow: 0 4px 8px rgba(231, 76, 60, 0.3);
        }

        .btn-back {
            background: linear-gradient(135deg, #6c757d 0%, #5a6268 100%);
            color: white;
        }

        .btn-back:hover {
            background: linear-gradient(135deg, #5a6268 0%, #495057 100%);
            color: white;
            transform: translateY(-1px);
            box-shadow: 0 4px 8px rgba(108, 117, 125, 0.3);
        }

        @media print {
            .preview-toolbar {
                display: none !important;
            }
            
            body {
                margin: 0;
                padding: 0;
                background: white;
            }
            
            .preview-container {
                max-width: none;
                margin: 0;
                padding: 20px;
                box-shadow: none;
                border-radius: 0;
            }
        }

        @media (max-width: 768px) {
            .rating-item {
                flex-direction: column;
                align-items: flex-start;
                gap: 5px;
            }
            
            .rating-value {
                align-self: flex-end;
            }
            
            .info-grid {
                grid-template-columns: 1fr;
            }
            
            .preview-toolbar {
                position: relative;
                top: auto;
                right: auto;
                margin-bottom: 20px;
                justify-content: center;
            }
            
            .btn-action {
                flex: 1;
                justify-content: center;
            }
        }
    </style>
</head>
<body>
    <!-- Toolbar Aksi -->
    <div class="preview-toolbar">
        <button onclick="window.print()" class="btn-action btn-pdf">
            <i class="bi bi-file-earmark-pdf-fill"></i>
            Save as PDF
        </button>
        <button onclick="window.close()" class="btn-action btn-back">
            <i class="bi bi-arrow-left"></i>
            Kembali
        </button>
    </div>

    <div class="preview-container">
        <!-- Overall Rating -->
        <div class="overall-rating">
            <h4><?php echo $average_rounded; ?>/4</h4>
            <div class="mb-2">
                <?php echo getStarRating($average_rounded); ?>
            </div>
            <small>Rata-rata Penilaian Keseluruhan</small>
        </div>

        <!-- Informasi Training -->
        <div class="detail-section">
            <h6><i class="bi bi-info-circle me-2"></i>Informasi Training</h6>
            <div class="info-grid">
                <div class="info-item">
                    <div class="info-label">Nama Training</div>
                    <div class="info-value"><?php echo htmlspecialchars($evaluation['training_name']); ?></div>
                </div>
                <div class="info-item">
                    <div class="info-label">Instruktur</div>
                    <div class="info-value"><?php echo htmlspecialchars($evaluation['instructor']); ?></div>
                </div>
                <div class="info-item">
                    <div class="info-label">Lokasi</div>
                    <div class="info-value"><?php echo htmlspecialchars($evaluation['location']); ?></div>
                </div>
                <div class="info-item">
                    <div class="info-label">Tanggal Training</div>
                    <div class="info-value"><?php echo $training_date; ?></div>
                </div>
            </div>
        </div>

        <!-- Informasi Peserta -->
        <div class="detail-section">
            <h6><i class="bi bi-person me-2"></i>Informasi Peserta</h6>
            <div class="info-grid">
                <div class="info-item">
                    <div class="info-label">Nama Peserta</div>
                    <div class="info-value"><?php echo htmlspecialchars($evaluation['participant_name']); ?></div>
                </div>
                <div class="info-item">
                    <div class="info-label">Jabatan</div>
                    <div class="info-value"><?php echo htmlspecialchars($evaluation['position']); ?></div>
                </div>
                <div class="info-item">
                    <div class="info-label">Unit Kerja</div>
                    <div class="info-value"><?php echo htmlspecialchars($evaluation['work_unit']); ?></div>
                </div>
                <div class="info-item">
                    <div class="info-label">Tanggal Evaluasi</div>
                    <div class="info-value"><?php echo $created_date; ?></div>
                </div>
            </div>
        </div>

        <!-- Evaluasi Fasilitator & Fasilitas -->
        <div class="detail-section">
            <h6><i class="bi bi-person-check me-2"></i>Evaluasi Fasilitator & Fasilitas</h6>
            
            <div class="rating-item">
                <span>Fasilitator menyiapkan segala sesuatunya dengan baik</span>
                <div class="rating-value">
                    <?php echo getStarRating($evaluation['fasilitator_persiapan']); ?>
                    <span class="badge bg-primary"><?php echo $evaluation['fasilitator_persiapan']; ?></span>
                    <small class="text-muted"><?php echo getRatingText($evaluation['fasilitator_persiapan']); ?></small>
                </div>
            </div>
            
            <div class="rating-item">
                <span>Fasilitator menguasai materi dan menyampaikan sesuai agenda</span>
                <div class="rating-value">
                    <?php echo getStarRating($evaluation['fasilitator_materi']); ?>
                    <span class="badge bg-primary"><?php echo $evaluation['fasilitator_materi']; ?></span>
                    <small class="text-muted"><?php echo getRatingText($evaluation['fasilitator_materi']); ?></small>
                </div>
            </div>
            
            <div class="rating-item">
                <span>Waktu training sudah cukup dalam penyampaian materi</span>
                <div class="rating-value">
                    <?php echo getStarRating($evaluation['waktu_training']); ?>
                    <span class="badge bg-primary"><?php echo $evaluation['waktu_training']; ?></span>
                    <small class="text-muted"><?php echo getRatingText($evaluation['waktu_training']); ?></small>
                </div>
            </div>
            
            <div class="rating-item">
                <span>Training dilakukan secara interaktif dan menarik</span>
                <div class="rating-value">
                    <?php echo getStarRating($evaluation['training_interaktif']); ?>
                    <span class="badge bg-primary"><?php echo $evaluation['training_interaktif']; ?></span>
                    <small class="text-muted"><?php echo getRatingText($evaluation['training_interaktif']); ?></small>
                </div>
            </div>
            
            <div class="rating-item">
                <span>Fasilitas tempat dan konsumsi mendukung kenyamanan</span>
                <div class="rating-value">
                    <?php echo getStarRating($evaluation['fasilitas_tempat']); ?>
                    <span class="badge bg-primary"><?php echo $evaluation['fasilitas_tempat']; ?></span>
                    <small class="text-muted"><?php echo getRatingText($evaluation['fasilitas_tempat']); ?></small>
                </div>
            </div>
            
            <div class="rating-item">
                <span>Peralatan training yang disediakan sudah memadai</span>
                <div class="rating-value">
                    <?php echo getStarRating($evaluation['peralatan_training']); ?>
                    <span class="badge bg-primary"><?php echo $evaluation['peralatan_training']; ?></span>
                    <small class="text-muted"><?php echo getRatingText($evaluation['peralatan_training']); ?></small>
                </div>
            </div>
        </div>

        <!-- Evaluasi Manfaat & Relevansi -->
        <div class="detail-section">
            <h6><i class="bi bi-lightbulb me-2"></i>Evaluasi Manfaat & Relevansi</h6>
            
            <div class="rating-item">
                <span>Saya mendapatkan ilmu pengetahuan baru setelah mengikuti training ini</span>
                <div class="rating-value">
                    <?php echo getStarRating($evaluation['ilmu_baru']); ?>
                    <span class="badge bg-success"><?php echo $evaluation['ilmu_baru']; ?></span>
                    <small class="text-muted"><?php echo getRatingText($evaluation['ilmu_baru']); ?></small>
                </div>
            </div>
            
            <div class="rating-item">
                <span>Saya memahami tujuan dan materi training ini</span>
                <div class="rating-value">
                    <?php echo getStarRating($evaluation['memahami_tujuan']); ?>
                    <span class="badge bg-success"><?php echo $evaluation['memahami_tujuan']; ?></span>
                    <small class="text-muted"><?php echo getRatingText($evaluation['memahami_tujuan']); ?></small>
                </div>
            </div>
            
            <div class="rating-item">
                <span>Program training ini sesuai dengan harapan saya</span>
                <div class="rating-value">
                    <?php echo getStarRating($evaluation['sesuai_harapan']); ?>
                    <span class="badge bg-success"><?php echo $evaluation['sesuai_harapan']; ?></span>
                    <small class="text-muted"><?php echo getRatingText($evaluation['sesuai_harapan']); ?></small>
                </div>
            </div>
            
            <div class="rating-item">
                <span>Isi program training ini bermanfaat bagi diri saya dan pekerjaan</span>
                <div class="rating-value">
                    <?php echo getStarRating($evaluation['bermanfaat']); ?>
                    <span class="badge bg-success"><?php echo $evaluation['bermanfaat']; ?></span>
                    <small class="text-muted"><?php echo getRatingText($evaluation['bermanfaat']); ?></small>
                </div>
            </div>
            
            <div class="rating-item">
                <span>Training ini bisa merubah kualitas pekerjaan saya menjadi lebih baik</span>
                <div class="rating-value">
                    <?php echo getStarRating($evaluation['kualitas_kerja']); ?>
                    <span class="badge bg-success"><?php echo $evaluation['kualitas_kerja']; ?></span>
                    <small class="text-muted"><?php echo getRatingText($evaluation['kualitas_kerja']); ?></small>
                </div>
            </div>
            
            <div class="rating-item">
                <span>Training ini relevan dengan pekerjaan yang saya lakukan saat ini</span>
                <div class="rating-value">
                    <?php echo getStarRating($evaluation['relevan_pekerjaan']); ?>
                    <span class="badge bg-success"><?php echo $evaluation['relevan_pekerjaan']; ?></span>
                    <small class="text-muted"><?php echo getRatingText($evaluation['relevan_pekerjaan']); ?></small>
                </div>
            </div>
        </div>

        <!-- Saran dan Masukan -->
        <?php if (!empty($evaluation['saran_masukan'])): ?>
        <div class="detail-section">
            <h6><i class="bi bi-chat-square-text me-2"></i>Saran dan Masukan</h6>
            <div class="p-3 bg-white rounded border-start border-4 border-info">
                <p class="mb-0 text-muted fst-italic">
                    "<?php echo nl2br(htmlspecialchars($evaluation['saran_masukan'])); ?>"
                </p>
            </div>
        </div>
        <?php else: ?>
        <div class="detail-section">
            <h6><i class="bi bi-chat-square-text me-2"></i>Saran dan Masukan</h6>
            <div class="p-3 bg-light rounded text-center text-muted">
                <i class="bi bi-chat-square-dots fs-1 mb-2 d-block"></i>
                Tidak ada saran dan masukan yang diberikan
            </div>
        </div>
        <?php endif; ?>

        <!-- Footer Info -->
        <div class="mt-4 pt-3 border-top text-center text-muted">
            <small>
                Dokumen digenerate pada <?php echo date('d-m-Y H:i:s'); ?><br>
                <strong>E-Learning System Pondok Indah Mall</strong>
            </small>
        </div>
    </div>

    <script>
        // Handle keyboard shortcut Ctrl+P
        document.addEventListener('keydown', function(e) {
            if (e.ctrlKey && e.key === 'p') {
                e.preventDefault();
                window.print();
            }
        });

        // Set document title untuk print
        document.title = 'Evaluasi Training - <?php echo htmlspecialchars($evaluation['training_name']); ?>';
    </script>
</body>
</html>
