<?php
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

require_once 'koneksi.php';

// Cek login
checkLogin();

$user_id = $_SESSION['user_id'];
$role = $_SESSION['role'];

// Pastikan user adalah trainer atau admin
if (!isset($role) || ($role !== 'trainer' && $role !== 'admin')) {
    header("Location: login.php?error=Anda tidak memiliki izin untuk mengakses halaman ini");
    exit();
}

// Ambil parameter pencarian
$search_term = isset($_GET['search']) ? trim($_GET['search']) : '';

if (empty($search_term)) {
    header("Location: data_evaluasi.php?error=Parameter pencarian tidak ditemukan");
    exit();
}

// Query untuk mengambil data evaluasi berdasarkan pencarian
$stmt = $koneksi->prepare("
    SELECT 
        id,
        training_name,
        instructor,
        location,
        participant_name,
        position,
        work_unit,
        training_date,
        fasilitator_persiapan,
        fasilitator_materi,
        waktu_training,
        training_interaktif,
        fasilitas_tempat,
        peralatan_training,
        ilmu_baru,
        memahami_tujuan,
        sesuai_harapan,
        bermanfaat,
        kualitas_kerja,
        relevan_pekerjaan,
        saran_masukan,
        created_at
    FROM 
        evaluasi_training
    WHERE 
        training_name LIKE ?
    ORDER BY 
        created_at DESC
");

$search_param = "%" . $search_term . "%";
$stmt->bind_param("s", $search_param);
$stmt->execute();
$result = $stmt->get_result();

$evaluation_data = [];
while ($row = $result->fetch_assoc()) {
    $evaluation_data[] = $row;
}
$stmt->close();

if (empty($evaluation_data)) {
    header("Location: data_evaluasi.php?error=Tidak ada data untuk diekspor");
    exit();
}

// Jika menggunakan library TCPDF atau FPDF, uncomment dan sesuaikan
// require_once('tcpdf/tcpdf.php');

// Untuk sementara, kita akan menggunakan HTML to PDF sederhana
// Set header untuk download PDF
header('Content-Type: application/pdf');
header('Content-Disposition: attachment;filename="Data_Evaluasi_Training_' . date('Y-m-d_H-i-s') . '.pdf"');
header('Cache-Control: max-age=0');

// Jika tidak ada library PDF, kita buat HTML yang bisa diprint sebagai PDF
?>
<!DOCTYPE html>
<html>
<head>
    <meta charset="UTF-8">
    <title>Data Evaluasi Training</title>
    <style>
        @page {
            size: A4 landscape;
            margin: 1cm;
        }
        body {
            font-family: Arial, sans-serif;
            font-size: 10px;
            margin: 0;
            padding: 0;
        }
        .header {
            text-align: center;
            margin-bottom: 20px;
        }
        .header h1 {
            font-size: 16px;
            margin: 5px 0;
            color: #2c3e50;
        }
        .header h2 {
            font-size: 14px;
            margin: 5px 0;
            color: #34495e;
        }
        .info {
            margin-bottom: 15px;
        }
        .info p {
            margin: 3px 0;
            font-size: 10px;
        }
        table {
            width: 100%;
            border-collapse: collapse;
            font-size: 8px;
        }
        th, td {
            border: 1px solid #ddd;
            padding: 4px;
            text-align: left;
        }
        th {
            background-color: #2c3e50;
            color: white;
            font-weight: bold;
            text-align: center;
        }
        .center {
            text-align: center;
        }
        .number {
            text-align: right;
            font-weight: bold;
        }
        .footer {
            margin-top: 20px;
            text-align: center;
            font-size: 8px;
            color: #7f8c8d;
        }
        .rating-high {
            background-color: #d4edda;
            color: #155724;
        }
        .rating-medium {
            background-color: #fff3cd;
            color: #856404;
        }
        .rating-low {
            background-color: #f8d7da;
            color: #721c24;
        }
    </style>
</head>
<body>
    <div class="header">
        <h1>DATA EVALUASI TRAINING</h1>
        <h2>PONDOK INDAH MALL</h2>
    </div>
    
    <div class="info">
        <p><strong>Pencarian:</strong> <?php echo htmlspecialchars($search_term); ?></p>
        <p><strong>Tanggal Export:</strong> <?php echo date('d-m-Y H:i:s'); ?></p>
        <p><strong>Total Data:</strong> <?php echo count($evaluation_data); ?> evaluasi</p>
    </div>
    
    <table>
        <thead>
            <tr>
                <th style="width: 3%;">No</th>
                <th style="width: 12%;">Nama Training</th>
                <th style="width: 10%;">Peserta</th>
                <th style="width: 8%;">Jabatan</th>
                <th style="width: 8%;">Unit Kerja</th>
                <th style="width: 7%;">Tanggal</th>
                <th style="width: 8%;">Instruktur</th>
                <th style="width: 8%;">Lokasi</th>
                <th style="width: 4%;">FP</th>
                <th style="width: 4%;">FM</th>
                <th style="width: 4%;">WT</th>
                <th style="width: 4%;">TI</th>
                <th style="width: 4%;">FT</th>
                <th style="width: 4%;">PT</th>
                <th style="width: 5%;">Avg R</th>
                <th style="width: 4%;">IB</th>
                <th style="width: 4%;">MT</th>
                <th style="width: 4%;">SH</th>
                <th style="width: 4%;">BM</th>
                <th style="width: 4%;">KK</th>
                <th style="width: 4%;">RP</th>
                <th style="width: 5%;">Avg L</th>
            </tr>
        </thead>
        <tbody>
            <?php 
            $no = 1;
            foreach ($evaluation_data as $data): 
                // Hitung rata-rata Reaksi
                $reaction_ratings = [
                    $data['fasilitator_persiapan'],
                    $data['fasilitator_materi'],
                    $data['waktu_training'],
                    $data['training_interaktif'],
                    $data['fasilitas_tempat'],
                    $data['peralatan_training']
                ];
                $reaction_average = array_sum($reaction_ratings) / count($reaction_ratings);
                $reaction_average_rounded = round($reaction_average, 1);
                
                // Hitung rata-rata Pembelajaran
                $learning_ratings = [
                    $data['ilmu_baru'],
                    $data['memahami_tujuan'],
                    $data['sesuai_harapan'],
                    $data['bermanfaat'],
                    $data['kualitas_kerja'],
                    $data['relevan_pekerjaan']
                ];
                $learning_average = array_sum($learning_ratings) / count($learning_ratings);
                $learning_average_rounded = round($learning_average, 1);
                
                // Tentukan class berdasarkan rating
                $reaction_class = $reaction_average_rounded >= 3.5 ? 'rating-high' : ($reaction_average_rounded >= 2.5 ? 'rating-medium' : 'rating-low');
                $learning_class = $learning_average_rounded >= 3.5 ? 'rating-high' : ($learning_average_rounded >= 2.5 ? 'rating-medium' : 'rating-low');
                
                // Format tanggal
                $training_date = date('d/m/Y', strtotime($data['training_date']));
            ?>
            <tr>
                <td class="center"><?php echo $no; ?></td>
                <td><?php echo htmlspecialchars(substr($data['training_name'], 0, 30)) . (strlen($data['training_name']) > 30 ? '...' : ''); ?></td>
                <td><?php echo htmlspecialchars(substr($data['participant_name'], 0, 20)) . (strlen($data['participant_name']) > 20 ? '...' : ''); ?></td>
                <td><?php echo htmlspecialchars(substr($data['position'], 0, 15)) . (strlen($data['position']) > 15 ? '...' : ''); ?></td>
                <td><?php echo htmlspecialchars(substr($data['work_unit'], 0, 15)) . (strlen($data['work_unit']) > 15 ? '...' : ''); ?></td>
                <td class="center"><?php echo $training_date; ?></td>
                <td><?php echo htmlspecialchars(substr($data['instructor'], 0, 15)) . (strlen($data['instructor']) > 15 ? '...' : ''); ?></td>
                <td><?php echo htmlspecialchars(substr($data['location'], 0, 15)) . (strlen($data['location']) > 15 ? '...' : ''); ?></td>
                <td class="center"><?php echo $data['fasilitator_persiapan']; ?></td>
                <td class="center"><?php echo $data['fasilitator_materi']; ?></td>
                <td class="center"><?php echo $data['waktu_training']; ?></td>
                <td class="center"><?php echo $data['training_interaktif']; ?></td>
                <td class="center"><?php echo $data['fasilitas_tempat']; ?></td>
                <td class="center"><?php echo $data['peralatan_training']; ?></td>
                <td class="center number <?php echo $reaction_class; ?>"><?php echo $reaction_average_rounded; ?></td>
                <td class="center"><?php echo $data['ilmu_baru']; ?></td>
                <td class="center"><?php echo $data['memahami_tujuan']; ?></td>
                <td class="center"><?php echo $data['sesuai_harapan']; ?></td>
                <td class="center"><?php echo $data['bermanfaat']; ?></td>
                <td class="center"><?php echo $data['kualitas_kerja']; ?></td>
                <td class="center"><?php echo $data['relevan_pekerjaan']; ?></td>
                <td class="center number <?php echo $learning_class; ?>"><?php echo $learning_average_rounded; ?></td>
            </tr>
            <?php 
            $no++;
            endforeach; 
            ?>
        </tbody>
    </table>
    
    <!-- Tabel Saran/Masukan terpisah -->
    <div style="page-break-before: always;">
        <div class="header">
            <h2>SARAN DAN MASUKAN</h2>
        </div>
        
        <table>
            <thead>
                <tr>
                    <th style="width: 5%;">No</th>
                    <th style="width: 25%;">Nama Training</th>
                    <th style="width: 20%;">Peserta</th>
                    <th style="width: 50%;">Saran/Masukan</th>
                </tr>
            </thead>
            <tbody>
                <?php 
                $no = 1;
                foreach ($evaluation_data as $data): 
                    if (!empty(trim($data['saran_masukan']))) :
                ?>
                <tr>
                    <td class="center"><?php echo $no; ?></td>
                    <td><?php echo htmlspecialchars($data['training_name']); ?></td>
                    <td><?php echo htmlspecialchars($data['participant_name']); ?></td>
                    <td><?php echo htmlspecialchars($data['saran_masukan']); ?></td>
                </tr>
                <?php 
                    $no++;
                    endif;
                endforeach; 
                ?>
            </tbody>
        </table>
    </div>
    
    <div class="footer">
        <p>Diekspor pada: <?php echo date('d-m-Y H:i:s'); ?></p>
        <p>E-Learning System Pondok Indah Mall</p>
        <p><em>Keterangan: FP=Fasilitator Persiapan, FM=Fasilitator Materi, WT=Waktu Training, TI=Training Interaktif, FT=Fasilitas Tempat, PT=Peralatan Training, Avg R=Rata-rata Reaksi, IB=Ilmu Baru, MT=Memahami Tujuan, SH=Sesuai Harapan, BM=Bermanfaat, KK=Kualitas Kerja, RP=Relevan Pekerjaan, Avg L=Rata-rata Pembelajaran</em></p>
    </div>
    
    <script>
        // Auto print when page loads
        window.onload = function() {
            window.print();
        }
    </script>
</body>
</html>
