<?php
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

require_once 'koneksi.php';

// Cek login
checkLogin();

$user_id = $_SESSION['user_id'];
$role = $_SESSION['role'];

// Pastikan user adalah trainer atau admin
if (!isset($role) || ($role !== 'trainer' && $role !== 'admin')) {
    header("Location: login.php?error=Anda tidak memiliki izin untuk mengakses halaman ini");
    exit();
}

// Ambil parameter pencarian
$search_term = isset($_GET['search']) ? trim($_GET['search']) : '';

if (empty($search_term)) {
    header("Location: data_evaluasi.php?error=Parameter pencarian tidak ditemukan");
    exit();
}

// Query untuk mengambil data evaluasi berdasarkan pencarian
$stmt = $koneksi->prepare("
    SELECT 
        id,
        training_name,
        instructor,
        location,
        participant_name,
        position,
        work_unit,
        training_date,
        fasilitator_persiapan,
        fasilitator_materi,
        waktu_training,
        training_interaktif,
        fasilitas_tempat,
        peralatan_training,
        ilmu_baru,
        memahami_tujuan,
        sesuai_harapan,
        bermanfaat,
        kualitas_kerja,
        relevan_pekerjaan,
        saran_masukan,
        created_at
    FROM 
        evaluasi_training
    WHERE 
        training_name LIKE ?
    ORDER BY 
        created_at DESC
");

$search_param = "%" . $search_term . "%";
$stmt->bind_param("s", $search_param);
$stmt->execute();
$result = $stmt->get_result();

$evaluation_data = [];
while ($row = $result->fetch_assoc()) {
    $evaluation_data[] = $row;
}
$stmt->close();

if (empty($evaluation_data)) {
    header("Location: data_evaluasi.php?error=Tidak ada data untuk diekspor");
    exit();
}

// Set header untuk download Excel
header('Content-Type: application/vnd.ms-excel');
header('Content-Disposition: attachment;filename="Data_Evaluasi_Training_' . date('Y-m-d_H-i-s') . '.xls"');
header('Cache-Control: max-age=0');

// Mulai output Excel
echo '<html xmlns:o="urn:schemas-microsoft-com:office:office" xmlns:x="urn:schemas-microsoft-com:office:excel" xmlns="http://www.w3.org/TR/REC-html40">';
echo '<head>';
echo '<meta http-equiv="Content-Type" content="text/html; charset=utf-8">';
echo '<style>';
echo 'table { border-collapse: collapse; width: 100%; }';
echo 'th, td { border: 1px solid #000; padding: 8px; text-align: left; }';
echo 'th { background-color: #4CAF50; color: white; font-weight: bold; }';
echo '.center { text-align: center; }';
echo '.number { text-align: right; }';
echo '</style>';
echo '</head>';
echo '<body>';

// Header laporan
echo '<h2 style="text-align: center; margin-bottom: 20px;">DATA EVALUASI TRAINING</h2>';
echo '<h3 style="text-align: center; margin-bottom: 20px;">PONDOK INDAH MALL</h3>';
echo '<p><strong>Tanggal Export:</strong> ' . date('d-m-Y H:i:s') . '</p>';
echo '<p><strong>Total Data:</strong> ' . count($evaluation_data) . ' evaluasi</p>';
echo '<br>';

// Tabel data
echo '<table>';
echo '<thead>';
echo '<tr>';
echo '<th>No</th>';
echo '<th>Nama Training</th>';
echo '<th>Peserta</th>';
echo '<th>Jabatan</th>';
echo '<th>Unit Kerja</th>';
echo '<th>Tanggal Training</th>';
echo '<th>Instruktur</th>';
echo '<th>Lokasi</th>';
echo '<th>Persiapan Fasilitator</th>';
echo '<th>Materi Fasilitator</th>';
echo '<th>Waktu Training</th>';
echo '<th>Training Interaktif</th>';
echo '<th>Fasilitas Tempat</th>';
echo '<th>Peralatan Training</th>';
echo '<th>Rata-rata Reaksi</th>';
echo '<th>Ilmu Baru</th>';
echo '<th>Memahami Tujuan</th>';
echo '<th>Sesuai Harapan</th>';
echo '<th>Bermanfaat</th>';
echo '<th>Kualitas Kerja</th>';
echo '<th>Relevan Pekerjaan</th>';
echo '<th>Rata-rata Pembelajaran</th>';
echo '<th>Saran/Masukan</th>';
echo '</tr>';
echo '</thead>';
echo '<tbody>';

$no = 1;
foreach ($evaluation_data as $data) {
    // Hitung rata-rata Reaksi (field 1-6)
    $reaction_ratings = [
        $data['fasilitator_persiapan'],
        $data['fasilitator_materi'],
        $data['waktu_training'],
        $data['training_interaktif'],
        $data['fasilitas_tempat'],
        $data['peralatan_training']
    ];
    $reaction_average = array_sum($reaction_ratings) / count($reaction_ratings);
    $reaction_average_rounded = round($reaction_average, 2);
    
    // Hitung rata-rata Pembelajaran (field 7-12)
    $learning_ratings = [
        $data['ilmu_baru'],
        $data['memahami_tujuan'],
        $data['sesuai_harapan'],
        $data['bermanfaat'],
        $data['kualitas_kerja'],
        $data['relevan_pekerjaan']
    ];
    $learning_average = array_sum($learning_ratings) / count($learning_ratings);
    $learning_average_rounded = round($learning_average, 2);
    
    // Format tanggal
    $training_date = date('d-m-Y', strtotime($data['training_date']));
    
    echo '<tr>';
    echo '<td class="center">' . $no . '</td>';
    echo '<td>' . htmlspecialchars($data['training_name']) . '</td>';
    echo '<td>' . htmlspecialchars($data['participant_name']) . '</td>';
    echo '<td>' . htmlspecialchars($data['position']) . '</td>';
    echo '<td>' . htmlspecialchars($data['work_unit']) . '</td>';
    echo '<td class="center">' . $training_date . '</td>';
    echo '<td>' . htmlspecialchars($data['instructor']) . '</td>';
    echo '<td>' . htmlspecialchars($data['location']) . '</td>';
    echo '<td class="center">' . $data['fasilitator_persiapan'] . '</td>';
    echo '<td class="center">' . $data['fasilitator_materi'] . '</td>';
    echo '<td class="center">' . $data['waktu_training'] . '</td>';
    echo '<td class="center">' . $data['training_interaktif'] . '</td>';
    echo '<td class="center">' . $data['fasilitas_tempat'] . '</td>';
    echo '<td class="center">' . $data['peralatan_training'] . '</td>';
    echo '<td class="center number"><strong>' . $reaction_average_rounded . '</strong></td>';
    echo '<td class="center">' . $data['ilmu_baru'] . '</td>';
    echo '<td class="center">' . $data['memahami_tujuan'] . '</td>';
    echo '<td class="center">' . $data['sesuai_harapan'] . '</td>';
    echo '<td class="center">' . $data['bermanfaat'] . '</td>';
    echo '<td class="center">' . $data['kualitas_kerja'] . '</td>';
    echo '<td class="center">' . $data['relevan_pekerjaan'] . '</td>';
    echo '<td class="center number"><strong>' . $learning_average_rounded . '</strong></td>';
    echo '<td>' . htmlspecialchars($data['saran_masukan']) . '</td>';
    echo '</tr>';
    $no++;
}

echo '</tbody>';
echo '</table>';

// Footer
echo '<br><br>';
echo '<p><em>Diekspor pada: ' . date('d-m-Y H:i:s') . '</em></p>';
echo '<p><em>E-Learning System Pondok Indah Mall</em></p>';

echo '</body>';
echo '</html>';
?>
