<?php
require_once 'koneksi.php';

// Cek login
checkLogin();

$user_id = $_SESSION['user_id'];
$role = $_SESSION['role'];
$nik_karyawan = $_SESSION['nik_karyawan'];

// Ambil informasi user menggunakan prepared statement
if ($role == 'trainer') {
    $stmt = $koneksi->prepare("SELECT * FROM trainers WHERE id = ?");
} elseif ($role == 'iss') {
    $stmt = $koneksi->prepare("SELECT * FROM iss WHERE id = ?");
} else {
    $stmt = $koneksi->prepare("SELECT * FROM peserta WHERE id = ?");
}
$stmt->bind_param("i", $user_id);
$stmt->execute();
$result = $stmt->get_result();
$user = $result->fetch_assoc();
$stmt->close();

// Ambil jumlah kegiatan training
$stmt = $koneksi->prepare("SELECT COUNT(*) as total_training FROM trainings");
$stmt->execute();
$result = $stmt->get_result();
$total_training = $result->fetch_assoc()['total_training'];
$stmt->close();

// Ambil jumlah peserta dan ISS
$stmt_peserta = $koneksi->prepare("SELECT COUNT(*) as total_peserta FROM peserta");
$stmt_peserta->execute();
$result_peserta = $stmt_peserta->get_result();
$total_peserta_count = $result_peserta->fetch_assoc()['total_peserta'];
$stmt_peserta->close();

$stmt_iss = $koneksi->prepare("SELECT COUNT(*) as total_iss FROM iss");
$stmt_iss->execute();
$result_iss = $stmt_iss->get_result();
$total_iss_count = $result_iss->fetch_assoc()['total_iss'];
$stmt_iss->close();

$total_peserta = $total_peserta_count + $total_iss_count;

// Ambil jumlah trainer
$stmt = $koneksi->prepare("SELECT COUNT(*) as total_trainers FROM trainers");
$stmt->execute();
$result = $stmt->get_result();
$total_trainers = $result->fetch_assoc()['total_trainers'];
$stmt->close();

// Ambil tahun yang dipilih dari parameter GET, default ke tahun saat ini
$selected_year = isset($_GET['year']) ? (int)$_GET['year'] : date('Y');

// Ambil data untuk Line Chart (jumlah training per bulan)
$all_months_labels = [];
$all_months_data = array_fill(0, 12, 0); // Inisialisasi dengan 0 untuk semua 12 bulan

// Buat label untuk semua 12 bulan (hanya nama bulan 3 huruf)
$month_names = [
    1 => 'Jan', 2 => 'Feb', 3 => 'Mar', 4 => 'Apr', 
    5 => 'Mei', 6 => 'Jun', 7 => 'Jul', 8 => 'Agu', 
    9 => 'Sep', 10 => 'Okt', 11 => 'Nov', 12 => 'Des'
];

for ($i = 1; $i <= 12; $i++) {
    $all_months_labels[] = $month_names[$i];
}

// Ambil data training aktual dari database berdasarkan tahun yang dipilih
$stmt = $koneksi->prepare("
    SELECT DATE_FORMAT(created_at, '%Y-%m') AS month_year, COUNT(*) AS training_count
    FROM trainings
    WHERE YEAR(created_at) = ?
    GROUP BY DATE_FORMAT(created_at, '%Y-%m')
    ORDER BY month_year ASC
");
$stmt->bind_param("i", $selected_year);
$stmt->execute();
$result = $stmt->get_result();

$fetched_training_data = [];
while ($row = $result->fetch_assoc()) {
    $fetched_training_data[$row['month_year']] = $row['training_count'];
}
$stmt->close();

// Isi all_months_data dengan data yang diambil
foreach ($all_months_labels as $index => $label) {
    $month_num = $index + 1;
    $month_year_key = $selected_year . '-' . str_pad($month_num, 2, '0', STR_PAD_LEFT);
    if (isset($fetched_training_data[$month_year_key])) {
        $all_months_data[$index] = $fetched_training_data[$month_year_key];
    }
}

$labels = $all_months_labels;
$training_data = $all_months_data;

// Ambil daftar tahun yang tersedia dari database untuk dropdown
$stmt = $koneksi->prepare("
    SELECT DISTINCT YEAR(created_at) as year 
    FROM trainings 
    WHERE created_at IS NOT NULL 
    ORDER BY year DESC
");
$stmt->execute();
$result = $stmt->get_result();
$available_years = [];
while ($row = $result->fetch_assoc()) {
    $available_years[] = $row['year'];
}
$stmt->close();

// Jika tidak ada data, tambahkan tahun saat ini
if (empty($available_years)) {
    $available_years[] = date('Y');
}

// Set current page untuk highlight menu
$current_page = basename($_SERVER['PHP_SELF']);
?>
<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Dashboard E-Learning</title>
    <link rel="icon" type="image/png" href="image/icon.png">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.10.0/font/bootstrap-icons.css">
    <style>
        :root {
            --soft-ui-primary-start: #00C4CC; /* Teal from the image */
            --soft-ui-primary-end: #CB0C9F; /* Purple from the image */
            --soft-ui-secondary: #67748E; /* Kept as secondary color */
            --soft-ui-info: #17C1E8; /* Kept as info color */
            --soft-ui-success: #82D616; /* Kept as success color */
            --soft-ui-warning: #FB8C00; /* Kept as warning color */
            --soft-ui-danger: #EA0606; /* Kept as danger color */
            --soft-ui-light: #E9ECEF; /* Kept as light color */
            --soft-ui-dark: #344767; /* Kept as dark color */
            --soft-ui-white: #FFFFFF;
            --soft-ui-gray-100: #F8F9FA;
            --soft-ui-gray-200: #E9ECEF;
            --soft-ui-gray-300: #DEE2E6;
            --soft-ui-gray-400: #CED4DA;
            --soft-ui-gray-500: #ADB5BD;
            --soft-ui-gray-600: #6C757D;
            --soft-ui-gray-700: #495057;
            --soft-ui-gray-800: #343A40;
            --soft-ui-gray-900: #212529;
        }

        html, body {
            height: 100%;
            margin: 0;
            font-family: 'Open Sans', sans-serif;
            background-color: var(--soft-ui-gray-100);
        }
        
        body {
            overflow-x: hidden;
            display: flex;
            flex-direction: column;
        }
        
        .navbar-top {
            position: fixed;
            top: 0;
            width: 100%;
            z-index: 1100;
            background: var(--soft-ui-white);
            border-bottom: 1px solid var(--soft-ui-gray-200);
            box-shadow: 0 2px 12px rgba(0, 0, 0, 0.05);
            padding: 0.75rem 1.5rem;
        }
        
        .navbar-top .container-fluid {
            display: flex;
            align-items: center;
            justify-content: space-between;
            flex-wrap: nowrap;
            position: relative;
        }
        
        .navbar-logo {
            height: 40px;
            width: auto;
            margin-right: 15px;
        }
        
        .navbar-title {
            position: absolute;
            left: 50%;
            transform: translateX(-50%);
            font-size: 1.3rem;
            color: var(--soft-ui-dark);
            font-weight: 700;
            text-align: center;
            white-space: nowrap;
            pointer-events: none;
        }

        .navbar-title-mobile {
            display: none;
            font-size: 0.85rem;
            color: var(--soft-ui-dark);
            font-weight: 700;
            text-align: center;
            line-height: 1.2;
            flex: 1;
            margin: 0 10px;
        }

        .navbar-title-mobile .line1 {
            display: block;
        }

        .navbar-title-mobile .line2 {
            display: block;
            font-size: 0.8rem;
        }
        
        .navbar-brand {
            font-size: 1.2rem;
            color: var(--soft-ui-dark);
            font-weight: 700;
            display: flex;
            align-items: center;
            z-index: 1;
        }

        .navbar-nav .nav-item .nav-link {
            color: var(--soft-ui-secondary);
            font-weight: 600;
            padding: 0.5rem 1rem;
            transition: all 0.2s ease-in-out;
        }

        .navbar-nav .nav-item .nav-link:hover {
            color: var(--soft-ui-primary-end);
        }

        .navbar-nav .nav-item .nav-link.active {
            color: var(--soft-ui-primary-end);
        }

        .navbar-nav .dropdown-menu {
            position: absolute;
            top: 100%;
            right: 0;
            left: auto;
            z-index: 1300;
            background-color: var(--soft-ui-white);
            border: 1px solid var(--soft-ui-gray-200);
            border-radius: 0.5rem;
            box-shadow: 0 4px 12px rgba(0, 0, 0, 0.15);
            min-width: 160px;
            margin-top: 0.125rem;
        }

        .navbar-nav .dropdown-item {
            color: var(--soft-ui-secondary);
            padding: 0.5rem 1rem;
            font-weight: 500;
            transition: all 0.2s ease-in-out;
        }

        .navbar-nav .dropdown-item:hover {
            background-color: var(--soft-ui-gray-200);
            color: var(--soft-ui-dark);
        }

        .navbar-nav .dropdown-item.active {
            background-color: var(--soft-ui-primary-end);
            color: var(--soft-ui-white);
        }
        
        .sidebar {
            min-height: 100vh;
            width: 250px;
            position: fixed;
            top: 0;
            left: 0;
            z-index: 1000;
            background: var(--soft-ui-white);
            color: var(--soft-ui-dark);
            padding-top: 70px;
            transition: all 0.3s ease-in-out;
            border-right: 1px solid var(--soft-ui-gray-200);
            box-shadow: 4px 0 15px rgba(0, 0, 0, 0.05);
            border-radius: 0 1rem 1rem 0;
        }

        .content {
            margin-left: 250px;
            margin-top: 0;
            padding: 20px;
            padding-top: 90px;
            transition: all 0.3s ease-in-out;
            flex-grow: 1;
        }
        
        .hamburger-mobile {
            display: none;
            background: none;
            border: none;
            color: var(--soft-ui-dark);
            font-size: 1.5rem;
            cursor: pointer;
            margin-right: 15px;
            transition: all 0.3s ease;
            z-index: 1;
        }
        
        .hamburger-mobile:focus {
            outline: none;
        }
        
        .sidebar-overlay {
            display: none;
            position: fixed;
            top: 0;
            left: 0;
            right: 0;
            bottom: 0;
            background-color: rgba(0, 0, 0, 0.4);
            z-index: 999;
        }
        
        .profile-section {
            text-align: center;
            padding: 15px 20px;
            border-bottom: 1px solid var(--soft-ui-gray-200);
            background: var(--soft-ui-white);
            border-radius: 0.75rem;
            box-shadow: 0 4px 15px rgba(0, 0, 0, 0.05);
        }
        
        .profile-photo {
            width: 80px;
            height: 80px;
            border-radius: 50%;
            object-fit: cover;
            border: 2px solid var(--soft-ui-gray-300);
            margin: 0 auto 10px;
            display: block;
            box-shadow: 0 4px 10px rgba(0, 0, 0, 0.08);
        }
        
        .profile-photo-placeholder {
            width: 80px;
            height: 80px;
            border-radius: 50%;
            background: var(--soft-ui-gray-400);
            display: flex;
            align-items: center;
            justify-content: center;
            margin: 0 auto 10px;
            border: 2px solid var(--soft-ui-gray-300);
            box-shadow: 0 4px 10px rgba(0, 0, 0, 0.08);
        }
        
        .profile-photo-placeholder i {
            font-size: 2rem;
            color: var(--soft-ui-white);
        }
        
        .profile-name {
            font-size: 1.1rem;
            font-weight: 600;
            color: var(--soft-ui-dark);
            margin-bottom: 5px;
            word-wrap: break-word;
        }
        
        .profile-info {
            font-size: 0.9rem;
            font-weight: 400;
            color: var(--soft-ui-secondary);
            margin-bottom: 3px;
        }
        
        .sidebar .nav-link {
            color: var(--soft-ui-secondary);
            padding: 0.75rem 1rem;
            border-radius: 0.5rem;
            margin: 0.25rem 0.75rem;
            transition: all 0.2s ease-in-out;
            font-weight: 600;
            display: flex;
            align-items: center;
        }
        
        .sidebar .nav-link:hover {
            background: linear-gradient(90deg, rgba(0, 196, 204, 0.1), rgba(203, 12, 159, 0.1));
            color: var(--soft-ui-dark);
        }
        
        .sidebar .nav-link.active {
            background: linear-gradient(195deg, var(--soft-ui-primary-start), var(--soft-ui-primary-end));
            color: var(--soft-ui-white) !important;
            box-shadow: 0 4px 12px rgba(0, 0, 0, 0.1);
        }

        .sidebar .nav-link.active i {
            color: var(--soft-ui-white);
        }
        
        .sidebar .nav-link i {
            font-size: 1.2rem;
            margin-right: 10px;
            color: var(--soft-ui-secondary);
            transition: all 0.2s ease-in-out;
        }

        .sidebar .nav-item.dropdown .dropdown-menu {
            background-color: var(--soft-ui-white);
            border: none;
            box-shadow: 0 4px 12px rgba(0, 0, 0, 0.08);
            border-radius: 0.5rem;
            padding: 0.5rem 0;
            margin-top: 0.25rem;
        }

        .sidebar .nav-item.dropdown .dropdown-item {
            color: var(--soft-ui-secondary);
            padding: 0.5rem 1.5rem;
            font-weight: 500;
            transition: all 0.2s ease-in-out;
        }

        .sidebar .nav-item.dropdown .dropdown-item:hover {
            background: linear-gradient(90deg, rgba(0, 196, 204, 0.1), rgba(203, 12, 159, 0.1));
            color: var(--soft-ui-dark);
        }

        .sidebar .nav-item.dropdown .dropdown-item.active {
            background: linear-gradient(195deg, var(--soft-ui-primary-start), var(--soft-ui-primary-end));
            color: var(--soft-ui-white);
        }

        .sidebar .nav-item:not(:last-child) {
            border-bottom: none;
        }
        
        .soft-ui-card {
            background-color: var(--soft-ui-white);
            border-radius: 0.75rem;
            box-shadow: 0 4px 12px rgba(0, 0, 0, 0.05);
            transition: all 0.2s ease-in-out;
            position: relative;
        }

        .soft-ui-card:hover {
            transform: translateY(-3px);
            box-shadow: 0 6px 16px rgba(0, 0, 0, 0.08);
        }

        .icon-shape {
            background: linear-gradient(195deg, var(--soft-ui-primary-start), var(--soft-ui-primary-end));
            width: 48px;
            height: 48px;
            border-radius: 0.75rem;
            display: flex;
            align-items: center;
            justify-content: center;
            box-shadow: 0 4px 20px 0 rgba(0, 196, 204, 0.14), 0 7px 10px -5px rgba(203, 12, 159, 0.4);
            z-index: 1;
            color: var(--soft-ui-white);
        }

        .icon-shape i {
            font-size: 1.5rem;
            opacity: 1;
        }

        .text-secondary {
            color: var(--soft-ui-secondary) !important;
        }

        .text-dark {
            color: var(--soft-ui-dark) !important;
        }

        .font-weight-bold {
            font-weight: 600 !important;
        }

        .font-weight-bolder {
            font-weight: 700 !important;
        }

        .horizontal.dark {
            background-color: transparent;
            border-top: 1px solid var(--soft-ui-gray-200);
            margin: 1rem 0;
        }

        .welcome-section {
            margin-bottom: 40px;
            padding: 50px 40px;
            background: linear-gradient(195deg, rgba(0, 196, 204, 0.05), rgba(203, 12, 159, 0.05));
            border-radius: 1rem;
            box-shadow: 0 8px 20px rgba(0, 0, 0, 0.08);
            border: 1px solid var(--soft-ui-gray-200);
            backdrop-filter: blur(10px);
            position: relative;
            overflow: hidden;
        }

        .welcome-section::before {
            content: '';
            position: absolute;
            top: -50%;
            left: -50%;
            width: 200%;
            height: 200%;
            background: radial-gradient(circle, rgba(0, 196, 204, 0.03) 0%, transparent 70%);
            animation: float 6s ease-in-out infinite;
            z-index: 0;
        }

        .welcome-section > * {
            position: relative;
            z-index: 1;
        }

        .welcome-content {
            display: flex;
            align-items: center;
            gap: 40px;
            min-height: 300px;
        }

        .welcome-text {
            flex: 1;
            text-align: left;
        }
        
        .welcome-title {
            font-size: 2.8rem;
            font-weight: 700;
            color: var(--soft-ui-dark);
            margin-bottom: 20px;
            background: linear-gradient(195deg, var(--soft-ui-primary-start), var(--soft-ui-primary-end));
            -webkit-background-clip: text;
            -webkit-text-fill-color: transparent;
            background-clip: text;
            line-height: 1.2;
        }

        .welcome-subtitle {
            font-size: 1.2rem;
            color: var(--soft-ui-secondary);
            margin-bottom: 30px;
            font-weight: 500;
            line-height: 1.6;
        }
        
        .join-training-btn {
            background: linear-gradient(195deg, var(--soft-ui-primary-start), var(--soft-ui-primary-end));
            border: none;
            border-radius: 0.75rem;
            padding: 1rem 2.5rem;
            font-size: 1.1rem;
            font-weight: 700;
            color: var(--soft-ui-white);
            text-decoration: none;
            display: inline-flex;
            align-items: center;
            transition: all 0.3s ease;
            box-shadow: 0 8px 25px rgba(0, 196, 204, 0.3);
            text-transform: uppercase;
            letter-spacing: 1px;
            position: relative;
            overflow: hidden;
        }

        .join-training-btn::before {
            content: '';
            position: absolute;
            top: 0;
            left: -100%;
            width: 100%;
            height: 100%;
            background: linear-gradient(90deg, transparent, rgba(255, 255, 255, 0.2), transparent);
            transition: left 0.5s;
        }

        .join-training-btn:hover::before {
            left: 100%;
        }
        
        .join-training-btn:hover {
            background: linear-gradient(195deg, var(--soft-ui-primary-end), var(--soft-ui-primary-start));
            transform: translateY(-5px);
            box-shadow: 0 12px 35px rgba(203, 12, 159, 0.4);
            color: var(--soft-ui-white);
        }
        
        .join-training-btn i {
            margin-right: 12px;
            font-size: 1.3rem;
        }

        .welcome-image {
            flex: 0 0 300px;
            display: flex;
            justify-content: center;
            align-items: center;
        }

        .rocket-image {
            max-width: 100%;
            height: auto;
            max-height: 280px;
            filter: drop-shadow(0 10px 30px rgba(0, 196, 204, 0.2));
            animation: rocketFloat 1s ease-in-out infinite;
        }

        @keyframes float {
            0%, 100% { transform: translateY(0px); }
            50% { transform: translateY(-10px); }
        }

        @keyframes rocketFloat {
            0%, 100% { transform: translateY(0px); }
            50% { transform: translateY(-15px); }
        }
        
        .chart-card {
            background: var(--soft-ui-white);
            border-radius: 1rem;
            box-shadow: 0 8px 32px rgba(0, 0, 0, 0.08);
            transition: all 0.4s cubic-bezier(0.175, 0.885, 0.32, 1.275);
            position: relative;
            overflow: hidden;
        }
        
        .chart-card::before {
            content: '';
            position: absolute;
            top: 0;
            left: 0;
            right: 0;
            height: 4px;
            background: linear-gradient(90deg, var(--soft-ui-primary-start), var(--soft-ui-primary-end));
            z-index: 1;
        }
        
        .chart-card:hover {
            transform: translateY(-8px);
            box-shadow: 0 16px 48px rgba(0, 0, 0, 0.12);
        }

        .chart-header {
            background: linear-gradient(135deg, rgba(0, 196, 204, 0.02), rgba(203, 12, 159, 0.02));
            color: var(--soft-ui-dark);
            font-size: 1.4rem;
            font-weight: 700;
            text-align: left;
            padding: 2rem 2rem 1.5rem;
            border-bottom: 1px solid rgba(0, 196, 204, 0.1);
            border-top-left-radius: 1rem;
            border-top-right-radius: 1rem;
            display: flex;
            justify-content: space-between;
            align-items: center;
            position: relative;
        }

        .chart-header .chart-title {
            display: flex;
            align-items: center;
            gap: 12px;
        }

        .chart-header .chart-title i {
            font-size: 1.5rem;
            background: linear-gradient(135deg, var(--soft-ui-primary-start), var(--soft-ui-primary-end));
            -webkit-background-clip: text;
            -webkit-text-fill-color: transparent;
            background-clip: text;
        }
        
        .chart-header::after {
            display: none;
        }
        
        .chart-container {
            position: relative;
            height: 400px;
            padding: 2rem;
            background: linear-gradient(135deg, rgba(255, 255, 255, 0.9), rgba(248, 250, 252, 0.9));
        }

        .year-filter {
            display: flex;
            align-items: center;
            gap: 12px;
            background: rgba(255, 255, 255, 0.8);
            padding: 8px 16px;
            border-radius: 12px;
            backdrop-filter: blur(10px);
            border: 1px solid rgba(0, 196, 204, 0.2);
        }

        .year-filter select {
            background: linear-gradient(135deg, var(--soft-ui-white), rgba(248, 250, 252, 0.9));
            border: 2px solid rgba(0, 196, 204, 0.2);
            border-radius: 8px;
            padding: 8px 16px;
            font-size: 0.9rem;
            font-weight: 600;
            color: var(--soft-ui-dark);
            cursor: pointer;
            transition: all 0.3s cubic-bezier(0.4, 0, 0.2, 1);
            box-shadow: 0 2px 8px rgba(0, 0, 0, 0.05);
        }

        .year-filter select:focus {
            outline: none;
            border-color: var(--soft-ui-primary-start);
            box-shadow: 0 0 0 3px rgba(0, 196, 204, 0.15), 0 4px 12px rgba(0, 0, 0, 0.1);
            transform: translateY(-1px);
        }

        .year-filter select:hover {
            border-color: var(--soft-ui-primary-start);
            transform: translateY(-1px);
            box-shadow: 0 4px 12px rgba(0, 0, 0, 0.1);
        }

        .year-filter label {
            font-size: 0.9rem;
            font-weight: 600;
            color: var(--soft-ui-secondary);
            margin: 0;
            text-shadow: 0 1px 2px rgba(255, 255, 255, 0.8);
        }
        
        footer {
            background: var(--soft-ui-white);
            color: var(--soft-ui-secondary);
            border-top: 1px solid var(--soft-ui-gray-200);
            padding: 1rem 0;
            text-align: center;
            flex-shrink: 0;
            margin-top: 2rem;
        }
        
        .animate-fade-in {
            animation: fadeIn 0.5s ease-in-out;
        }
        
        @keyframes fadeIn {
            from { opacity: 0; transform: translateY(10px); }
            to { opacity: 1; transform: translateY(0); }
        }

        @media (max-width: 768px) {
            .sidebar {
                margin-left: -250px;
                border-radius: 0;
                padding-top: 90px;
            }
            .sidebar-active {
                margin-left: 0;
            }
            .content {
                margin-left: 0;
                padding-top: 100px;
            }
            
            .navbar-title {
                display: none;
            }
            .navbar-logo {
                display: none;
            }
            
            .navbar-title-mobile {
                display: block;
            }
            
            .hamburger-mobile {
                display: block;
            }
            .navbar-search {
                display: none;
            }
            .navbar-nav {
                position: static;
            }
            .navbar-nav .dropdown-menu {
                position: absolute;
                right: 0;
                left: auto;
                z-index: 1300;
            }
            .soft-ui-card {
                margin-bottom: 1rem;
            }
            .chart-container {
                height: 300px;
                padding: 1.5rem;
            }

            .chart-header {
                flex-direction: column;
                gap: 15px;
                align-items: flex-start;
                padding: 1.5rem;
            }

            .year-filter {
                align-self: stretch;
                justify-content: space-between;
            }

            .welcome-content {
                flex-direction: column;
                text-align: center;
                gap: 30px;
                min-height: auto;
            }

            .welcome-text {
                text-align: center;
            }

            .welcome-title {
                font-size: 2rem;
            }
            .welcome-subtitle {
                font-size: 1rem;
            }
            .join-training-btn {
                padding: 0.8rem 2rem;
                font-size: 1rem;
            }
            .welcome-section {
                padding: 30px 20px;
                margin-bottom: 30px;
            }

            .welcome-image {
                flex: none;
                order: -1;
            }

            .rocket-image {
                max-height: 200px;
            }
            
            .navbar-top {
                padding: 0.5rem 1rem;
                min-height: 70px;
            }

            .profile-photo, .profile-photo-placeholder {
                width: 60px;
                height: 60px;
            }
            .profile-photo-placeholder i {
                font-size: 1.5rem;
            }
            .profile-name {
                font-size: 1rem;
            }
            .profile-info {
                font-size: 0.8rem;
            }
        }

        @media (max-width: 576px) {
            .navbar-top {
                padding: 0.5rem 1rem;
                min-height: 70px;
            }
            .navbar-title-mobile {
                font-size: 0.8rem;
            }
            .navbar-title-mobile .line2 {
                font-size: 0.75rem;
            }
            .welcome-title {
                font-size: 1.7rem;
            }
            .welcome-subtitle {
                font-size: 0.9rem;
            }
            .join-training-btn {
                padding: 0.7rem 1.5rem;
                font-size: 0.9rem;
            }
            .welcome-section {
                padding: 25px 15px;
            }

            .rocket-image {
                max-height: 150px;
            }

            .profile-photo, .profile-photo-placeholder {
                width: 50px;
                height: 50px;
            }
            .profile-photo-placeholder i {
                font-size: 1.2rem;
            }
            .profile-name {
                font-size: 0.9rem;
            }
            .profile-info {
                font-size: 0.7rem;
            }
        }
    </style>
</head>
<body>
    <nav class="navbar navbar-expand-lg navbar-top">
        <div class="container-fluid">
            <button class="hamburger-mobile d-md-none" type="button" id="sidebarToggle">
                <i class="bi bi-list"></i>
            </button>
            <a class="navbar-brand d-none d-md-flex" href="#">
                <img src="image/logopim.png" alt="Logo PIM" class="navbar-logo">
            </a>
            <div class="navbar-title d-none d-md-block">
                E-Learning System Pondok Indah Mall
            </div>
            <div class="navbar-title-mobile d-md-none">
                <span class="line1">E-Learning System</span>
                <span class="line2">Pondok Indah Mall</span>
            </div>
            <?php if ($role != 'iss'): ?>
            <ul class="navbar-nav ms-auto mb-2 mb-lg-0">
                <li class="nav-item dropdown">
                    <a class="nav-link dropdown-toggle text-dark" href="#" id="navbarDropdown" role="button" data-bs-toggle="dropdown" aria-expanded="false">
                        <i class="bi bi-person-circle"></i>
                    </a>
                    <ul class="dropdown-menu dropdown-menu-end">
                        <li><a class="dropdown-item <?php echo ($current_page == 'profile.php') ? 'active' : ''; ?>" href="profile.php">Profile</a></li>
                        <li><hr class="dropdown-divider"></li>
                        <li><a class="dropdown-item" href="logout.php">Logout</a></li>
                    </ul>
                </li>
            </ul>
            <?php endif; ?>
        </div>
    </nav>

    <div class="sidebar-overlay" id="sidebarOverlay"></div>

    <div class="sidebar border-end" id="sidebar">
        <div class="profile-section">
            <?php if (!empty($user['foto_profil'])): ?>
                <img src="Uploads/profiles/<?php echo htmlspecialchars($user['foto_profil']); ?>" alt="Foto Profil" class="profile-photo">
            <?php else: ?>
                <div class="profile-photo-placeholder">
                    <i class="bi bi-person-circle"></i>
                </div>
            <?php endif; ?>
            <div class="profile-name"><?php echo htmlspecialchars($user['nama_lengkap']); ?></div>
            <div class="profile-info"><?php echo htmlspecialchars($user['jabatan'] ?? 'Tidak ada jabatan'); ?></div>
            <div class="profile-info"><?php echo htmlspecialchars($user['divisi'] ?? 'Tidak ada divisi'); ?></div>
        </div>
        <div class="p-3">
            <h5 class="mb-4 text-dark">Menu</h5>
            <ul class="nav flex-column">
                <li class="nav-item">
                    <a class="nav-link <?php echo ($current_page == 'dashboard.php') ? 'active' : ''; ?>" href="dashboard.php">
                        <i class="bi bi-house-door-fill"></i> Dashboard
                    </a>
                </li>
                <li class="nav-item">
                    <a class="nav-link <?php echo ($current_page == 'materi.php') ? 'active' : ''; ?>" href="materi.php">
                        <i class="bi bi-book"></i> Materi
                    </a>
                </li>
            <?php if ($role == 'trainer'): ?>
    <li class="nav-item dropdown">
        <a class="nav-link dropdown-toggle <?php echo ($current_page == 'add_posttest.php' || $current_page == 'list_posttest.php') ? 'active' : ''; ?>" href="#" id="postTestDropdown" role="button" data-bs-toggle="dropdown" aria-expanded="false">
            <i class="bi bi-clipboard-check"></i> Post Test
        </a>
        <ul class="dropdown-menu" aria-labelledby="postTestDropdown">
            <li><a class="dropdown-item <?php echo ($current_page == 'add_posttest.php') ? 'active' : ''; ?>" href="add_posttest.php">Tambah Post Test</a></li>
            <li><a class="dropdown-item <?php echo ($current_page == 'list_posttest.php') ? 'active' : ''; ?>" href="list_posttest.php">List Post Test</a></li>
        </ul>
    </li>
<?php elseif ($role == 'peserta' || $role == 'iss'): ?>
    <li class="nav-item">
        <a class="nav-link <?php echo ($current_page == 'list_posttest.php') ? 'active' : ''; ?>" href="list_posttest.php">
            <i class="bi bi-clipboard-check"></i> Post Test
        </a>
    </li>
<?php endif; ?>
                <li class="nav-item dropdown">
                    <a class="nav-link dropdown-toggle <?php echo ($current_page == 'add_training.php' || $current_page == 'list_training.php') ? 'active' : ''; ?>" href="#" id="trainingDropdown" role="button" data-bs-toggle="dropdown" aria-expanded="false">
                        <i class="bi bi-journal-text"></i> Training
                    </a>
                    <ul class="dropdown-menu" aria-labelledby="trainingDropdown">
                        <?php if($role == 'trainer'): ?>
                        <li><a class="dropdown-item <?php echo ($current_page == 'add_training.php') ? 'active' : ''; ?>" href="add_training.php">Tambah Kegiatan Training</a></li>
                        <?php endif; ?>
                        <li><a class="dropdown-item <?php echo ($current_page == 'list_training.php') ? 'active' : ''; ?>" href="list_training.php">List Training</a></li>
                    </ul>
                </li>
            <?php if ($role == 'trainer'): ?>
                <li class="nav-item">
                    <a class="nav-link <?php echo ($current_page == 'report.php') ? 'active' : ''; ?>" href="report.php">
                        <i class="bi bi-file-earmark-text"></i> Report
                    </a>
                </li>
                <li class="nav-item">
                    <a class="nav-link <?php echo ($current_page == 'data_evaluasi.php') ? 'active' : ''; ?>" href="data_evaluasi.php">
                        <i class="bi bi-clipboard-data"></i> Data Evaluasi
                    </a>
                </li>
            <?php endif; ?>
            </ul>
        </div>
    </div>

    <div class="content">
        <div class="container-fluid">
            <!-- Welcome Section - Now shows for all user roles including trainer -->
            <div class="welcome-section animate-fade-in">
                <div class="welcome-content">
                    <div class="welcome-text">
                        <h1 class="welcome-title">
                            <i class="bi bi-mortarboard me-3"></i>
                            Selamat Datang di PIM Training
                        </h1>
                        <p class="welcome-subtitle">
                            <?php if ($role == 'trainer'): ?>
                                Kelola dan pantau berbagai program training yang tersedia.<br>
                                Berikan pengalaman pembelajaran terbaik untuk peserta!
                            <?php else: ?>
                                Tingkatkan kemampuan Anda dengan mengikuti berbagai program training yang tersedia.<br>
                                Mulai perjalanan pembelajaran Anda sekarang juga!
                            <?php endif; ?>
                        </p>
                        <a href="list_training.php" class="join-training-btn">
                            <i class="bi bi-play-circle-fill"></i>
                            <?php echo ($role == 'trainer') ? 'Manage Training' : 'Join Training Now'; ?>
                        </a>
                    </div>
                    <div class="welcome-image">
                        <img src="image/rocket-white.png" alt="Rocket Launch" class="rocket-image">
                    </div>
                </div>
            </div>

            <div class="row mt-4">
                <div class="col-xl-3 col-sm-6 mb-xl-0 mb-4">
                    <div class="card soft-ui-card animate-fade-in">
                        <div class="card-body p-3">
                            <div class="row gx-4">
                                <div class="col-8">
                                    <div class="numbers">
                                        <p class="text-sm mb-0 text-capitalize font-weight-bold text-secondary">Kegiatan Training</p>
                                        <h5 class="font-weight-bolder mb-0 text-dark"><?php echo $total_training; ?></h5>
                                    </div>
                                </div>
                                <div class="col-4 text-end">
                                    <div class="icon-shape bg-gradient-primary shadow text-center border-radius-md">
                                        <i class="bi bi-journal-text text-lg opacity-10" aria-hidden="true"></i>
                                    </div>
                                </div>
                            </div>
                            <hr class="horizontal dark my-3">
                        </div>
                    </div>
                </div>
                <div class="col-xl-3 col-sm-6 mb-xl-0 mb-4">
                    <div class="card soft-ui-card animate-fade-in">
                        <div class="card-body p-3">
                            <div class="row gx-4">
                                <div class="col-8">
                                    <div class="numbers">
                                        <p class="text-sm mb-0 text-capitalize font-weight-bold text-secondary">Peserta Terdaftar</p>
                                        <h5 class="font-weight-bolder mb-0 text-dark"><?php echo $total_peserta; ?></h5>
                                    </div>
                                </div>
                                <div class="col-4 text-end">
                                    <div class="icon-shape bg-gradient-primary shadow text-center border-radius-md">
                                        <i class="bi bi-people text-lg opacity-10" aria-hidden="true"></i>
                                    </div>
                                </div>
                            </div>
                            <hr class="horizontal dark my-3">
                        </div>
                    </div>
                </div>
                <div class="col-xl-3 col-sm-6 mb-xl-0 mb-4">
                    <div class="card soft-ui-card animate-fade-in">
                        <div class="card-body p-3">
                            <div class="row gx-4">
                                <div class="col-8">
                                    <div class="numbers">
                                        <p class="text-sm mb-0 text-capitalize font-weight-bold text-secondary">Trainer Terdaftar</p>
                                        <h5 class="font-weight-bolder mb-0 text-dark"><?php echo $total_trainers; ?></h5>
                                    </div>
                                </div>
                                <div class="col-4 text-end">
                                    <div class="icon-shape bg-gradient-primary shadow text-center border-radius-md">
                                        <i class="bi bi-person-gear text-lg opacity-10" aria-hidden="true"></i>
                                    </div>
                                </div>
                            </div>
                            <hr class="horizontal dark my-3">
                        </div>
                    </div>
                </div>
            </div>

            <div class="row mt-4">
                <div class="col-12">
                    <div class="card chart-card animate-fade-in">
                        <div class="chart-header">
                            <div class="chart-title">
                                <i class="bi bi-graph-up"></i>
                                <span>Statistik Kegiatan Training per Bulan</span>
                            </div>
                            <div class="year-filter">
                                <label for="yearSelect">Tahun:</label>
                                <select id="yearSelect" onchange="changeYear()">
                                    <?php foreach ($available_years as $year): ?>
                                        <option value="<?php echo $year; ?>" <?php echo ($year == $selected_year) ? 'selected' : ''; ?>>
                                            <?php echo $year; ?>
                                        </option>
                                    <?php endforeach; ?>
                                </select>
                            </div>
                        </div>
                        <div class="chart-body">
                            <div class="chart-container">
                                <canvas id="trainingChart"></canvas>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <footer class="text-center">
        <div class="container">
            <p class="mb-0">© <?php echo date('Y'); ?> E-Learning System by PIM</p>
        </div>
    </footer>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/chart.js@4.4.0/dist/chart.umd.min.js"></script>
    <script>
        function changeYear() {
            const selectedYear = document.getElementById('yearSelect').value;
            window.location.href = `dashboard.php?year=${selectedYear}`;
        }

        document.addEventListener('DOMContentLoaded', function() {
            const sidebarToggle = document.getElementById('sidebarToggle');
            const sidebar = document.getElementById('sidebar');
            const sidebarOverlay = document.getElementById('sidebarOverlay');
            const trainingDropdownToggle = document.getElementById('trainingDropdown');
            const postTestDropdownToggle = document.getElementById('postTestDropdown');
            
            let isDropdownClick = false;

            function toggleSidebar() {
                sidebar.classList.toggle('sidebar-active');
                sidebarOverlay.style.display = sidebar.classList.contains('sidebar-active') ? 'block' : 'none';
                
                if (sidebar.classList.contains('sidebar-active')) {
                    document.body.style.overflow = 'hidden';
                } else {
                    document.body.style.overflow = '';
                }
            }

            sidebarToggle.addEventListener('click', function(e) {
                e.stopPropagation();
                toggleSidebar();
            });

            sidebarOverlay.addEventListener('click', function() {
                if (!isDropdownClick) {
                    toggleSidebar();
                }
                isDropdownClick = false;
            });

            if (trainingDropdownToggle) {
                trainingDropdownToggle.addEventListener('click', function(e) {
                    if (window.innerWidth <= 768) {
                        isDropdownClick = true;
                    }
                });
            }

            if (postTestDropdownToggle) {
                postTestDropdownToggle.addEventListener('click', function(e) {
                    if (window.innerWidth <= 768) {
                        isDropdownClick = true;
                    }
                });
            }
            
            document.addEventListener('click', function(e) {
                if (window.innerWidth <= 768) {
                    let clickedInsideAnyDropdown = false;
                    if (trainingDropdownToggle && trainingDropdownToggle.contains(e.target)) {
                        clickedInsideAnyDropdown = true;
                    }
                    if (postTestDropdownToggle && postTestDropdownToggle.contains(e.target)) {
                        clickedInsideAnyDropdown = true;
                    }
                    if (!clickedInsideAnyDropdown) {
                        isDropdownClick = false;
                    }
                }
            });

            const regularNavLinks = document.querySelectorAll('.sidebar .nav-link:not(.dropdown-toggle)');
            regularNavLinks.forEach(link => {
                link.addEventListener('click', function() {
                    if (window.innerWidth <= 768 && sidebar.classList.contains('sidebar-active')) {
                        toggleSidebar();
                    }
                });
            });

            const dropdownItems = document.querySelectorAll('.sidebar .dropdown-menu .dropdown-item');
            dropdownItems.forEach(item => {
                item.addEventListener('click', function() {
                    if (window.innerWidth <= 768 && sidebar.classList.contains('sidebar-active')) {
                        toggleSidebar();
                    }
                });
            });

            window.addEventListener('resize', function() {
                if (window.innerWidth > 768) {
                    sidebar.classList.remove('sidebar-active');
                    sidebarOverlay.style.display = 'none';
                    document.body.style.overflow = '';
                    isDropdownClick = false;
                }
            });
        });

        const ctx = document.getElementById('trainingChart').getContext('2d');
        
        // Create multiple gradients for enhanced visual appeal
        const gradientFill = ctx.createLinearGradient(0, 0, 0, 400);
        gradientFill.addColorStop(0, 'rgba(0, 196, 204, 0.3)');
        gradientFill.addColorStop(0.5, 'rgba(0, 196, 204, 0.15)');
        gradientFill.addColorStop(1, 'rgba(203, 12, 159, 0.05)');

        const gradientStroke = ctx.createLinearGradient(0, 0, ctx.canvas.width, 0);
        gradientStroke.addColorStop(0, 'rgba(0, 196, 204, 1)');
        gradientStroke.addColorStop(0.5, 'rgba(102, 126, 234, 1)');
        gradientStroke.addColorStop(1, 'rgba(203, 12, 159, 1)');

        new Chart(ctx, {
            type: 'line',
            data: {
                labels: <?php echo json_encode($labels); ?>,
                datasets: [{
                    label: 'Jumlah Kegiatan Training',
                    data: <?php echo json_encode($training_data); ?>,
                    backgroundColor: gradientFill,
                    borderColor: gradientStroke,
                    borderWidth: 4,
                    tension: 0.4,
                    fill: true,
                    pointRadius: 6,
                    pointHoverRadius: 10,
                    pointBackgroundColor: '#ffffff',
                    pointBorderColor: gradientStroke,
                    pointBorderWidth: 3,
                    pointHoverBackgroundColor: '#ffffff',
                    pointHoverBorderColor: 'rgba(203, 12, 159, 1)',
                    pointHoverBorderWidth: 4,
                    pointShadowColor: 'rgba(0, 0, 0, 0.2)',
                    pointShadowBlur: 10,
                    pointShadowOffsetX: 0,
                    pointShadowOffsetY: 4,
                }]
            },
            options: {
                responsive: true,
                maintainAspectRatio: false,
                interaction: {
                    intersect: false,
                    mode: 'index'
                },
                plugins: {
                    legend: {
                        display: true,
                        position: 'top',
                        align: 'end',
                        labels: {
                            font: {
                                size: window.innerWidth <= 768 ? 13 : 16,
                                weight: '600',
                                family: "'Inter', 'Segoe UI', sans-serif"
                            },
                            color: '#1e293b',
                            padding: 25,
                            usePointStyle: true,
                            pointStyle: 'circle',
                            boxWidth: 12,
                            boxHeight: 12
                        }
                    },
                    tooltip: {
                        enabled: true,
                        backgroundColor: 'rgba(15, 23, 42, 0.95)',
                        titleFont: { 
                            size: window.innerWidth <= 768 ? 15 : 18,
                            weight: '700',
                            family: "'Inter', sans-serif"
                        },
                        bodyFont: { 
                            size: window.innerWidth <= 768 ? 13 : 16,
                            weight: '500',
                            family: "'Inter', sans-serif"
                        },
                        padding: 20,
                        cornerRadius: 16,
                        displayColors: true,
                        borderColor: 'rgba(0, 196, 204, 0.8)',
                        borderWidth: 2,
                        titleColor: '#f1f5f9',
                        bodyColor: '#cbd5e1',
                        caretSize: 8,
                        caretPadding: 12,
                        boxPadding: 8,
                        usePointStyle: true,
                        callbacks: {
                            title: function(context) {
                                return `📊 Bulan ${context[0].label}`;
                            },
                            label: function(context) {
                                return `🎯 Total Training: ${context.parsed.y} kegiatan`;
                            },
                            afterLabel: function(context) {
                                const total = context.dataset.data.reduce((a, b) => a + b, 0);
                                const percentage = ((context.parsed.y / total) * 100).toFixed(1);
                                return `📈 Persentase: ${percentage}%`;
                            }
                        }
                    }
                },
                scales: {
                    x: {
                        title: {
                            display: true,
                            text: '📅 Periode Bulan',
                            color: '#1e293b',
                            font: { 
                                size: window.innerWidth <= 768 ? 15 : 18, 
                                weight: '700',
                                family: "'Inter', sans-serif"
                            },
                            padding: 25
                        },
                        ticks: {
                            color: '#475569',
                            font: { 
                                size: window.innerWidth <= 768 ? 12 : 14,
                                weight: '600',
                                family: "'Inter', sans-serif"
                            },
                            maxRotation: 0,
                            minRotation: 0,
                            padding: 15
                        },
                        grid: { 
                            display: true,
                            color: 'rgba(148, 163, 184, 0.1)',
                            lineWidth: 1,
                            drawOnChartArea: true,
                            drawTicks: false
                        },
                        border: {
                            display: false
                        }
                    },
                    y: {
                        title: {
                            display: true,
                            text: '📊 Jumlah Training',
                            color: '#1e293b',
                            font: { 
                                size: window.innerWidth <= 768 ? 15 : 18, 
                                weight: '700',
                                family: "'Inter', sans-serif"
                            },
                            padding: 25
                        },
                        ticks: {
                            color: '#475569',
                            font: { 
                                size: window.innerWidth <= 768 ? 12 : 14,
                                weight: '600',
                                family: "'Inter', sans-serif"
                            },
                            stepSize: 1,
                            beginAtZero: true,
                            padding: 15,
                            callback: function(value) {
                                return Number.isInteger(value) ? value + ' 🎯' : '';
                            }
                        },
                        grid: {
                            color: 'rgba(148, 163, 184, 0.15)',
                            lineWidth: 1,
                            drawBorder: false,
                            drawOnChartArea: true,
                            drawTicks: false
                        },
                        border: {
                            display: false
                        }
                    }
                },
                animation: {
                    duration: 2500,
                    easing: 'easeInOutCubic',
                    delay: (context) => {
                        let delay = 0;
                        if (context.type === 'data' && context.mode === 'default') {
                            delay = context.dataIndex * 150;
                        }
                        return delay;
                    }
                },
                elements: {
                    line: {
                        tension: 0.4,
                        borderWidth: 4,
                        borderColor: gradientStroke,
                        fill: true,
                        backgroundColor: gradientFill,
                        shadowColor: 'rgba(0, 196, 204, 0.3)',
                        shadowBlur: 15,
                        shadowOffsetX: 0,
                        shadowOffsetY: 8
                    },
                    point: {
                        radius: 6,
                        hoverRadius: 10,
                        backgroundColor: '#ffffff',
                        borderColor: gradientStroke,
                        borderWidth: 3,
                        hoverBackgroundColor: '#ffffff',
                        hoverBorderColor: 'rgba(203, 12, 159, 1)',
                        hoverBorderWidth: 4,
                        shadowColor: 'rgba(0, 0, 0, 0.2)',
                        shadowBlur: 10,
                        shadowOffsetX: 0,
                        shadowOffsetY: 4
                    }
                },
                onHover: (event, activeElements) => {
                    event.native.target.style.cursor = activeElements.length > 0 ? 'pointer' : 'default';
                }
            }
        });
    </script>
</body>
</html>
