<?php
require_once 'koneksi.php';

// Cek login
checkLogin();

// Set timezone ke Asia/Jakarta
date_default_timezone_set('Asia/Jakarta');

$user_id = $_SESSION['user_id'];
$role = $_SESSION['role'];
$error = "";
$success = "";

// Ambil informasi user menggunakan prepared statement
if ($role == 'trainer') {
    $stmt = $koneksi->prepare("SELECT nama_lengkap, foto_profil, jabatan, divisi FROM trainers WHERE id = ?");
} else {
    $stmt = $koneksi->prepare("SELECT nama_lengkap, foto_profil, jabatan, divisi FROM peserta WHERE id = ?");
}
$stmt->bind_param("i", $user_id);
$stmt->execute();
$result = $stmt->get_result();
$user = $result->fetch_assoc();
$nama_user = $user['nama_lengkap'] ?? 'Unknown';
$stmt->close();

// Proses perubahan password
if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    $old_password = trim($_POST['old_password'] ?? '');
    $new_password = trim($_POST['new_password'] ?? '');
    $confirm_password = trim($_POST['confirm_password'] ?? '');

    // Validasi input
    if (empty($old_password) || empty($new_password) || empty($confirm_password)) {
        $error = "Semua kolom harus diisi.";
    } elseif ($new_password !== $confirm_password) {
        $error = "Password baru dan konfirmasi tidak cocok.";
    } elseif (strlen($new_password) < 8) {
        $error = "Password baru harus minimal 8 karakter.";
    } else {
        // Ambil password lama dari database
        if ($role == 'trainer') {
            $stmt = $koneksi->prepare("SELECT password FROM trainers WHERE id = ?");
        } else {
            $stmt = $koneksi->prepare("SELECT password FROM peserta WHERE id = ?");
        }
        $stmt->bind_param("i", $user_id);
        $stmt->execute();
        $result = $stmt->get_result();
        $user_data = $result->fetch_assoc();
        $stored_password = $user_data['password'] ?? '';
        $stmt->close();

        // Verifikasi password lama
        if (!password_verify($old_password, $stored_password)) {
            $error = "Password lama salah.";
        } else {
            // Enkripsi password baru
            $new_password_hash = password_hash($new_password, PASSWORD_BCRYPT);

            // Update password di database
            if ($role == 'trainer') {
                $stmt = $koneksi->prepare("UPDATE trainers SET password = ? WHERE id = ?");
            } else {
                $stmt = $koneksi->prepare("UPDATE peserta SET password = ? WHERE id = ?");
            }
            $stmt->bind_param("si", $new_password_hash, $user_id);
            if ($stmt->execute()) {
                $success = "Password berhasil diubah.";
            } else {
                $error = "Gagal mengubah password: " . $koneksi->error;
            }
            $stmt->close();
        }
    }
}

// Set current page untuk highlight menu
$current_page = basename($_SERVER['PHP_SELF']);
?>
<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Ubah Password - E-Learning</title>
    <link rel="icon" type="image/png" href="image/icon.png">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.10.0/font/bootstrap-icons.css">
    <style>
        body {
            background: #ffffff;
            margin: 0;
            overflow-x: hidden;
        }
        
        .navbar-top {
            position: fixed;
            top: 0;
            width: 100%;
            z-index: 1100;
            background: #0a939e;
            border-bottom: 2px solid rgba(157, 206, 218, 0.3);
            box-shadow: 0 4px 20px rgba(157, 206, 218, 0.2);
            backdrop-filter: blur(10px);
        }
        
        .navbar-top .container-fluid {
            display: flex;
            align-items: center;
            justify-content: space-between;
            position: relative;
            flex-wrap: nowrap;
        }
        
        .navbar-brand {
            font-size: 1.2rem;
            position: absolute;
            left: 50%;
            transform: translateX(-50%);
            text-align: center;
            color: #9dceda;
            min-width: 0;
            font-weight: 700;
            text-shadow: 0 2px 4px rgba(0,0,0,0.15);
            font-style: italic;
        }
        
        .navbar-top .dropdown {
            margin-left: auto;
            margin-right: 10px;
        }
        
        .sidebar {
            min-height: 100vh;
            width: 250px;
            position: fixed;
            top: 0;
            left: 0;
            z-index: 1000;
            background: #0a939e;
            color: #ffffff;
            padding-top: 70px;
            transition: all 0.3s;
            border-right: 1px solid rgba(157, 206, 218, 0.3);
            box-shadow: 4px 0 20px rgba(157, 206, 218, 0.15);
        }
        
        .content {
            margin-left: 250px;
            padding: 20px;
            padding-top: 80px;
            transition: all 0.3s;
        }
        
        .hamburger-mobile {
            display: none;
            background: none;
            border: none;
            color: #ffffff;
            font-size: 1.5rem;
            cursor: pointer;
            margin-right: 15px;
            transition: all 0.3s ease;
        }
        
        .hamburger-mobile:focus {
            outline: none;
        }
        
        .sidebar-overlay {
            display: none;
            position: fixed;
            top: 0;
            left: 0;
            right: 0;
            bottom: 0;
            background-color: rgba(10, 147, 158, 0.5);
            z-index: 999;
        }
        
        /* Profile Section Styles */
        .profile-section {
            text-align: center;
            padding: 15px 20px;
            border-bottom: 1px solid rgba(157, 206, 218, 0.3);
            margin-bottom: 20px;
            background: #ffffff;
            border-radius: 20px;
            margin: 15px;
            box-shadow: 0 8px 25px rgba(157, 206, 218, 0.2);
            backdrop-filter: blur(10px);
        }
        
        .profile-photo {
            width: 80px;
            height: 80px;
            border-radius: 50%;
            object-fit: cover;
            border: 2px solid #9dceda;
            margin: 0 auto 10px;
            display: block;
            box-shadow: 0 8px 20px rgba(157, 206, 218, 0.3);
        }
        
        .profile-photo-placeholder {
            width: 80px;
            height: 80px;
            border-radius: 50%;
            background: #9dceda;
            display: flex;
            align-items: center;
            justify-content: center;
            margin: 0 auto 10px;
            border: 2px solid #fff;
            box-shadow: 0 8px 20px rgba(157, 206, 218, 0.3);
        }
        
        .profile-photo-placeholder i {
            font-size: 2rem;
            color: #fff;
        }
        
        .profile-name {
            font-size: 1.1rem;
            font-weight: 600;
            color: #0a939e;
            margin-bottom: 5px;
            word-wrap: break-word;
        }
        
        .profile-info {
            font-size: 0.9rem;
            font-weight: 400;
            color: #666666;
            margin-bottom: 3px;
        }
        
        .form-card {
            transition: transform 0.3s ease, box-shadow 0.3s ease;
            border: 1px solid rgba(157, 206, 218, 0.2);
            border-radius: 12px;
            box-shadow: 0 6px 12px rgba(157, 206, 218, 0.08);
            overflow: hidden;
            background: #ffffff;
            backdrop-filter: blur(10px);
        }
        
        .form-card:hover {
            transform: scale(1.01);
            box-shadow: 0 8px 16px rgba(157, 206, 218, 0.12);
        }
        
        .form-header {
            padding: 20px;
            color: #fff;
            text-align: center;
            font-weight: 600;
            font-size: 1.25rem;
            background: #0a939e;
        }
        
        .form-body {
            padding: 20px;
        }
        
        .form-label {
            font-weight: 500;
            color: #0a939e;
        }
        
        .form-control {
            border: 1px solid rgba(157, 206, 218, 0.3);
            border-radius: 8px;
            padding: 0.75rem;
            transition: border-color 0.3s ease, box-shadow 0.3s ease;
        }
        
        .form-control:focus {
            border-color: #9dceda;
            box-shadow: 0 0 5px rgba(157, 206, 218, 0.5);
        }
        
        .toggle-password {
            border: none;
            background: #f1f3f5;
            color: #555;
            border-radius: 0 8px 8px 0;
            cursor: pointer;
            padding: 0.75rem;
            transition: background 0.3s ease;
        }
        
        .toggle-password:hover {
            background: #e9ecef;
        }
        
        .toggle-password i {
            font-size: 1rem;
        }
        
        .input-group-text {
            padding: 0.75rem;
            background: #f1f3f5;
            border: 1px solid rgba(157, 206, 218, 0.3);
            border-left: none;
            border-radius: 0 8px 8px 0;
        }
        
        .btn-primary {
            background: #9dceda;
            border: none;
            border-radius: 10px;
            padding: 0.6rem 2rem;
            font-weight: 600;
            font-size: 1rem;
            box-shadow: 0 2px 4px rgba(157, 206, 218, 0.1);
            transition: all 0.3s ease;
        }
        
        .btn-primary:hover {
            background: #86b9c6;
            transform: scale(1.08);
            box-shadow: 0 6px 12px rgba(157, 206, 218, 0.2);
        }
        
        .alert {
            border-radius: 8px;
            padding: 1rem;
        }
        
        .alert-danger {
            background: #f8d7da;
            color: #721c24;
            border: 1px solid #f5c6cb;
        }
        
        .alert-success {
            background: #d4edda;
            color: #155724;
            border: 1px solid #c3e6cb;
        }
        
        .page-title {
            font-size: 1.75rem;
            font-weight: 700;
            color: #0a939e;
            margin-bottom: 30px;
            text-align: center;
        }
        
        footer {
            background: #0a939e;
            margin-top: 20px;
            padding-top: 20px;
            border-top: 1px solid rgba(157, 206, 218, 0.2);
        }
        
        .animate-fade-in {
            animation: fadeIn 0.5s ease-in-out;
        }
        
        @keyframes fadeIn {
            from { opacity: 0; transform: translateY(10px); }
            to { opacity: 1; transform: translateY(0); }
        }
        
        @media (min-width: 769px) {
            .sidebar { margin-left: 0; }
            .content { margin-left: 250px; }
            .navbar-brand { font-size: 1.2rem; white-space: nowrap; }
            .navbar-top .dropdown { margin-left: auto; margin-right: 10px; }
        }
        
        @media (max-width: 768px) {
            .sidebar {
                margin-left: -250px;
                top: 0;
                transition: all 0.3s;
                box-shadow: 5px 0 15px rgba(157, 206, 218, 0.2);
            }
            .sidebar-active { margin-left: 0; z-index: 1200; }
            .content {
                margin-left: 0;
                padding: 10px;
                padding-top: 70px;
                width: 100%;
            }
            .navbar-brand {
                font-size: 0.8rem;
                left: 50%;
                transform: translateX(-50%);
                max-width: 50%;
                white-space: normal;
                line-height: 1.2;
                padding: 0 20px;
            }}
            .nav-link.dropdown-toggle { font-size: 1rem; }
            .hamburger-mobile { display: block; margin-right: 5px; padding: 8px; }
            .navbar-top .dropdown { margin-left: auto; margin-right: 5px; }
            .form-card {
                margin-bottom: 15px;
            }
            .form-label, .form-control {
                font-size: 0.85rem;
            }
            .toggle-password {
                padding: 0.6rem;
            }
            .btn-primary {
                padding: 0.4rem 0.8rem;
                font-size: 0.8rem;
            }
            .page-title {
                font-size: 1.25rem;
                text-align: center;
            }
            .alert {
                font-size: 0.85rem;
            }
            .form-header {
                font-size: 1.1rem;
            }
            .profile-photo, .profile-photo-placeholder {
                width: 60px;
                height: 60px;
            }
            .profile-photo-placeholder i {
                font-size: 1.5rem;
            }
            .profile-name {
                font-size: 1rem;
            }
            .profile-info {
                font-size: 0.8rem;
            }
        }
        
        @media (max-width: 576px) {
            .navbar-brand { font-size: 0.7rem; max-width: 60%; }
            .hamburger-mobile { margin-right: 3px; padding: 6px; }
            .navbar-top .dropdown { margin-right: 3px; }
            .nav-link.dropdown-toggle { font-size: 1rem; }
            .form-label, .form-control {
                font-size: 0.8rem;
            }
            .toggle-password {
                padding: 0.5rem;
            }
            .btn-primary {
                padding: 0.3rem 0.6rem;
                font-size: 0.75rem;
            }
            .page-title {
                font-size: 1.1rem;
            }
            .alert {
                font-size: 0.8rem;
            }
            .form-header {
                font-size: 1rem;
            }
            .profile-photo, .profile-photo-placeholder {
                width: 50px;
                height: 50px;
            }
            .profile-photo-placeholder i {
                font-size: 1.2rem;
            }
            .profile-name {
                font-size: 0.9rem;
            }
            .profile-info {
                font-size: 0.7rem;
            }
        }
        
        .dropdown-menu, .dropdown-menu-end {
            position: absolute;
            z-index: 1000;
            background: #ffffff;
            border: 1px solid rgba(157, 206, 218, 0.3);
            border-radius: 8px;
            box-shadow: 0 8px 16px rgba(157, 206, 218, 0.2);
            transform: translateY(10px);
            opacity: 0;
            transition: opacity 0.3s ease, transform 0.3s ease;
            backdrop-filter: blur(10px);
        }
        
        .dropdown-menu.show, .dropdown-menu-end.show {
            transform: translateY(0);
            opacity: 1;
        }
        
        .dropdown-item {
            color: #0a939e;
            padding: 10px 20px;
            font-weight: 500;
            transition: background 0.3s ease, transform 0.2s ease;
            border-radius: 6px;
            margin: 4px 8px;
        }
        
        .dropdown-item:hover {
            background: #9dceda;
            transform: scale(1.02);
            color: #fff;
        }
        
        .dropdown-item.active {
            background: #9dceda;
            color: #fff;
        }
        
        .dropdown-divider {
            border-top: 1px solid rgba(157, 206, 218, 0.3);
        }
        
        .nav-link {
            color: #ffffff !important;
            padding: 12px 15px;
            border-radius: 8px;
            margin: 5px 10px;
            transition: background 0.3s ease, color 0.3s ease, transform 0.2s ease, box-shadow 0.3s ease;
            font-weight: 500;
        }
        
        .nav-link:hover, .nav-link.active {
            background: #9dceda;
            color: #fff !important;
            transform: scale(1.02);
            box-shadow: 0 4px 8px rgba(157, 206, 218, 0.2);
        }
        
        .nav-link i {
            font-size: 1.2rem;
            margin-right: 10px;
        }
        
        .nav-item:not(:last-child) {
            border-bottom: 1px solid rgba(157, 206, 218, 0.1);
        }
    </style>
</head>
<body>
    <!-- Top Navbar -->
    <nav class="navbar navbar-dark navbar-top">
        <div class="container-fluid">
            <button class="hamburger-mobile d-md-none" type="button" id="sidebarToggle">
                <i class="bi bi-list"></i>
            </button>
            <div class="navbar-brand">E-Learning System Pondok Indah Mall</div>
            <div class="dropdown">
                <a class="nav-link dropdown-toggle text-white" href="#" id="navbarDropdown" role="button" data-bs-toggle="dropdown" data-bs-auto-close="outside">
                    <i class="bi bi-person-circle"></i>
                </a>
                <ul class="dropdown-menu dropdown-menu-end">
                    <li><a class="dropdown-item <?php echo ($current_page == 'profile.php') ? 'active' : ''; ?>" href="profile.php">Profile</a></li>
                    <li><a class="dropdown-item <?php echo ($current_page == 'change_password.php') ? 'active' : ''; ?>" href="change_password.php">Change Password</a></li>
                    <li><hr class="dropdown-divider"></li>
                    <li><a class="dropdown-item" href="logout.php">Logout</a></li>
                </ul>
            </div>
        </div>
    </nav>

    <!-- Sidebar overlay (for mobile) -->
    <div class="sidebar-overlay" id="sidebarOverlay"></div>

    <!-- Sidebar -->
    <div class="sidebar border-end" id="sidebar">
        <div class="p-3">
            <!-- Profile Section -->
            <div class="profile-section">
                <?php if (!empty($user['foto_profil'])): ?>
                    <img src="Uploads/profiles/<?php echo htmlspecialchars($user['foto_profil']); ?>" alt="Foto Profil" class="profile-photo">
                <?php else: ?>
                    <div class="profile-photo-placeholder">
                        <i class="bi bi-person-circle"></i>
                    </div>
                <?php endif; ?>
                <div class="profile-name"><?php echo htmlspecialchars($user['nama_lengkap']); ?></div>
                <div class="profile-info"><?php echo htmlspecialchars($user['jabatan'] ?? 'Tidak ada jabatan'); ?></div>
                <div class="profile-info"><?php echo htmlspecialchars($user['divisi'] ?? 'Tidak ada divisi'); ?></div>
            </div>
            <h5 class="mb-4 text-white">Menu</h5>
            <ul class="nav flex-column">
                <li class="nav-item">
                    <a class="nav-link <?php echo ($current_page == 'dashboard.php') ? 'active' : ''; ?>" href="dashboard.php">
                        <i class="bi bi-house-door"></i> Dashboard
                    </a>
                </li>
                <li class="nav-item">
                    <a class="nav-link <?php echo ($current_page == 'materi.php') ? 'active' : ''; ?>" href="materi.php">
                        <i class="bi bi-book"></i> Materi
                    </a>
                </li>
                <!-- Post Test Menu -->
                <?php if ($role == 'trainer'): ?>
                    <li class="nav-item dropdown">
                        <a class="nav-link dropdown-toggle <?php echo ($current_page == 'add_posttest.php' || $current_page == 'list_posttest.php' || $current_page == 'view_posttest_scores.php') ? 'active' : ''; ?>" href="#" id="postTestDropdown" role="button" data-bs-toggle="dropdown" aria-expanded="false">
                            <i class="bi bi-clipboard-check"></i> Post Test
                        </a>
                        <ul class="dropdown-menu" aria-labelledby="postTestDropdown">
                            <li><a class="dropdown-item <?php echo ($current_page == 'add_posttest.php') ? 'active' : ''; ?>" href="add_posttest.php">Tambah Post Test</a></li>
                            <li><a class="dropdown-item <?php echo ($current_page == 'list_posttest.php' || $current_page == 'view_posttest_scores.php') ? 'active' : ''; ?>" href="list_posttest.php">List Post Test</a></li>
                        </ul>
                    </li>
                <?php elseif ($role == 'peserta' || $role == 'iss'): ?>
                    <li class="nav-item">
                        <a class="nav-link <?php echo ($current_page == 'list_posttest.php' || $current_page == 'take_posttest.php' || $current_page == 'post_test_result.php') ? 'active' : ''; ?>" href="list_posttest.php">
                            <i class="bi bi-clipboard-check"></i> Post Test
                        </a>
                    </li>
                <?php endif; ?>
                <!-- End Post Test Menu -->
                <li class="nav-item dropdown">
                    <a class="nav-link dropdown-toggle <?php echo ($current_page == 'add_training.php' || $current_page == 'list_training.php') ? 'active' : ''; ?>" 
                       href="#" id="trainingDropdown" role="button" data-bs-toggle="dropdown" aria-expanded="false">
                        <i class="bi bi-journal-text"></i> Training
                    </a>
                    <ul class="dropdown-menu" aria-labelledby="trainingDropdown">
                        <li><a class="dropdown-item <?php echo ($current_page == 'add_training.php') ? 'active' : ''; ?>" href="add_training.php">Tambah Kegiatan Training</a></li>
                        <li><a class="dropdown-item <?php echo ($current_page == 'list_training.php') ? 'active' : ''; ?>" href="list_training.php">List Training</a></li>
                    </ul>
                </li>
                
                <!-- Tambahkan menu Report dan Data Evaluasi untuk Trainer -->
                <?php if ($_SESSION['role'] == 'trainer'): ?>
                    <li class="nav-item">
                        <a class="nav-link <?php echo ($current_page == 'report.php') ? 'active' : ''; ?>" href="report.php">
                            <i class="bi bi-file-earmark-text"></i> Report
                        </a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link <?php echo ($current_page == 'data_evaluasi.php') ? 'active' : ''; ?>" href="data_evaluasi.php">
                            <i class="bi bi-clipboard-data"></i> Data Evaluasi
                        </a>
                    </li>
                <?php endif; ?>
            </ul>
        </div>
    </div>

    <!-- Content -->
    <div class="content">
        <div class="container mt-4">
            <h2 class="page-title animate-fade-in">Ubah Password</h2>
            <div class="row">
                <div class="col-md-6 mx-auto">
                    <div class="card form-card animate-fade-in">
                        <div class="form-header">
                            Form Ubah Password
                        </div>
                        <div class="form-body">
                            <?php if(!empty($error)): ?>
                                <div class="alert alert-danger"><?php echo htmlspecialchars($error); ?></div>
                            <?php endif; ?>
                            
                            <?php if(!empty($success)): ?>
                                <div class="alert alert-success"><?php echo htmlspecialchars($success); ?></div>
                            <?php endif; ?>
                            
                            <form method="POST" action="">
                                <div class="mb-3">
                                    <label for="old_password" class="form-label">Password Lama</label>
                                    <input type="password" class="form-control" id="old_password" name="old_password" required>
                                </div>
                                <div class="mb-3">
                                    <label for="new_password" class="form-label">Password Baru</label>
                                    <div class="input-group">
                                        <input type="password" class="form-control" id="new_password" name="new_password" required>
                                        <span class="input-group-text toggle-password" id="toggleNewPassword">
                                            <i class="bi bi-eye"></i>
                                        </span>
                                    </div>
                                </div>
                                <div class="mb-3">
                                    <label for="confirm_password" class="form-label">Konfirmasi Password Baru</label>
                                    <div class="input-group">
                                        <input type="password" class="form-control" id="confirm_password" name="confirm_password" required>
                                        <span class="input-group-text toggle-password" id="toggleConfirmPassword">
                                            <i class="bi bi-eye"></i>
                                        </span>
                                    </div>
                                </div>
                                <button type="submit" class="btn btn-primary w-100">Ubah Password</button>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    
    <footer class="text-white text-center py-3 mt-5">
        <div class="container">
            <p class="mb-0">© <?php echo date('Y'); ?> E-Learning System by PIM</p>
        </div>
    </footer>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
    <script>
        document.addEventListener('DOMContentLoaded', function() {
            // Toggle visibilitas password baru
            const toggleNewPassword = document.getElementById('toggleNewPassword');
            if (toggleNewPassword) {
                toggleNewPassword.addEventListener('click', function() {
                    const passwordInput = document.getElementById('new_password');
                    const icon = this.querySelector('i');
                    if (passwordInput && icon) {
                        if (passwordInput.type === 'password') {
                            passwordInput.type = 'text';
                            icon.classList.remove('bi-eye');
                            icon.classList.add('bi-eye-slash');
                        } else {
                            passwordInput.type = 'password';
                            icon.classList.remove('bi-eye-slash');
                            icon.classList.add('bi-eye');
                        }
                    } else {
                        console.error('New password input or icon not found');
                    }
                });
            } else {
                console.error('Toggle new password sidebar');
            }

            // Toggle visibilitas konfirmasi password
            const toggleConfirmPassword = document.getElementById('toggleConfirmPassword');
            if (toggleConfirmPassword) {
                toggleConfirmPassword.addEventListener('click', function() {
                    const passwordInput = document.getElementById('confirm_password');
                    const icon = this.querySelector('i');
                    if (passwordInput && icon) {
                        if (passwordInput.type === 'password') {
                            passwordInput.type = 'text';
                            icon.classList.remove('bi-eye');
                            icon.classList.add('bi-eye-slash');
                        } else {
                            passwordInput.type = 'password';
                            icon.classList.remove('bi-eye-slash');
                            icon.classList.add('bi-eye');
                        }
                    } else {
                        console.error('Confirm password input or icon not found');
                    }
                });
            } else {
                console.error('Toggle confirm password sidebar');
            }

            // Toggle sidebar for mobile
            const sidebarToggle = document.getElementById('sidebarToggle');
            const sidebar = document.getElementById('sidebar');
            const sidebarOverlay = document.getElementById('sidebarOverlay');
            const dropdownToggle = document.getElementById('trainingDropdown');
            
            // Flag untuk melacak apakah klik dropdown atau Training
            let isTrainingDropdownClick = false;

            function toggleSidebar() {
                sidebar.classList.toggle('sidebar-active');
                sidebarOverlay.style.display = sidebar.classList.contains('sidebar-active') ? 'block' : 'none';
                
                // Prevent body scrolling when sidebar is open
                if (sidebar.classList.contains('sidebar-active')) {
                    document.body.style.overflow = 'hidden';
                } else {
                    document.body.style.overflow = '';
                }
            }

            // Toggle sidebar ketika hamburger diklik
            sidebarToggle.addEventListener('click', function(e) {
                e.stopPropagation();
                toggleSidebar();
            });

            // Tutup sidebar ketika klik di luar
            sidebarOverlay.addEventListener('click', function() {
                // Jika klik dari dropdown Training, jangan tutup sidebar
                if (!isTrainingDropdownClick) {
                    toggleSidebar();
                }
                // Reset flag
                isTrainingDropdownClick = false;
            });

            // Mencegah penutupan sidebar saat mengklik dropdown Training
            if (dropdownToggle) {
                // Tangani klik pada dropdown Training
                dropdownToggle.addEventListener('click', function(e) {
                    if (window.innerWidth <= 768) {
                        // Set flag bahwa klik dari dropdown Training
                        isTrainingDropdownClick = true;
                    }
                });
                
                // Tangani klik di luar dropdown saat dropdown terbuka
                document.addEventListener('click', function(e) {
                    // Reset flag ketika klik di luar dropdown
                    if (!dropdownToggle.contains(e.target) && window.innerWidth <= 768) {
                        isTrainingDropdownClick = false;
                    }
                });
            }

            // Handle klik pada item menu biasa (kecuali dropdown Training)
            const regularNavLinks = document.querySelectorAll('.sidebar .nav-link:not(.dropdown-toggle)');
            regularNavLinks.forEach(link => {
                link.addEventListener('click', function() {
                    if (window.innerWidth <= 768 && sidebar.classList.contains('sidebar-active')) {
                        toggleSidebar();
                    }
                });
            });

            // Handle klik pada item submenu Training
            const dropdownItems = document.querySelectorAll('.sidebar .dropdown-menu .dropdown-item');
            dropdownItems.forEach(item => {
                item.addEventListener('click', function() {
                    if (window.innerWidth <= 768 && sidebar.classList.contains('sidebar-active')) {
                        toggleSidebar();
                    }
                });
            });

            // Handle resize window
            window.addEventListener('resize', function() {
                if (window.innerWidth > 768) {
                    sidebar.classList.remove('sidebar-active');
                    sidebarOverlay.style.display = 'none';
                    document.body.style.overflow = '';
                    isTrainingDropdownClick = false;
                }
            });
        });
    </script>
</body>
</html>