<?php
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

require_once 'koneksi.php';

// Cek login
checkLogin();

date_default_timezone_set('Asia/Jakarta');

$user_id = $_SESSION['user_id'];
$role = $_SESSION['role'];
$nik_karyawan = $_SESSION['nik_karyawan'];

// Pastikan user adalah trainer
if (!isset($role) || $role !== 'trainer') {
    header("Location: login.php?error=Anda tidak memiliki izin untuk mengakses halaman ini");
    exit();
}

// Ambil informasi user trainer
$stmt = $koneksi->prepare("SELECT nama_lengkap, jabatan, divisi, foto_profil FROM trainers WHERE id = ?");
$stmt->bind_param("i", $user_id);
$stmt->execute();
$result = $stmt->get_result();
$user = $result->fetch_assoc();
$stmt->close();

$nama_user = $user['nama_lengkap'] ?? 'Unknown';

$error = "";
$success = "";

// Inisialisasi variabel untuk form (untuk memastikan kosong saat pertama kali dimuat)
$question_text = '';
$option_a = '';
$option_b = '';
$option_c = '';
$option_d = '';
$correct_answer = '';
$training_id_selected = ''; // Untuk menyimpan training_id yang dipilih setelah submit

// Ambil daftar training untuk dropdown
$trainings = [];
$stmt = $koneksi->prepare("SELECT id, judul FROM trainings ORDER BY judul ASC");
$stmt->execute();
$result = $stmt->get_result();
while ($row = $result->fetch_assoc()) {
    $trainings[] = $row;
}
$stmt->close();

// Proses penambahan soal
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $training_id_selected = $_POST['training_id'] ?? '';
    $questions_data = $_POST['questions'] ?? []; // Ini akan menjadi array dari array soal

    if (empty($training_id_selected)) {
        $error = "Pilih Training terlebih dahulu.";
    } elseif (empty($questions_data)) {
        $error = "Tambahkan setidaknya satu soal.";
    } else {
        $all_questions_valid = true;
        $koneksi->begin_transaction(); // Mulai transaksi untuk insert batch

        foreach ($questions_data as $index => $q_data) {
            $q_text = $q_data['question_text'] ?? '';
            $opt_a = $q_data['option_a'] ?? '';
            $opt_b = $q_data['option_b'] ?? '';
            $opt_c = $q_data['option_c'] ?? '';
            $opt_d = $q_data['option_d'] ?? '';
            $correct_ans = $q_data['correct_answer'] ?? '';

            // Validasi setiap soal
            if (empty($q_text) || empty($opt_a) || empty($opt_b) || empty($opt_c) || empty($opt_d) || empty($correct_ans)) {
                $error = "Semua field soal harus diisi. Soal #" . ($index + 1) . " tidak lengkap.";
                $all_questions_valid = false;
                break; // Hentikan proses jika ada soal yang tidak lengkap
            }

            $stmt = $koneksi->prepare("INSERT INTO post_test_questions (training_id, question_text, option_a, option_b, option_c, option_d, correct_answer, created_by_trainer_id) VALUES (?, ?, ?, ?, ?, ?, ?, ?)");
            $stmt->bind_param("issssssi", $training_id_selected, $q_text, $opt_a, $opt_b, $opt_c, $opt_d, $correct_ans, $user_id);

            if (!$stmt->execute()) {
                $error = "Gagal menambahkan soal #" . ($index + 1) . ": " . $stmt->error;
                $all_questions_valid = false;
                break;
            }
            $stmt->close();
        }

        if ($all_questions_valid) {
            $koneksi->commit();
            $success = "Semua soal berhasil ditambahkan!";
            // Kosongkan form setelah berhasil submit
            $question_text = $option_a = $option_b = $option_c = $option_d = $correct_answer = '';
            $training_id_selected = ''; // Reset pilihan training
        } else {
            $koneksi->rollback(); // Batalkan semua insert jika ada yang gagal atau tidak valid
        }
    }
}

$current_page = basename($_SERVER['PHP_SELF']);
?>
<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Buat Soal Post Test - E-Learning</title>
    <link rel="icon" type="image/png" href="image/icon.png">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.10.0/font/bootstrap-icons.css">
    <style>
        :root {
            --soft-ui-primary-start: #00C4CC; /* Teal */
            --soft-ui-primary-end: #CB0C9F; /* Purple */
            --soft-ui-secondary: #67748E; /* Kept as secondary color */
            --soft-ui-info: #17C1E8; /* Kept as info color */
            --soft-ui-success: #82D616; /* Kept as success color */
            --soft-ui-warning: #FB8C00; /* Kept as warning color */
            --soft-ui-danger: #EA0606; /* Kept as danger color */
            --soft-ui-light: #E9ECEF; /* Kept as light color */
            --soft-ui-dark: #344767; /* Kept as dark color */
            --soft-ui-white: #FFFFFF;
            --soft-ui-gray-100: #F8F9FA;
            --soft-ui-gray-200: #E9ECEF;
            --soft-ui-gray-300: #DEE2E6;
            --soft-ui-gray-400: #CED4DA;
            --soft-ui-gray-500: #ADB5BD;
            --soft-ui-gray-600: #6C757D;
            --soft-ui-gray-700: #495057;
            --soft-ui-gray-800: #343A40;
            --soft-ui-gray-900: #212529;
        }

        html, body {
            height: 100%;
            margin: 0;
            font-family: 'Open Sans', sans-serif;
            background-color: var(--soft-ui-gray-100);
        }
        
        body {
            overflow-x: hidden;
            display: flex;
            flex-direction: column;
        }
        
        .navbar-top {
            position: fixed;
            top: 0;
            width: 100%;
            z-index: 1100;
            background: var(--soft-ui-white);
            border-bottom: 1px solid var(--soft-ui-gray-200);
            box-shadow: 0 2px 12px rgba(0, 0, 0, 0.05);
            padding: 0.75rem 1.5rem;
        }
        
        .navbar-top .container-fluid {
            display: flex;
            align-items: center;
            justify-content: space-between;
            flex-wrap: nowrap;
            position: relative;
        }
        
        .navbar-logo {
            height: 40px;
            width: auto;
            margin-right: 15px;
        }
        
        .navbar-title {
            position: absolute;
            left: 50%;
            transform: translateX(-50%);
            font-size: 1.3rem;
            color: var(--soft-ui-dark);
            font-weight: 700;
            text-align: center;
            white-space: nowrap;
            pointer-events: none;
        }

        .navbar-title-mobile {
            display: none;
            font-size: 0.85rem;
            color: var(--soft-ui-dark);
            font-weight: 700;
            text-align: center;
            line-height: 1.2;
            flex: 1;
            margin: 0 10px;
        }

        .navbar-title-mobile .line1 {
            display: block;
        }

        .navbar-title-mobile .line2 {
            display: block;
            font-size: 0.8rem;
        }
        
        .navbar-brand {
            font-size: 1.2rem;
            color: var(--soft-ui-dark);
            font-weight: 700;
            display: flex;
            align-items: center;
            z-index: 1;
        }

        .navbar-nav {
            position: relative;
            z-index: 1200;
        }

        .navbar-nav .nav-item .nav-link {
            color: var(--soft-ui-secondary);
            font-weight: 600;
            padding: 0.5rem 1rem;
            transition: all 0.2s ease-in-out;
        }

        .navbar-nav .nav-item .nav-link:hover {
            color: var(--soft-ui-primary-end);
        }

        .navbar-nav .nav-item .nav-link.active {
            color: var(--soft-ui-primary-end);
        }

        .navbar-nav .dropdown-menu {
            position: absolute;
            top: 100%;
            right: 0;
            left: auto;
            z-index: 1300;
            background-color: var(--soft-ui-white);
            border: 1px solid var(--soft-ui-gray-200);
            border-radius: 0.5rem;
            box-shadow: 0 4px 12px rgba(0, 0, 0, 0.15);
            min-width: 160px;
            margin-top: 0.125rem;
        }

        .navbar-nav .dropdown-item {
            color: var(--soft-ui-secondary);
            padding: 0.5rem 1rem;
            font-weight: 500;
            transition: all 0.2s ease-in-out;
        }

        .navbar-nav .dropdown-item:hover {
            background-color: var(--soft-ui-gray-200);
            color: var(--soft-ui-dark);
        }

        .navbar-nav .dropdown-item.active {
            background-color: var(--soft-ui-primary-end);
            color: var(--soft-ui-white);
        }
        
        .sidebar {
            min-height: 100vh;
            width: 250px;
            position: fixed;
            top: 0;
            left: 0;
            z-index: 1000;
            background: var(--soft-ui-white);
            color: var(--soft-ui-dark);
            padding-top: 70px;
            transition: all 0.3s ease-in-out;
            border-right: 1px solid var(--soft-ui-gray-200);
            box-shadow: 4px 0 15px rgba(0, 0, 0, 0.05);
            border-radius: 0 1rem 1rem 0;
        }

        .content {
            margin-left: 250px;
            margin-top: 0;
            padding: 20px;
            padding-top: 90px;
            transition: all 0.3s ease-in-out;
            flex-grow: 1;
        }
        
        .hamburger-mobile {
            display: none;
            background: none;
            border: none;
            color: var(--soft-ui-dark);
            font-size: 1.5rem;
            cursor: pointer;
            margin-right: 15px;
            transition: all 0.3s ease;
            z-index: 1;
        }
        
        .hamburger-mobile:focus {
            outline: none;
        }
        
        .sidebar-overlay {
            display: none;
            position: fixed;
            top: 0;
            left: 0;
            right: 0;
            bottom: 0;
            background-color: rgba(0, 0, 0, 0.4);
            z-index: 999;
        }
        
        .profile-section {
            text-align: center;
            padding: 15px 20px;
            border-bottom: 1px solid var(--soft-ui-gray-200);
            background: var(--soft-ui-white);
            border-radius: 0.75rem;
            box-shadow: 0 4px 15px rgba(0, 0, 0, 0.05);
        }
        
        .profile-photo {
            width: 80px;
            height: 80px;
            border-radius: 50%;
            object-fit: cover;
            border: 2px solid var(--soft-ui-gray-300);
            margin: 0 auto 10px;
            display: block;
            box-shadow: 0 4px 10px rgba(0, 0, 0, 0.08);
        }
        
        .profile-photo-placeholder {
            width: 80px;
            height: 80px;
            border-radius: 50%;
            background: var(--soft-ui-gray-400);
            display: flex;
            align-items: center;
            justify-content: center;
            margin: 0 auto 10px;
            border: 2px solid var(--soft-ui-gray-300);
            box-shadow: 0 4px 10px rgba(0, 0, 0, 0.08);
        }
        
        .profile-photo-placeholder i {
            font-size: 2rem;
            color: var(--soft-ui-white);
        }
        
        .profile-name {
            font-size: 1.1rem;
            font-weight: 600;
            color: var(--soft-ui-dark);
            margin-bottom: 5px;
            word-wrap: break-word;
        }
        
        .profile-info {
            font-size: 0.9rem;
            font-weight: 400;
            color: var(--soft-ui-secondary);
            margin-bottom: 3px;
        }
        
        .sidebar .nav-link {
            color: var(--soft-ui-secondary);
            padding: 0.75rem 1rem;
            border-radius: 0.5rem;
            margin: 0.25rem 0.75rem;
            transition: all 0.2s ease-in-out;
            font-weight: 600;
            display: flex;
            align-items: center;
        }
        
        .sidebar .nav-link:hover {
            background: linear-gradient(90deg, rgba(0, 196, 204, 0.1), rgba(203, 12, 159, 0.1));
            color: var(--soft-ui-dark);
        }
        
        .sidebar .nav-link.active {
            background: linear-gradient(195deg, var(--soft-ui-primary-start), var(--soft-ui-primary-end));
            color: var(--soft-ui-white) !important;
            box-shadow: 0 4px 12px rgba(0, 0, 0, 0.1);
        }

        .sidebar .nav-link.active i {
            color: var(--soft-ui-white);
        }
        
        .sidebar .nav-link i {
            font-size: 1.2rem;
            margin-right: 10px;
            color: var(--soft-ui-secondary);
            transition: all 0.2s ease-in-out;
        }

        .sidebar .nav-item.dropdown .dropdown-menu {
            background-color: var(--soft-ui-white);
            border: none;
            box-shadow: 0 4px 12px rgba(0, 0, 0, 0.08);
            border-radius: 0.5rem;
            padding: 0.5rem 0;
            margin-top: 0.25rem;
        }

        .sidebar .nav-item.dropdown .dropdown-item {
            color: var(--soft-ui-secondary);
            padding: 0.5rem 1.5rem;
            font-weight: 500;
            transition: all 0.2s ease-in-out;
        }

        .sidebar .nav-item.dropdown .dropdown-item:hover {
            background: linear-gradient(90deg, rgba(0, 196, 204, 0.1), rgba(203, 12, 159, 0.1));
            color: var(--soft-ui-dark);
        }

        .sidebar .nav-item.dropdown .dropdown-item.active {
            background: linear-gradient(195deg, var(--soft-ui-primary-start), var(--soft-ui-primary-end));
            color: var(--soft-ui-white);
        }

        .sidebar .nav-item:not(:last-child) {
            border-bottom: none;
        }

        .page-title {
            font-size: 2rem;
            font-weight: 700;
            color: var(--soft-ui-dark);
            margin-bottom: 30px;
            text-align: center;
            background: linear-gradient(195deg, var(--soft-ui-primary-start), var(--soft-ui-primary-end));
            -webkit-background-clip: text;
            -webkit-text-fill-color: transparent;
            background-clip: text;
        }

        .card {
            background-color: var(--soft-ui-white);
            border-radius: 0.75rem;
            box-shadow: 0 4px 12px rgba(0, 0, 0, 0.05);
            transition: all 0.2s ease-in-out;
            border: none;
        }

        .card:hover {
            transform: translateY(-3px);
            box-shadow: 0 6px 16px rgba(0, 0, 0, 0.08);
        }

        .card-header {
            background: linear-gradient(195deg, var(--soft-ui-primary-start), var(--soft-ui-primary-end));
            color: var(--soft-ui-white);
            font-weight: 700;
            font-size: 1.25rem;
            text-align: center;
            padding: 1.5rem;
            border-bottom: none;
            border-top-left-radius: 0.75rem;
            border-top-right-radius: 0.75rem;
        }

        .card-body {
            padding: 2rem;
        }

        .question-block {
            margin-bottom: 2rem;
            border: 1px solid var(--soft-ui-gray-200);
            border-radius: 0.75rem;
            overflow: hidden;
        }

        .question-block .card-header {
            background: linear-gradient(90deg, var(--soft-ui-primary-start), var(--soft-ui-primary-end));
            color: var(--soft-ui-white);
            font-size: 1.1rem;
            padding: 1rem 1.5rem;
            display: flex;
            justify-content: space-between;
            align-items: center;
        }

        .form-label {
            font-weight: 600;
            color: var(--soft-ui-dark);
            margin-bottom: 0.5rem;
        }

        .form-control, .form-select {
            border: 1px solid var(--soft-ui-gray-300);
            border-radius: 0.5rem;
            padding: 0.75rem 1rem;
            font-size: 1rem;
            transition: all 0.2s ease-in-out;
        }

        .form-control:focus, .form-select:focus {
            border-color: var(--soft-ui-primary-start);
            box-shadow: 0 0 0 0.2rem rgba(0, 196, 204, 0.25);
        }

        .btn {
            border-radius: 0.5rem;
            padding: 0.75rem 1.5rem;
            font-weight: 600;
            transition: all 0.2s ease-in-out;
            border: none;
        }

        .btn-primary {
            background: var(--soft-ui-primary-end); /* Purple untuk Submit Semua Soal */
            color: var(--soft-ui-white);
        }

        .btn-primary:hover {
            background: #a80a85; /* Darker purple */
            transform: translateY(-2px);
            box-shadow: 0 4px 12px rgba(203, 12, 159, 0.3);
            color: var(--soft-ui-white);
        }

        .btn-info {
            background: var(--soft-ui-primary-start); /* Teal untuk Tambah Soal Baru */
            color: var(--soft-ui-white);
        }

        .btn-info:hover {
            background: #009ea6; /* Darker teal */
            transform: translateY(-2px);
            box-shadow: 0 4px 12px rgba(0, 196, 204, 0.3);
            color: var(--soft-ui-white);
        }

        .btn-danger {
            background: linear-gradient(195deg, var(--soft-ui-primary-start), var(--soft-ui-primary-end));
            color: var(--soft-ui-white);
        }

        .btn-danger:hover {
            background: linear-gradient(195deg, var(--soft-ui-primary-end), var(--soft-ui-primary-start));
            transform: translateY(-2px);
            box-shadow: 0 4px 12px rgba(234, 6, 6, 0.3);
            color: var(--soft-ui-white);
        }

        .btn-sm {
            padding: 0.5rem 1rem;
            font-size: 0.875rem;
        }

        .alert {
            border-radius: 0.75rem;
            border: none;
            padding: 1rem 1.5rem;
            font-weight: 500;
        }

        .alert-danger {
            background: rgba(0, 196, 204, 0.1);
            color: var(--soft-ui-primary-start);
        }

        .alert-success {
            background: rgba(203, 12, 159, 0.1);
            color: var(--soft-ui-primary-end);
        }
        
        footer {
            background: var(--soft-ui-white);
            color: var(--soft-ui-secondary);
            border-top: 1px solid var(--soft-ui-gray-200);
            padding: 1rem 0;
            text-align: center;
            flex-shrink: 0;
            margin-top: 2rem;
        }
        
        .animate-fade-in {
            animation: fadeIn 0.5s ease-in-out;
        }
        
        @keyframes fadeIn {
            from { opacity: 0; transform: translateY(10px); }
            to { opacity: 1; transform: translateY(0); }
        }

        @media (max-width: 768px) {
            .sidebar {
                margin-left: -250px;
                border-radius: 0;
                padding-top: 90px;
            }
            .sidebar-active {
                margin-left: 0;
            }
            .content {
                margin-left: 0;
                padding-top: 100px;
            }
            
            .navbar-title {
                display: none;
            }
            .navbar-logo {
                display: none;
            }
            
            .navbar-title-mobile {
                display: block;
            }
            
            .hamburger-mobile {
                display: block;
            }
            .navbar-search {
                display: none;
            }
            .navbar-nav {
                position: static;
            }
            .navbar-nav .dropdown-menu {
                position: absolute;
                right: 0;
                left: auto;
                z-index: 1300;
            }
            .page-title {
                font-size: 1.5rem;
                margin-bottom: 20px;
            }
            
            .card-body {
                padding: 1rem;
            }

            .question-block .card-header {
                padding: 0.75rem 1rem;
                font-size: 1rem;
            }
        }

        @media (max-width: 576px) {
            .navbar-top {
                padding: 0.5rem 1rem;
                min-height: 70px;
            }
            .navbar-title-mobile {
                font-size: 0.8rem;
            }
            .navbar-title-mobile .line2 {
                font-size: 0.75rem;
            }
            .page-title {
                font-size: 1.25rem;
            }

            .card-body {
                padding: 0.75rem;
            }
        }
    </style>
</head>
<body>
    <nav class="navbar navbar-expand-lg navbar-top">
        <div class="container-fluid">
            <button class="hamburger-mobile d-md-none" type="button" id="sidebarToggle">
                <i class="bi bi-list"></i>
            </button>
            <a class="navbar-brand d-none d-md-flex" href="#">
                <img src="image/logopim.png" alt="Logo PIM" class="navbar-logo">
            </a>
            <div class="navbar-title d-none d-md-block">
                E-Learning System Pondok Indah Mall
            </div>
            <div class="navbar-title-mobile d-md-none">
                <span class="line1">E-Learning System</span>
                <span class="line2">Pondok Indah Mall</span>
            </div>
            <ul class="navbar-nav ms-auto mb-2 mb-lg-0">
                <li class="nav-item dropdown">
                    <a class="nav-link dropdown-toggle text-dark" href="#" id="navbarDropdown" role="button" data-bs-toggle="dropdown" aria-expanded="false">
                        <i class="bi bi-person-circle"></i>
                    </a>
                    <ul class="dropdown-menu dropdown-menu-end">
                        <li><a class="dropdown-item <?php echo ($current_page == 'profile.php') ? 'active' : ''; ?>" href="profile.php">Profile</a></li>
                        <li><hr class="dropdown-divider"></li>
                        <li><a class="dropdown-item" href="logout.php">Logout</a></li>
                    </ul>
                </li>
            </ul>
        </div>
    </nav>

    <div class="sidebar-overlay" id="sidebarOverlay"></div>

    <div class="sidebar border-end" id="sidebar">
        <div class="profile-section">
            <?php if (!empty($user['foto_profil'])): ?>
                <img src="Uploads/profiles/<?php echo htmlspecialchars($user['foto_profil']); ?>" alt="Foto Profil" class="profile-photo">
            <?php else: ?>
                <div class="profile-photo-placeholder">
                    <i class="bi bi-person-circle"></i>
                </div>
            <?php endif; ?>
            <div class="profile-name"><?php echo htmlspecialchars($user['nama_lengkap']); ?></div>
            <div class="profile-info"><?php echo htmlspecialchars($user['jabatan'] ?? 'Tidak ada jabatan'); ?></div>
            <div class="profile-info"><?php echo htmlspecialchars($user['divisi'] ?? 'Tidak ada divisi'); ?></div>
        </div>
        <div class="p-3">
            <h5 class="mb-4 text-dark">Menu</h5>
            <ul class="nav flex-column">
                <li class="nav-item">
                    <a class="nav-link <?php echo ($current_page == 'dashboard.php') ? 'active' : ''; ?>" href="dashboard.php">
                        <i class="bi bi-house-door-fill"></i> Dashboard
                    </a>
                </li>
                <li class="nav-item">
                    <a class="nav-link <?php echo ($current_page == 'materi.php') ? 'active' : ''; ?>" href="materi.php">
                        <i class="bi bi-book"></i> Materi
                    </a>
                </li>
            <?php if ($role == 'trainer'): ?>
    <li class="nav-item dropdown">
        <a class="nav-link dropdown-toggle <?php echo ($current_page == 'add_posttest.php' || $current_page == 'list_posttest.php') ? 'active' : ''; ?>" href="#" id="postTestDropdown" role="button" data-bs-toggle="dropdown" aria-expanded="false">
            <i class="bi bi-clipboard-check"></i> Post Test
        </a>
        <ul class="dropdown-menu" aria-labelledby="postTestDropdown">
            <li><a class="dropdown-item <?php echo ($current_page == 'add_posttest.php') ? 'active' : ''; ?>" href="add_posttest.php">Tambah Post Test</a></li>
            <li><a class="dropdown-item <?php echo ($current_page == 'list_posttest.php') ? 'active' : ''; ?>" href="list_posttest.php">List Post Test</a></li>
        </ul>
    </li>
<?php elseif ($role == 'peserta' || $role == 'iss'): ?>
    <li class="nav-item">
        <a class="nav-link <?php echo ($current_page == 'list_posttest.php') ? 'active' : ''; ?>" href="list_posttest.php">
            <i class="bi bi-clipboard-check"></i> Post Test
        </a>
    </li>
<?php endif; ?>
                <li class="nav-item dropdown">
                    <a class="nav-link dropdown-toggle <?php echo ($current_page == 'add_training.php' || $current_page == 'list_training.php') ? 'active' : ''; ?>" href="#" id="trainingDropdown" role="button" data-bs-toggle="dropdown" aria-expanded="false">
                        <i class="bi bi-journal-text"></i> Training
                    </a>
                    <ul class="dropdown-menu" aria-labelledby="trainingDropdown">
                        <?php if($role == 'trainer'): ?>
                        <li><a class="dropdown-item <?php echo ($current_page == 'add_training.php') ? 'active' : ''; ?>" href="add_training.php">Tambah Kegiatan Training</a></li>
                        <?php endif; ?>
                        <li><a class="dropdown-item <?php echo ($current_page == 'list_training.php') ? 'active' : ''; ?>" href="list_training.php">List Training</a></li>
                    </ul>
                </li>
            <?php if ($role == 'trainer'): ?>
                <li class="nav-item">
                    <a class="nav-link <?php echo ($current_page == 'report.php') ? 'active' : ''; ?>" href="report.php">
                        <i class="bi bi-file-earmark-text"></i> Report
                    </a>
                </li>
                <li class="nav-item">
                    <a class="nav-link <?php echo ($current_page == 'data_evaluasi.php') ? 'active' : ''; ?>" href="data_evaluasi.php">
                        <i class="bi bi-clipboard-data"></i> Data Evaluasi
                    </a>
                </li>
            <?php endif; ?>
            </ul>
        </div>
    </div>

    <div class="content">
        <div class="container-fluid">
            <h2 class="page-title animate-fade-in">Buat Soal Post Test</h2>
            
            <div class="row">
                <div class="col-md-10 offset-md-1">
                    <div class="card animate-fade-in">
                        <div class="card-header">
                            <i class="bi bi-clipboard-check me-2"></i>
                            Form Pembuatan Soal Pilihan Ganda
                        </div>
                        <div class="card-body">
                            <?php if (!empty($error)): ?>
                                <div class="alert alert-danger">
                                    <i class="bi bi-exclamation-triangle me-2"></i>
                                    <?php echo htmlspecialchars($error); ?>
                                </div>
                            <?php endif; ?>
                            <?php if (!empty($success)): ?>
                                <div class="alert alert-success">
                                    <i class="bi bi-check-circle me-2"></i>
                                    <?php echo htmlspecialchars($success); ?>
                                </div>
                            <?php endif; ?>

                            <form method="POST" action="">
                                <div class="mb-4">
                                    <label for="training_id" class="form-label">
                                        <i class="bi bi-journal-text me-2"></i>Pilih Training:
                                    </label>
                                    <select class="form-select" id="training_id" name="training_id" required>
                                        <option value="">-- Pilih Training --</option>
                                        <?php foreach ($trainings as $training): ?>
                                            <option value="<?php echo htmlspecialchars($training['id']); ?>" <?php echo ($training_id_selected == $training['id']) ? 'selected' : ''; ?>>
                                                <?php echo htmlspecialchars($training['judul']); ?>
                                            </option>
                                        <?php endforeach; ?>
                                    </select>
                                </div>

                                <div id="questions-container">
                                    <div class="question-block card mb-4" data-question-index="0">
                                        <div class="card-header d-flex justify-content-between align-items-center">
                                            <h6 class="mb-0">
                                                <i class="bi bi-question-circle me-2"></i>
                                                Soal #<span class="question-number">1</span>
                                            </h6>
                                            <button type="button" class="btn btn-sm btn-danger remove-question-btn" style="display:none;">
                                                <i class="bi bi-x-circle"></i> Hapus Soal
                                            </button>
                                        </div>
                                        <div class="card-body">
                                            <div class="mb-3">
                                                <label for="question_text_0" class="form-label">Teks Soal:</label>
                                                <textarea class="form-control" id="question_text_0" name="questions[0][question_text]" rows="3" required><?php echo htmlspecialchars($question_text); ?></textarea>
                                            </div>
                                            <div class="row">
                                                <div class="col-md-6">
                                                    <div class="mb-3">
                                                        <label for="option_a_0" class="form-label">Opsi A:</label>
                                                        <input type="text" class="form-control" id="option_a_0" name="questions[0][option_a]" value="<?php echo htmlspecialchars($option_a); ?>" required>
                                                    </div>
                                                </div>
                                                <div class="col-md-6">
                                                    <div class="mb-3">
                                                        <label for="option_b_0" class="form-label">Opsi B:</label>
                                                        <input type="text" class="form-control" id="option_b_0" name="questions[0][option_b]" value="<?php echo htmlspecialchars($option_b); ?>" required>
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="row">
                                                <div class="col-md-6">
                                                    <div class="mb-3">
                                                        <label for="option_c_0" class="form-label">Opsi C:</label>
                                                        <input type="text" class="form-control" id="option_c_0" name="questions[0][option_c]" value="<?php echo htmlspecialchars($option_c); ?>" required>
                                                    </div>
                                                </div>
                                                <div class="col-md-6">
                                                    <div class="mb-3">
                                                        <label for="option_d_0" class="form-label">Opsi D:</label>
                                                        <input type="text" class="form-control" id="option_d_0" name="questions[0][option_d]" value="<?php echo htmlspecialchars($option_d); ?>" required>
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="mb-3">
                                                <label for="correct_answer_0" class="form-label">Jawaban Benar:</label>
                                                <select class="form-select" id="correct_answer_0" name="questions[0][correct_answer]" required>
                                                    <option value="">-- Pilih Jawaban Benar --</option>
                                                    <option value="A" <?php echo ($correct_answer == 'A') ? 'selected' : ''; ?>>A</option>
                                                    <option value="B" <?php echo ($correct_answer == 'B') ? 'selected' : ''; ?>>B</option>
                                                    <option value="C" <?php echo ($correct_answer == 'C') ? 'selected' : ''; ?>>C</option>
                                                    <option value="D" <?php echo ($correct_answer == 'D') ? 'selected' : ''; ?>>D</option>
                                                </select>
                                            </div>
                                        </div>
                                    </div>
                                </div>

                                <button type="button" id="add-question-btn" class="btn btn-info w-100 mb-3">
                                    <i class="bi bi-plus-circle me-2"></i> Tambah Soal Baru
                                </button>

                                <button type="submit" class="btn btn-primary w-100">
                                    <i class="bi bi-save me-2"></i> Submit Semua Soal
                                </button>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <footer class="text-center">
        <div class="container">
            <p class="mb-0">© <?php echo date('Y'); ?> E-Learning System by PIM</p>
        </div>
    </footer>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
    <script>
        document.addEventListener('DOMContentLoaded', function() {
            const sidebarToggle = document.getElementById('sidebarToggle');
            const sidebar = document.getElementById('sidebar');
            const sidebarOverlay = document.getElementById('sidebarOverlay');
            const trainingDropdownToggle = document.getElementById('trainingDropdown');
            const postTestDropdownToggle = document.getElementById('postTestDropdown');
            
            let isDropdownClick = false;

            function toggleSidebar() {
                sidebar.classList.toggle('sidebar-active');
                sidebarOverlay.style.display = sidebar.classList.contains('sidebar-active') ? 'block' : 'none';
                
                if (sidebar.classList.contains('sidebar-active')) {
                    document.body.style.overflow = 'hidden';
                } else {
                    document.body.style.overflow = '';
                }
            }

            sidebarToggle.addEventListener('click', function(e) {
                e.stopPropagation();
                toggleSidebar();
            });

            sidebarOverlay.addEventListener('click', function() {
                if (!isDropdownClick) {
                    toggleSidebar();
                }
                isDropdownClick = false;
            });

            if (trainingDropdownToggle) {
                trainingDropdownToggle.addEventListener('click', function(e) {
                    if (window.innerWidth <= 768) {
                        isDropdownClick = true;
                    }
                });
            }

            if (postTestDropdownToggle) {
                postTestDropdownToggle.addEventListener('click', function(e) {
                    if (window.innerWidth <= 768) {
                        isDropdownClick = true;
                    }
                });
            }
            
            document.addEventListener('click', function(e) {
                if (window.innerWidth <= 768) {
                    let clickedInsideAnyDropdown = false;
                    if (trainingDropdownToggle && trainingDropdownToggle.contains(e.target)) {
                        clickedInsideAnyDropdown = true;
                    }
                    if (postTestDropdownToggle && postTestDropdownToggle.contains(e.target)) {
                        clickedInsideAnyDropdown = true;
                    }
                    if (!clickedInsideAnyDropdown) {
                        isDropdownClick = false;
                    }
                }
            });

            const regularNavLinks = document.querySelectorAll('.sidebar .nav-link:not(.dropdown-toggle)');
            regularNavLinks.forEach(link => {
                link.addEventListener('click', function() {
                    if (window.innerWidth <= 768 && sidebar.classList.contains('sidebar-active')) {
                        toggleSidebar();
                    }
                });
            });

            const dropdownItems = document.querySelectorAll('.sidebar .dropdown-menu .dropdown-item');
            dropdownItems.forEach(item => {
                item.addEventListener('click', function() {
                    if (window.innerWidth <= 768 && sidebar.classList.contains('sidebar-active')) {
                        toggleSidebar();
                    }
                });
            });

            window.addEventListener('resize', function() {
                if (window.innerWidth > 768) {
                    sidebar.classList.remove('sidebar-active');
                    sidebarOverlay.style.display = 'none';
                    document.body.style.overflow = '';
                    isDropdownClick = false;
                }
            });
        });

        document.addEventListener('DOMContentLoaded', function() {
            const questionsContainer = document.getElementById('questions-container');
            const addQuestionBtn = document.getElementById('add-question-btn');
            let questionIndex = 0;

            function updateQuestionNumbers() {
                const questionBlocks = questionsContainer.querySelectorAll('.question-block');
                questionBlocks.forEach((block, index) => {
                    block.querySelector('.question-number').textContent = index + 1;
                    const removeBtn = block.querySelector('.remove-question-btn');
                    if (questionBlocks.length > 1) {
                        removeBtn.style.display = 'block';
                    } else {
                        removeBtn.style.display = 'none';
                    }
                });
            }

            updateQuestionNumbers();

            addQuestionBtn.addEventListener('click', function() {
                questionIndex++;
                const newQuestionBlock = document.createElement('div');
                newQuestionBlock.classList.add('question-block', 'card', 'mb-4');
                newQuestionBlock.setAttribute('data-question-index', questionIndex);

                newQuestionBlock.innerHTML = `
                    <div class="card-header d-flex justify-content-between align-items-center">
                        <h6 class="mb-0">
                            <i class="bi bi-question-circle me-2"></i>
                            Soal #<span class="question-number">${questionIndex + 1}</span>
                        </h6>
                        <button type="button" class="btn btn-sm btn-danger remove-question-btn">
                            <i class="bi bi-x-circle"></i> Hapus Soal
                        </button>
                    </div>
                    <div class="card-body">
                        <div class="mb-3">
                            <label for="question_text_${questionIndex}" class="form-label">Teks Soal:</label>
                            <textarea class="form-control" id="question_text_${questionIndex}" name="questions[${questionIndex}][question_text]" rows="3" required></textarea>
                        </div>
                        <div class="row">
                            <div class="col-md-6">
                                <div class="mb-3">
                                    <label for="option_a_${questionIndex}" class="form-label">Opsi A:</label>
                                    <input type="text" class="form-control" id="option_a_${questionIndex}" name="questions[${questionIndex}][option_a]" required>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="mb-3">
                                    <label for="option_b_${questionIndex}" class="form-label">Opsi B:</label>
                                    <input type="text" class="form-control" id="option_b_${questionIndex}" name="questions[${questionIndex}][option_b]" required>
                                </div>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-md-6">
                                <div class="mb-3">
                                    <label for="option_c_${questionIndex}" class="form-label">Opsi C:</label>
                                    <input type="text" class="form-control" id="option_c_${questionIndex}" name="questions[${questionIndex}][option_c]" required>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="mb-3">
                                    <label for="option_d_${questionIndex}" class="form-label">Opsi D:</label>
                                    <input type="text" class="form-control" id="option_d_${questionIndex}" name="questions[${questionIndex}][option_d]" required>
                                </div>
                            </div>
                        </div>
                        <div class="mb-3">
                            <label for="correct_answer_${questionIndex}" class="form-label">Jawaban Benar:</label>
                            <select class="form-select" id="correct_answer_${questionIndex}" name="questions[${questionIndex}][correct_answer]" required>
                                <option value="">-- Pilih Jawaban Benar --</option>
                                <option value="A">A</option>
                                <option value="B">B</option>
                                <option value="C">C</option>
                                <option value="D">D</option>
                            </select>
                        </div>
                    </div>
                `;
                questionsContainer.appendChild(newQuestionBlock);
                updateQuestionNumbers();
            });

            questionsContainer.addEventListener('click', function(event) {
                if (event.target.classList.contains('remove-question-btn') || event.target.closest('.remove-question-btn')) {
                    const btn = event.target.closest('.remove-question-btn');
                    const questionBlockToRemove = btn.closest('.question-block');
                    if (questionsContainer.querySelectorAll('.question-block').length > 1) {
                        questionBlockToRemove.remove();
                        updateQuestionNumbers();
                    } else {
                        alert('Minimal harus ada satu soal.');
                    }
                }
            });
        });
    </script>
</body>
</html>